/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.preferences.EasyDBOptionList;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.EasyDBSettingsPanel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class EasyDBSettingsPanel {
    private DialogPage page;
    private IProject project;
    private Button launchEasyDbBtn;
    private Button genDatabaseBtn;
    private Button[] databaseBtn;
    private List<Button> oracleBtns = new ArrayList();
    private List<Button> mysqlBtns = new ArrayList();
    private List<Button> postgreBtns = new ArrayList();
    private List<Button> sqlserverBtns = new ArrayList();
    private List<Button> informixBtns = new ArrayList();
    private GenericOptionGroup[] oracleOptions;
    private GenericOptionGroup[] mySqlOptions;
    private GenericOptionGroup[] sqlServerOptions;
    private GenericOptionGroup[] genericOptions;
    private GenericOptionGroup[] postgreOptions;
    private GenericOptionGroup[] informixOptions;
    private IPreferenceStore store;

    public EasyDBSettingsPanel(Composite composite, IProject iProject, IPreferenceStore iPreferenceStore) {
        this(composite, null, iProject, iPreferenceStore);
    }

    public EasyDBSettingsPanel(Composite composite, DialogPage dialogPage, IPreferenceStore iPreferenceStore) {
        this(composite, dialogPage, null, iPreferenceStore);
    }

    private EasyDBSettingsPanel(Composite composite, DialogPage dialogPage, IProject iProject, IPreferenceStore iPreferenceStore) {
        Object object;
        Object object2;
        int n;
        this.project = iProject;
        this.page = dialogPage;
        this.store = iPreferenceStore;
        String[] stringArray = EasyDBOptionList.getFolderOptions();
        stringArray = EasyDBOptionList.getOracleOptions();
        this.oracleOptions = new GenericOptionGroup[stringArray.length];
        for (n = 0; n < this.oracleOptions.length; ++n) {
            this.oracleOptions[n] = new GenericOptionGroup(this, stringArray[n]);
        }
        stringArray = EasyDBOptionList.getPostgreOptions();
        this.postgreOptions = new GenericOptionGroup[stringArray.length];
        for (n = 0; n < this.postgreOptions.length; ++n) {
            this.postgreOptions[n] = new GenericOptionGroup(this, stringArray[n]);
        }
        stringArray = EasyDBOptionList.getInformixOptions();
        this.informixOptions = new GenericOptionGroup[stringArray.length];
        for (n = 0; n < this.informixOptions.length; ++n) {
            this.informixOptions[n] = new GenericOptionGroup(this, stringArray[n]);
        }
        stringArray = EasyDBOptionList.getMySqlOptions();
        this.mySqlOptions = new GenericOptionGroup[stringArray.length];
        for (n = 0; n < this.mySqlOptions.length; ++n) {
            this.mySqlOptions[n] = new GenericOptionGroup(this, stringArray[n]);
        }
        stringArray = EasyDBOptionList.getSqlServerOptions();
        this.sqlServerOptions = new GenericOptionGroup[stringArray.length];
        for (n = 0; n < this.sqlServerOptions.length; ++n) {
            this.sqlServerOptions[n] = new GenericOptionGroup(this, stringArray[n]);
        }
        stringArray = EasyDBOptionList.getGenericOptions();
        this.genericOptions = new GenericOptionGroup[stringArray.length];
        for (n = 0; n < this.genericOptions.length; ++n) {
            this.genericOptions[n] = new GenericOptionGroup(this, stringArray[n]);
        }
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        if (dialogPage != null && dialogPage instanceof PreferencePage) {
            object2 = (PreferencePage)dialogPage;
            object = new FormText(composite, 0);
            object.setText(IsresourceBundle.getString((String)"easydb_runtime_lnk"), true, false);
            object.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (iProject != null || dialogPage instanceof IWizardPage) {
            this.launchEasyDbBtn = new Button(composite, 32);
            this.launchEasyDbBtn.setText("Launch EDBIIS during build");
            object2 = null;
            if (iProject != null) {
                object2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.launcheasydb");
            }
            this.launchEasyDbBtn.setSelection(object2 != null && ((String)object2).equals("___iscobol.option.true"));
        }
        object2 = new Group(composite, 0);
        object2.setText("Database Types");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        object2.setLayout((Layout)gridLayout);
        this.genDatabaseBtn = new Button((Composite)object2, 32);
        this.genDatabaseBtn.setText("Generic");
        object = this.getProperty("easydb.Generic");
        this.genDatabaseBtn.setSelection(object != null && ((String)object).equals("___iscobol.option.true"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.genDatabaseBtn.setLayoutData((Object)gridData);
        stringArray = EasyDBOptionList.getDatabaseOptions();
        this.databaseBtn = new Button[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "[" + stringArray[i] + "] " + EasyDBOptionList.getDescription((String)stringArray[i]);
            this.databaseBtn[i] = new Button((Composite)object2, 32);
            this.databaseBtn[i].setText(string);
            this.databaseBtn[i].setData((Object)stringArray[i]);
            object = this.getProperty("easydb." + stringArray[i]);
            this.databaseBtn[i].setSelection(object != null && ((String)object).equals("___iscobol.option.true"));
            this.databaseBtn[i].addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            if (EasyDBOptionList.isOracle((String)stringArray[i])) {
                this.oracleBtns.add(this.databaseBtn[i]);
                continue;
            }
            if (EasyDBOptionList.isMySQL((String)stringArray[i])) {
                this.mysqlBtns.add(this.databaseBtn[i]);
                continue;
            }
            if (EasyDBOptionList.isInformix((String)stringArray[i])) {
                this.informixBtns.add(this.databaseBtn[i]);
                continue;
            }
            if (EasyDBOptionList.isSQLServer((String)stringArray[i])) {
                this.sqlserverBtns.add(this.databaseBtn[i]);
                continue;
            }
            if (!EasyDBOptionList.isPostgreSql((String)stringArray[i])) continue;
            this.postgreBtns.add(this.databaseBtn[i]);
        }
        this.createOptionGroup(composite, "Generic Options", this.genericOptions, true);
        this.createOptionGroup(composite, "Oracle Options", this.oracleOptions, this.isSelected(this.oracleBtns));
        this.createOptionGroup(composite, "PostgreSql Options", this.postgreOptions, this.isSelected(this.postgreBtns));
        this.createOptionGroup(composite, "Informix Options", this.informixOptions, this.isSelected(this.informixBtns));
        this.createOptionGroup(composite, "MySQL with LIMIT Options", this.mySqlOptions, this.isSelected(this.mysqlBtns));
        this.createOptionGroup(composite, "SQL Server Options", this.sqlServerOptions, this.isSelected(this.sqlserverBtns));
    }

    private boolean isSelected(List<Button> list) {
        for (Button button : list) {
            if (!button.getSelection()) continue;
            return true;
        }
        return false;
    }

    private String getProperty(String string) {
        String string2;
        String string3 = this.page != null ? (this.store.contains(string) ? this.store.getString(string) : this.store.getDefaultString(string)) : ((string2 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)string)) != null && !string2.equals("___iscobol.option.false") ? string2 : null);
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        return string3;
    }

    private Group createSubGroup(Composite composite, int n, boolean bl) {
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        Button button = new Button((Composite)group, 16);
        button.setText("None");
        button.setEnabled(bl);
        return group;
    }

    private Group createOptionGroup(Composite composite, String string, GenericOptionGroup[] genericOptionGroupArray, boolean bl) {
        Group group = new Group(composite, 0);
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        EasyDBOptionList.OptionGroup optionGroup = null;
        Group group2 = null;
        for (int i = 0; i < genericOptionGroupArray.length; ++i) {
            Group group3 = null;
            EasyDBOptionList.OptionGroup optionGroup2 = EasyDBOptionList.getGroup((String)genericOptionGroupArray[i].optionName);
            if (optionGroup != null) {
                if (optionGroup == optionGroup2) {
                    group3 = group2;
                } else if (optionGroup2 != null) {
                    group3 = group2 = this.createSubGroup((Composite)group, optionGroup2.getOptions().length + 1, bl);
                    optionGroup = optionGroup2;
                } else {
                    group3 = group;
                    group2 = null;
                    optionGroup = null;
                }
            } else if (optionGroup2 != null) {
                group3 = group2 = this.createSubGroup((Composite)group, optionGroup2.getOptions().length + 1, bl);
                optionGroup = optionGroup2;
            } else {
                group3 = group;
            }
            genericOptionGroupArray[i].create(group3, this.getProperty("easydb." + genericOptionGroupArray[i].optionName), bl, group2);
        }
        return group;
    }

    public void store() {
        String string = "easydb.Generic";
        if (this.genDatabaseBtn.getSelection()) {
            this.store.setValue(string, "___iscobol.option.true");
        } else {
            this.store.setValue(string, "___iscobol.option.false");
        }
        for (int i = 0; i < this.databaseBtn.length; ++i) {
            string = "easydb." + this.databaseBtn[i].getData();
            if (this.databaseBtn[i].getSelection()) {
                this.store.setValue(string, "___iscobol.option.true");
                continue;
            }
            this.store.setValue(string, "___iscobol.option.false");
        }
        this.performOk(this.genericOptions);
        this.performOk(this.oracleOptions);
        this.performOk(this.postgreOptions);
        this.performOk(this.sqlServerOptions);
        this.performOk(this.informixOptions);
        this.performOk(this.mySqlOptions);
    }

    public void performOk(IProject iProject) {
        if (iProject == null) {
            this.store();
        } else {
            PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.launcheasydb", (String)(this.launchEasyDbBtn.getSelection() ? "___iscobol.option.true" : "___iscobol.option.false"));
            String string = "easydb.Generic";
            if (this.genDatabaseBtn.getSelection()) {
                PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)"___iscobol.option.true");
            } else {
                PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)"___iscobol.option.false");
            }
            for (int i = 0; i < this.databaseBtn.length; ++i) {
                string = "easydb." + this.databaseBtn[i].getData();
                if (this.databaseBtn[i].getSelection()) {
                    PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)"___iscobol.option.true");
                    continue;
                }
                PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)"___iscobol.option.false");
            }
            this.performOk(this.genericOptions, iProject);
            this.performOk(this.oracleOptions, iProject);
            this.performOk(this.postgreOptions, iProject);
            this.performOk(this.informixOptions, iProject);
            this.performOk(this.sqlServerOptions, iProject);
            this.performOk(this.mySqlOptions, iProject);
        }
    }

    private void performOk(GenericOptionGroup[] genericOptionGroupArray) {
        for (int i = 0; i < genericOptionGroupArray.length; ++i) {
            String string = "easydb." + genericOptionGroupArray[i].optionName;
            if (genericOptionGroupArray[i].button.getSelection()) {
                if (genericOptionGroupArray[i].hasValue) {
                    this.store.setValue(string, genericOptionGroupArray[i].textField.getText());
                    continue;
                }
                this.store.setValue(string, "___iscobol.option.true");
                continue;
            }
            this.store.setValue(string, "___iscobol.option.false");
        }
    }

    private void performOk(GenericOptionGroup[] genericOptionGroupArray, IProject iProject) {
        for (int i = 0; i < genericOptionGroupArray.length; ++i) {
            String string = "easydb." + genericOptionGroupArray[i].optionName;
            if (genericOptionGroupArray[i].button.getSelection()) {
                if (genericOptionGroupArray[i].hasValue) {
                    PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)genericOptionGroupArray[i].textField.getText());
                    continue;
                }
                PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)"___iscobol.option.true");
                continue;
            }
            PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)string, (String)"___iscobol.option.false");
        }
    }

    public void performDefaults() {
        boolean bl = this.project != null;
        String string = "easydb.Generic";
        String string2 = bl ? (this.store.contains(string) ? this.store.getString(string) : this.store.getDefaultString(string)) : this.store.getDefaultString(string);
        this.genDatabaseBtn.setSelection(string2 != null && string2.equals("___iscobol.option.true"));
        for (int i = 0; i < this.databaseBtn.length; ++i) {
            string = "easydb." + this.databaseBtn[i].getData();
            string2 = bl ? (this.store.contains(string) ? this.store.getString(string) : this.store.getDefaultString(string)) : this.store.getDefaultString(string);
            this.databaseBtn[i].setSelection(string2 != null && string2.equals("___iscobol.option.true"));
        }
        this.databaseBtnSelchanged();
        this.performDefaults(this.genericOptions, bl);
        this.performDefaults(this.oracleOptions, bl);
        this.performDefaults(this.postgreOptions, bl);
        this.performDefaults(this.informixOptions, bl);
        this.performDefaults(this.sqlServerOptions, bl);
        this.performDefaults(this.mySqlOptions, bl);
        if (this.launchEasyDbBtn != null) {
            this.launchEasyDbBtn.setSelection(true);
        }
    }

    private void performDefaults(GenericOptionGroup[] genericOptionGroupArray, boolean bl) {
        for (int i = 0; i < genericOptionGroupArray.length; ++i) {
            String string = null;
            String string2 = "easydb." + genericOptionGroupArray[i].optionName;
            string = bl ? (this.store.contains(string2) ? this.store.getString(string2) : this.store.getDefaultString(string2)) : this.store.getDefaultString(string2);
            if (string != null && string.length() == 0) {
                string = null;
            }
            genericOptionGroupArray[i].setValue(string);
        }
    }

    private void databaseBtnSelchanged() {
        int n;
        boolean bl = this.isSelected(this.oracleBtns);
        for (n = 0; n < this.oracleOptions.length; ++n) {
            this.oracleOptions[n].setEnabled(bl);
        }
        bl = this.isSelected(this.postgreBtns);
        for (n = 0; n < this.postgreOptions.length; ++n) {
            this.postgreOptions[n].setEnabled(bl);
        }
        bl = this.isSelected(this.mysqlBtns);
        for (n = 0; n < this.mySqlOptions.length; ++n) {
            this.mySqlOptions[n].setEnabled(bl);
        }
        bl = this.isSelected(this.sqlserverBtns);
        for (n = 0; n < this.sqlServerOptions.length; ++n) {
            this.sqlServerOptions[n].setEnabled(bl);
        }
        bl = this.isSelected(this.informixBtns);
        for (n = 0; n < this.informixOptions.length; ++n) {
            this.informixOptions[n].setEnabled(bl);
        }
    }

    public boolean isValid() {
        return true;
    }

    static /* synthetic */ void access$000(EasyDBSettingsPanel easyDBSettingsPanel) {
        easyDBSettingsPanel.databaseBtnSelchanged();
    }
}

