/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.SettingList;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.plugins.editor.wizards.ResourceSettingsPanel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class FileSettingsPage
extends PropertyPage
implements IWizardPage {
    private ResourceSettingsPanel panel;
    private boolean valid = true;
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private SettingList fileSettings;
    private boolean useFileOpts;

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getName() {
        return "";
    }

    public boolean isPageComplete() {
        return this.valid;
    }

    public Control createContents(Composite composite) {
        String string;
        this.setTitle("File Settings");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        IFile iFile = (IFile)this.getElement();
        this.panel = new ResourceSettingsPanel(composite2, 0, (IResource)iFile, false, false);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 800;
        this.panel.setLayoutData((Object)gridData);
        this.panel.setPreferencePage((PreferencePage)this);
        this.useFileOpts = iFile != null ? (string = PluginUtilities.getPersistentProperty((IResource)iFile.getProject(), (String)"Default", (String)"iscobol.checkfileopt")) != null && !string.equals("___iscobol.option.false") : true;
        if (!this.useFileOpts) {
            this.panel.disableAll();
            this.setMessage(IsresourceBundle.getString((String)"specific_file_opts_ignored"), 2);
        }
        return composite2;
    }

    public void setValid(boolean bl) {
        super.setValid(bl);
        this.valid = bl;
    }

    public boolean isValid() {
        if (this.panel == null) {
            return true;
        }
        String string = null;
        if (string == null) {
            string = this.panel.validate();
        }
        this.setErrorMessage(string);
        return string == null;
    }

    public boolean performOk() {
        if (this.useFileOpts) {
            return this.performOk((IResource)this.getElement());
        }
        return super.performOk();
    }

    public boolean performCancel() {
        if (this.useFileOpts && this.panel.isRestoredDefaults() && this.fileSettings != null) {
            PluginUtilities.putSettingList((SettingList)this.fileSettings, (IProject)((IFile)this.getElement()).getProject());
        }
        return super.performCancel();
    }

    public boolean performOk(IResource iResource) {
        if (!this.panel.isRestoredDefaults()) {
            this.panel.setOptionsAsPersistent(iResource, false);
        }
        PluginUtilities.saveProjectOptions((IProject)iResource.getProject());
        this.panel.setRestoredDefaults(false);
        IIscobolNavigator iIscobolNavigator = PluginUtilities.findFileNavigator();
        if (iIscobolNavigator != null) {
            iIscobolNavigator.refresh((Object)iResource);
        }
        return true;
    }

    protected void performDefaults() {
        if (this.useFileOpts) {
            IFile iFile = (IFile)this.getElement();
            this.fileSettings = PluginUtilities.getSettingList((IResource)iFile, (boolean)false);
            PluginUtilities.removePersistentProperties((IFile)iFile);
            this.panel.restoreProjectDefaults();
            this.panel.setRestoredDefaults(true);
        }
    }

    public ResourceSettingsPanel getPanel() {
        return this.panel;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }
}

