/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.osgi.framework.Bundle;

public class IscobolNewExamplePage
extends WizardNewFileCreationPage {
    private IConfigurationElement example;
    private boolean isScreenExample;
    public static final String EXAMPLE_PLUGIN_ID = "com.iscobol.plugins.examples.IscobolExamples";

    public IscobolNewExamplePage(String string, String string2, IStructuredSelection iStructuredSelection, IConfigurationElement iConfigurationElement) {
        super(string, iStructuredSelection);
        String string3;
        this.setDescription(string2);
        this.example = iConfigurationElement;
        this.isScreenExample = this.example != null && (string3 = this.example.getAttribute("type")) != null && string3.equals("screen");
    }

    public IFile createNewFile() {
        Bundle bundle;
        String string;
        String string2 = this.getFileName();
        String string3 = null;
        int n = string2.lastIndexOf(46);
        if (n >= 0 && n < string2.length() - 1) {
            string3 = string2.substring(n + 1);
        }
        if (string3 == null) {
            String string4 = string3 = this.isScreenExample ? "isp" : "cbl";
            if (n >= 0) {
                this.setFileName(string2 + string3);
            } else {
                this.setFileName(string2 + "." + string3);
            }
        }
        IFile iFile = super.createNewFile();
        if (this.example != null && (string = this.example.getAttribute("filename")) != null && string.length() > 0 && (bundle = Platform.getBundle((String)EXAMPLE_PLUGIN_ID)) != null) {
            this.copyFiles(bundle, string, iFile);
        }
        return iFile;
    }

    public boolean isScreenExample() {
        return this.isScreenExample;
    }

    private void copyFiles(Bundle bundle, String string, IFile iFile) {
        IProject iProject;
        URL uRL;
        InputStream inputStream = null;
        try {
            uRL = bundle.getEntry(string);
            if (uRL != null) {
                inputStream = uRL.openStream();
            } else {
                iProject = new MessageBox(this.getShell(), 1);
                iProject.setMessage(IsresourceBundle.getString((String)"example_not_found_msg"));
                iProject.open();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream != null) {
            PluginUtilities.modifyFile((IFile)iFile, (InputStream)inputStream, (boolean)true, (boolean)true);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IProject iProject2 = iProject = (uRL = this.getContainerFolder()) != null ? uRL.getProject() : null;
        if (iProject != null) {
            IConfigurationElement[] iConfigurationElementArray = this.example.getChildren("sourcefiles");
            if (iConfigurationElementArray != null && iConfigurationElementArray.length > 0) {
                this.copySourcefiles(bundle, iConfigurationElementArray[0], iProject);
            }
            if (this.isScreenExample && (iConfigurationElementArray = this.example.getChildren("screenfiles")) != null && iConfigurationElementArray.length > 0) {
                this.copyScreenfiles(bundle, iConfigurationElementArray[0], iProject);
            }
            if ((iConfigurationElementArray = this.example.getChildren("copyfiles")) != null && iConfigurationElementArray.length > 0) {
                this.copyCopyfiles(bundle, iConfigurationElementArray[0], iProject);
            }
            if ((iConfigurationElementArray = this.example.getChildren("resources")) != null && iConfigurationElementArray.length > 0) {
                this.copyResources(bundle, iConfigurationElementArray[0], iProject);
            }
        }
    }

    private void copyCopyfiles(Bundle bundle, IConfigurationElement iConfigurationElement, IProject iProject) {
        IContainer iContainer;
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("copyfile");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return;
        }
        IContainer[] iContainerArray = null;
        try {
            iContainerArray = PluginUtilities.getCopyFolders((IProject)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (iContainerArray == null || iContainerArray.length == 0) {
            iContainer = iProject.getFolder((IPath)new Path("cpy"));
            PluginUtilities.createFolder((IFolder)((IFolder)iContainer));
        } else {
            iContainer = iContainerArray[0];
        }
        this.copyData(bundle, iConfigurationElementArray, iContainer);
    }

    private void copyResources(Bundle bundle, IConfigurationElement iConfigurationElement, IProject iProject) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("resource");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return;
        }
        IFolder iFolder = null;
        try {
            iFolder = PluginUtilities.getResourcesFolder((IProject)iProject);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (iFolder == null) {
            iFolder = iProject.getFolder((IPath)new Path("resourcesdir"));
            PluginUtilities.createFolder((IFolder)iFolder);
        }
        this.copyData(bundle, iConfigurationElementArray, (IContainer)iFolder);
    }

    private void copySourcefiles(Bundle bundle, IConfigurationElement iConfigurationElement, IProject iProject) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("sourcefile");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return;
        }
        IContainer iContainer = null;
        try {
            iContainer = PluginUtilities.getSourceFolder((IProject)iProject);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (iContainer == null) {
            iContainer = iProject.getFolder((IPath)new Path("sourcedir"));
            PluginUtilities.createFolder((IFolder)((IFolder)iContainer));
        }
        this.copyData(bundle, iConfigurationElementArray, iContainer);
    }

    private void copyScreenfiles(Bundle bundle, IConfigurationElement iConfigurationElement, IProject iProject) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("screenfile");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return;
        }
        IContainer iContainer = null;
        try {
            iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (iContainer == null) {
            iContainer = iProject.getFolder((IPath)new Path("screendir"));
            PluginUtilities.createFolder((IFolder)((IFolder)iContainer));
        }
        this.copyData(bundle, iConfigurationElementArray, iContainer);
    }

    private void copyData(Bundle bundle, IConfigurationElement[] iConfigurationElementArray, IContainer iContainer) {
        for (int i = 0; i < iConfigurationElementArray.length; ++i) {
            String string = iConfigurationElementArray[i].getAttribute("filename");
            if (string == null || string.length() <= 0) continue;
            InputStream inputStream = null;
            try {
                URL uRL = bundle.getEntry(string);
                if (uRL != null) {
                    inputStream = uRL.openStream();
                    String string2 = new File(uRL.getFile()).getName();
                    Path path = new Path(string2);
                    IFile iFile = iContainer.getFile((IPath)path);
                    if (iFile.exists()) {
                        PluginUtilities.modifyFile((IFile)iFile, (InputStream)inputStream, (boolean)true, (boolean)true);
                    } else {
                        PluginUtilities.createFile((IFile)iFile, (InputStream)inputStream, (boolean)true);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream == null) continue;
            try {
                inputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void createAdvancedControls(Composite composite) {
    }

    protected void createLinkTarget() {
    }

    protected void handleAdvancedButtonSelect() {
    }

    protected IStatus validateLinkedResource() {
        return Status.OK_STATUS;
    }

    private IContainer getContainerFolder() {
        IPath iPath = this.getContainerFullPath();
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        return iResource instanceof IContainer ? (IContainer)iResource : null;
    }

    protected boolean validatePage() {
        boolean bl = super.validatePage();
        if (!bl) {
            return bl;
        }
        IContainer iContainer = this.getContainerFolder();
        if (this.isScreenExample) {
            String string = this.getFileName();
            if (string == null || !string.endsWith(".isp")) {
                this.setErrorMessage(IsresourceBundle.getString((String)"file_must_have_isp_ext_msg"));
                bl = false;
            } else if (iContainer == null || !PluginUtilities.isScreenFolder((IContainer)iContainer)) {
                this.setErrorMessage(IsresourceBundle.getString((String)"file_not_in_screen_fld_msg"));
                bl = false;
            } else {
                this.setErrorMessage(null);
            }
        } else if (iContainer == null || !PluginUtilities.isInSourceFolder((IContainer)iContainer)) {
            this.setErrorMessage(IsresourceBundle.getString((String)"file_not_in_src_fld_msg"));
            bl = false;
        } else {
            this.setErrorMessage(null);
        }
        return bl;
    }
}

