/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.FileSettingsPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public abstract class IscobolNewFileWizard
extends BasicNewFileResourceWizard {
    protected WizardNewFileCreationPage mainPage;
    protected FileSettingsPage settingsPage;
    public static final String rcsid = "$Id: IscobolNewFileWizard.java,v 1.4 2008/12/12 11:14:37 gianni Exp $";

    public boolean performFinish() {
        IFile iFile = this.mainPage.createNewFile();
        if (iFile == null) {
            return false;
        }
        if (this.settingsPage != null) {
            this.settingsPage.performOk((IResource)iFile);
        }
        this.selectAndReveal((IResource)iFile);
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage iWorkbenchPage;
            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.fileCreated(iFile);
        return true;
    }

    protected abstract void fileCreated(IFile var1);

    public void addPages() {
        try {
            this.adjustSelection();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.mainPage = this.createMainPage();
        this.mainPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.mainPage);
        this.settingsPage = this.createFileSettingsPage();
        if (this.settingsPage != null) {
            this.settingsPage.setWizard((IWizard)this);
            this.settingsPage.setPreviousPage((IWizardPage)this.mainPage);
            this.addPage((IWizardPage)this.settingsPage);
        }
    }

    protected final void adjustSelection() throws CoreException {
        IContainer iContainer;
        IProject iProject = this.getSelectedProject();
        if (iProject != null && (iContainer = this.getDefaultFolder(iProject)) != null) {
            this.selection = new StructuredSelection((Object)iContainer);
        }
    }

    protected final IProject getSelectedProject() {
        Object object;
        if (this.selection != null && !this.selection.isEmpty() && (object = this.selection.getFirstElement()) instanceof IResource) {
            IProject iProject = ((IResource)object).getProject();
            try {
                if (iProject != null && iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null) {
                    return iProject;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected IContainer getDefaultFolder(IProject iProject) throws CoreException {
        if (iProject == null) {
            return null;
        }
        return PluginUtilities.getSourceFolder((IProject)iProject);
    }

    protected abstract WizardNewFileCreationPage createMainPage();

    protected abstract FileSettingsPage createFileSettingsPage();
}

