/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.IscobolNewFilePage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ide.IDE;

public class IscobolNewProgramPage
extends IscobolNewFilePage {
    private final String eol = PluginUtilities.getLineDelimiter();
    private int generationMode = IscobolEditorPlugin.getIntFromStore((String)"iscobol.cobolgen.mode");

    public IscobolNewProgramPage(IStructuredSelection iStructuredSelection) {
        super(IsresourceBundle.getString((String)"new_program_title"), IsresourceBundle.getString((String)"new_program_desc"), iStructuredSelection);
    }

    private boolean isIscobolHtmlProject(IProject iProject) {
        try {
            return iProject != null && iProject.getNature("com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IFile createNewFile() {
        IFile iFile;
        boolean bl = IscobolEditorPlugin.getIntFromStore((String)"iscobol.cobolgen.format") == 1;
        CobolFormatter cobolFormatter = new CobolFormatter(bl, this.generationMode);
        String string = this.getFileName();
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1);
        }
        if (string2 == null) {
            if (n >= 0) {
                this.setFileName(string + "cbl");
            } else {
                this.setFileName(string + ".cbl");
            }
        }
        if ((iFile = super.createNewFile()) == null || iFile.isLinked()) {
            return iFile;
        }
        IProject iProject = iFile.getProject();
        boolean bl2 = this.isIscobolHtmlProject(iProject);
        String string3 = string.toUpperCase();
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cobolFormatter.formatLine("IDENTIFICATION DIVISION.")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("PROGRAM-ID. " + string3 + "."));
        stringBuilder.append(cobolFormatter.formatLine("AUTHOR. " + System.getProperty("user.name", "") + ".")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("ENVIRONMENT DIVISION.")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("CONFIGURATION SECTION.")).append(this.eol);
        if (bl2) {
            stringBuilder.append(cobolFormatter.formatLine("REPOSITORY."));
            stringBuilder.append(cobolFormatter.formatLine("   CLASS WEB-AREA AS \"com.iscobol.rts.HTTPHandler\""));
            stringBuilder.append(cobolFormatter.formatLine("   .")).append(this.eol);
        }
        stringBuilder.append(cobolFormatter.formatLine("INPUT-OUTPUT SECTION.")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("DATA DIVISION.")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("FILE SECTION.")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("WORKING-STORAGE SECTION.")).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("LINKAGE SECTION."));
        if (bl2) {
            stringBuilder.append(cobolFormatter.formatLine("01 LNK-AREA OBJECT REFERENCE WEB-AREA."));
        }
        stringBuilder.append(this.eol);
        if (!bl2) {
            stringBuilder.append(cobolFormatter.formatLine("SCREEN SECTION.")).append(this.eol);
        }
        String string4 = "PROCEDURE DIVISION";
        if (bl2) {
            string4 = string4 + " USING LNK-AREA";
        }
        string4 = string4 + ".";
        stringBuilder.append(cobolFormatter.formatLine(string4)).append(this.eol);
        stringBuilder.append(cobolFormatter.formatLine("MAIN."));
        PluginUtilities.modifyFile((IFile)iFile, (String)stringBuilder.toString(), (boolean)true);
        IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile);
        if (iEditorDescriptor == null || !iEditorDescriptor.getId().equals(IscobolEditor.ID)) {
            IDE.setDefaultEditor((IFile)iFile, (String)IscobolEditor.ID);
        }
        return iFile;
    }

    protected boolean validatePage() {
        boolean bl = super.validatePage();
        if (!bl) {
            return bl;
        }
        IPath iPath = this.getContainerFullPath();
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (!(iResource instanceof IContainer) || !PluginUtilities.isInSourceFolder((IContainer)((IContainer)iResource))) {
            this.setErrorMessage(IsresourceBundle.getString((String)"file_not_in_src_fld_msg"));
            bl = false;
        } else {
            this.setErrorMessage(null);
        }
        return bl;
    }
}

