/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.plugins.editor.wizards.ClasspathPage;
import com.iscobol.plugins.editor.wizards.EasyDBSettingsPage;
import com.iscobol.plugins.editor.wizards.FilterExtensionsPage;
import com.iscobol.plugins.editor.wizards.IscobolNewProjectPage;
import com.iscobol.plugins.editor.wizards.IscobolNewProjectWizard;
import com.iscobol.plugins.editor.wizards.ProjectSettingsPage;
import com.iscobol.plugins.editor.wizards.ProjectSettingsPage2;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.Bundle;

public class IscobolNewProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    protected IscobolNewProjectPage mainPage;
    protected ProjectSettingsPage projectPage1;
    protected ProjectSettingsPage2 projectPage2;
    protected FilterExtensionsPage filterExtensionPage;
    protected EasyDBSettingsPage easyDbPage;
    protected ClasspathPage classpathPage;
    protected WizardNewProjectReferencePage referencePage;
    protected IProject newProject;

    public void addPages() {
        this.mainPage = new IscobolNewProjectPage();
        this.addPage((IWizardPage)this.mainPage);
        this.projectPage1 = new ProjectSettingsPage();
        this.projectPage1.setWizard((IWizard)this);
        this.projectPage1.setPreviousPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.projectPage1);
        this.projectPage2 = new ProjectSettingsPage2();
        this.projectPage2.setWizard((IWizard)this);
        this.projectPage2.setPreviousPage((IWizardPage)this.projectPage1);
        this.addPage((IWizardPage)this.projectPage2);
        this.filterExtensionPage = new FilterExtensionsPage();
        this.filterExtensionPage.setWizard((IWizard)this);
        this.filterExtensionPage.setPreviousPage((IWizardPage)this.projectPage2);
        this.addPage((IWizardPage)this.filterExtensionPage);
        this.easyDbPage = new EasyDBSettingsPage();
        this.easyDbPage.setWizard((IWizard)this);
        this.easyDbPage.setPreviousPage((IWizardPage)this.filterExtensionPage);
        this.addPage((IWizardPage)this.easyDbPage);
        this.classpathPage = new ClasspathPage();
        this.classpathPage.setWizard((IWizard)this);
        this.classpathPage.setPreviousPage((IWizardPage)this.easyDbPage);
        this.addPage((IWizardPage)this.classpathPage);
        this.projectPage1.setNextPage((IWizardPage)this.projectPage2);
        this.projectPage2.setNextPage((IWizardPage)this.filterExtensionPage);
        this.filterExtensionPage.setNextPage((IWizardPage)this.easyDbPage);
        this.easyDbPage.setNextPage((IWizardPage)this.classpathPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            this.referencePage.setTitle(IsresourceBundle.getString((String)"project_ref_title"));
            this.referencePage.setDescription(IsresourceBundle.getString((String)"project_ref_desc"));
            this.classpathPage.setNextPage((IWizardPage)this.referencePage);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    protected IProject createNewProject() {
        1 var5_5;
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject iProject = this.mainPage.getProjectHandle();
        IPath iPath = null;
        if (!this.mainPage.useDefaults()) {
            iPath = this.mainPage.getLocationPath();
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocation(iPath);
        if (this.referencePage != null && ((IProject[])(var5_5 = this.referencePage.getReferencedProjects())).length > 0) {
            iProjectDescription.setReferencedProjects((IProject[])var5_5);
        }
        var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)var5_5);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            PluginUtilities.log((Throwable)invocationTargetException);
        }
        this.newProject = iProject;
        return this.newProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intCreateProject(IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            iProgressMonitor.beginTask("", 2000);
            iProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public boolean performFinish() {
        IIscobolNavigator iIscobolNavigator;
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        try {
            this.addBuilder(this.newProject, "com.iscobol.plugins.editor.IscobolEditor.IscobolBuilder");
            this.addNatures(this.newProject);
            this.projectPage1.performOk(this.newProject, true);
            this.projectPage2.performOk(this.newProject, true);
            this.easyDbPage.performOk(this.newProject, true);
            this.classpathPage.performOk(this.newProject);
        }
        catch (CoreException coreException) {
            PluginUtilities.log((Throwable)coreException);
        }
        this.addSystemFiles();
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        IIscobolNavigator iIscobolNavigator2 = PluginUtilities.findStructuralNavigator();
        if (iIscobolNavigator2 != null) {
            iIscobolNavigator2.refresh((Object)this.newProject);
        }
        if ((iIscobolNavigator = PluginUtilities.findDataNavigator()) != null) {
            iIscobolNavigator.refresh((Object)this.newProject);
        }
        return true;
    }

    protected void addSystemFiles() {
        String string = PluginUtilities.getCurrentSettingMode((IResource)this.newProject);
        try {
            IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)this.newProject, (String)string);
            if (iContainerArray.length > 0) {
                String string2 = IscobolEditorPlugin.getStringFromStore((String)"iscobol.systemcopybooks");
                Bundle bundle = Platform.getBundle((String)"com.iscobol.plugins.libraries");
                if (string2.equals("ALL")) {
                    for (String string3 : IscobolEditorPlugin.SYSTEM_COPY_BOOKS) {
                        this.createFile(iContainerArray[0], (IPath)new Path(string3), bundle, "copy/" + string3);
                    }
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        this.createFile(iContainerArray[0], (IPath)new Path(string4), bundle, "copy/" + string4);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createFile(IContainer object, IPath iPath, Bundle bundle, String string) throws IOException, CoreException {
        IPath iPath2;
        if (iPath.segmentCount() > 1) {
            iPath2 = iPath.removeLastSegments(1);
            object = object.exists(iPath2) ? object.getFolder(iPath2) : new ContainerGenerator(object.getFullPath().append(iPath2)).generateContainer(null);
            iPath = new Path(iPath.lastSegment());
        }
        iPath2 = object.getFile(iPath);
        InputStream inputStream = bundle.getEntry(string).openStream();
        PluginUtilities.createFile((IFile)iPath2, (InputStream)inputStream, (boolean)true);
        inputStream.close();
    }

    protected void addBuilder(IProject iProject, String string) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        for (int i = 0; i < iCommandArray.length; ++i) {
            if (!iCommandArray[i].getBuilderName().equals(string)) continue;
            return;
        }
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName(string);
        iCommand.setBuilding(6, true);
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
        System.arraycopy(iCommandArray, 0, iCommandArray2, 1, iCommandArray.length);
        iCommandArray2[0] = iCommand;
        iProjectDescription.setBuildSpec(iCommandArray2);
        iProject.setDescription(iProjectDescription, null);
    }

    protected void addNatures(IProject iProject) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setNatureIds(new String[]{"com.iscobol.plugins.editor.IscobolEditor.IscobolNature", "com.iscobol.plugins.editor.IscobolEditor.IscobolNatureExt"});
        iProject.setDescription(iProjectDescription, null);
    }

    static /* synthetic */ void access$000(IscobolNewProjectWizard iscobolNewProjectWizard, IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        iscobolNewProjectWizard.intCreateProject(iProjectDescription, iProject, iProgressMonitor);
    }
}

