/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.AbstractImportPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class IscobolProgramImportPage
extends AbstractImportPage<IFile> {
    private List extensions = new ArrayList();
    private Button filterTypesBtn;
    private Button createLinksBtn;
    private boolean createLinks;

    public IscobolProgramImportPage(String string, String string2) {
        super(string, string2);
        String string3 = this.getImportExtensions();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.extensions.add(stringTokenizer.nextToken());
        }
    }

    protected String getLastImportDirectory() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.sourceImportDirectory");
    }

    protected void setLastImportDirectory(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.sourceImportDirectory", string);
    }

    protected String getImportExtensions() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.sourceImportExtensions");
    }

    protected void setImportExtensions(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.sourceImportExtensions", string);
    }

    protected boolean validateSelection() {
        if (this.progNames == null) {
            this.setPageInvalid(IsresourceBundle.getString((String)"no_program_selected_msg"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFiles(IProgressMonitor iProgressMonitor) {
        try {
            IContainer iContainer = (IContainer)this.getParentResource();
            iContainer.refreshLocal(2, null);
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("Import programs", this.progNames.length);
            }
            boolean bl = false;
            for (int i = 0; i < this.progFiles.length; ++i) {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String string = this.progNames[i];
                Path path = new Path(string);
                IFile iFile = iContainer.getFile((IPath)path);
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Import program '" + iFile.getName() + "'...");
                }
                if (this.importProgramInfo((Object)iFile, this.progFiles[i])) {
                    boolean bl2;
                    if (this.exists((IResource)iFile)) {
                        iFile.delete(true, null);
                    }
                    if (this.createLinks) {
                        bl2 = PluginUtilities.createLinkFile((IFile)iFile, (URI)this.progFiles[i].toURI());
                    } else {
                        FileInputStream fileInputStream = new FileInputStream(this.progFiles[i]);
                        bl2 = PluginUtilities.createFile((IFile)iFile, (InputStream)fileInputStream, (boolean)true);
                        ((InputStream)fileInputStream).close();
                    }
                    if (bl2) {
                        bl = true;
                    }
                } else {
                    PluginUtilities.removePersistentProperties((IFile)iFile);
                }
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            if (bl) {
                PluginUtilities.saveProjectOptions((IProject)this.getParentResource().getProject());
            }
        }
        catch (CoreException coreException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    public boolean validateFileName(String string) {
        if (this.extensions.isEmpty()) {
            return true;
        }
        string = string.toLowerCase();
        for (Object e : this.extensions) {
            if (!string.endsWith("." + e.toString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected Image getFileTreeItemImage() {
        return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/source.gif");
    }

    protected IFile getFile(Object object) {
        if (object instanceof IFile) {
            return (IFile)object;
        }
        return null;
    }

    protected IContainer getContainer(Object object) {
        IProject iProject = null;
        if (object instanceof IResource) {
            iProject = ((IResource)object).getProject();
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            iProject = (IProject)iAdaptable.getAdapter(IProject.class);
        }
        if (iProject != null) {
            if (object instanceof IContainer && PluginUtilities.isInSourceFolder((IContainer)((IContainer)object))) {
                return (IContainer)object;
            }
            try {
                return PluginUtilities.getSourceFolder((IProject)iProject);
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected boolean importProgramInfo0(IFile iFile, File file) throws Exception {
        return true;
    }

    protected void loadDestinationTree(Tree tree) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray != null) {
            for (int i = 0; i < iProjectArray.length; ++i) {
                if (!iProjectArray[i].isOpen() || !this.isIscobolProject(iProjectArray[i])) continue;
                this.setExistsProjects(true);
                TreeItem treeItem = new TreeItem(tree, 0);
                IContainer iContainer = null;
                try {
                    iContainer = PluginUtilities.getSourceFolder((IProject)iProjectArray[i]);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (iContainer != null) {
                    if (iContainer != iProjectArray[i]) {
                        treeItem.setText(iProjectArray[i].getName() + "/" + iContainer.getName());
                        treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/sourcefolder.gif"));
                        treeItem.setData((Object)iContainer);
                    } else {
                        treeItem.setText(iProjectArray[i].getName());
                        treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
                        treeItem.setData((Object)iProjectArray[i]);
                    }
                    try {
                        this.visit(iContainer, treeItem);
                    }
                    catch (CoreException coreException) {}
                    continue;
                }
                treeItem.setText(iProjectArray[i].getName());
                treeItem.setData((Object)iProjectArray[i]);
            }
        }
    }

    protected boolean hasAdvancedControls() {
        return true;
    }

    protected void createAdvancedControls(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        this.createLinksBtn = new Button(composite, 32);
        this.createLinksBtn.setText(IsresourceBundle.getString((String)"create_links_lbl"));
        this.createLinksBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void visit(IContainer iContainer, TreeItem treeItem) throws CoreException {
        IResource[] iResourceArray;
        for (IResource iResource : iResourceArray = iContainer.members()) {
            if (!(iResource instanceof IFolder)) continue;
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setText(iResource.getName());
            treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/sourcefolder.gif"));
            treeItem2.setData((Object)iResource);
            this.visit((IContainer)iResource, treeItem2);
        }
    }

    protected String getFileTreeItemText(String string) {
        return string;
    }

    protected Composite createButtonPanel(Composite composite) {
        Composite composite2 = super.createButtonPanel(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 3;
        this.filterTypesBtn = new Button(composite2, 8);
        this.filterTypesBtn.setText("Filter Types...");
        this.filterTypesBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    static /* synthetic */ boolean access$002(IscobolProgramImportPage iscobolProgramImportPage, boolean bl) {
        iscobolProgramImportPage.createLinks = bl;
        return iscobolProgramImportPage.createLinks;
    }

    static /* synthetic */ Button access$100(IscobolProgramImportPage iscobolProgramImportPage) {
        return iscobolProgramImportPage.createLinksBtn;
    }

    static /* synthetic */ List access$200(IscobolProgramImportPage iscobolProgramImportPage) {
        return iscobolProgramImportPage.extensions;
    }
}

