/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class IscobolProjectSelectionWizardPage
extends WizardPage {
    private Tree tree;
    private boolean existsProjects;
    protected IProject parentProject;
    private IStructuredSelection selection;
    private String label;
    private IPropertyChangeListener listener;
    private boolean htmlProjects;

    public IscobolProjectSelectionWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection) {
        this(string, string2, string3, iStructuredSelection, false);
    }

    public IscobolProjectSelectionWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, boolean bl) {
        super(string, string2, null);
        this.label = string3;
        this.selection = iStructuredSelection;
        this.htmlProjects = bl;
    }

    public IProject getParentProject() {
        return this.parentProject;
    }

    private boolean validatePage() {
        if (!this.existsProjects) {
            this.setPageInvalid(IsresourceBundle.getString((String)"no_projects_msg"));
            return false;
        }
        boolean bl = this.validateParent();
        if (bl) {
            this.setPageValid();
        }
        return bl;
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    private boolean validateParent() {
        if (this.parentProject == null) {
            this.setPageInvalid(IsresourceBundle.getString((String)"select_parent_prj_msg"));
            return false;
        }
        return true;
    }

    public void createControl(Composite composite) {
        TreeItem treeItem;
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(this.label);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.tree = new Tree(composite2, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 80;
        this.tree.setLayoutData((Object)gridData);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray != null) {
            for (int i = 0; i < iProjectArray.length; ++i) {
                if (!iProjectArray[i].isOpen() || !this.isIscobolProject(iProjectArray[i])) continue;
                this.existsProjects = true;
                treeItem = new TreeItem(this.tree, 0);
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
                treeItem.setText(iProjectArray[i].getName());
                treeItem.setData((Object)iProjectArray[i]);
            }
        }
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.selection.isEmpty()) {
            IProject iProject = ((IResource)this.selection.getFirstElement()).getProject();
            treeItem = this.tree.getItems();
            for (int i = 0; i < ((TreeItem[])treeItem).length; ++i) {
                if (!treeItem[i].getText().equals(iProject.getName())) continue;
                this.tree.setSelection(treeItem[i]);
                this.parentProject = iProject;
            }
        }
        this.validatePage();
    }

    private boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null && (!this.htmlProjects || iProject.getNature("com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature") != null);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IPropertyChangeListener getListener() {
        return this.listener;
    }

    public void setListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listener = iPropertyChangeListener;
    }

    static /* synthetic */ IPropertyChangeListener access$000(IscobolProjectSelectionWizardPage iscobolProjectSelectionWizardPage) {
        return iscobolProjectSelectionWizardPage.listener;
    }

    static /* synthetic */ boolean access$100(IscobolProjectSelectionWizardPage iscobolProjectSelectionWizardPage) {
        return iscobolProjectSelectionWizardPage.validatePage();
    }
}

