/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;

public class NewLinkedFilesPage
extends WizardPage {
    private static final int YES = 0;
    private static final int YES_ALL = 1;
    private static final int NO = 2;
    private static final int NO_ALL = 3;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private Tree dirTree;
    private TreeItem dirTreeRootItem;
    private Tree fileTree;
    private Tree destTree;
    private TreeItem lastFileItem;
    private TreeItem lastDirItem;
    private TreeEditor fileTreeEditor;
    private Button selectAll;
    private Button deselectAll;
    private Button filterTypes;
    private Text fromDir;
    protected IContainer parentFolder;
    protected String[] fileNames;
    protected File[] files;
    private boolean existsProjects;
    private int overwriteCode = 2;
    private String[] lastExtensions;
    private String lastOtherExtensions;
    private FileFilter filter = new /* Unavailable Anonymous Inner Class!! */;

    public NewLinkedFilesPage(String string) {
        super(string);
    }

    public NewLinkedFilesPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    protected String getLastLinkDirectory() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.LinkDirectory");
    }

    protected void setLastLinkDirectory(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.LinkDirectory", string);
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    private boolean isIscobolProject(IProject iProject) {
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void createControl(Composite composite) {
        String string;
        Object object;
        TreeItem treeItem;
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"select_dest_folder_lbl"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
        this.destTree = new Tree(composite2, 0x10000800);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 180;
        this.destTree.setLayoutData((Object)gridData);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        this.destTree.addListener(36, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        if (iProjectArray != null) {
            this.destTree.setItemCount(iProjectArray.length);
            for (int i = 0; i < iProjectArray.length; ++i) {
                if (!iProjectArray[i].isOpen() || !this.isIscobolProject(iProjectArray[i])) continue;
                this.existsProjects = true;
                treeItem = new TreeItem(this.destTree, 0);
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
                treeItem.setText(iProjectArray[i].getName());
                treeItem.setData((Object)iProjectArray[i]);
            }
        }
        this.destTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"from_dir_lbl"));
        this.fromDir = new Text(composite2, 2048);
        this.fromDir.addListener(14, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.fromDir.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(768);
        this.fromDir.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        button.setText(IsresourceBundle.getString((String)"browse_lbl"));
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        treeItem = new Composite(composite2, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        treeItem.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        treeItem.setLayout((Layout)gridLayout);
        label = new Label((Composite)treeItem, 0);
        label = new Label((Composite)treeItem, 0);
        label.setText("(" + IsresourceBundle.getString((String)"rename_help_msg") + ")");
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        this.dirTree = new Tree((Composite)treeItem, 268437508);
        gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        this.dirTree.setLayoutData((Object)gridData);
        this.dirTree.addListener(36, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.dirTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree = new Tree((Composite)treeItem, 2084);
        this.fileTree.setToolTipText(IsresourceBundle.getString((String)"rename_help_msg"));
        this.fileTreeEditor = new TreeEditor(this.fileTree);
        this.fileTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(1808);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        gridData.horizontalIndent = 10;
        this.fileTree.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        composite3.setLayoutData((Object)gridData);
        this.filterTypes = new Button(composite3, 8);
        this.filterTypes.setText(IsresourceBundle.getString((String)"filter_types_lbl"));
        this.filterTypes.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectAll = new Button(composite3, 8);
        this.selectAll.setText(IsresourceBundle.getString((String)"select_all_lbl"));
        this.selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deselectAll = new Button(composite3, 8);
        this.deselectAll.setText(IsresourceBundle.getString((String)"deselect_all_lbl"));
        this.deselectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.selection != null && (object = this.selection.getFirstElement()) instanceof IContainer) {
            this.select((IContainer)object);
        }
        if ((string = this.getLastLinkDirectory()) != null) {
            this.fromDir.setText(string);
            this.loadDirTree(string);
        }
        this.validatePage();
    }

    private void selectFiles() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.lastExtensions != null) {
            for (int i = 0; i < this.lastExtensions.length; ++i) {
                hashMap.put(this.lastExtensions[i], this.lastExtensions[i]);
            }
        }
        if (this.lastOtherExtensions != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.lastOtherExtensions, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string.startsWith("*.")) {
                    string = string.substring(2);
                } else if (string.startsWith(".")) {
                    string = string.substring(1);
                }
                hashMap.put(string, string);
            }
        }
        TreeItem[] treeItemArray = this.fileTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            string = treeItemArray[i].getText();
            int n = string.lastIndexOf(46);
            if (n >= 0 && n < string.length() - 1 && hashMap.containsKey(string.substring(n + 1))) {
                treeItemArray[i].setChecked(true);
                continue;
            }
            treeItemArray[i].setChecked(false);
        }
        this.setFiles();
        this.validatePage();
    }

    private void loadDirTree(String string) {
        this.dirTree.removeAll();
        this.fileTree.removeAll();
        File file = new File(string);
        this.fileNames = null;
        this.files = null;
        if (file.exists() && file.isDirectory()) {
            this.setLastLinkDirectory(string);
            this.dirTreeRootItem = new TreeItem(this.dirTree, 0);
            this.dirTreeRootItem.setText(file.getName());
            this.dirTreeRootItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
            this.dirTreeRootItem.setData("file", (Object)file);
            File[] fileArray = PluginUtilities.listFiles((File)file, (FileFilter)this.filter);
            if (fileArray != null && fileArray.length > 0) {
                this.dirTreeRootItem.setData("children", (Object)fileArray);
                this.dirTreeRootItem.setItemCount(fileArray.length);
                this.dirTreeRootItem.setExpanded(true);
            }
            this.dirTree.setSelection(this.dirTreeRootItem);
            this.loadFileTree(file);
        }
        this.validatePage();
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
        this.workbench = iWorkbench;
    }

    void activateEditor(TreeItem treeItem) {
        boolean bl = true;
        Composite composite = new Composite((Composite)this.fileTree, 0);
        if (bl) {
            composite.setBackground(treeItem.getDisplay().getSystemColor(2));
        }
        Text text = new Text(composite, 0);
        int n = bl ? 1 : 0;
        composite.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addVerifyListener((VerifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTreeEditor.setEditor((Control)composite, treeItem);
        text.setText(treeItem.getText());
        text.selectAll();
        text.setFocus();
    }

    private boolean validatePage() {
        boolean bl;
        if (!this.existsProjects) {
            this.setPageInvalid(IsresourceBundle.getString((String)"no_projects_msg"));
            return false;
        }
        boolean bl2 = bl = this.validateParent() && this.validateSelection();
        if (bl) {
            this.setPageValid();
        }
        return bl;
    }

    private boolean validateParent() {
        if (this.parentFolder == null) {
            this.setPageInvalid(IsresourceBundle.getString((String)"select_dest_folder_lbl"));
            return false;
        }
        return true;
    }

    protected boolean validateSelection() {
        return true;
    }

    private void setFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        TreeItem[] treeItemArray = this.fileTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getChecked()) continue;
            arrayList.add(treeItemArray[i].getText());
            arrayList2.add(treeItemArray[i].getData());
        }
        if (arrayList2.size() == 0) {
            this.fileNames = null;
            this.files = null;
        } else {
            this.fileNames = new String[arrayList.size()];
            arrayList.toArray(this.fileNames);
            this.files = new File[arrayList2.size()];
            arrayList2.toArray(this.files);
        }
    }

    protected boolean exists(IResource iResource) {
        IPath iPath = iResource.getLocation();
        return iPath != null && iPath.toFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFiles(ArrayList arrayList, IProgressMonitor iProgressMonitor) {
        try {
            this.parentFolder.refreshLocal(2, null);
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("Create Links", this.fileNames.length);
            }
            boolean bl = false;
            for (int i = 0; i < this.fileNames.length; ++i) {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String string = this.fileNames[i];
                Path path = new Path(string);
                IFile iFile = this.parentFolder.getFile((IPath)path);
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Link file '" + iFile.getName() + "'...");
                }
                if (this.canCreate(iFile, this.files[i])) {
                    if (this.exists((IResource)iFile)) {
                        PluginUtilities.deleteFile((IFile)iFile, (boolean)false);
                    }
                    if (PluginUtilities.createLinkFile((IFile)iFile, (URI)this.files[i].toURI())) {
                        arrayList.add(iFile);
                        bl = true;
                    }
                } else {
                    PluginUtilities.removePersistentProperties((IFile)iFile);
                }
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            if (bl) {
                PluginUtilities.saveProjectOptions((IProject)this.parentFolder.getProject());
            }
        }
        catch (CoreException coreException) {
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    protected IFile[] createFiles() {
        if (this.fileNames == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            this.createFiles(arrayList, null);
            IFile[] iFileArray = new IFile[arrayList.size()];
            arrayList.toArray(iFileArray);
            return iFileArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void select(IContainer iContainer) {
        if (iContainer != null) {
            IPath iPath = iContainer.getFullPath();
            this.select(this.destTree.getItems(), iPath, 0);
            this.parentFolder = iContainer;
        }
        this.validatePage();
    }

    private void select(TreeItem[] treeItemArray, IPath iPath, int n) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getText().equals(iPath.segment(n))) continue;
            if (n >= iPath.segmentCount() - 1 || treeItemArray[i].getItemCount() <= 0) {
                this.destTree.setSelection(treeItemArray[i]);
                return;
            }
            this.select(treeItemArray[i].getItems(), iPath, n + 1);
            return;
        }
    }

    public boolean validateFileName(String string) {
        return true;
    }

    private void loadFileTree(File file) {
        File[] fileArray = PluginUtilities.listFiles((File)file, (FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.removeAll();
        for (int i = 0; i < fileArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.fileTree, 0);
            String string = fileArray[i].getName();
            treeItem.setText(string);
            treeItem.setData((Object)fileArray[i]);
            treeItem.setImage(PluginUtilities.getFileTreeItemImage((String)fileArray[i].getName()));
        }
        this.selectFiles();
        this.fileNames = null;
        this.validatePage();
    }

    private int openMessageDialog(String string) {
        int[] nArray = new int[]{0};
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return nArray[0];
    }

    protected boolean canCreate(IFile iFile, File file) {
        if (this.exists((IResource)iFile)) {
            switch (this.overwriteCode) {
                case 1: {
                    return true;
                }
                case 0: 
                case 2: {
                    this.overwriteCode = this.openMessageDialog(IsresourceBundle.getString((String)"overwrite_lbl") + " file '" + iFile.getName() + "'");
                    if (this.overwriteCode < 0) {
                        this.overwriteCode = 2;
                    }
                    switch (this.overwriteCode) {
                        case 0: 
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ Tree access$000(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.destTree;
    }

    static /* synthetic */ boolean access$100(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.validatePage();
    }

    static /* synthetic */ Text access$200(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.fromDir;
    }

    static /* synthetic */ void access$300(NewLinkedFilesPage newLinkedFilesPage, String string) {
        newLinkedFilesPage.loadDirTree(string);
    }

    static /* synthetic */ TreeItem access$400(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.dirTreeRootItem;
    }

    static /* synthetic */ FileFilter access$500(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.filter;
    }

    static /* synthetic */ Tree access$600(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.dirTree;
    }

    static /* synthetic */ TreeItem access$700(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastDirItem;
    }

    static /* synthetic */ void access$800(NewLinkedFilesPage newLinkedFilesPage, File file) {
        newLinkedFilesPage.loadFileTree(file);
    }

    static /* synthetic */ TreeItem access$702(NewLinkedFilesPage newLinkedFilesPage, TreeItem treeItem) {
        newLinkedFilesPage.lastDirItem = treeItem;
        return newLinkedFilesPage.lastDirItem;
    }

    static /* synthetic */ TreeItem access$902(NewLinkedFilesPage newLinkedFilesPage, TreeItem treeItem) {
        newLinkedFilesPage.lastFileItem = treeItem;
        return newLinkedFilesPage.lastFileItem;
    }

    static /* synthetic */ void access$1000(NewLinkedFilesPage newLinkedFilesPage) {
        newLinkedFilesPage.setFiles();
    }

    static /* synthetic */ TreeItem access$900(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastFileItem;
    }

    static /* synthetic */ String[] access$1100(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastExtensions;
    }

    static /* synthetic */ String access$1200(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastOtherExtensions;
    }

    static /* synthetic */ String[] access$1102(NewLinkedFilesPage newLinkedFilesPage, String[] stringArray) {
        newLinkedFilesPage.lastExtensions = stringArray;
        return stringArray;
    }

    static /* synthetic */ String access$1202(NewLinkedFilesPage newLinkedFilesPage, String string) {
        newLinkedFilesPage.lastOtherExtensions = string;
        return newLinkedFilesPage.lastOtherExtensions;
    }

    static /* synthetic */ void access$1300(NewLinkedFilesPage newLinkedFilesPage) {
        newLinkedFilesPage.selectFiles();
    }

    static /* synthetic */ Tree access$1400(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.fileTree;
    }

    static /* synthetic */ TreeEditor access$1500(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.fileTreeEditor;
    }
}

