/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.preferences.PreferencesUtil;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.wizards.ResourceSettingsPanel;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectSettingsPage
extends PropertyPage
implements IWizardPage {
    private Text sourceTxt;
    private Text resourceTxt;
    private Text logsTxt;
    private Text dataTxt;
    private Text fdslFldTxt;
    private Text screenCopyFldTxt;
    private Text iscobolPropsTxt;
    private Text htmlAndroidTxt;
    private Button webxmlStandardBtn;
    private Button webxmlCustomBtn;
    private Text webxmlCustomTxt;
    private Button webxmlCustomBrowseBtn;
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private boolean valid = true;
    private boolean screenPainterPluginLoaded = Platform.getBundle((String)"com.iscobol.plugins.screenpainter.IscobolScreenPainter") != null;
    private boolean htmlProject;
    private Control control;

    public boolean isHtmlProject() {
        return this.htmlProject;
    }

    public void setHtmlProject(boolean bl) {
        this.htmlProject = bl;
    }

    public boolean canFlipToNextPage() {
        return this.valid;
    }

    public String getName() {
        return "";
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.control != null) {
            IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
            this.sourceTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.sourcedir"));
            this.resourceTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.resourcesdir"));
            this.logsTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.logsdir"));
            this.dataTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.datadir"));
            this.fdslFldTxt.setText(this.getPreference(iPreferenceStore, this.htmlProject ? "iscobol.newproject._copydir" : "iscobol.newproject.fdsldir"));
            if (!this.htmlProject) {
                this.screenCopyFldTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.copydir"));
            }
            this.iscobolPropsTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.ispropsfile"));
            if (this.htmlProject) {
                this.htmlAndroidTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.htmlandroiddir"));
                this.webxmlStandardBtn.setSelection(true);
                this.webxmlCustomBtn.setSelection(false);
                this.webxmlCustomTxt.setEnabled(false);
                this.webxmlCustomBrowseBtn.setEnabled(false);
            }
        }
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return this.valid;
    }

    private String getPreference(IPreferenceStore iPreferenceStore, String string) {
        if (iPreferenceStore.contains(string)) {
            return iPreferenceStore.getString(string);
        }
        return iPreferenceStore.getDefaultString(string);
    }

    private IProject castOrAdaptProject() {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return iProject;
    }

    public Control createContents(Composite composite) {
        IFolder iFolder;
        String[] stringArray;
        String string;
        int n;
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        this.setTitle("Project Settings");
        IProject iProject = this.castOrAdaptProject();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n = iProject != null ? 3 : 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"src_dir_lbl") + ": ");
        this.sourceTxt = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.sourceTxt.setLayoutData((Object)gridData);
        if (iProject != null) {
            try {
                this.htmlProject = iProject.getNature("com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature") != null;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"sourcedir");
            if (string != null) {
                this.sourceTxt.setText(string);
            }
            this.createBrowseButton(iProject, this.sourceTxt);
        } else {
            this.sourceTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.sourcedir"));
        }
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"res_dir_lbl") + ": ");
        this.resourceTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.resourceTxt.setLayoutData((Object)gridData);
        if (iProject != null) {
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"resourcesdir");
            if (string != null) {
                this.resourceTxt.setText(string);
            }
            this.createBrowseButton(iProject, this.resourceTxt);
        } else {
            this.resourceTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.resourcesdir"));
        }
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"logs_dir_lbl") + ": ");
        this.logsTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.logsTxt.setLayoutData((Object)gridData);
        if (iProject != null) {
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"logsdir");
            if (string != null) {
                this.logsTxt.setText(string);
            }
            this.createBrowseButton(iProject, this.logsTxt);
        } else {
            this.logsTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.logsdir"));
        }
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"data_dir_lbl") + ": ");
        this.dataTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.dataTxt.setLayoutData((Object)gridData);
        if (iProject != null) {
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"datadir");
            if (string != null) {
                this.dataTxt.setText(string);
            }
            this.createBrowseButton(iProject, this.dataTxt);
        } else {
            this.dataTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.datadir"));
        }
        label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)(this.htmlProject ? "cpy_dir_lbl" : "fdsl_copy_dir_lbl")) + ": ");
        this.fdslFldTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.fdslFldTxt.setLayoutData((Object)gridData);
        if (iProject != null) {
            string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)(this.htmlProject ? "copydir" : "fdslcopydir"));
            if (string == null && (string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject), (String)"-sp=")) != null) {
                stringArray = string.split(File.pathSeparator);
                string = stringArray.length > 0 ? stringArray[0] : "";
            }
            if (string != null) {
                this.fdslFldTxt.setText(string);
                if (this.htmlProject) {
                    PreferencesUtil.getInstance().setCopyFolder(string, false);
                } else {
                    PreferencesUtil.getInstance().setFdslCopyFolder(string, false);
                }
            }
            this.createBrowseButton(iProject, this.fdslFldTxt);
        } else {
            string = this.getPreference(iPreferenceStore, this.htmlProject ? "iscobol.newproject._copydir" : "iscobol.newproject.fdsldir");
            this.fdslFldTxt.setText(string);
            if (this.htmlProject) {
                PreferencesUtil.getInstance().setCopyFolder(string, false);
            } else {
                PreferencesUtil.getInstance().setFdslCopyFolder(string, false);
            }
        }
        if (!this.htmlProject) {
            label = new Label(composite2, 0);
            label.setText(IsresourceBundle.getString((String)"screen_pgm_copy_dir_lbl") + ": ");
            this.screenCopyFldTxt = new Text(composite2, 2048);
            gridData = new GridData(768);
            this.screenCopyFldTxt.setLayoutData((Object)gridData);
            if (iProject != null) {
                string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"screencopydir");
                if (string == null && (string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject), (String)"-sp=")) != null) {
                    stringArray = string.split(File.pathSeparator);
                    string = stringArray.length > 0 ? stringArray[0] : "";
                }
                if (string != null) {
                    this.screenCopyFldTxt.setText(string);
                    PreferencesUtil.getInstance().setScreenProgramCopyFolder(string, false);
                }
                this.createBrowseButton(iProject, this.screenCopyFldTxt);
            } else {
                string = this.getPreference(iPreferenceStore, "iscobol.newproject.copydir");
                this.screenCopyFldTxt.setText(string);
                PreferencesUtil.getInstance().setScreenProgramCopyFolder(string, false);
            }
        }
        if (this.htmlProject) {
            label = new Label(composite2, 0);
            label.setText(IsresourceBundle.getString((String)"html_android_dir_lbl") + ": ");
            this.htmlAndroidTxt = new Text(composite2, 2048);
            gridData = new GridData(768);
            this.htmlAndroidTxt.setLayoutData((Object)gridData);
            if (iProject != null) {
                string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"html_androiddir");
                if (string != null) {
                    this.htmlAndroidTxt.setText(string);
                }
                this.createBrowseButton(iProject, this.htmlAndroidTxt);
            } else {
                this.htmlAndroidTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.htmlandroiddir"));
            }
            stringArray = new Group(composite2, 0);
            stringArray.setText(IsresourceBundle.getString((String)"webxml_lbl"));
            iFolder = new GridLayout();
            iFolder.numColumns = 3;
            stringArray.setLayout((Layout)iFolder);
            gridData = new GridData(768);
            gridData.horizontalSpan = gridLayout.numColumns;
            stringArray.setLayoutData((Object)gridData);
            this.webxmlStandardBtn = new Button((Composite)stringArray, 16);
            this.webxmlStandardBtn.setText(IsresourceBundle.getString((String)"use_standard_webxml_lbl"));
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.webxmlStandardBtn.setLayoutData((Object)gridData);
            this.webxmlCustomBtn = new Button((Composite)stringArray, 16);
            this.webxmlCustomBtn.setText(IsresourceBundle.getString((String)"use_custom_webxml_lbl"));
            this.webxmlCustomTxt = new Text((Composite)stringArray, 2048);
            gridData = new GridData(768);
            this.webxmlCustomTxt.setLayoutData((Object)gridData);
            this.webxmlCustomBrowseBtn = new Button((Composite)stringArray, 8);
            this.webxmlCustomBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
            if (iProject != null) {
                string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"webxml_file");
                if (string != null && string.length() > 0) {
                    this.webxmlCustomBtn.setSelection(true);
                    this.webxmlStandardBtn.setSelection(false);
                    this.webxmlCustomTxt.setText(string);
                } else {
                    this.webxmlCustomBtn.setSelection(false);
                    this.webxmlStandardBtn.setSelection(true);
                    this.webxmlCustomTxt.setEnabled(false);
                    this.webxmlCustomBrowseBtn.setEnabled(false);
                }
            } else {
                this.webxmlCustomBtn.setSelection(false);
                this.webxmlStandardBtn.setSelection(true);
                this.webxmlCustomTxt.setEnabled(false);
                this.webxmlCustomBrowseBtn.setEnabled(false);
            }
            this.webxmlStandardBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.webxmlCustomBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.webxmlCustomBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        stringArray = new Group(composite2, 0);
        stringArray.setText("iscobol.properties");
        gridData = new GridData(768);
        gridData.horizontalSpan = gridLayout.numColumns;
        gridData.heightHint = 250;
        stringArray.setLayoutData((Object)gridData);
        stringArray.setLayout((Layout)new FillLayout());
        this.iscobolPropsTxt = new Text((Composite)stringArray, 2818);
        if (iProject != null) {
            try {
                iFolder = PluginUtilities.getResourcesFolder((IProject)iProject);
                if (iFolder != null && iFolder.exists()) {
                    Object object;
                    IFile iFile = iFolder.getFile((IPath)new Path("iscobol.properties"));
                    if (!iFile.exists()) {
                        object = this.getPreference(iPreferenceStore, "iscobol.newproject.ispropsfile");
                        PluginUtilities.createFile((IFile)iFile, (String)object);
                    }
                    object = iFile.getContents();
                    byte[] byArray = new byte[((InputStream)object).available()];
                    ((InputStream)object).read(byArray);
                    ((InputStream)object).close();
                    this.iscobolPropsTxt.setText(new String(byArray, PluginUtilities.getCharset((IFile)iFile)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (!this.htmlProject) {
            this.iscobolPropsTxt.setText(this.getPreference(iPreferenceStore, "iscobol.newproject.ispropsfile"));
        }
        this.sourceTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resourceTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.logsTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dataTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fdslFldTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.htmlProject) {
            this.screenCopyFldTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.htmlProject) {
            this.htmlAndroidTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.webxmlCustomTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.control = composite2;
        return composite2;
    }

    private Button createBrowseButton(IProject iProject, Text text) {
        Button button = new Button(text.getParent(), 8);
        button.setText(IsresourceBundle.getString((String)"browse_lbl"));
        GridData gridData = new GridData(4);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return button;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
        super.setValid(bl);
    }

    private boolean setPageValid(String string, int n) {
        this.setMessage(string, n);
        return string == null || n != 3;
    }

    private void validateOpt(IProject iProject, String string, String string2) throws Exception {
        String string3 = !PluginUtilities.isValidPathName((String)string2) ? "Invalid value of " + string + ": '" + string2 + "'" : ResourceSettingsPanel.validateOpt((IProject)iProject, (String)string, (String)string2, (int)1);
        if (string3 != null) {
            throw new Exception(string3);
        }
    }

    public boolean isValid() {
        if (this.control == null) {
            return true;
        }
        IProject iProject = this.castOrAdaptProject();
        try {
            this.validateOpt(iProject, "sourcedir", this.sourceTxt.getText());
            if (this.sourceTxt.getText().equalsIgnoreCase("translated")) {
                return this.setPageValid(IsresourceBundle.getString((String)"translated_reserved_msg"), 3);
            }
        }
        catch (Exception exception) {
            return this.setPageValid(exception.getMessage(), 3);
        }
        try {
            this.validateOpt(iProject, "resourcesdir", this.resourceTxt.getText());
            this.validateOpt(iProject, "logsdir", this.logsTxt.getText());
            this.validateOpt(iProject, "datadir", this.dataTxt.getText());
            this.validateOpt(iProject, this.htmlProject ? "copydir" : "fdslcopydir", this.fdslFldTxt.getText());
            if (!this.htmlProject) {
                this.validateOpt(iProject, "screendir", this.screenCopyFldTxt.getText());
            }
            if (this.htmlProject) {
                File file;
                this.validateOpt(iProject, "html_androiddir", this.htmlAndroidTxt.getText());
                if (!(this.webxmlStandardBtn.getSelection() || (file = new File(this.webxmlCustomTxt.getText().trim())).exists() && file.isFile() && file.getName().equals("web.xml"))) {
                    throw new Exception(IsresourceBundle.getString((String)"invalid_webxml_filename_msg"));
                }
            }
        }
        catch (Exception exception) {
            return this.setPageValid(exception.getMessage(), 2);
        }
        return this.setPageValid(null, 0);
    }

    public boolean performOk() {
        return this.performOk(this.castOrAdaptProject(), false);
    }

    private void saveField(IProject iProject, Text text, boolean bl, String string, String string2, String string3) {
        String string4 = "";
        if (text != null) {
            string4 = text.getText();
        }
        if (string4.length() == 0) {
            string4 = string3;
        }
        Path path = new Path(string4);
        if (!string4.equals("/") && !string4.equals("") && !iProject.exists((IPath)path) && bl) {
            PluginUtilities.createFolder((IFolder)iProject.getFolder((IPath)path));
        }
        PluginUtilities.setPersistentProperty((IResource)iProject, (String)string, (String)string2, (String)string4);
    }

    public boolean performOk(IProject iProject, boolean bl) {
        if (iProject != null) {
            Object object;
            this.saveField(iProject, this.sourceTxt, bl, "Default", "sourcedir", "source");
            if (this.screenPainterPluginLoaded && !this.htmlProject) {
                this.saveField(iProject, null, bl, "Default", "screendir", "screen");
                this.saveField(iProject, null, bl, "Default", "fddir", "fd");
            }
            this.saveField(iProject, this.resourceTxt, bl, "Default", "resourcesdir", "");
            this.saveField(iProject, this.logsTxt, bl, "Default", "logsdir", "logs");
            this.saveField(iProject, this.dataTxt, bl, "Default", "datadir", "data");
            if (this.htmlProject) {
                this.saveField(iProject, this.fdslFldTxt, bl, "Default", "copydir", "cpy");
            } else {
                this.saveField(iProject, this.fdslFldTxt, bl, "Default", "fdslcopydir", "fdsl");
            }
            if (!this.htmlProject) {
                this.saveField(iProject, this.screenCopyFldTxt, bl, "Default", "screencopydir", "screenpgm");
            }
            if (this.htmlProject) {
                this.saveField(iProject, this.htmlAndroidTxt, bl, "Default", "html_androiddir", "html");
                object = "";
                if (this.webxmlCustomBtn.getSelection()) {
                    object = this.webxmlCustomTxt.getText().trim();
                }
                PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"webxml_file", (String)object);
            }
            PluginUtilities.saveProjectOptions((IProject)iProject);
            try {
                object = PluginUtilities.getResourcesFolder((IProject)iProject);
                if (object != null && object.exists()) {
                    IFile iFile = object.getFile((IPath)new Path("iscobol.properties"));
                    if (!iFile.exists()) {
                        PluginUtilities.createFile((IFile)iFile);
                    }
                    String string = this.iscobolPropsTxt.getText();
                    PluginUtilities.modifyFile((IFile)iFile, (String)string, (boolean)false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = PluginUtilities.findFileNavigator();
            if (object != null) {
                object.refresh((Object)iProject);
            }
        }
        return true;
    }

    static /* synthetic */ Text access$000(ProjectSettingsPage projectSettingsPage) {
        return projectSettingsPage.webxmlCustomTxt;
    }

    static /* synthetic */ Button access$100(ProjectSettingsPage projectSettingsPage) {
        return projectSettingsPage.webxmlCustomBrowseBtn;
    }

    static /* synthetic */ boolean access$200(ProjectSettingsPage projectSettingsPage) {
        return projectSettingsPage.htmlProject;
    }

    static /* synthetic */ Text access$300(ProjectSettingsPage projectSettingsPage) {
        return projectSettingsPage.fdslFldTxt;
    }

    static /* synthetic */ Text access$400(ProjectSettingsPage projectSettingsPage) {
        return projectSettingsPage.screenCopyFldTxt;
    }
}

