/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.wizards;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.plugins.editor.wizards.ProjectSettingsPanel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectSettingsPage2
extends PropertyPage
implements IWizardPage {
    private ProjectSettingsPanel panel;
    private Button checkBtn;
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private boolean htmlProject;

    public boolean isHtmlProject() {
        return this.htmlProject;
    }

    public void setHtmlProject(boolean bl) {
        this.htmlProject = bl;
        if (this.panel != null) {
            this.panel.setHtmlProject(bl);
        }
    }

    public boolean canFlipToNextPage() {
        return this.validate();
    }

    private boolean validate() {
        return this.panel != null && this.panel.isValid();
    }

    public String getName() {
        return "";
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.checkBtn != null) {
            this.checkBtn.setSelection(true);
        }
        if (this.panel != null) {
            this.panel.performDefaults();
        }
    }

    public void setWizard(IWizard iWizard) {
        this.wizard = iWizard;
    }

    public void setNextPage(IWizardPage iWizardPage) {
        this.nextPage = iWizardPage;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage iWizardPage) {
        this.prevPage = iWizardPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private IProject castOrAdaptProject() {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return iProject;
    }

    public Control createContents(Composite composite) {
        this.setTitle("Compile/Runtime options");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.checkBtn = new Button(composite2, 32);
        this.checkBtn.setText(IsresourceBundle.getString((String)"use_spec_opt_lbl"));
        IProject iProject = this.castOrAdaptProject();
        if (iProject != null) {
            String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.checkfileopt");
            this.checkBtn.setSelection(string != null && string.equals("___iscobol.option.true"));
        } else {
            this.checkBtn.setSelection(true);
        }
        this.panel = new ProjectSettingsPanel(composite2, iProject, (DialogPage)this, this.htmlProject);
        GridData gridData = new GridData(1808);
        this.panel.setLayoutData((Object)gridData);
        return composite2;
    }

    public boolean isValid() {
        return this.validate();
    }

    public boolean performOk() {
        return this.performOk(this.castOrAdaptProject(), false);
    }

    public boolean performOk(IProject iProject, boolean bl) {
        if (iProject != null) {
            String string = this.checkBtn.getSelection() ? "___iscobol.option.true" : "___iscobol.option.false";
            PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.checkfileopt", (String)string);
            this.panel.performOk((IResource)iProject, bl);
            PluginUtilities.saveProjectOptions((IProject)iProject);
            IIscobolNavigator iIscobolNavigator = PluginUtilities.findFileNavigator();
            if (iIscobolNavigator != null) {
                iIscobolNavigator.refresh((Object)iProject);
            }
        }
        return true;
    }
}

