/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.wizards;

import com.iscobol.html_android.IscobolHtmlAndroidPlugin;
import com.iscobol.html_android.wizards.HtmlToAndroidAppSettingsPage;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PackageName;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HtmlToAndroidAppSettingsPage
extends WizardPage
implements IWizardPage {
    private Text sdkDirTxt;
    private Button sdkDirBrowseBtn;
    private Text appNameTxt;
    private Text appVersionTxt;
    private Text pkgNameTxt;
    private Text destFileTxt;
    private Combo sdkTargetCmb;
    private Button destFileBrowseBtn;
    private Button enableDebugBtn;
    private Button showTitleBarBtn;
    private IProject project;

    public HtmlToAndroidAppSettingsPage(IStructuredSelection iStructuredSelection) {
        super("HtmlToAndroidAppSettingsPage", "Android Application", null);
        if (!iStructuredSelection.isEmpty() && iStructuredSelection.getFirstElement() instanceof IResource) {
            this.project = ((IResource)iStructuredSelection.getFirstElement()).getProject();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Android SDK:");
        this.sdkDirTxt = new Text(composite2, 2048);
        this.sdkDirTxt.setLayoutData((Object)new GridData(768));
        String string = IscobolHtmlAndroidPlugin.getDefault().getPreferenceStore().getString("iscobol.exportandroid.android_sdk_home");
        if (string != null) {
            this.sdkDirTxt.setText(string);
        }
        this.sdkDirBrowseBtn = new Button(composite2, 8);
        this.sdkDirBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.sdkDirBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label(composite2, 0);
        label.setText("Android Target:");
        this.sdkTargetCmb = new Combo(composite2, 2056);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.sdkTargetCmb.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Application Name:");
        this.appNameTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.appNameTxt.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Application Version:");
        this.appVersionTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.appVersionTxt.setLayoutData((Object)gridData);
        this.appVersionTxt.setText("1.0");
        label = new Label(composite2, 0);
        label.setText("Package Name:");
        this.pkgNameTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.pkgNameTxt.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Destination File:");
        this.destFileTxt = new Text(composite2, 2048);
        this.destFileTxt.setLayoutData((Object)new GridData(768));
        this.destFileBrowseBtn = new Button(composite2, 8);
        this.destFileBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.showTitleBarBtn = new Button(composite2, 32);
        this.showTitleBarBtn.setText("Show Title Bar");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.showTitleBarBtn.setLayoutData((Object)gridData);
        this.enableDebugBtn = new Button(composite2, 32);
        this.enableDebugBtn.setText("Enable WebView Remote Debugging");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.enableDebugBtn.setLayoutData((Object)gridData);
        this.setProject(this.project);
        this.destFileBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        3 var7_7 = new /* Unavailable Anonymous Inner Class!! */;
        this.sdkDirTxt.addModifyListener((ModifyListener)var7_7);
        this.appNameTxt.addModifyListener((ModifyListener)var7_7);
        this.appVersionTxt.addModifyListener((ModifyListener)var7_7);
        this.pkgNameTxt.addModifyListener((ModifyListener)var7_7);
        this.destFileTxt.addModifyListener((ModifyListener)var7_7);
        this.sdkTargetCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setControl((Control)composite2);
        this.validatePage(null);
    }

    private void setEnableDebuggingState() {
        String string = this.sdkTargetCmb.getText();
        String string2 = (String)this.sdkTargetCmb.getData(string);
        if (string2 != null && Integer.parseInt(string2) < 19) {
            this.enableDebugBtn.setEnabled(false);
            this.enableDebugBtn.setSelection(false);
        } else {
            this.enableDebugBtn.setEnabled(true);
        }
    }

    private boolean validatePage(ModifyEvent modifyEvent) {
        if (this.getAndroidSdk().length() == 0) {
            return this.setPageInvalid("Set Android SDK");
        }
        Object object = new File(this.getAndroidSdk());
        if (!((File)object).exists() || !((File)object).isDirectory()) {
            return this.setPageInvalid("Android SDK directory does not exist");
        }
        File file = new File(this.sdkDirTxt.getText() + File.separator + "platforms");
        if (!file.exists() || !file.isDirectory()) {
            return this.setPageInvalid("'platforms' folder not found in Android SDK directory");
        }
        File[] fileArray = file.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (fileArray.length == 0) {
            return this.setPageInvalid("No SDK targets available, please run the Android SDK Manager and install at least one SDK Platform");
        }
        if (modifyEvent == null || modifyEvent.widget == this.sdkDirTxt) {
            this.fillSdkTargetCmb(fileArray);
        }
        if (this.getApplicationName().length() == 0) {
            return this.setPageInvalid("Set Application name");
        }
        if (!this.getApplicationVersion().matches("\\d+\\.\\d+(\\.\\d+)?")) {
            return this.setPageInvalid("Invalid Version format");
        }
        object = this.getPackageName();
        if (PackageName.check((String)object) == PackageName.INVALID || !Character.isLowerCase(((String)object).charAt(0)) || ((String)object).indexOf(46) < 0) {
            return this.setPageInvalid("Invalid Package name");
        }
        if (this.getDestinationFile().length() == 0) {
            return this.setPageInvalid("Set Destination File");
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSdkTargetCmb(File[] fileArray) {
        this.sdkTargetCmb.removeAll();
        for (File file : fileArray) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file.getAbsolutePath() + File.separator + "source.properties");
                properties.load(fileInputStream);
                String string = properties.getProperty("Pkg.Desc", "Unknown");
                String string2 = properties.getProperty("AndroidVersion.ApiLevel", "0");
                String string3 = string + " (API Level " + string2 + ")";
                this.sdkTargetCmb.add(string3);
                this.sdkTargetCmb.setData(string3, (Object)string2);
            }
            catch (IOException iOException) {
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        int n = this.getDefaultSdkTargetIndex();
        if (n >= 0) {
            this.sdkTargetCmb.select(n);
        } else {
            this.sdkTargetCmb.select(0);
        }
        this.setEnableDebuggingState();
    }

    private int getDefaultSdkTargetIndex() {
        String string = IscobolHtmlAndroidPlugin.getDefault().getPreferenceStore().getString("iscobol.exportandroid.android_sdk_target");
        if (string != null) {
            for (int i = 0; i < this.sdkTargetCmb.getItemCount(); ++i) {
                if (!string.equals(this.sdkTargetCmb.getData(this.sdkTargetCmb.getItem(i)))) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(false);
        return false;
    }

    public String getApplicationName() {
        return this.appNameTxt.getText().trim();
    }

    public String getPackageName() {
        return this.pkgNameTxt.getText().trim();
    }

    public String getApplicationVersion() {
        return this.appVersionTxt.getText().trim();
    }

    public String getDestinationFile() {
        return this.destFileTxt.getText().trim();
    }

    public boolean isEnableDebugging() {
        return this.enableDebugBtn.getSelection();
    }

    public boolean isShowTitleBar() {
        return this.showTitleBarBtn.getSelection();
    }

    public String getAndroidSdk() {
        return this.sdkDirTxt.getText();
    }

    public String getAndroidSdkTarget() {
        return (String)this.sdkTargetCmb.getData(this.sdkTargetCmb.getText());
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
        if (iProject != null) {
            String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.android_sdk_home");
            if (string != null) {
                this.sdkDirTxt.setText(string);
            } else {
                string = IscobolHtmlAndroidPlugin.getDefault().getPreferenceStore().getString("iscobol.exportandroid.android_sdk_home");
                if (string != null) {
                    this.sdkDirTxt.setText(string);
                }
            }
            String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.android_sdk_target");
            if (string2 != null) {
                this.sdkTargetCmb.setText(string2);
            } else {
                int n = this.getDefaultSdkTargetIndex();
                if (n >= 0) {
                    this.sdkTargetCmb.select(n);
                } else {
                    this.sdkTargetCmb.select(0);
                }
            }
            String string3 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.app_name");
            if (string3 != null) {
                this.appNameTxt.setText(string3);
            } else {
                this.appNameTxt.setText(iProject.getName());
            }
            String string4 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.app_version");
            if (string4 != null) {
                this.appVersionTxt.setText(string4);
            } else {
                this.appVersionTxt.setText("1.0");
            }
            String string5 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.pkg_name");
            if (string5 == null && (string5 = iProject.getName().toLowerCase().replace(' ', '_').replace('-', '_')).indexOf(46) < 0) {
                string5 = "com." + string5;
            }
            this.pkgNameTxt.setText(string5);
            String string6 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.dest_file");
            if (string6 != null) {
                this.destFileTxt.setText(string6);
            } else {
                this.destFileTxt.setText("");
            }
            String string7 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.show_title_bar");
            this.showTitleBarBtn.setSelection("true".equals(string7));
            String string8 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.enable_debugging");
            this.enableDebugBtn.setSelection("true".equals(string8));
            this.setEnableDebuggingState();
            this.validatePage(null);
        }
    }

    static /* synthetic */ Text access$000(HtmlToAndroidAppSettingsPage htmlToAndroidAppSettingsPage) {
        return htmlToAndroidAppSettingsPage.sdkDirTxt;
    }

    static /* synthetic */ IProject access$100(HtmlToAndroidAppSettingsPage htmlToAndroidAppSettingsPage) {
        return htmlToAndroidAppSettingsPage.project;
    }

    static /* synthetic */ Text access$200(HtmlToAndroidAppSettingsPage htmlToAndroidAppSettingsPage) {
        return htmlToAndroidAppSettingsPage.destFileTxt;
    }

    static /* synthetic */ boolean access$300(HtmlToAndroidAppSettingsPage htmlToAndroidAppSettingsPage, ModifyEvent modifyEvent) {
        return htmlToAndroidAppSettingsPage.validatePage(modifyEvent);
    }

    static /* synthetic */ void access$400(HtmlToAndroidAppSettingsPage htmlToAndroidAppSettingsPage) {
        htmlToAndroidAppSettingsPage.setEnableDebuggingState();
    }
}

