/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.wizards;

import com.iscobol.html_android.wizards.HtmlToAndroidKeystorePage;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HtmlToAndroidKeystorePage
extends WizardPage
implements IWizardPage {
    private Button useKeystoreBtn;
    private Button keystoreBrowseBtn;
    private Text keystoreTxt;
    private Text keystorePwdTxt;
    private Text aliasTxt;
    private Text aliasPwdTxt;
    private Group keystoreGrp;
    private Group aliasGrp;
    private Label keystoreLbl;
    private Label keystorePwdLbl;
    private Label aliasLbl;
    private Label aliasPwdLbl;
    private IProject project;

    public HtmlToAndroidKeystorePage(IStructuredSelection iStructuredSelection) {
        super("HtmlToAndroidKeystorePage", "Keystore", null);
        if (!iStructuredSelection.isEmpty() && iStructuredSelection.getFirstElement() instanceof IResource) {
            this.project = ((IResource)iStructuredSelection.getFirstElement()).getProject();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.useKeystoreBtn = new Button(composite2, 32);
        this.useKeystoreBtn.setText("Use Keystore");
        this.keystoreGrp = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.keystoreGrp.setLayout((Layout)gridLayout);
        this.keystoreGrp.setText("Keystore");
        GridData gridData = new GridData(768);
        this.keystoreGrp.setLayoutData((Object)gridData);
        this.keystoreLbl = new Label((Composite)this.keystoreGrp, 0);
        this.keystoreLbl.setText("Location:");
        this.keystoreTxt = new Text((Composite)this.keystoreGrp, 2048);
        this.keystoreTxt.setLayoutData((Object)gridData);
        this.keystoreBrowseBtn = new Button((Composite)this.keystoreGrp, 8);
        this.keystoreBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.keystoreBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keystorePwdLbl = new Label((Composite)this.keystoreGrp, 0);
        this.keystorePwdLbl.setText("Password:");
        this.keystorePwdTxt = new Text((Composite)this.keystoreGrp, 0x400800);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.keystorePwdTxt.setLayoutData((Object)gridData);
        this.aliasGrp = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.aliasGrp.setLayout((Layout)gridLayout);
        this.aliasGrp.setText("Alias");
        gridData = new GridData(768);
        this.aliasGrp.setLayoutData((Object)gridData);
        this.aliasLbl = new Label((Composite)this.aliasGrp, 0);
        this.aliasLbl.setText("Name:");
        this.aliasTxt = new Text((Composite)this.aliasGrp, 2048);
        this.aliasTxt.setLayoutData((Object)gridData);
        this.aliasPwdLbl = new Label((Composite)this.aliasGrp, 0);
        this.aliasPwdLbl.setText("Password:");
        this.aliasPwdTxt = new Text((Composite)this.aliasGrp, 0x400800);
        this.aliasPwdTxt.setLayoutData((Object)gridData);
        2 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        this.keystoreTxt.addModifyListener((ModifyListener)var5_5);
        this.keystorePwdTxt.addModifyListener((ModifyListener)var5_5);
        this.aliasTxt.addModifyListener((ModifyListener)var5_5);
        this.aliasPwdTxt.addModifyListener((ModifyListener)var5_5);
        this.useKeystoreBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setProject(this.project);
        this.validatePage();
        this.setControl((Control)composite2);
    }

    private void validatePage() {
        boolean bl = this.useKeystoreBtn.getSelection();
        this.keystoreGrp.setEnabled(bl);
        this.keystoreLbl.setEnabled(bl);
        this.keystoreTxt.setEnabled(bl);
        this.keystorePwdLbl.setEnabled(bl);
        this.keystorePwdTxt.setEnabled(bl);
        this.aliasGrp.setEnabled(bl);
        this.aliasLbl.setEnabled(bl);
        this.aliasTxt.setEnabled(bl);
        this.aliasPwdLbl.setEnabled(bl);
        this.aliasPwdTxt.setEnabled(bl);
        if (bl) {
            if (this.keystoreTxt.getText().length() == 0) {
                this.setErrorMessage("Set Keystore Location");
                this.setPageComplete(false);
                return;
            }
            File file = new File(this.keystoreTxt.getText());
            if (!file.exists() || !file.isFile()) {
                this.setErrorMessage("Keystore Location has an invalid value");
                this.setPageComplete(false);
                return;
            }
            if (this.keystorePwdTxt.getText().length() == 0) {
                this.setErrorMessage("Set Keystore Password");
                this.setPageComplete(false);
                return;
            }
            if (this.aliasTxt.getText().length() == 0) {
                this.setErrorMessage("Set Alias");
                this.setPageComplete(false);
                return;
            }
            if (this.aliasPwdTxt.getText().length() == 0) {
                this.setErrorMessage("Set Alias Password");
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getKeystoreLocation() {
        return this.keystoreTxt.getText();
    }

    public String getKeystorePassword() {
        return this.keystorePwdTxt.getText();
    }

    public String getAlias() {
        return this.aliasTxt.getText();
    }

    public String getAliasPassword() {
        return this.aliasPwdTxt.getText();
    }

    public boolean useKeystore() {
        return this.useKeystoreBtn.getSelection();
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
        if (iProject != null) {
            String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.ks.enabled");
            this.useKeystoreBtn.setSelection("true".equals(string));
            if (this.useKeystoreBtn.getSelection()) {
                String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.ks.location");
                if (string2 != null) {
                    this.keystoreTxt.setText(string2);
                } else {
                    this.keystoreTxt.setText("");
                }
                String string3 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.ks.pwd");
                if (string3 != null) {
                    this.keystorePwdTxt.setText(string3);
                } else {
                    this.keystorePwdTxt.setText("");
                }
                String string4 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.ks.alias");
                if (string4 != null) {
                    this.aliasTxt.setText(string4);
                } else {
                    this.aliasTxt.setText("");
                }
                String string5 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.ks.alias.pwd");
                if (string5 != null) {
                    this.aliasPwdTxt.setText(string5);
                } else {
                    this.aliasPwdTxt.setText("");
                }
            } else {
                this.keystoreTxt.setText("");
                this.keystorePwdTxt.setText("");
                this.aliasTxt.setText("");
                this.aliasPwdTxt.setText("");
            }
            this.validatePage();
        }
    }

    static /* synthetic */ Text access$000(HtmlToAndroidKeystorePage htmlToAndroidKeystorePage) {
        return htmlToAndroidKeystorePage.keystoreTxt;
    }

    static /* synthetic */ void access$100(HtmlToAndroidKeystorePage htmlToAndroidKeystorePage) {
        htmlToAndroidKeystorePage.validatePage();
    }
}

