/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.wizards;

import com.iscobol.html_android.wizards.HtmlToAndroidLauncherIconPage;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class HtmlToAndroidLauncherIconPage
extends WizardPage
implements IWizardPage {
    private static final String[] DPIS = new String[]{"ldpi", "mdpi", "hdpi", "xhdpi", "xxhdpi"};
    private static final int DPI_COUNT = DPIS.length;
    private Button defaultIconBtn;
    private Button customIconBtn;
    private Button browseBtn;
    private Text customIconTxt;
    private Label[] dpiLbl;
    private Image[] defaultImages;
    private Image[] customImages;
    private IProject project;

    public HtmlToAndroidLauncherIconPage(IStructuredSelection iStructuredSelection) {
        super("HtmlToAndroidLauncherIconPage", "Launcher Icon", null);
        if (!iStructuredSelection.isEmpty() && iStructuredSelection.getFirstElement() instanceof IResource) {
            this.project = ((IResource)iStructuredSelection.getFirstElement()).getProject();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.defaultIconBtn = new Button(composite2, 16);
        this.defaultIconBtn.setText("Default Launcher Icon");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.defaultIconBtn.setLayoutData((Object)gridData);
        this.customIconBtn = new Button(composite2, 16);
        this.customIconBtn.setText("Custom Launcher Icon");
        this.customIconTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.customIconTxt.setLayoutData((Object)gridData);
        this.customIconTxt.setEnabled(false);
        this.browseBtn = new Button(composite2, 8);
        this.browseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.browseBtn.setEnabled(false);
        Group group = new Group(composite2, 0);
        group.setText("Preview");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        group.setLayout((Layout)gridLayout);
        Group[] groupArray = new Group[DPI_COUNT];
        this.dpiLbl = new Label[DPI_COUNT];
        this.defaultImages = new Image[DPI_COUNT];
        this.customImages = new Image[DPI_COUNT];
        this.defaultIconBtn.setSelection(true);
        Bundle bundle = Platform.getBundle((String)"com.iscobol.plugins.HtmlAndroid");
        String string = "resources/android/project_template/res/drawable-";
        String string2 = "/ic_launcher.png";
        for (int i = 0; i < this.dpiLbl.length; ++i) {
            this.defaultImages[i] = ImageDescriptor.createFromURL((URL)bundle.getEntry(string + DPIS[i] + string2)).createImage();
            groupArray[i] = new Group((Composite)group, 0);
            gridData = new GridData();
            gridData.verticalAlignment = 128;
            groupArray[i].setLayoutData((Object)gridData);
            groupArray[i].setText(DPIS[i]);
            groupArray[i].setLayout((Layout)new FillLayout());
            this.dpiLbl[i] = new Label((Composite)groupArray[i], 0);
            this.dpiLbl[i].setImage(this.defaultImages[i]);
        }
        this.setProject(this.project);
        1 var10_11 = new /* Unavailable Anonymous Inner Class!! */;
        this.defaultIconBtn.addSelectionListener((SelectionListener)var10_11);
        this.customIconTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.browseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setControl((Control)composite2);
    }

    public void dispose() {
        for (int i = 0; i < DPI_COUNT; ++i) {
            if (this.defaultImages[i] == null) continue;
            this.defaultImages[i].dispose();
        }
        this.disposeCustomImages();
        super.dispose();
    }

    private void disposeCustomImages() {
        for (int i = 0; i < DPI_COUNT; ++i) {
            if (this.customImages[i] == null) continue;
            this.customImages[i].dispose();
        }
    }

    private boolean validatePage() {
        this.disposeCustomImages();
        if (this.customIconBtn.getSelection()) {
            for (int i = 0; i < DPI_COUNT; ++i) {
                this.dpiLbl[i].setImage(null);
            }
            String string = this.customIconTxt.getText();
            if (string.length() == 0) {
                return this.setPageInvalid("Set Custom Image");
            }
            File file = new File(string);
            if (!file.exists() || !file.isFile()) {
                return this.setPageInvalid("'" + string + "' does not exist");
            }
            try {
                Image image = ImageDescriptor.createFromURL((URL)file.toURI().toURL()).createImage();
                this.customImages = new Image[]{this.getScaledImage(image, 36, 36), this.getScaledImage(image, 48, 48), this.getScaledImage(image, 72, 72), this.getScaledImage(image, 96, 96), this.getScaledImage(image, 144, 144)};
                image.dispose();
                for (int i = 0; i < DPI_COUNT; ++i) {
                    this.dpiLbl[i].setImage(this.customImages[i]);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    private Image getScaledImage(Image image, int n, int n2) {
        Image image2 = new Image((Device)Display.getDefault(), n, n2);
        GC gC = new GC((Drawable)image2);
        gC.setAntialias(1);
        gC.setInterpolation(2);
        gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, n, n2);
        gC.dispose();
        return image2;
    }

    private boolean setPageInvalid(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(false);
        return false;
    }

    public Image[] getCustomImages() {
        return this.customImages;
    }

    public String getCustomImageFile() {
        return this.customIconTxt.getText();
    }

    public boolean usesCustomImages() {
        return this.customIconBtn.getSelection();
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
        if (iProject != null) {
            String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobol.exportandroid.launcher_icon");
            if (string != null) {
                this.defaultIconBtn.setSelection(false);
                this.customIconBtn.setSelection(true);
                this.customIconTxt.setEnabled(true);
                this.browseBtn.setEnabled(true);
                this.customIconTxt.setText(string);
            } else {
                for (int i = 0; i < this.dpiLbl.length; ++i) {
                    this.dpiLbl[i].setImage(this.defaultImages[i]);
                }
                this.defaultIconBtn.setSelection(true);
                this.customIconBtn.setSelection(false);
                this.customIconTxt.setEnabled(false);
                this.browseBtn.setEnabled(false);
                this.customIconTxt.setText("");
            }
            this.validatePage();
        }
    }

    static /* synthetic */ Button access$000(HtmlToAndroidLauncherIconPage htmlToAndroidLauncherIconPage) {
        return htmlToAndroidLauncherIconPage.defaultIconBtn;
    }

    static /* synthetic */ Text access$100(HtmlToAndroidLauncherIconPage htmlToAndroidLauncherIconPage) {
        return htmlToAndroidLauncherIconPage.customIconTxt;
    }

    static /* synthetic */ Button access$200(HtmlToAndroidLauncherIconPage htmlToAndroidLauncherIconPage) {
        return htmlToAndroidLauncherIconPage.browseBtn;
    }

    static /* synthetic */ Label[] access$300(HtmlToAndroidLauncherIconPage htmlToAndroidLauncherIconPage) {
        return htmlToAndroidLauncherIconPage.dpiLbl;
    }

    static /* synthetic */ Image[] access$400(HtmlToAndroidLauncherIconPage htmlToAndroidLauncherIconPage) {
        return htmlToAndroidLauncherIconPage.defaultImages;
    }

    static /* synthetic */ boolean access$500(HtmlToAndroidLauncherIconPage htmlToAndroidLauncherIconPage) {
        return htmlToAndroidLauncherIconPage.validatePage();
    }
}

