/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.wizards;

import com.iscobol.html_android.wizards.WebContentsPanel;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class WebContentsPanel {
    private TabFolder tabFolder;
    private TabEntry classesTab;
    private TabEntry htmlTab;
    private TabEntry classpathTab;
    private TreeItem iscobolTreeItem;
    private TreeItem projectTreeItem;
    private TreeItem zkTreeItem;
    private List<TabEntry> tabs = new ArrayList();
    private IPropertyChangeListener listener;
    private IProject project;
    private boolean isWD2;
    private boolean exportIscobolLibraries;

    public WebContentsPanel(boolean bl) {
        this.exportIscobolLibraries = bl;
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.tabFolder = new TabFolder(composite2, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 350;
        this.tabFolder.setLayoutData((Object)gridData);
        this.classesTab = new /* Unavailable Anonymous Inner Class!! */;
        this.tabs.add(this.classesTab);
        this.classpathTab = new /* Unavailable Anonymous Inner Class!! */;
        this.tabs.add(this.classpathTab);
        if (this.project != null) {
            try {
                IContainer iContainer = PluginUtilities.getHtmlFolder((IProject)this.project);
                if (iContainer != null) {
                    this.htmlTab = new /* Unavailable Anonymous Inner Class!! */;
                    this.tabs.add(this.htmlTab);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return composite2;
    }

    private void loadClasspath(Tree tree) {
        if (this.project == null) {
            return;
        }
        if (this.exportIscobolLibraries) {
            if (tree.getItemCount() == 0) {
                this.iscobolTreeItem = new TreeItem(tree, 0);
                this.iscobolTreeItem.setText("isCOBOL");
                this.iscobolTreeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/iscobol16x16.png"));
                this.loadJarItems(this.iscobolTreeItem, PluginUtilities.getIscobolLibraryFiles((IProject)this.project, (boolean)false));
                if (this.isWD2) {
                    this.loadZKTreeItem();
                }
                this.projectTreeItem = new TreeItem(tree, 0);
                this.projectTreeItem.setText("Project");
                this.projectTreeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
            } else {
                this.projectTreeItem.removeAll();
                if (!this.isWD2) {
                    if (this.zkTreeItem != null && !this.zkTreeItem.isDisposed()) {
                        this.zkTreeItem.dispose();
                        this.zkTreeItem = null;
                    }
                } else if (this.zkTreeItem == null) {
                    this.loadZKTreeItem();
                }
                for (TreeItem file : this.iscobolTreeItem.getItems()) {
                    if (!file.getText().equals("ishttp.jar")) continue;
                    if (!this.isWD2) {
                        file.setChecked(true);
                        file.setData("$$FIXED$$", (Object)"true");
                        file.setForeground(file.getDisplay().getSystemColor(16));
                        continue;
                    }
                    file.setChecked(false);
                    file.setData("$$FIXED$$", null);
                    file.setForeground(this.iscobolTreeItem.getForeground());
                }
            }
        } else {
            tree.removeAll();
        }
        TreeItem[] treeItemArray = PluginUtilities.getProjectClasspath((IProject)this.project);
        if (treeItemArray != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)treeItemArray, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                File file = new File(string);
                if (!file.exists()) continue;
                TreeItem treeItem = this.exportIscobolLibraries ? new TreeItem(this.projectTreeItem, 0) : new TreeItem(tree, 0);
                treeItem.setText(string);
                treeItem.setData("path", (Object)string);
                if (file.isDirectory()) {
                    treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
                    continue;
                }
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/jar.gif"));
            }
        }
    }

    private void loadZKTreeItem() {
        this.zkTreeItem = new TreeItem(this.iscobolTreeItem, 0, 0);
        this.zkTreeItem.setData("$$FIXED$$", (Object)"true");
        this.zkTreeItem.setChecked(true);
        this.zkTreeItem.setText("zk");
        this.zkTreeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
        this.zkTreeItem.setForeground(this.zkTreeItem.getDisplay().getSystemColor(16));
        this.loadJarItems(this.zkTreeItem, PluginUtilities.getIscobolLibraryFiles((IProject)this.project, (boolean)true));
    }

    private void loadJarItems(TreeItem treeItem, List<File> list) {
        for (File file : list) {
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/jar.gif"));
            String string = file.getName();
            treeItem2.setText(string);
            treeItem2.setData("path", (Object)file.getAbsolutePath());
            if (!"iscobol.jar".equals(string) && (this.isWD2 || !"ishttp.jar".equals(string)) && !treeItem.getText().equals("zk")) continue;
            treeItem2.setChecked(true);
            treeItem2.setData("$$FIXED$$", (Object)"true");
            treeItem2.setForeground(treeItem2.getDisplay().getSystemColor(16));
        }
    }

    private void loadHtmlFiles(Tree tree, IContainer iContainer) {
        try {
            this.loadTree(tree, null, iContainer.members());
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private void loadClasses(Tree tree) {
        if (this.project == null) {
            return;
        }
        try {
            Object object = PluginUtilities.getOutputFolder((IProject)this.project, (String)PluginUtilities.getCurrentSettingMode((IResource)this.project), (boolean)false);
            if (object != null) {
                if (object instanceof IContainer) {
                    this.loadTree(tree, null, ((IContainer)object).members());
                } else {
                    this.loadTree(tree, null, new File((String)object).listFiles());
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private void loadTree(Tree tree, TreeItem treeItem, File[] fileArray) {
        if (treeItem == null) {
            tree.removeAll();
        }
        for (File file : fileArray) {
            TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(tree, 0);
            treeItem2.setText(file.getName());
            if (file.isDirectory()) {
                treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
                this.loadTree(tree, treeItem2, file.listFiles());
                continue;
            }
            treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/file_obj.gif"));
        }
    }

    private void loadTree(Tree tree, TreeItem treeItem, IResource[] iResourceArray) {
        if (treeItem == null) {
            tree.removeAll();
        }
        for (IResource iResource : iResourceArray) {
            TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(tree, 0);
            treeItem2.setText(iResource.getName());
            if (iResource instanceof IContainer) {
                treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
                try {
                    this.loadTree(tree, treeItem2, ((IContainer)iResource).members());
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
                continue;
            }
            treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/file_obj.gif"));
        }
    }

    private void setIncludes(Tree tree, String string) {
        if (string.equals("(All)")) {
            for (TreeItem treeItem : tree.getItems()) {
                treeItem.setChecked(true);
                PluginUtilities.checkItems((TreeItem)treeItem, (boolean)true);
            }
        } else {
            for (TreeItem treeItem : tree.getItems()) {
                treeItem.setChecked(false);
                PluginUtilities.checkItems((TreeItem)treeItem, (boolean)false);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                PluginUtilities.setTreeSelection((TreeItem[])tree.getItems(), (IPath)new Path(stringTokenizer.nextToken()), (boolean)true);
            }
        }
    }

    private void setExcludes(Tree tree, String string) {
        for (TreeItem treeItem : tree.getItems()) {
            treeItem.setChecked(true);
            PluginUtilities.checkItems((TreeItem)treeItem, (boolean)true);
        }
        if (!string.equals("(None)")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                PluginUtilities.setTreeSelection((TreeItem[])tree.getItems(), (IPath)new Path(stringTokenizer.nextToken()), (boolean)false);
            }
        }
    }

    public void setIncludeClasses(String string) {
        this.setIncludes(this.classesTab.tree, string);
    }

    public void setIncludeHtml(String string) {
        if (this.htmlTab != null) {
            this.setIncludes(this.htmlTab.tree, string);
        }
    }

    public void setIncludeClasspath(String string) {
        if (string.equals("(All)")) {
            for (TreeItem treeItem : this.classpathTab.tree.getItems()) {
                treeItem.setChecked(true);
                PluginUtilities.checkItems((TreeItem)treeItem, (boolean)true);
            }
        } else {
            for (TreeItem treeItem : this.classpathTab.tree.getItems()) {
                treeItem.setChecked(false);
                PluginUtilities.checkItems((TreeItem)treeItem, (boolean)false);
            }
            HashSet hashSet = new HashSet();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
            this.checkClasspathEntries((Set)hashSet, null);
        }
    }

    private void checkClasspathEntries(Set set, TreeItem treeItem) {
        TreeItem[] treeItemArray;
        for (TreeItem treeItem2 : treeItemArray = treeItem != null ? treeItem.getItems() : this.classpathTab.tree.getItems()) {
            if (treeItem2.getItemCount() > 0) {
                this.checkClasspathEntries(set, treeItem2);
                continue;
            }
            if (!set.contains(treeItem2.getData("path"))) continue;
            treeItem2.setChecked(true);
            PluginUtilities.checkItems((TreeItem)treeItem2, (boolean)true);
            PluginUtilities.checkPath((TreeItem)treeItem2.getParentItem(), (boolean)true, (boolean)false);
        }
    }

    public void setExcludeClasses(String string) {
        this.setExcludes(this.classesTab.tree, string);
    }

    public void setExcludeHtml(String string) {
        if (this.htmlTab != null) {
            this.setExcludes(this.htmlTab.tree, string);
        }
    }

    private String[] getIncludesAndExcludes(Tree tree) {
        String[] stringArray = new String[]{"(All)", "(None)"};
        for (TreeItem treeItem : tree.getItems()) {
            if (treeItem.getChecked() && !treeItem.getGrayed()) continue;
            stringArray = null;
            break;
        }
        if (stringArray == null) {
            int n;
            ArrayList arrayList;
            stringArray = new String[2];
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            this.getIncludesAndExcludes(tree.getItems(), "", (List)arrayList2, arrayList3);
            if (arrayList2.size() < arrayList3.size()) {
                arrayList = arrayList2;
                n = 0;
                stringArray[1] = "(None)";
            } else {
                arrayList = arrayList3;
                n = 1;
                stringArray[0] = "(All)";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string);
            }
            stringArray[n] = stringBuilder.toString();
        }
        return stringArray;
    }

    private void getIncludesAndExcludes(TreeItem[] treeItemArray, String string, List<String> list, List<String> list2) {
        for (TreeItem treeItem : treeItemArray) {
            String string2 = string;
            if (string2.length() > 0) {
                string2 = string2 + "/";
            }
            string2 = string2 + treeItem.getText();
            if (treeItem.getChecked()) {
                if (treeItem.getItemCount() == 0) {
                    list.add(string2);
                    continue;
                }
                this.getIncludesAndExcludes(treeItem.getItems(), string2, list, list2);
                continue;
            }
            list2.add(string2);
        }
    }

    public String getIncludeClasses() {
        return this.getIncludesAndExcludes(this.classesTab.tree)[0];
    }

    public String getExcludeClasses() {
        return this.getIncludesAndExcludes(this.classesTab.tree)[1];
    }

    public String getIncludeClasspath() {
        String string = null;
        for (TreeItem treeItem : this.classpathTab.tree.getItems()) {
            if (treeItem.getChecked() && !treeItem.getGrayed()) continue;
            string = null;
            break;
        }
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.buildClasspathString(stringBuilder, null);
            string = stringBuilder.toString();
        }
        return string;
    }

    private void buildClasspathString(StringBuilder stringBuilder, TreeItem treeItem) {
        TreeItem[] treeItemArray;
        for (TreeItem treeItem2 : treeItemArray = treeItem != null ? treeItem.getItems() : this.classpathTab.tree.getItems()) {
            if (treeItem2.getItemCount() > 0) {
                this.buildClasspathString(stringBuilder, treeItem2);
                continue;
            }
            if (!treeItem2.getChecked()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(treeItem2.getData("path"));
        }
    }

    public String getIncludeHtml() {
        return this.htmlTab != null ? this.getIncludesAndExcludes(this.htmlTab.tree)[0] : null;
    }

    public String getExcludeHtml() {
        return this.htmlTab != null ? this.getIncludesAndExcludes(this.htmlTab.tree)[1] : null;
    }

    public void initializeDefaults() {
        for (TabEntry tabEntry : this.tabs) {
            tabEntry.load();
        }
        this.setIncludeClasses("(All)");
        this.setIncludeHtml("(All)");
        this.initializeClasspathDefaults();
    }

    private void initializeClasspathDefaults() {
        for (TreeItem treeItem : this.classpathTab.tree.getItems()) {
            treeItem.setChecked(true);
            PluginUtilities.checkItems((TreeItem)treeItem, (boolean)true);
        }
        if (this.exportIscobolLibraries) {
            for (TreeItem treeItem : this.iscobolTreeItem.getItems()) {
                treeItem.setChecked(treeItem.getData("$$FIXED$$") != null);
            }
        }
    }

    public void initializeFrom(Map<String, String> map) {
        Object object2;
        for (Object object2 : this.tabs) {
            object2.load();
        }
        String string = map.get("___included_classes");
        if (string != null) {
            this.setIncludeClasses(string);
        }
        if ((string == null || string.equals("(All)")) && (object2 = map.get("___excluded_classes")) != null) {
            this.setExcludeClasses((String)object2);
        }
        if (this.htmlTab != null) {
            String string2;
            object2 = map.get("___included_html");
            if (object2 != null) {
                this.setIncludeHtml((String)object2);
            }
            if ((object2 == null || ((String)object2).equals("(All)")) && (string2 = map.get("___excluded_html")) != null) {
                this.setExcludeHtml(string2);
            }
        }
        if ((object2 = map.get("___included_classpath")) != null) {
            this.setIncludeClasspath((String)object2);
        }
    }

    public void performApply(Map<String, String> map) {
        String[] stringArray = this.getIncludesAndExcludes(this.classesTab.tree);
        map.put("___included_classes", stringArray[0]);
        map.put("___excluded_classes", stringArray[1]);
        if (this.htmlTab != null) {
            String[] stringArray2 = this.getIncludesAndExcludes(this.htmlTab.tree);
            map.put("___included_html", stringArray2[0]);
            map.put("___excluded_html", stringArray2[1]);
        }
        map.put("___included_classpath", this.getIncludeClasspath());
    }

    public IPropertyChangeListener getListener() {
        return this.listener;
    }

    public void setListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listener = iPropertyChangeListener;
    }

    private void fireChangeEvent() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent((Object)this, "webContents", null, null));
        }
    }

    public void setWD2(boolean bl) {
        String string;
        this.isWD2 = bl;
        this.loadClasspath(this.classpathTab.tree);
        this.initializeClasspathDefaults();
        if (this.project != null && (string = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)"iscobol.exportwar.included_classpath")) != null) {
            this.setIncludeClasspath(string);
        }
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
        try {
            IContainer iContainer = this.project != null ? PluginUtilities.getHtmlFolder((IProject)this.project) : null;
            if (iContainer != null) {
                if (this.tabs.size() == 2) {
                    this.htmlTab = new /* Unavailable Anonymous Inner Class!! */;
                    this.tabs.add(2, this.htmlTab);
                }
            } else if (this.tabs.size() == 3) {
                this.tabs.remove(2);
                this.htmlTab.tabItem.dispose();
                this.htmlTab = null;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IProject getProject() {
        return this.project;
    }

    static /* synthetic */ TabFolder access$000(WebContentsPanel webContentsPanel) {
        return webContentsPanel.tabFolder;
    }

    static /* synthetic */ void access$100(WebContentsPanel webContentsPanel) {
        webContentsPanel.fireChangeEvent();
    }

    static /* synthetic */ void access$200(WebContentsPanel webContentsPanel, Tree tree) {
        webContentsPanel.loadClasses(tree);
    }

    static /* synthetic */ void access$300(WebContentsPanel webContentsPanel, Tree tree) {
        webContentsPanel.loadClasspath(tree);
    }

    static /* synthetic */ boolean access$400(WebContentsPanel webContentsPanel) {
        return webContentsPanel.exportIscobolLibraries;
    }

    static /* synthetic */ TreeItem access$500(WebContentsPanel webContentsPanel) {
        return webContentsPanel.iscobolTreeItem;
    }

    static /* synthetic */ void access$600(WebContentsPanel webContentsPanel, Tree tree, IContainer iContainer) {
        webContentsPanel.loadHtmlFiles(tree, iContainer);
    }
}

