/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.types.Key;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.beans.types.XFDAttributes;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CodeGenerator {
    private static final String FIX = "   ";
    private final String eol = PluginUtilities.getLineDelimiter();
    private ScreenFD_SL fdSL;
    private IProject project;
    private boolean ansiFormat;
    private CobolFormatter formatter;
    public static final String ISCOBOL_PREFIX = "is-";
    private IContainer fileCopyFolder;
    String fdName;
    private FileDescriptor fd;
    private VariableTypeList recordDescription;

    public CodeGenerator(String string, IProject iProject, FileDescriptor fileDescriptor, VariableTypeList variableTypeList, boolean bl, int n) {
        this.fd = fileDescriptor;
        this.fdName = string;
        this.project = iProject;
        this.recordDescription = variableTypeList;
        this.ansiFormat = bl;
        this.formatter = new CobolFormatter(bl, n);
    }

    public CodeGenerator(ScreenFD_SL screenFD_SL, int n) {
        this.fdSL = screenFD_SL;
        this.fd = this.fdSL.getFileDescriptor();
        this.fdName = this.fdSL.getFdName();
        this.project = screenFD_SL.getProject();
        this.recordDescription = screenFD_SL.getFdItems();
        this.ansiFormat = IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.progfile.ansi");
        try {
            this.fileCopyFolder = PluginUtilities.getFileLayoutCopyFolder((IProject)this.project);
            if (this.fileCopyFolder == null) {
                this.fileCopyFolder = PluginUtilities.getFirstLocalCopyFolder((IProject)this.project);
                if (this.fileCopyFolder == null) {
                    this.fileCopyFolder = PluginUtilities.getSourceFolder((IProject)this.project);
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.formatter = new CobolFormatter(this.ansiFormat, n);
    }

    public void refreshFolders() {
        try {
            this.fileCopyFolder.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IFile generateFD() {
        StringBuilder stringBuilder = new StringBuilder();
        this.generateFD(stringBuilder);
        IFile iFile = null;
        iFile = this.fd.getFileFormat().getValue() == 5 ? this.getCopyFile(this.fileCopyFolder, this.fdName + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.sort.suffix"), stringBuilder.toString()) : this.getCopyFile(this.fileCopyFolder, this.fdName + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.filesec.suffix"), stringBuilder.toString());
        if (iFile != null) {
            return iFile;
        }
        return null;
    }

    public void generateFD(StringBuilder stringBuilder) {
        VariableType[] variableTypeArray;
        Object object;
        if (this.fd.getComment() != null) {
            try {
                object = new BufferedReader(new StringReader(this.fd.getComment()));
                variableTypeArray = ((BufferedReader)object).readLine();
                while (variableTypeArray != null) {
                    stringBuilder.append(this.formatter.formatComment((String)variableTypeArray));
                    variableTypeArray = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fd.getFileDirective() != null && this.fd.getFileDirective().length() > 0) {
            if (this.ansiFormat) {
                stringBuilder.append("      $efd file=" + this.fd.getFileDirective() + this.eol);
            } else {
                stringBuilder.append("*((efd file=" + this.fd.getFileDirective() + "))" + this.eol);
            }
        }
        object = new StringBuilder();
        if (this.fd.getFileFormat().getValue() == 5) {
            ((StringBuilder)object).append("sd ");
        } else {
            ((StringBuilder)object).append("fd ");
        }
        ((StringBuilder)object).append(this.fdName);
        if (this.fd.isGlobal()) {
            ((StringBuilder)object).append(" is global");
        }
        if (this.fd.isExternal()) {
            ((StringBuilder)object).append(" is external");
        }
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        if (this.fd.getUseBlockAttributes() && (this.fd.getBlockMinSize() > 0 || this.fd.getBlockMaxSize() > 0) && this.fd.getBlockMaxSize() > 1) {
            ((StringBuilder)object).append(" block contains ");
            if (this.fd.getBlockMinSize() > 0) {
                ((StringBuilder)object).append(this.fd.getBlockMinSize());
                ((StringBuilder)object).append(" to ");
                ((StringBuilder)object).append(this.fd.getBlockMaxSize());
            } else {
                ((StringBuilder)object).append(this.fd.getBlockMaxSize());
            }
            if (this.fd.isBlockRecords()) {
                ((StringBuilder)object).append(" records");
            } else {
                ((StringBuilder)object).append(" characters");
            }
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getUseRecordAttributes()) {
            if (this.fd.getRecordMinSize() != 0 || this.fd.getRecordMaxSize() != 0) {
                ((StringBuilder)object).append(" record contains ");
                if (this.fd.getRecordMinSize() != 0 && this.fd.getRecordMinSize() != this.fd.getRecordMaxSize()) {
                    ((StringBuilder)object).append(this.fd.getRecordMinSize());
                    ((StringBuilder)object).append(" to ");
                    ((StringBuilder)object).append(this.fd.getRecordMaxSize());
                } else {
                    ((StringBuilder)object).append(this.fd.getRecordMaxSize());
                }
                ((StringBuilder)object).append(" characters");
                stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
                object = new StringBuilder(FIX);
            }
            if (this.fd.isRecordVarying()) {
                ((StringBuilder)object).append(" is varying in size from ");
                ((StringBuilder)object).append(this.fd.getRecordFrom());
                ((StringBuilder)object).append(" to ");
                ((StringBuilder)object).append(this.fd.getRecordTo());
                ((StringBuilder)object).append(" characters");
                ((StringBuilder)object).append(" depending on ");
                ((StringBuilder)object).append(this.fd.getRecordDepend());
                stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
                object = new StringBuilder(FIX);
            }
        }
        if (this.fd.getUseLabelAttributes() && this.fd.isLabelRecordStd()) {
            ((StringBuilder)object).append(" label record is standard");
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getUseLabelAttributes() && this.fd.getValueLabel() != null && !this.fd.getValueLabel().equals("")) {
            ((StringBuilder)object).append(" value label is ");
            ((StringBuilder)object).append(this.fd.getValueLabel());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getValueFileId() != null && !this.fd.getValueFileId().equals("")) {
            ((StringBuilder)object).append(" value of file-id ");
            ((StringBuilder)object).append(this.fd.getValueFileId());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getCodeSetName() != null && !this.fd.getCodeSetName().equals("")) {
            ((StringBuilder)object).append(" code-set is ");
            ((StringBuilder)object).append(this.fd.getCodeSetName());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getLinageLines() != null && !this.fd.getLinageLines().equals("")) {
            ((StringBuilder)object).append(" linage is ");
            ((StringBuilder)object).append(this.fd.getLinageLines());
            if (this.fd.getLinageFooting() != null && !this.fd.getLinageFooting().equals("")) {
                ((StringBuilder)object).append(" with footing ");
                ((StringBuilder)object).append(this.fd.getLinageFooting());
                stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
                object = new StringBuilder(FIX);
            }
            if (this.fd.getLinageTop() != null && !this.fd.getLinageTop().equals("")) {
                ((StringBuilder)object).append(" lines at top ");
                ((StringBuilder)object).append(this.fd.getLinageTop());
                stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
                object = new StringBuilder(FIX);
            }
            if (this.fd.getLinageBottom() != null && !this.fd.getLinageBottom().equals("")) {
                ((StringBuilder)object).append(" lines at bottom ");
                ((StringBuilder)object).append(this.fd.getLinageBottom());
                stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
                object = new StringBuilder(FIX);
            }
        }
        ((StringBuilder)object).append(".");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        variableTypeArray = this.recordDescription.get01or77Variables();
        this.getDataDivisionCode(variableTypeArray, stringBuilder);
    }

    public IFile getFDFile() throws CoreException {
        String string = this.fd.getFileFormat().getValue() == 5 ? IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.sort.suffix") : IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.filesec.suffix");
        IResource iResource = PluginUtilities.findMember((IContainer)this.fileCopyFolder, (IPath)new Path(this.fdName + string));
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public IFile getSLFile() throws CoreException {
        IResource iResource = PluginUtilities.findMember((IContainer)this.fileCopyFolder, (IPath)new Path(this.fdName + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.filectl.suffix")));
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public IFile getPRCFile() throws CoreException {
        IResource iResource = PluginUtilities.findMember((IContainer)this.fileCopyFolder, (IPath)new Path(this.fdName + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.fileproc.suffix")));
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public IFile generateSL() {
        StringBuilder stringBuilder = new StringBuilder();
        this.generateSL(stringBuilder);
        IFile iFile = this.getCopyFile(this.fileCopyFolder, this.fdName + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.filectl.suffix"), stringBuilder.toString());
        if (iFile != null) {
            return iFile;
        }
        return null;
    }

    public void generateSL(StringBuilder stringBuilder) {
        if (this.fd.getFileFormat().getValue() == 0 || this.fd.getFileFormat().getValue() == 1 || this.fd.getFileFormat().getValue() == 2) {
            this.generateSLSeq(stringBuilder);
        } else if (this.fd.getFileFormat().getValue() == 3) {
            this.generateSLRel(stringBuilder);
        } else if (this.fd.getFileFormat().getValue() == 4) {
            this.generateSLIdx(stringBuilder);
        } else if (this.fd.getFileFormat().getValue() == 5) {
            this.generateSLSrt(stringBuilder);
        }
    }

    public void generateSLSeq(StringBuilder stringBuilder) {
        Object object;
        if (this.ansiFormat) {
            stringBuilder.append("      ");
        }
        stringBuilder.append("*> Sequential SELECT");
        stringBuilder.append(this.eol);
        if (this.fd.getCommentSel() != null) {
            try {
                object = new BufferedReader(new StringReader(this.fd.getCommentSel()));
                String string = ((BufferedReader)object).readLine();
                while (string != null) {
                    stringBuilder.append(this.formatter.formatComment(string));
                    string = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("select ");
        if (this.fd.isOptional()) {
            ((StringBuilder)object).append(" optional ");
        }
        ((StringBuilder)object).append(this.fdSL.getFdName());
        ((StringBuilder)object).append(" assign to ");
        if (this.fd.getValueFileId() == null || this.fd.getValueFileId().equals("")) {
            if (this.fd.isExternal()) {
                ((StringBuilder)object).append(" external ");
            }
            ((StringBuilder)object).append(this.fd.getAssignDevice().getCobolName() + " ");
            if (this.fd.getAssignName() != null && !this.fd.getAssignName().equals("")) {
                ((StringBuilder)object).append(this.fd.getAssignName());
            } else {
                ((StringBuilder)object).append("\"" + this.fdSL.getFdName() + "\"");
            }
        }
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        ((StringBuilder)object).append(" organization is ");
        if (this.fd.getFileFormat().getValue() == 1) {
            ((StringBuilder)object).append(" binary ");
        } else if (this.fd.getFileFormat().getValue() == 2) {
            ((StringBuilder)object).append(" line ");
        }
        ((StringBuilder)object).append("sequential");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        if (this.fd.getLockMode().getValue() != 0) {
            ((StringBuilder)object).append(" lock mode is ");
            ((StringBuilder)object).append(this.fd.getLockMode().getName().toLowerCase());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.isRecordDelimiterStd1()) {
            ((StringBuilder)object).append(" record delimiter is standard-1");
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getFileStatusName() != null && !this.fd.getFileStatusName().equals("")) {
            ((StringBuilder)object).append(" file status is ");
            ((StringBuilder)object).append(this.fd.getFileStatusName());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.isPadding()) {
            ((StringBuilder)object).append(" padding character is ");
            ((StringBuilder)object).append(this.fd.getPaddingCharacter());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        this.generateClassDeclaration(this.fd, (StringBuilder)object);
        ((StringBuilder)object).append(".");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
    }

    public void generateSLRel(StringBuilder stringBuilder) {
        Object object;
        if (this.ansiFormat) {
            stringBuilder.append("      ");
        }
        stringBuilder.append("*> Relative SELECT");
        stringBuilder.append(this.eol);
        if (this.fd.getCommentSel() != null) {
            try {
                object = new BufferedReader(new StringReader(this.fd.getCommentSel()));
                String string = ((BufferedReader)object).readLine();
                while (string != null) {
                    stringBuilder.append(this.formatter.formatComment(string));
                    string = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("select ");
        if (this.fd.isOptional()) {
            ((StringBuilder)object).append(" optional ");
        }
        ((StringBuilder)object).append(this.fdSL.getFdName());
        ((StringBuilder)object).append(" assign to ");
        if (this.fd.getValueFileId() == null || this.fd.getValueFileId().equals("")) {
            if (this.fd.isExternal()) {
                ((StringBuilder)object).append(" external ");
            }
            ((StringBuilder)object).append(this.fd.getAssignDevice().getCobolName() + " ");
            if (this.fd.getAssignName() != null && !this.fd.getAssignName().equals("")) {
                ((StringBuilder)object).append(this.fd.getAssignName());
            } else {
                ((StringBuilder)object).append("\"" + this.fdSL.getFdName() + "\"");
            }
        }
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        ((StringBuilder)object).append(" organization is ");
        ((StringBuilder)object).append("relative");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        if (this.fd.getAccessMode().getValue() != 0) {
            ((StringBuilder)object).append(" access mode is ");
            ((StringBuilder)object).append(this.fd.getAccessMode().getName().toLowerCase());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        ((StringBuilder)object).append(" relative key is ");
        ((StringBuilder)object).append(this.fd.getKeyName());
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        if (this.fd.getLockMode().getValue() != 0) {
            ((StringBuilder)object).append(" lock mode is ");
            ((StringBuilder)object).append(this.fd.getLockMode().getName().toLowerCase());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getFileStatusName() != null && !this.fd.getFileStatusName().equals("")) {
            ((StringBuilder)object).append(" file status is ");
            ((StringBuilder)object).append(this.fd.getFileStatusName());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        this.generateClassDeclaration(this.fd, (StringBuilder)object);
        ((StringBuilder)object).append(".");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
    }

    public void generateSLIdx(StringBuilder stringBuilder) {
        String string;
        Object object;
        if (this.ansiFormat) {
            stringBuilder.append("      ");
        }
        stringBuilder.append("*> Indexed SELECT");
        stringBuilder.append(this.eol);
        if (this.fd.getCommentSel() != null) {
            try {
                object = new BufferedReader(new StringReader(this.fd.getCommentSel()));
                string = ((BufferedReader)object).readLine();
                while (string != null) {
                    stringBuilder.append(this.formatter.formatComment(string));
                    string = ((BufferedReader)object).readLine();
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("select ");
        if (this.fd.isOptional()) {
            ((StringBuilder)object).append(" optional ");
        }
        ((StringBuilder)object).append(this.fdName);
        ((StringBuilder)object).append(" assign to ");
        if (this.fd.getValueFileId() == null || this.fd.getValueFileId().equals("")) {
            if (this.fd.isExternal()) {
                ((StringBuilder)object).append(" external ");
            }
            ((StringBuilder)object).append(this.fd.getAssignDevice().getCobolName() + " ");
            if (this.fd.getAssignName() != null && !this.fd.getAssignName().equals("")) {
                ((StringBuilder)object).append(this.fd.getAssignName());
            } else {
                ((StringBuilder)object).append("\"" + this.fdSL.getFdName() + "\"");
            }
        }
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        if (this.fd.isWithCompression()) {
            ((StringBuilder)object).append(" with compression ");
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.isWithEncryption()) {
            ((StringBuilder)object).append(" with encryption ");
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getCompressionFactor().getValue() != 0) {
            ((StringBuilder)object).append(" compression control value is ");
            ((StringBuilder)object).append(this.fd.getCompressionFactor().getName());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        ((StringBuilder)object).append(" organization is indexed");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
        object = new StringBuilder(FIX);
        if (this.fd.getAccessMode().getValue() != 0) {
            ((StringBuilder)object).append(" access mode is ");
            ((StringBuilder)object).append(this.fd.getAccessMode().getName().toLowerCase());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        string = this.fd.getKeys();
        for (int i = 0; i < string.getSettingCount(); ++i) {
            Key key = (Key)string.getSettingAt(i);
            if (key.getKeyType().getValue() == 2 || key.getKeyType().getValue() == 3) {
                ((StringBuilder)object).append(" alternate ");
            }
            ((StringBuilder)object).append(" record key is ");
            ((StringBuilder)object).append(key.getName());
            if (!key.getName().equalsIgnoreCase(key.getFieldNameList())) {
                if (!key.getName().equals("")) {
                    ((StringBuilder)object).append(" =");
                }
                String string2 = key.getFieldNameList();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    ((StringBuilder)object).append(" ");
                    ((StringBuilder)object).append(stringTokenizer.nextToken());
                }
            }
            if (key.getKeyType().getValue() == 1 || key.getKeyType().getValue() == 3) {
                ((StringBuilder)object).append(" with duplicates");
            }
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getLockMode().getValue() != 0) {
            ((StringBuilder)object).append(" lock mode is ");
            ((StringBuilder)object).append(this.fd.getLockMode().getName().toLowerCase());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.getFileStatusName() != null && !this.fd.getFileStatusName().equals("")) {
            ((StringBuilder)object).append(" file status is ");
            ((StringBuilder)object).append(this.fd.getFileStatusName());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        if (this.fd.isCollating()) {
            ((StringBuilder)object).append(" collating sequence is ");
            ((StringBuilder)object).append(this.fd.getAlphabetName());
            stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
            object = new StringBuilder(FIX);
        }
        this.generateClassDeclaration(this.fd, (StringBuilder)object);
        ((StringBuilder)object).append(".");
        stringBuilder.append(this.formatter.formatLine(((StringBuilder)object).toString()));
    }

    public void generateSLSrt(StringBuilder stringBuilder) {
        if (this.ansiFormat) {
            stringBuilder.append("      ");
        }
        stringBuilder.append("*> Select SORT");
        stringBuilder.append(this.eol);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("select ");
        stringBuilder2.append(this.fdSL.getFdName());
        stringBuilder2.append(" assign to ");
        if (this.fd.isExternal()) {
            stringBuilder2.append(" external ");
        }
        stringBuilder2.append(this.fd.getAssignDevice().getCobolName() + " ");
        stringBuilder.append(this.formatter.formatLine(stringBuilder2.toString()));
        stringBuilder2 = new StringBuilder(FIX);
        if (this.fd.getAssignName() != null && !this.fd.getAssignName().equals("")) {
            stringBuilder2.append(this.fd.getAssignName());
        }
        if (this.fd.getLockMode().getValue() != 0) {
            stringBuilder2.append(" lock mode is ");
            stringBuilder2.append(this.fd.getLockMode().getName().toLowerCase());
            stringBuilder.append(this.formatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(FIX);
        }
        if (this.fd.getFileStatusName() != null && !this.fd.getFileStatusName().equals("")) {
            stringBuilder2.append(" file status is ");
            stringBuilder2.append(this.fd.getFileStatusName());
            stringBuilder.append(this.formatter.formatLine(stringBuilder2.toString()));
            stringBuilder2 = new StringBuilder(FIX);
        }
        this.generateClassDeclaration(this.fd, stringBuilder);
        stringBuilder2.append(".");
        stringBuilder.append(this.formatter.formatLine(stringBuilder2.toString()));
    }

    private void generateClassDeclaration(FileDescriptor fileDescriptor, StringBuilder stringBuilder) {
        if (fileDescriptor.getClassVariable() != null && fileDescriptor.getClassVariable().length() > 0) {
            stringBuilder.append(" class ");
            stringBuilder.append(fileDescriptor.getClassVariable());
        } else if (fileDescriptor.getClassName() != null && fileDescriptor.getClassName().length() > 0) {
            stringBuilder.append(" class \"");
            stringBuilder.append(fileDescriptor.getClassName());
            stringBuilder.append("\"");
        }
    }

    public IFile generatePRC() {
        IFile iFile = null;
        if (IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.fileproc.checked")) {
            StringBuilder stringBuilder = new StringBuilder();
            this.generatePRC(stringBuilder);
            iFile = this.getCopyFile(this.fileCopyFolder, this.fdName + IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.fileproc.suffix"), stringBuilder.toString());
        }
        return iFile;
    }

    public void generatePRC(StringBuilder stringBuilder) {
        if (this.ansiFormat) {
            stringBuilder.append("      ");
        }
        stringBuilder.append("*> Copy PROCEDURE");
        stringBuilder.append(this.eol);
        stringBuilder.append(this.fdSL.getEventParagraphs().getBody());
    }

    private void getDataDivisionCode(VariableType[] variableTypeArray, StringBuilder stringBuilder) {
        String[] stringArray = new String[]{"", null};
        for (int i = 0; i < variableTypeArray.length; ++i) {
            this.getVarDeclCode(variableTypeArray[i], stringBuilder, "", stringArray);
        }
    }

    private IFile getCopyFile(IContainer iContainer, String string, String string2) {
        return PluginUtilities.getFile((IContainer)iContainer, (String)string, (boolean)false, (String)string2);
    }

    private void getVarDeclCode(VariableType variableType, StringBuilder stringBuilder, String string, String[] stringArray) {
        Object object;
        XFDAttributes xFDAttributes = variableType.getXFDAttributes();
        if (xFDAttributes != null) {
            object = this.ansiFormat ? new StringBuilder("      $efd ") : new StringBuilder("*((efd ");
            if (xFDAttributes.isUseCommentDirective()) {
                if (this.ansiFormat) {
                    stringBuilder.append("      $efd comment " + xFDAttributes.getCommentDirective());
                } else {
                    stringBuilder.append("*((efd comment " + xFDAttributes.getCommentDirective() + "))");
                }
                stringBuilder.append(this.eol);
            }
            if (xFDAttributes.isUseGroupDirective()) {
                object.append("use group, ");
            }
            if (xFDAttributes.getNameDirective() != null && !xFDAttributes.getNameDirective().equals("") && !xFDAttributes.getNameDirective().equalsIgnoreCase(variableType.getName())) {
                object.append("name=" + xFDAttributes.getNameDirective() + ", ");
            }
            if (xFDAttributes.isUseDataTypeDirective()) {
                object.append(xFDAttributes.getDataTypeDirective().getName().toLowerCase());
                if (xFDAttributes.getDateFormat() != null && !xFDAttributes.getDateFormat().equals("")) {
                    object.append("=" + xFDAttributes.getDateFormat());
                }
                object.append(", ");
            }
            if (xFDAttributes.isUseWhenDirective()) {
                object.append("when " + xFDAttributes.getWhenDirective());
                object.append(" tablename=" + xFDAttributes.getTableName() + ", ");
            }
            if (xFDAttributes.isSplit()) {
                object.append("split, ");
            }
            if (xFDAttributes.isHidden()) {
                object.append("hidden, ");
            }
            if (xFDAttributes.isSerial()) {
                object.append("serial, ");
            }
            if (xFDAttributes.getCobtrigger() != null && !xFDAttributes.getCobtrigger().equals("")) {
                object.append("cobtrigger=" + xFDAttributes.getCobtrigger() + ", ");
            }
            if (!object.toString().equals("      $efd ") && !object.toString().equals("*((efd ")) {
                stringBuilder.append(object.toString().substring(0, object.length() - 2));
                if (!this.ansiFormat) {
                    stringBuilder.append("))");
                }
                stringBuilder.append(this.eol);
            }
        }
        stringBuilder.append(com.iscobol.screenpainter.CodeGenerator.getVarDeclCode((VariableType)variableType, (boolean)false, (String)string, (String[])stringArray, (CobolFormatter)this.formatter));
        object = variableType.getChildren();
        for (int i = 0; i < ((SettingTreeItem[])object).length; ++i) {
            this.getVarDeclCode((VariableType)object[i], stringBuilder, string + FIX, stringArray);
        }
    }
}

