/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.DataLayoutEditor;
import com.iscobol.plugins.editor.IscobolOutlinePage;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DataLayoutContentOutline
extends Page
implements IContentOutlinePage,
ISelectionProvider {
    private Composite control;
    private StackLayout stackLayout;
    private Vector<ISelectionChangedListener> selchangeListeners = new Vector();
    private Hashtable<IContentOutlinePage, Composite> outlineControls = new Hashtable();
    private IscobolOutlinePage eventOutline;
    private Control genericControl;
    protected DataLayoutEditor editor;

    public DataLayoutContentOutline(DataLayoutEditor dataLayoutEditor) {
        this.editor = dataLayoutEditor;
        this.eventOutline = (IscobolOutlinePage)dataLayoutEditor.getEventParagraphsEditor().getOutlinePage();
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        if (this.eventOutline != null) {
            this.eventOutline.init(iPageSite);
        }
        iPageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void createControl(Composite composite) {
        this.control = new Composite(composite, 0);
        Label label = new Label(this.control, 0);
        label.setText("Content Outline not available");
        this.genericControl = label;
        this.stackLayout = new StackLayout();
        this.control.setLayout((Layout)this.stackLayout);
        if (this.eventOutline != null) {
            Composite composite2 = this.getControlForOutline((IContentOutlinePage)this.eventOutline);
            this.eventOutline.createControl(composite2);
        }
        this.stackLayout.topControl = this.genericControl;
    }

    private Composite getControlForOutline(IContentOutlinePage iContentOutlinePage) {
        Composite composite = (Composite)this.outlineControls.get(iContentOutlinePage);
        if (composite == null) {
            composite = new Composite(this.control, 0);
            composite.setLayout((Layout)new FillLayout());
            this.outlineControls.put(iContentOutlinePage, composite);
        }
        return composite;
    }

    public void dispose() {
        if (this.eventOutline != null) {
            this.eventOutline.dispose();
        }
        super.dispose();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            Composite composite = this.getControlForOutline(iContentOutlinePage);
            this.stackLayout.topControl = composite;
            this.control.layout();
            iContentOutlinePage.setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selchangeListeners.addElement(iSelectionChangedListener);
        if (this.eventOutline != null) {
            this.eventOutline.addSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            return iContentOutlinePage.getSelection();
        }
        return new StructuredSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selchangeListeners.removeElement(iSelectionChangedListener);
        if (this.eventOutline != null) {
            this.eventOutline.removeSelectionChangedListener(iSelectionChangedListener);
        }
    }

    private IContentOutlinePage getActiveOutline() {
        int n = this.editor.getActivePageIndex();
        if (n >= 0 && n == this.editor.getPageCount() - 1) {
            return this.eventOutline;
        }
        return null;
    }

    public void setSelection(ISelection iSelection) {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            iContentOutlinePage.setSelection(iSelection);
        }
    }

    public void refresh() {
        IContentOutlinePage iContentOutlinePage = this.getActiveOutline();
        if (iContentOutlinePage != null) {
            Composite composite = this.getControlForOutline(iContentOutlinePage);
            this.stackLayout.topControl = composite;
        } else {
            this.stackLayout.topControl = this.genericControl;
        }
        this.control.layout();
    }
}

