/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.DataLayoutContentOutline;
import com.iscobol.filedesigner.DataLayoutEditor;
import com.iscobol.filedesigner.FileControlPage;
import com.iscobol.filedesigner.IOHandlingPage;
import com.iscobol.filedesigner.KeyDefinitionPage;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.XFDPage;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.util.ImageProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.editorinputs.EventParagraphsEditorInput;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DataLayoutEditor
extends FormEditor
implements IResourceChangeListener {
    public static final String ID = "iscobolscreenpainter.DataLayoutEditor";
    private boolean resourceListenerEnabled = true;
    private EventParagraphsEditorInput epInput;
    private EventParagraphsEditor epEditor;
    FileControlPage fileControlPage;
    KeyDefinitionPage keyDefinitionPage;
    IOHandlingPage ioHandlingPage;
    XFDPage efdPage;
    private IStorageEditorInput storageInput;
    private boolean dirty;
    private ScreenFD_SL fdsl;
    private DataLayoutContentOutline outline;

    public DataLayoutEditor() {
        this.addListeners();
    }

    private void addListeners() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (!this.resourceListenerEnabled) {
            return;
        }
        IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta().findMember(iFile.getFullPath());
        if (iResourceDelta != null) {
            switch (iResourceDelta.getKind()) {
                case 2: {
                    this.closeEditor();
                    break;
                }
                case 4: {
                    if ((iResourceDelta.getFlags() & 0x100) != 256 && (iResourceDelta.getFlags() & 0x800) != 2048) break;
                    this.closeEditor();
                }
            }
            if (iResourceDelta.getKind() == 2) {
                this.closeEditor();
            }
        }
    }

    private void closeEditor() {
        1 var1_1 = new /* Unavailable Anonymous Inner Class!! */;
        Display.getDefault().asyncExec((Runnable)var1_1);
    }

    private void removeListeners() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    public void activateEventParagraphsEditor() {
        this.setActivePage(this.getEventParagraphsEditorIndex());
        this.pageChange(this.getEventParagraphsEditorIndex());
    }

    public void activateFileControlPage() {
        this.setActivePage(this.getFileControlPageIndex());
        this.pageChange(this.getFileControlPageIndex());
    }

    public void activateKeyDefinitionPage() {
        this.setActivePage(this.getKeyDefinitionPageIndex());
        this.pageChange(this.getKeyDefinitionPageIndex());
    }

    public void activateIOHandlingPage() {
        this.setActivePage(this.getIOHandlingPageIndex());
        this.pageChange(this.getIOHandlingPageIndex());
    }

    public void activateEFDPage() {
        this.setActivePage(this.getEFDPageIndex());
        this.pageChange(this.getEFDPageIndex());
    }

    public int getPageCount() {
        return super.getPageCount();
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
        this.editorDirtyStateChanged();
    }

    public boolean isDirty() {
        return this.storageInput instanceof IFileEditorInput && (this.dirty || super.isDirty());
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.storageInput = (IStorageEditorInput)iEditorInput;
        IFile iFile = null;
        if (this.storageInput instanceof IFileEditorInput) {
            iFile = ((IFileEditorInput)this.storageInput).getFile();
            this.fdsl = new ScreenFD_SL(iFile);
        } else {
            try {
                String string = System.getProperty("java.io.tmpdir", ".");
                File file = new File(string + File.separator + iEditorInput.getName());
                InputStream inputStream = this.storageInput.getStorage().getContents();
                this.fdsl = new ScreenFD_SL(file);
                this.fdsl.load(inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.removeListeners();
        }
        if (!PluginUtilities.checkRelease((ScreenRoot)this.fdsl, (Shell)this.getSite().getShell())) {
            this.closeEditor();
        }
        this.setPartName(iEditorInput.getName());
        try {
            this.epInput = new EventParagraphsEditorInput(this.fdsl.getEventParagraphs(), this.fdsl.getFile(), this.storageInput.getName(), true);
            this.epEditor = new EventParagraphsEditor((FormEditor)this);
            this.epEditor.setSite(this.getSite());
            this.epEditor.setInput((IEditorInput)this.epInput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscoboldd.reloadlinkedcopies") && this.storageInput instanceof IFileEditorInput) {
            this.fdsl.getFdItems().reloadAllLinkedCopies(this.fdsl.getProject());
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.fdsl.save();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    public EventParagraphsEditor getEventParagraphsEditor() {
        return this.epEditor;
    }

    private DataLayoutContentOutline getOutlinePage() {
        if (this.outline == null) {
            this.outline = new DataLayoutContentOutline(this);
        }
        return this.outline;
    }

    public void pageChange(int n) {
        super.pageChange(n);
        if (this.outline != null) {
            this.outline.refresh();
        }
        if (n == this.getKeyDefinitionPageIndex()) {
            if (this.keyDefinitionPage.getContentPane() != null) {
                this.keyDefinitionPage.initData();
            }
        } else if (n == this.getEFDPageIndex()) {
            if (this.efdPage.getContentPane() != null) {
                this.efdPage.initData();
            }
        } else if (n == this.getFileControlPageIndex()) {
            IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
            if (iEditorActionBarContributor != null && iEditorActionBarContributor instanceof MultiPageEditorActionBarContributor) {
                ((MultiPageEditorActionBarContributor)iEditorActionBarContributor).setActivePage((IEditorPart)this.fileControlPage);
            }
            this.fileControlPage.updateActions();
        }
    }

    int getEventParagraphsEditorIndex() {
        return 4;
    }

    int getFileControlPageIndex() {
        return 0;
    }

    int getKeyDefinitionPageIndex() {
        return 1;
    }

    int getIOHandlingPageIndex() {
        return 2;
    }

    int getEFDPageIndex() {
        return 3;
    }

    public Object getAdapter(Class clazz) {
        IFile iFile = this.getDataLayout().getFile();
        if (clazz == IShowInSource.class) {
            if (iFile != null) {
                return new /* Unavailable Anonymous Inner Class!! */;
            }
            return null;
        }
        if (clazz == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (clazz == ScreenFD_SL.class) {
            return this.getDataLayout();
        }
        if (clazz == ActionRegistry.class) {
            if (this.getActivePageInstance() == this.fileControlPage) {
                return this.fileControlPage.getActionRegistry();
            }
            return null;
        }
        if (clazz == CommandStack.class) {
            if (this.getActivePageInstance() == this.fileControlPage) {
                return this.fileControlPage.getVarContentPane().getCommandStack();
            }
            return null;
        }
        if (clazz == IscobolEditor.class) {
            if (iFile != null && this.getActiveEditor() == this.getEventParagraphsEditor()) {
                return this.getEventParagraphsEditor();
            }
            return null;
        }
        return super.getAdapter(clazz);
    }

    protected void addPages() {
        try {
            ImageProvider imageProvider = IscobolScreenPainterPlugin.getDefault().getImageProvider();
            this.fileControlPage = new FileControlPage(this);
            this.addPage((IFormPage)this.fileControlPage);
            this.setPageImage(this.getFileControlPageIndex(), imageProvider.getImage("/fdfilectlsec.png"));
            this.keyDefinitionPage = new KeyDefinitionPage(this);
            this.addPage((IFormPage)this.keyDefinitionPage);
            this.setPageImage(this.getKeyDefinitionPageIndex(), imageProvider.getImage("/fdkeysec.png"));
            this.ioHandlingPage = new IOHandlingPage(this);
            this.addPage((IFormPage)this.ioHandlingPage);
            this.setPageImage(this.getIOHandlingPageIndex(), imageProvider.getImage("/fdiohdlsec.png"));
            this.efdPage = new XFDPage(this);
            this.addPage((IFormPage)this.efdPage);
            this.setPageImage(this.getEFDPageIndex(), imageProvider.getImage("/fdefdsec.png"));
            if (this.epInput != null) {
                this.addPage((IEditorPart)this.epEditor, (IEditorInput)this.epInput);
                this.setPageText(this.getEventParagraphsEditorIndex(), ISPBundle.getString((String)"event_paragraphs_lbl"));
                this.setPageImage(this.getEventParagraphsEditorIndex(), imageProvider.getImage("/paragrapheditor.png"));
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public int getActivePageIndex() {
        return super.getActivePage();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (!(this.storageInput instanceof IFileEditorInput)) {
            return;
        }
        this.dirty = false;
        if (this.fileControlPage != null && this.fileControlPage.getContentPane() != null) {
            this.fileControlPage.cleanDirtyState();
        }
        if (this.epEditor != null) {
            this.fdsl.getEventParagraphs().setBody(this.epEditor.getViewer().getDocument().get());
        }
        this.resourceListenerEnabled = false;
        this.fdsl.save();
        this.resourceListenerEnabled = true;
        if (this.epEditor != null) {
            this.epEditor.doSave(iProgressMonitor);
        }
    }

    public ScreenFD_SL getDataLayout() {
        return this.fdsl;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public FileControlPage getFileControlPage() {
        return this.fileControlPage;
    }

    public KeyDefinitionPage getKeyDefinitionPage() {
        return this.keyDefinitionPage;
    }

    public IOHandlingPage getIoHandlingPage() {
        return this.ioHandlingPage;
    }

    public XFDPage getEfdPage() {
        return this.efdPage;
    }
}

