/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.DataLayoutEditor;
import com.iscobol.filedesigner.DataLayoutPage;
import com.iscobol.filedesigner.FileControlPage;
import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.filedesigner.types.AccessMode;
import com.iscobol.filedesigner.types.AssignDevice;
import com.iscobol.filedesigner.types.FileFormat;
import com.iscobol.filedesigner.types.LockMode;
import com.iscobol.plugins.editor.findinobject.FindInObjectMatchReference;
import com.iscobol.screenpainter.ISettingItemListPage;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.actions.CopyBeanAction;
import com.iscobol.screenpainter.actions.CutBeanAction;
import com.iscobol.screenpainter.actions.DeleteBeanAction;
import com.iscobol.screenpainter.actions.PasteBeanAction;
import com.iscobol.screenpainter.actions.SelectAllBeansAction;
import com.iscobol.screenpainter.beans.types.Percentage;
import com.iscobol.screenpainter.propertysheet.DirtyStateChangeListener;
import com.iscobol.screenpainter.propertysheet.SettingsContentPane;
import com.iscobol.screenpainter.propertysheet.VariableSettingsContentPane;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.texteditor.IUpdate;

public class FileControlPage
extends DataLayoutPage
implements CommandStackListener,
ISelectionChangedListener,
ISettingItemListPage {
    private Button optionalBtn;
    private Button reserveBtn;
    private Button areaNumberBtn;
    private Button noAreaBtn;
    private Button alternateBtn;
    private Button comprEncBtn;
    private Button encBtn;
    private Button comprBtn;
    private Button collatingBtn;
    private Button paddingBtn;
    private Button recDelimBtn;
    private Button externalBtn;
    private Button globalBtn;
    private Button blockBtn;
    private Button codeSetBtn;
    private Button labelBtn;
    private Button linageBtn;
    private Button recordBtn;
    private Button blockRecordsBtn;
    private Button blockCharactersBtn;
    private Button valueFileIdBtn;
    private Button valueLabelBtn;
    private Button keyTableBtn;
    private Button blockMinSizeBtn;
    private Button recordStdBtn;
    private Button recordOmBtn;
    private Button linFootingBtn;
    private Button linTopBtn;
    private Button linBottomBtn;
    private Button containBtn;
    private Button varyingBtn;
    private Button recordMinBtn;
    private Button recordFromBtn;
    private Button recordToBtn;
    private Button recordDependBtn;
    private Text assignNameTxt;
    private Text fileStatusTxt;
    private Text keyNameTxt;
    private Text areaNumberTxt;
    private Text alphabetTxt;
    private Text paddingCharTxt;
    private Text fileNameTxt;
    private Text commentTxt;
    private Text commentSelTxt;
    private Text blockMinSizeTxt;
    private Text blockMaxSizeTxt;
    private Text codeSetNameTxt;
    private Text linLinesTxt;
    private Text linFootingTxt;
    private Text linTopTxt;
    private Text linBottomTxt;
    private Text recordMinTxt;
    private Text recordMaxTxt;
    private Text recordFromTxt;
    private Text recordToTxt;
    private Text recordDependTxt;
    private Text valueFileIdTxt;
    private Text valueLabelTxt;
    private Text keyTableTxt;
    private Text classNameTxt;
    private Text classVarTxt;
    private Combo fileFormatCmb;
    private Combo accessModeCmb;
    private Combo assignDeviceCmb;
    private Combo lockModeCmb;
    private Combo comprFactorCmb;
    private Section fdAdvSec;
    private Section reserveSec;
    private Section comprEncSec;
    private Section collatingSec;
    private Section paddingSec;
    private Section recDelimSec;
    private Section recDefAdvSec;
    private Section declSec;
    private Section blockSec;
    private Section codeSetSec;
    private Section labelSec;
    private Section linageSec;
    private Section recordSec;
    private Section valueFileIdSec;
    private Section valueLabelSec;
    private Section keyTableSec;
    private Section containSec;
    private Section varyingSec;
    private CTabFolder fdTabFolder;
    private Label keyNameLbl;
    private Label paddingCharLbl;
    private Label alphabetLbl;
    private Label comprFactorLbl;
    private Label codeSetNameLbl;
    private Label linLinesLbl;
    private Label blockMinSizeLbl;
    private Label blockMaxSizeLbl;
    private Label recordMinLbl;
    private Label recordMaxLbl;
    private Label valueFileIdLbl;
    private Label valueLabelLbl;
    private Label keyTableLbl;
    private Label recordFromLbl;
    private Label recordToLbl;
    private Label recordDependLbl;
    private Label linFootingLbl;
    private Label linTopLbl;
    private Label linBottomLbl;
    private VariableSettingsContentPane varContentPane;
    private List selectionActions = new ArrayList();
    private List updateActions = new ArrayList();
    private List stackActions = new ArrayList();
    private ActionRegistry actionRegistry;

    FileControlPage(DataLayoutEditor dataLayoutEditor) {
        super(dataLayoutEditor, "iscobolscreenpainter.DataLayoutEditor.Page1", "File Definition");
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public List getSelectionActions() {
        return this.selectionActions;
    }

    public List getUpdateActions() {
        return this.updateActions;
    }

    public List getStackActions() {
        return this.stackActions;
    }

    public void updateActions() {
        Iterator iterator = this.selectionActions.iterator();
        while (iterator.hasNext()) {
            ((SelectionAction)iterator.next()).update();
        }
        iterator = this.updateActions.iterator();
        while (iterator.hasNext()) {
            ((IUpdate)iterator.next()).update();
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateActions();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (clazz == CommandStack.class) {
            return this.varContentPane.getCommandStack();
        }
        return super.getAdapter(clazz);
    }

    private CommandStack myGetCommandStack() {
        CommandStack commandStack = (CommandStack)this.getParent().getAdapter(CommandStack.class);
        if (commandStack == null) {
            commandStack = (CommandStack)this.getAdapter(CommandStack.class);
        }
        return commandStack;
    }

    protected void createActions() {
        ActionRegistry actionRegistry = this.getActionRegistry();
        CutBeanAction cutBeanAction = new CutBeanAction(this.getParent());
        actionRegistry.registerAction((IAction)cutBeanAction);
        this.getSelectionActions().add(cutBeanAction);
        cutBeanAction = new CopyBeanAction(this.getParent());
        actionRegistry.registerAction((IAction)cutBeanAction);
        this.getSelectionActions().add(cutBeanAction);
        cutBeanAction = new PasteBeanAction(this.getParent());
        actionRegistry.registerAction((IAction)cutBeanAction);
        this.getSelectionActions().add(cutBeanAction);
        1 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        actionRegistry.registerAction((IAction)var3_3);
        this.getStackActions().add(var3_3);
        2 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        actionRegistry.registerAction((IAction)var4_4);
        this.getStackActions().add(var4_4);
        SelectAllBeansAction selectAllBeansAction = new SelectAllBeansAction(this.getParent());
        this.getUpdateActions().add(selectAllBeansAction);
        actionRegistry.registerAction((IAction)selectAllBeansAction);
        cutBeanAction = new DeleteBeanAction(this.getParent());
        actionRegistry.registerAction((IAction)cutBeanAction);
        this.getSelectionActions().add(cutBeanAction);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setShowFocusedControl(true);
        scrolledForm.setText("File Definition");
        scrolledForm.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/fdfilectlsec.png"));
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = scrolledForm.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 3;
        composite.setLayout((Layout)tableWrapLayout);
        formToolkit.createLabel(composite, "File Name: ");
        this.fileNameTxt = formToolkit.createText(composite, "", 2048);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.fileNameTxt.setLayoutData((Object)tableWrapData);
        this.fileNameTxt.setEnabled(false);
        this.optionalBtn = formToolkit.createButton(composite, "Optional", 32);
        tableWrapData = new TableWrapData(8);
        this.optionalBtn.setLayoutData((Object)tableWrapData);
        this.fdTabFolder = new CTabFolder(composite, 128);
        tableWrapData = new TableWrapData(256);
        tableWrapData.colspan = 3;
        this.fdTabFolder.setLayoutData((Object)tableWrapData);
        formToolkit.adapt((Composite)this.fdTabFolder);
        CTabItem cTabItem = new CTabItem(this.fdTabFolder, 0);
        cTabItem.setText("File Descriptor Settings");
        Composite composite2 = formToolkit.createComposite((Composite)this.fdTabFolder);
        cTabItem.setControl((Control)composite2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.fdAdvSec = formToolkit.createSection(composite2, 260);
        this.fdAdvSec.setText("Advanced");
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fdAdvSec.setLayoutData((Object)gridData);
        Composite composite3 = formToolkit.createComposite((Composite)this.fdAdvSec);
        this.fdAdvSec.setClient((Control)composite3);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 3;
        composite3.setLayout((Layout)gridLayout);
        this.reserveBtn = formToolkit.createButton(composite3, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.reserveBtn.setLayoutData((Object)gridData);
        this.reserveSec = formToolkit.createSection(composite3, 256);
        this.reserveSec.setText("Reserve");
        gridData = new GridData(1808);
        this.reserveSec.setLayoutData((Object)gridData);
        Composite composite4 = formToolkit.createComposite((Composite)this.reserveSec);
        this.reserveSec.setClient((Control)composite4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite4.setLayout((Layout)gridLayout);
        this.areaNumberBtn = formToolkit.createButton(composite4, "Number", 16);
        this.areaNumberTxt = formToolkit.createText(composite4, "", 2048);
        gridData = new GridData(768);
        this.areaNumberTxt.setLayoutData((Object)gridData);
        this.alternateBtn = formToolkit.createButton(composite4, "Alternate", 32);
        this.noAreaBtn = formToolkit.createButton(composite4, "No", 16);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.noAreaBtn.setLayoutData((Object)gridData);
        this.paddingBtn = formToolkit.createButton(composite3, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.paddingBtn.setLayoutData((Object)gridData);
        this.paddingSec = formToolkit.createSection(composite3, 256);
        this.paddingSec.setText("Padding");
        gridData = new GridData(1808);
        this.paddingSec.setLayoutData((Object)gridData);
        Composite composite5 = formToolkit.createComposite((Composite)this.paddingSec);
        this.paddingSec.setClient((Control)composite5);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite5.setLayout((Layout)gridLayout);
        this.paddingCharLbl = formToolkit.createLabel(composite5, "Character:");
        this.paddingCharTxt = formToolkit.createText(composite5, "", 2048);
        gridData = new GridData(768);
        this.paddingCharTxt.setLayoutData((Object)gridData);
        Label label = formToolkit.createLabel(composite3, "");
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.recDelimSec = formToolkit.createSection(composite3, 256);
        this.recDelimSec.setText("Record Delimiter");
        gridData = new GridData(1808);
        this.recDelimSec.setLayoutData((Object)gridData);
        Composite composite6 = formToolkit.createComposite((Composite)this.recDelimSec);
        this.recDelimSec.setClient((Control)composite6);
        gridLayout = new GridLayout();
        composite6.setLayout((Layout)gridLayout);
        this.recDelimBtn = formToolkit.createButton(composite6, "Record delimiter is standard-1", 32);
        this.comprEncBtn = formToolkit.createButton(composite3, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.comprEncBtn.setLayoutData((Object)gridData);
        this.comprEncSec = formToolkit.createSection(composite3, 256);
        this.comprEncSec.setText("Compression/Encryption");
        gridData = new GridData(1808);
        this.comprEncSec.setLayoutData((Object)gridData);
        Composite composite7 = formToolkit.createComposite((Composite)this.comprEncSec);
        this.comprEncSec.setClient((Control)composite7);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite7.setLayout((Layout)gridLayout);
        this.encBtn = formToolkit.createButton(composite7, "Encryption", 32);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.encBtn.setLayoutData((Object)gridData);
        this.comprBtn = formToolkit.createButton(composite7, "Compression", 32);
        gridData = new GridData();
        this.comprBtn.setLayoutData((Object)gridData);
        this.comprFactorLbl = formToolkit.createLabel(composite7, "Compression control factor (%):");
        gridData = new GridData();
        gridData.horizontalIndent = 50;
        this.comprFactorLbl.setLayoutData((Object)gridData);
        this.comprFactorCmb = new Combo(composite7, 2056);
        this.collatingBtn = formToolkit.createButton(composite3, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.collatingBtn.setLayoutData((Object)gridData);
        this.collatingSec = formToolkit.createSection(composite3, 256);
        this.collatingSec.setText("Collating");
        gridData = new GridData(1808);
        this.collatingSec.setLayoutData((Object)gridData);
        Composite composite8 = formToolkit.createComposite((Composite)this.collatingSec);
        this.collatingSec.setClient((Control)composite8);
        gridLayout = new GridLayout();
        composite8.setLayout((Layout)gridLayout);
        this.alphabetLbl = formToolkit.createLabel(composite8, "Alphabet name:");
        this.alphabetTxt = formToolkit.createText(composite8, "", 2048);
        gridData = new GridData(768);
        this.alphabetTxt.setLayoutData((Object)gridData);
        Section section = formToolkit.createSection(composite2, 256);
        section.setText("Assign to");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        section.setLayoutData((Object)gridData);
        Composite composite9 = formToolkit.createComposite((Composite)section);
        section.setClient((Control)composite9);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite9.setLayout((Layout)gridLayout);
        formToolkit.createLabel(composite9, "Device:");
        this.assignDeviceCmb = new Combo(composite9, 2056);
        gridData = new GridData(768);
        this.assignDeviceCmb.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite9, "Name:");
        this.assignNameTxt = formToolkit.createText(composite9, "", 2048);
        gridData = new GridData(768);
        this.assignNameTxt.setLayoutData((Object)gridData);
        Section section2 = formToolkit.createSection(composite2, 256);
        section2.setText("File Format");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        section2.setLayoutData((Object)gridData);
        Composite composite10 = formToolkit.createComposite((Composite)section2);
        section2.setClient((Control)composite10);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite10.setLayout((Layout)gridLayout);
        formToolkit.createLabel(composite10, "Format:");
        this.fileFormatCmb = new Combo(composite10, 2056);
        gridData = new GridData(768);
        this.fileFormatCmb.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite10, "Access Mode:");
        this.accessModeCmb = new Combo(composite10, 2056);
        gridData = new GridData(768);
        this.accessModeCmb.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite10, "File Status:");
        this.fileStatusTxt = formToolkit.createText(composite10, "", 2048);
        gridData = new GridData(768);
        this.fileStatusTxt.setLayoutData((Object)gridData);
        this.keyNameLbl = formToolkit.createLabel(composite10, "Key Name:");
        this.keyNameTxt = formToolkit.createText(composite10, "", 2048);
        gridData = new GridData(768);
        this.keyNameTxt.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite10, "Lock Mode:");
        this.lockModeCmb = new Combo(composite10, 2056);
        gridData = new GridData(768);
        this.lockModeCmb.setLayoutData((Object)gridData);
        Label label2 = formToolkit.createLabel(composite2, "Comment:");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label2.setLayoutData((Object)gridData);
        this.commentSelTxt = formToolkit.createText(composite2, "", 2050);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 50;
        this.commentSelTxt.setLayoutData((Object)gridData);
        Section section3 = formToolkit.createSection(composite2, 256);
        section3.setText("Class");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        section3.setLayoutData((Object)gridData);
        Composite composite11 = formToolkit.createComposite((Composite)section3);
        section3.setClient((Control)composite11);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        composite11.setLayout((Layout)gridLayout);
        formToolkit.createLabel(composite11, "Name:");
        this.classNameTxt = formToolkit.createText(composite11, "", 2048);
        this.classNameTxt.setLayoutData((Object)new GridData(768));
        new /* Unavailable Anonymous Inner Class!! */;
        formToolkit.createLabel(composite11, "Variable:");
        this.classVarTxt = formToolkit.createText(composite11, "", 2048);
        this.classVarTxt.setLayoutData((Object)new GridData(768));
        new /* Unavailable Anonymous Inner Class!! */;
        Label label3 = formToolkit.createLabel(composite2, "Comment:");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        label3.setLayoutData((Object)gridData);
        this.commentTxt = formToolkit.createText(composite2, "", 2050);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 50;
        this.commentTxt.setLayoutData((Object)gridData);
        CTabItem cTabItem2 = new CTabItem(this.fdTabFolder, 0);
        cTabItem2.setText("Record Definition");
        Composite composite12 = formToolkit.createComposite((Composite)this.fdTabFolder);
        cTabItem2.setControl((Control)composite12);
        gridLayout = new GridLayout();
        composite12.setLayout((Layout)gridLayout);
        this.recDefAdvSec = formToolkit.createSection(composite12, 260);
        gridData = new GridData(768);
        this.recDefAdvSec.setLayoutData((Object)gridData);
        this.recDefAdvSec.setText("Advanced");
        Composite composite13 = formToolkit.createComposite((Composite)this.recDefAdvSec);
        this.recDefAdvSec.setClient((Control)composite13);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 3;
        composite13.setLayout((Layout)gridLayout);
        label = formToolkit.createLabel(composite13, "");
        gridData = new GridData();
        gridData.widthHint = 15;
        label.setLayoutData((Object)gridData);
        this.declSec = formToolkit.createSection(composite13, 256);
        this.declSec.setText("Declared");
        gridData = new GridData(1808);
        this.declSec.setLayoutData((Object)gridData);
        Composite composite14 = formToolkit.createComposite((Composite)this.declSec);
        this.declSec.setClient((Control)composite14);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite14.setLayout((Layout)gridLayout);
        this.externalBtn = formToolkit.createButton(composite14, "External", 32);
        this.globalBtn = formToolkit.createButton(composite14, "Global", 32);
        this.blockBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.blockBtn.setLayoutData((Object)gridData);
        this.blockSec = formToolkit.createSection(composite13, 256);
        this.blockSec.setText("Block");
        gridData = new GridData(1808);
        this.blockSec.setLayoutData((Object)gridData);
        Composite composite15 = formToolkit.createComposite((Composite)this.blockSec);
        this.blockSec.setClient((Control)composite15);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite15.setLayout((Layout)gridLayout);
        this.blockMinSizeBtn = formToolkit.createButton(composite15, "", 32);
        this.blockMinSizeLbl = formToolkit.createLabel(composite15, "Block Minimum Size");
        this.blockMinSizeTxt = formToolkit.createText(composite15, "", 2048);
        gridData = new GridData(768);
        this.blockMinSizeTxt.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite15, "");
        this.blockMaxSizeLbl = formToolkit.createLabel(composite15, "Block Maximum Size");
        this.blockMaxSizeTxt = formToolkit.createText(composite15, "", 2048);
        gridData = new GridData(768);
        this.blockMaxSizeTxt.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite15, "");
        this.blockRecordsBtn = formToolkit.createButton(composite15, "Records", 16);
        this.blockCharactersBtn = formToolkit.createButton(composite15, "Characters", 16);
        this.codeSetBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.codeSetBtn.setLayoutData((Object)gridData);
        this.codeSetSec = formToolkit.createSection(composite13, 256);
        this.codeSetSec.setText("Code-Set");
        gridData = new GridData(1808);
        this.codeSetSec.setLayoutData((Object)gridData);
        Composite composite16 = formToolkit.createComposite((Composite)this.codeSetSec);
        this.codeSetSec.setClient((Control)composite16);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite16.setLayout((Layout)gridLayout);
        this.codeSetNameLbl = formToolkit.createLabel(composite16, "Name:");
        this.codeSetNameTxt = formToolkit.createText(composite16, "", 2048);
        gridData = new GridData(768);
        this.codeSetNameTxt.setLayoutData((Object)gridData);
        this.labelBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.labelBtn.setLayoutData((Object)gridData);
        this.labelSec = formToolkit.createSection(composite13, 256);
        this.labelSec.setText("Label");
        gridData = new GridData(1808);
        this.labelSec.setLayoutData((Object)gridData);
        Composite composite17 = formToolkit.createComposite((Composite)this.labelSec);
        this.labelSec.setClient((Control)composite17);
        gridLayout = new GridLayout();
        composite17.setLayout((Layout)gridLayout);
        this.recordStdBtn = formToolkit.createButton(composite17, "Record(s) standard", 16);
        this.recordOmBtn = formToolkit.createButton(composite17, "Record(s) omitted", 16);
        this.linageBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.linageBtn.setLayoutData((Object)gridData);
        this.linageSec = formToolkit.createSection(composite13, 256);
        this.linageSec.setText("Linage");
        gridData = new GridData(1808);
        this.linageSec.setLayoutData((Object)gridData);
        Composite composite18 = formToolkit.createComposite((Composite)this.linageSec);
        this.linageSec.setClient((Control)composite18);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite18.setLayout((Layout)gridLayout);
        formToolkit.createLabel(composite18, "");
        this.linLinesLbl = formToolkit.createLabel(composite18, "Lines");
        this.linLinesTxt = formToolkit.createText(composite18, "", 2048);
        gridData = new GridData(768);
        this.linLinesTxt.setLayoutData((Object)gridData);
        this.linFootingBtn = formToolkit.createButton(composite18, "", 32);
        this.linFootingLbl = formToolkit.createLabel(composite18, "Footing");
        this.linFootingTxt = formToolkit.createText(composite18, "", 2048);
        gridData = new GridData(768);
        this.linFootingTxt.setLayoutData((Object)gridData);
        this.linTopBtn = formToolkit.createButton(composite18, "", 32);
        this.linTopLbl = formToolkit.createLabel(composite18, "Top");
        this.linTopTxt = formToolkit.createText(composite18, "", 2048);
        gridData = new GridData(768);
        this.linTopTxt.setLayoutData((Object)gridData);
        this.linBottomBtn = formToolkit.createButton(composite18, "", 32);
        this.linBottomLbl = formToolkit.createLabel(composite18, "Bottom");
        this.linBottomTxt = formToolkit.createText(composite18, "", 2048);
        gridData = new GridData(768);
        this.linBottomTxt.setLayoutData((Object)gridData);
        this.recordBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.recordBtn.setLayoutData((Object)gridData);
        this.recordSec = formToolkit.createSection(composite13, 256);
        this.recordSec.setText("Record");
        gridData = new GridData(1808);
        this.recordSec.setLayoutData((Object)gridData);
        Composite composite19 = formToolkit.createComposite((Composite)this.recordSec);
        this.recordSec.setClient((Control)composite19);
        gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 3;
        gridLayout.numColumns = 2;
        composite19.setLayout((Layout)gridLayout);
        this.containBtn = formToolkit.createButton(composite19, "", 16);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.containBtn.setLayoutData((Object)gridData);
        this.containSec = formToolkit.createSection(composite19, 256);
        this.containSec.setText("Contain");
        gridData = new GridData(1808);
        this.containSec.setLayoutData((Object)gridData);
        Composite composite20 = formToolkit.createComposite((Composite)this.containSec);
        this.containSec.setClient((Control)composite20);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite20.setLayout((Layout)gridLayout);
        this.recordMinBtn = formToolkit.createButton(composite20, "", 32);
        this.recordMinLbl = formToolkit.createLabel(composite20, "Minimum");
        this.recordMinTxt = formToolkit.createText(composite20, "", 2048);
        gridData = new GridData(768);
        this.recordMinTxt.setLayoutData((Object)gridData);
        formToolkit.createLabel(composite20, "");
        this.recordMaxLbl = formToolkit.createLabel(composite20, "Maximum");
        this.recordMaxTxt = formToolkit.createText(composite20, "", 2048);
        gridData = new GridData(768);
        this.recordMaxTxt.setLayoutData((Object)gridData);
        this.varyingBtn = formToolkit.createButton(composite19, "", 16);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.varyingBtn.setLayoutData((Object)gridData);
        this.varyingSec = formToolkit.createSection(composite19, 256);
        this.varyingSec.setText("Varying In Size");
        gridData = new GridData(1808);
        this.varyingSec.setLayoutData((Object)gridData);
        Composite composite21 = formToolkit.createComposite((Composite)this.varyingSec);
        this.varyingSec.setClient((Control)composite21);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite21.setLayout((Layout)gridLayout);
        this.recordFromBtn = formToolkit.createButton(composite21, "", 32);
        this.recordFromLbl = formToolkit.createLabel(composite21, "From");
        this.recordFromTxt = formToolkit.createText(composite21, "", 2048);
        gridData = new GridData(768);
        this.recordFromTxt.setLayoutData((Object)gridData);
        this.recordToBtn = formToolkit.createButton(composite21, "", 32);
        this.recordToLbl = formToolkit.createLabel(composite21, "To");
        this.recordToTxt = formToolkit.createText(composite21, "", 2048);
        gridData = new GridData(768);
        this.recordToTxt.setLayoutData((Object)gridData);
        this.recordDependBtn = formToolkit.createButton(composite21, "", 32);
        this.recordDependLbl = formToolkit.createLabel(composite21, "Depend");
        this.recordDependTxt = formToolkit.createText(composite21, "", 2048);
        gridData = new GridData(768);
        this.recordDependTxt.setLayoutData((Object)gridData);
        this.valueFileIdBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.valueFileIdBtn.setLayoutData((Object)gridData);
        this.valueFileIdSec = formToolkit.createSection(composite13, 256);
        this.valueFileIdSec.setText("Value of File-ID");
        gridData = new GridData(1808);
        this.valueFileIdSec.setLayoutData((Object)gridData);
        Composite composite22 = formToolkit.createComposite((Composite)this.valueFileIdSec);
        this.valueFileIdSec.setClient((Control)composite22);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite22.setLayout((Layout)gridLayout);
        this.valueFileIdLbl = formToolkit.createLabel(composite22, "Name:");
        this.valueFileIdTxt = formToolkit.createText(composite22, "", 2048);
        gridData = new GridData(768);
        this.valueFileIdTxt.setLayoutData((Object)gridData);
        this.valueLabelBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.valueLabelBtn.setLayoutData((Object)gridData);
        this.valueLabelSec = formToolkit.createSection(composite13, 256);
        this.valueLabelSec.setText("Value of Label");
        gridData = new GridData(1808);
        this.valueLabelSec.setLayoutData((Object)gridData);
        Composite composite23 = formToolkit.createComposite((Composite)this.valueLabelSec);
        this.valueLabelSec.setClient((Control)composite23);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite23.setLayout((Layout)gridLayout);
        this.valueLabelLbl = formToolkit.createLabel(composite23, "Label:");
        this.valueLabelTxt = formToolkit.createText(composite23, "", 2048);
        gridData = new GridData(768);
        this.valueLabelTxt.setLayoutData((Object)gridData);
        this.keyTableBtn = formToolkit.createButton(composite13, "", 32);
        gridData = new GridData();
        gridData.widthHint = 15;
        gridData.verticalAlignment = 1;
        this.keyTableBtn.setLayoutData((Object)gridData);
        this.keyTableSec = formToolkit.createSection(composite13, 256);
        this.keyTableSec.setText("Key Table");
        gridData = new GridData(1808);
        this.keyTableSec.setLayoutData((Object)gridData);
        Composite composite24 = formToolkit.createComposite((Composite)this.keyTableSec);
        this.keyTableSec.setClient((Control)composite24);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite24.setLayout((Layout)gridLayout);
        this.keyTableLbl = formToolkit.createLabel(composite24, "Data-Name:");
        this.keyTableTxt = formToolkit.createText(composite24, "", 2048);
        gridData = new GridData(768);
        this.keyTableTxt.setLayoutData((Object)gridData);
        this.varContentPane = new VariableSettingsContentPane(composite12, null, this.getFdItems(), formToolkit, 500, 1, (ScreenRoot)this.getDataLayout(), 150, 200);
        gridData = new GridData(768);
        this.varContentPane.setLayoutData((Object)gridData);
        this.varContentPane.createClientArea();
        this.varContentPane.setDefaultVarPicture("9(3)");
        this.varContentPane.setDefaultItemPrefix(this.getFdName() + "-item");
        this.varContentPane.setDefaultCondPrefix(this.getFdName() + "-cond-item");
        this.varContentPane.setDefaultConstPrefix(this.getFdName() + "-const-item");
        this.varContentPane.setDefaultRenamePrefix(this.getFdName() + "-ren-item");
        formToolkit.adapt((Composite)this.varContentPane);
        this.fdTabFolder.setSelection(0);
        this.varContentPane.addSelectionChangedListener((ISelectionChangedListener)this);
        this.varContentPane.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.varContentPane.setEditorPart((IEditorPart)this);
        this.createActions();
        this.initData();
        this.setSectionEnabledStates(this.getFileDescriptor());
        this.addListeners(scrolledForm);
        this.setContentPane(composite);
    }

    public void commandStackChanged(EventObject eventObject) {
        Iterator iterator = this.stackActions.iterator();
        while (iterator.hasNext()) {
            ((UpdateAction)iterator.next()).update();
        }
    }

    void initData() {
        int n;
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.fileNameTxt.setText(this.getFdName());
        this.optionalBtn.setSelection(fileDescriptor.isOptional());
        AssignDevice assignDevice = fileDescriptor.getAssignDevice();
        String[] stringArray = assignDevice.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.assignDeviceCmb.setData(stringArray[i], (Object)new Integer(i));
        }
        this.fillAssignDeviceCmb(fileDescriptor);
        if (fileDescriptor.getAssignName() != null) {
            this.assignNameTxt.setText(fileDescriptor.getAssignName());
        }
        FileFormat fileFormat = fileDescriptor.getFileFormat();
        stringArray = fileFormat.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.fileFormatCmb.add(stringArray[i]);
        }
        this.fileFormatCmb.select(fileFormat.getValue());
        AccessMode accessMode = fileDescriptor.getAccessMode();
        stringArray = accessMode.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.accessModeCmb.setData(stringArray[i], (Object)new Integer(i));
        }
        this.fillAccessModeCmb(fileDescriptor);
        if (fileDescriptor.getFileStatusName() != null) {
            this.fileStatusTxt.setText(fileDescriptor.getFileStatusName());
        }
        if (fileDescriptor.getKeyName() != null) {
            this.keyNameTxt.setText(fileDescriptor.getKeyName());
        }
        this.setKeyNameTxtEnabledState(fileDescriptor);
        LockMode lockMode = fileDescriptor.getLockMode();
        stringArray = lockMode.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.lockModeCmb.setData(stringArray[i], (Object)new Integer(i));
        }
        if (fileDescriptor.getClassName() != null) {
            this.classNameTxt.setText(fileDescriptor.getClassName());
        }
        if (fileDescriptor.getClassVariable() != null) {
            this.classVarTxt.setText(fileDescriptor.getClassVariable());
        }
        this.comprEncBtn.setSelection(fileDescriptor.isWithCompression() || fileDescriptor.isWithEncryption());
        this.fillLockModeCmb(fileDescriptor);
        if (fileDescriptor.getCommentSel() != null) {
            this.commentSelTxt.setText(fileDescriptor.getCommentSel());
        }
        this.comprBtn.setSelection(fileDescriptor.isWithCompression());
        this.encBtn.setSelection(fileDescriptor.isWithEncryption());
        Percentage percentage = fileDescriptor.getCompressionFactor();
        stringArray = percentage.getNames();
        for (n = 0; n < stringArray.length; ++n) {
            this.comprFactorCmb.add(stringArray[n]);
        }
        this.comprFactorCmb.select(percentage.getValue());
        this.reserveBtn.setSelection(fileDescriptor.isReserve());
        this.areaNumberBtn.setSelection(!fileDescriptor.isReserveNoArea());
        this.noAreaBtn.setSelection(fileDescriptor.isReserveNoArea());
        this.areaNumberTxt.setText("" + fileDescriptor.getReserveNumber());
        this.alternateBtn.setSelection(fileDescriptor.isReserveAlternate());
        this.collatingBtn.setSelection(fileDescriptor.isCollating());
        if (fileDescriptor.getAlphabetName() != null) {
            this.alphabetTxt.setText(fileDescriptor.getAlphabetName());
        }
        this.paddingBtn.setSelection(fileDescriptor.isPadding());
        if (fileDescriptor.getPaddingCharacter() != null) {
            this.paddingCharTxt.setText(fileDescriptor.getPaddingCharacter());
        }
        this.recDelimBtn.setSelection(fileDescriptor.isRecordDelimiterStd1());
        if (fileDescriptor.getComment() != null) {
            this.commentTxt.setText(fileDescriptor.getComment());
        }
        this.externalBtn.setSelection(fileDescriptor.isExternal());
        this.globalBtn.setSelection(fileDescriptor.isGlobal());
        this.blockBtn.setSelection(fileDescriptor.getUseBlockAttributes());
        n = fileDescriptor.getBlockMinSize();
        if (n < 1) {
            n = 1;
        }
        this.blockMinSizeBtn.setSelection(n > 1);
        this.blockMinSizeTxt.setText("" + n);
        int n2 = fileDescriptor.getBlockMaxSize();
        if (n2 < n) {
            n2 = n;
        }
        this.blockMaxSizeTxt.setText("" + n2);
        this.blockRecordsBtn.setSelection(fileDescriptor.isBlockRecords());
        this.blockCharactersBtn.setSelection(!fileDescriptor.isBlockRecords());
        this.setBlockSecEnabledState(fileDescriptor.getUseBlockAttributes());
        boolean bl = fileDescriptor.getCodeSetName() != null && fileDescriptor.getCodeSetName().length() > 0;
        this.codeSetBtn.setSelection(bl);
        if (bl) {
            this.codeSetNameTxt.setText(fileDescriptor.getCodeSetName());
        }
        this.setCodeSetSecEnabledState(bl);
        this.labelBtn.setSelection(fileDescriptor.getUseLabelAttributes());
        this.recordStdBtn.setSelection(fileDescriptor.isLabelRecordStd());
        this.recordOmBtn.setSelection(!fileDescriptor.isLabelRecordStd());
        this.setLabelSecEnabledState(fileDescriptor.getUseLabelAttributes());
        String string = fileDescriptor.getLinageLines();
        String string2 = fileDescriptor.getLinageFooting();
        String string3 = fileDescriptor.getLinageTop();
        String string4 = fileDescriptor.getLinageBottom();
        boolean bl2 = string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0;
        this.linageBtn.setSelection(bl2);
        if (bl2) {
            if (string != null && string.length() > 0) {
                this.linLinesTxt.setText(string);
            }
            if (string2 != null && string2.length() > 0) {
                this.linFootingBtn.setSelection(true);
                this.linFootingTxt.setText(string2);
            } else {
                this.linFootingBtn.setSelection(false);
            }
            if (string3 != null && string3.length() > 0) {
                this.linTopTxt.setText(string3);
                this.linTopBtn.setSelection(true);
            } else {
                this.linTopBtn.setSelection(false);
            }
            if (string4 != null && string4.length() > 0) {
                this.linBottomTxt.setText(string4);
                this.linBottomBtn.setSelection(true);
            } else {
                this.linBottomBtn.setSelection(false);
            }
        }
        this.setLinageSecEnabledState(bl2);
        this.recordBtn.setSelection(fileDescriptor.getUseRecordAttributes());
        this.containBtn.setSelection(!fileDescriptor.isRecordVarying());
        this.varyingBtn.setSelection(fileDescriptor.isRecordVarying());
        int n3 = fileDescriptor.getRecordMinSize();
        if (n3 < 1) {
            n3 = 1;
        }
        this.recordMinBtn.setSelection(n3 > 1);
        this.recordMinTxt.setText("" + n3);
        int n4 = fileDescriptor.getRecordMaxSize();
        if (n4 < n3) {
            n4 = n3;
        }
        this.recordMaxTxt.setText("" + n4);
        int n5 = fileDescriptor.getRecordFrom();
        if (n5 < 1) {
            n5 = 1;
        }
        this.recordFromBtn.setSelection(n5 > 1);
        this.recordFromTxt.setText("" + n5);
        int n6 = fileDescriptor.getRecordTo();
        if (n6 < n5) {
            n6 = n5;
        }
        this.recordToBtn.setSelection(n6 > 1);
        this.recordToTxt.setText("" + n6);
        String string5 = fileDescriptor.getRecordDepend();
        if (string5 != null && string5.length() > 0) {
            this.recordDependBtn.setSelection(true);
            this.recordDependTxt.setText(string5);
        } else {
            this.recordDependBtn.setSelection(false);
        }
        this.setRecordSecEnabledState(fileDescriptor.getUseRecordAttributes());
        String string6 = fileDescriptor.getValueFileId();
        this.valueFileIdBtn.setSelection(string6 != null && string6.length() > 0);
        this.setValueFileIdEnabledState(this.valueFileIdBtn.getSelection());
        String string7 = fileDescriptor.getValueLabel();
        this.valueLabelBtn.setSelection(string7 != null && string7.length() > 0);
        this.setValueLabelEnabledState(this.valueLabelBtn.getSelection());
        String string8 = fileDescriptor.getKeyTableDataName();
        this.keyTableBtn.setSelection(string8 != null && string8.length() > 0);
        this.setKeyTableEnabledState(this.keyTableBtn.getSelection());
    }

    private void setSectionEnabledStates(FileDescriptor fileDescriptor) {
        this.setReserveSecEnabledState(fileDescriptor);
        this.setPaddingSecEnabledState(fileDescriptor);
        this.setCollatingSecEnabledState(fileDescriptor);
        this.setRecDelimSecEnabledState(fileDescriptor);
        this.setComprEncSecEnabledState(fileDescriptor);
    }

    private void fillLockModeCmb(FileDescriptor fileDescriptor) {
        this.lockModeCmb.removeAll();
        LockMode lockMode = fileDescriptor.getLockMode();
        AssignDevice assignDevice = fileDescriptor.getAssignDevice();
        if (assignDevice.getValue() == 7 || assignDevice.getValue() == 8 || assignDevice.getValue() == 9) {
            this.lockModeCmb.add(lockMode.getName(0));
        } else {
            FileFormat fileFormat = fileDescriptor.getFileFormat();
            switch (fileFormat.getValue()) {
                case 0: {
                    this.lockModeCmb.add(lockMode.getName(0));
                    break;
                }
                case 1: 
                case 2: {
                    this.lockModeCmb.add(lockMode.getName(0));
                    this.lockModeCmb.add(lockMode.getName(1));
                    this.lockModeCmb.add(lockMode.getName(2));
                    this.lockModeCmb.add(lockMode.getName(8));
                    break;
                }
                case 3: 
                case 4: {
                    this.lockModeCmb.add(lockMode.getName(0));
                    this.lockModeCmb.add(lockMode.getName(1));
                    this.lockModeCmb.add(lockMode.getName(2));
                    this.lockModeCmb.add(lockMode.getName(5));
                    this.lockModeCmb.add(lockMode.getName(6));
                    this.lockModeCmb.add(lockMode.getName(3));
                    this.lockModeCmb.add(lockMode.getName(4));
                    this.lockModeCmb.add(lockMode.getName(7));
                    this.lockModeCmb.add(lockMode.getName(8));
                    this.lockModeCmb.add(lockMode.getName(11));
                    this.lockModeCmb.add(lockMode.getName(12));
                    this.lockModeCmb.add(lockMode.getName(9));
                    this.lockModeCmb.add(lockMode.getName(10));
                    this.lockModeCmb.add(lockMode.getName(13));
                    break;
                }
                case 5: {
                    this.lockModeCmb.add(lockMode.getName(0));
                }
            }
        }
        int n = this.lockModeCmb.indexOf(lockMode.getName());
        if (n < 0) {
            n = 0;
        }
        this.lockModeCmb.select(n);
    }

    private void fillAssignDeviceCmb(FileDescriptor fileDescriptor) {
        this.assignDeviceCmb.removeAll();
        FileFormat fileFormat = fileDescriptor.getFileFormat();
        AssignDevice assignDevice = fileDescriptor.getAssignDevice();
        switch (fileFormat.getValue()) {
            case 0: {
                this.assignDeviceCmb.add(assignDevice.getName(0));
                this.assignDeviceCmb.add(assignDevice.getName(7));
                this.assignDeviceCmb.add(assignDevice.getName(8));
                this.assignDeviceCmb.add(assignDevice.getName(9));
                break;
            }
            case 1: {
                this.assignDeviceCmb.add(assignDevice.getName(0));
                this.assignDeviceCmb.add(assignDevice.getName(1));
                this.assignDeviceCmb.add(assignDevice.getName(2));
                this.assignDeviceCmb.add(assignDevice.getName(3));
                this.assignDeviceCmb.add(assignDevice.getName(4));
                this.assignDeviceCmb.add(assignDevice.getName(6));
                this.assignDeviceCmb.add(assignDevice.getName(5));
                this.assignDeviceCmb.add(assignDevice.getName(7));
                this.assignDeviceCmb.add(assignDevice.getName(8));
                this.assignDeviceCmb.add(assignDevice.getName(9));
                this.assignDeviceCmb.add(assignDevice.getName(10));
                this.assignDeviceCmb.add(assignDevice.getName(11));
                this.assignDeviceCmb.add(assignDevice.getName(12));
                this.assignDeviceCmb.add(assignDevice.getName(13));
                this.assignDeviceCmb.add(assignDevice.getName(14));
                this.assignDeviceCmb.add(assignDevice.getName(17));
                this.assignDeviceCmb.add(assignDevice.getName(15));
                this.assignDeviceCmb.add(assignDevice.getName(16));
                break;
            }
            case 2: {
                this.assignDeviceCmb.add(assignDevice.getName(0));
                this.assignDeviceCmb.add(assignDevice.getName(1));
                this.assignDeviceCmb.add(assignDevice.getName(2));
                this.assignDeviceCmb.add(assignDevice.getName(3));
                this.assignDeviceCmb.add(assignDevice.getName(4));
                this.assignDeviceCmb.add(assignDevice.getName(6));
                this.assignDeviceCmb.add(assignDevice.getName(5));
                this.assignDeviceCmb.add(assignDevice.getName(7));
                this.assignDeviceCmb.add(assignDevice.getName(8));
                this.assignDeviceCmb.add(assignDevice.getName(9));
                this.assignDeviceCmb.add(assignDevice.getName(10));
                this.assignDeviceCmb.add(assignDevice.getName(11));
                this.assignDeviceCmb.add(assignDevice.getName(12));
                this.assignDeviceCmb.add(assignDevice.getName(13));
                this.assignDeviceCmb.add(assignDevice.getName(14));
                this.assignDeviceCmb.add(assignDevice.getName(17));
                break;
            }
            case 3: 
            case 4: {
                this.assignDeviceCmb.add(assignDevice.getName(0));
                this.assignDeviceCmb.add(assignDevice.getName(1));
                this.assignDeviceCmb.add(assignDevice.getName(2));
                this.assignDeviceCmb.add(assignDevice.getName(3));
                this.assignDeviceCmb.add(assignDevice.getName(4));
                this.assignDeviceCmb.add(assignDevice.getName(6));
                this.assignDeviceCmb.add(assignDevice.getName(5));
                this.assignDeviceCmb.add(assignDevice.getName(10));
                this.assignDeviceCmb.add(assignDevice.getName(11));
                this.assignDeviceCmb.add(assignDevice.getName(12));
                this.assignDeviceCmb.add(assignDevice.getName(13));
                this.assignDeviceCmb.add(assignDevice.getName(14));
                this.assignDeviceCmb.add(assignDevice.getName(17));
                break;
            }
            case 5: {
                this.assignDeviceCmb.add(assignDevice.getName(0));
                this.assignDeviceCmb.add(assignDevice.getName(18));
                this.assignDeviceCmb.add(assignDevice.getName(19));
                this.assignDeviceCmb.add(assignDevice.getName(20));
                this.assignDeviceCmb.add(assignDevice.getName(21));
            }
        }
        int n = this.assignDeviceCmb.indexOf(assignDevice.getName());
        if (n < 0) {
            n = 0;
        }
        this.assignDeviceCmb.select(n);
    }

    private void fillAccessModeCmb(FileDescriptor fileDescriptor) {
        this.accessModeCmb.removeAll();
        FileFormat fileFormat = fileDescriptor.getFileFormat();
        AccessMode accessMode = fileDescriptor.getAccessMode();
        switch (fileFormat.getValue()) {
            case 0: 
            case 1: 
            case 2: {
                this.accessModeCmb.add(accessMode.getName(0));
                this.accessModeCmb.add(accessMode.getName(1));
                break;
            }
            case 3: 
            case 4: {
                this.accessModeCmb.add(accessMode.getName(0));
                this.accessModeCmb.add(accessMode.getName(1));
                this.accessModeCmb.add(accessMode.getName(2));
                this.accessModeCmb.add(accessMode.getName(3));
                break;
            }
            case 5: {
                this.accessModeCmb.add(accessMode.getName(0));
            }
        }
        int n = this.accessModeCmb.indexOf(accessMode.getName());
        if (n < 0) {
            n = 0;
        }
        this.accessModeCmb.select(n);
    }

    private void setKeyNameTxtEnabledState(FileDescriptor fileDescriptor) {
        boolean bl = fileDescriptor.getFileFormat().getValue() == 3 && fileDescriptor.getAccessMode().getValue() != 0;
        this.keyNameLbl.setEnabled(bl);
        this.keyNameTxt.setEnabled(bl);
    }

    private void setReserveSecEnabledState(FileDescriptor fileDescriptor) {
        boolean bl = fileDescriptor.getFileFormat().getValue() != 5;
        this.reserveBtn.setEnabled(bl);
        this.setReserveSecEnabledState0(fileDescriptor, bl && fileDescriptor.isReserve());
    }

    private void setReserveSecEnabledState0(FileDescriptor fileDescriptor, boolean bl) {
        this.areaNumberBtn.setEnabled(bl);
        this.noAreaBtn.setEnabled(bl);
        this.alternateBtn.setEnabled(bl);
        this.setAreaNumberTxtEnabledState(!fileDescriptor.isReserveNoArea() && bl);
    }

    private void setAreaNumberTxtEnabledState(boolean bl) {
        this.areaNumberTxt.setEnabled(bl);
    }

    private void setCollatingSecEnabledState(FileDescriptor fileDescriptor) {
        boolean bl = fileDescriptor.getFileFormat().getValue() == 4;
        this.collatingBtn.setEnabled(bl);
        this.setCollatingSecEnabledState0(bl && fileDescriptor.isCollating());
    }

    private void setCollatingSecEnabledState0(boolean bl) {
        this.alphabetLbl.setEnabled(bl);
        this.alphabetTxt.setEnabled(bl);
    }

    private void setPaddingSecEnabledState(FileDescriptor fileDescriptor) {
        FileFormat fileFormat = fileDescriptor.getFileFormat();
        boolean bl = fileFormat.getValue() == 0 || fileFormat.getValue() == 1 || fileFormat.getValue() == 2;
        this.paddingBtn.setEnabled(bl);
        this.setPaddingSecEnabledState0(bl && fileDescriptor.isPadding());
    }

    private void setPaddingSecEnabledState0(boolean bl) {
        this.paddingCharLbl.setEnabled(bl);
        this.paddingCharTxt.setEnabled(bl);
    }

    private void setRecDelimSecEnabledState(FileDescriptor fileDescriptor) {
        FileFormat fileFormat = fileDescriptor.getFileFormat();
        boolean bl = fileFormat.getValue() == 0 || fileFormat.getValue() == 1 || fileFormat.getValue() == 2;
        this.recDelimBtn.setEnabled(bl);
    }

    private void setComprEncSecEnabledState(FileDescriptor fileDescriptor) {
        boolean bl = fileDescriptor.getFileFormat().getValue() == 4;
        this.comprEncBtn.setEnabled(bl);
        this.setComprEncSecEnabledState0(fileDescriptor, bl && (fileDescriptor.isWithCompression() || fileDescriptor.isWithEncryption()));
    }

    private void setComprEncSecEnabledState0(FileDescriptor fileDescriptor, boolean bl) {
        this.encBtn.setEnabled(bl);
        this.comprBtn.setEnabled(bl);
        this.setComprFactorCmbEnabledState(bl && fileDescriptor.isWithCompression());
    }

    private void setComprFactorCmbEnabledState(boolean bl) {
        this.comprFactorLbl.setEnabled(bl);
        this.comprFactorCmb.setEnabled(bl);
    }

    private void fileFormatCmbSelchange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        int n = this.fileFormatCmb.getSelectionIndex();
        FileFormat fileFormat = fileDescriptor.getFileFormat();
        FileFormat fileFormat2 = new FileFormat(n);
        fileDescriptor.setFileFormat(fileFormat2);
        this.fillAccessModeCmb(fileDescriptor);
        this.fillAssignDeviceCmb(fileDescriptor);
        this.fillLockModeCmb(fileDescriptor);
        this.setSectionEnabledStates(fileDescriptor);
        this.makeDirty();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this.getDataLayout(), "iscobol.fd.file.format", (Object)fileFormat, (Object)fileFormat2);
        IscobolScreenPainterPlugin.getDefault().firePropertyChangeEvent(propertyChangeEvent);
    }

    private void assignDeviceCmbSelchange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        int n = this.assignDeviceCmb.getSelectionIndex();
        String string = this.assignDeviceCmb.getItem(n);
        fileDescriptor.setAssignDevice(new AssignDevice(((Integer)this.assignDeviceCmb.getData(string)).intValue()));
        this.fillLockModeCmb(fileDescriptor);
        this.makeDirty();
    }

    private void accessModeCmbSelchange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        int n = this.accessModeCmb.getSelectionIndex();
        String string = this.accessModeCmb.getItem(n);
        fileDescriptor.setAccessMode(new AccessMode(((Integer)this.accessModeCmb.getData(string)).intValue()));
        this.setKeyNameTxtEnabledState(fileDescriptor);
        this.makeDirty();
    }

    private void lockModeCmbSelchange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        int n = this.lockModeCmb.getSelectionIndex();
        String string = this.lockModeCmb.getItem(n);
        fileDescriptor.setLockMode(new LockMode(((Integer)this.lockModeCmb.getData(string)).intValue()));
        this.makeDirty();
    }

    private void comprFactorCmbSelchange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        int n = this.comprFactorCmb.getSelectionIndex();
        fileDescriptor.setCompressionFactor(new Percentage(n));
        this.makeDirty();
    }

    private void assignAssignNameTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setAssignName(this.assignNameTxt.getText());
        this.makeDirty();
    }

    private void keyNameTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setKeyName(this.keyNameTxt.getText());
        this.makeDirty();
    }

    private void fileStatusTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setFileStatusName(this.fileStatusTxt.getText());
        this.makeDirty();
    }

    private void classNameTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setClassName(this.classNameTxt.getText());
        this.makeDirty();
    }

    private void classVarTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setClassVariable(this.classVarTxt.getText());
        this.makeDirty();
    }

    private void areaNumberTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        if (this.areaNumberTxt.getText().length() == 0) {
            fileDescriptor.setReserveNumber(0);
        } else {
            fileDescriptor.setReserveNumber(Integer.parseInt(this.areaNumberTxt.getText()));
        }
        this.makeDirty();
    }

    private void paddingCharTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setPaddingCharacter(this.paddingCharTxt.getText());
        this.makeDirty();
    }

    private void alphabetTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setAlphabetName(this.alphabetTxt.getText());
        this.makeDirty();
    }

    private void commentTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setComment(this.commentTxt.getText());
        this.makeDirty();
    }

    private void commentSelTxtModify() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setCommentSel(this.commentSelTxt.getText());
        this.makeDirty();
    }

    private void optionalBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setOptional(this.optionalBtn.getSelection());
        this.makeDirty();
    }

    private void reserveBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setReserve(this.reserveBtn.getSelection());
        this.setReserveSecEnabledState0(fileDescriptor, this.reserveBtn.getSelection());
        this.makeDirty();
    }

    private void areaNumberBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setReserveNoArea(!this.areaNumberBtn.getSelection());
        this.setAreaNumberTxtEnabledState(this.areaNumberBtn.getSelection());
        this.makeDirty();
    }

    private void noAreaBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setReserveNoArea(this.noAreaBtn.getSelection());
        this.setAreaNumberTxtEnabledState(!this.noAreaBtn.getSelection());
        this.makeDirty();
    }

    private void alternateBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setReserveAlternate(this.alternateBtn.getSelection());
        this.makeDirty();
    }

    private void paddingBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setPadding(this.paddingBtn.getSelection());
        this.setPaddingSecEnabledState0(this.paddingBtn.getSelection());
        this.makeDirty();
    }

    private void collatingBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setCollating(this.collatingBtn.getSelection());
        this.setCollatingSecEnabledState0(this.collatingBtn.getSelection());
        this.makeDirty();
    }

    private void recDelimBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setRecordDelimiterStd1(this.recDelimBtn.getSelection());
        this.makeDirty();
    }

    private void comprEncBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setComprEncSecEnabledState0(fileDescriptor, this.comprEncBtn.getSelection());
        this.makeDirty();
    }

    private void encBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setWithEncryption(this.encBtn.getSelection());
        this.makeDirty();
    }

    private void comprBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setWithCompression(this.comprBtn.getSelection());
        this.setComprFactorCmbEnabledState(this.comprBtn.getSelection());
        this.makeDirty();
    }

    void addListeners(ScrolledForm scrolledForm) {
        5 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        this.fdAdvSec.addExpansionListener((IExpansionListener)var2_2);
        this.assignDeviceCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.assignNameTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileFormatCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keyNameTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.accessModeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileStatusTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.lockModeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.classNameTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.classVarTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.optionalBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.reserveBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.areaNumberBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.noAreaBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.areaNumberTxt.addVerifyListener((VerifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.areaNumberTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alternateBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.paddingBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.paddingCharTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recDelimBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.comprEncBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.encBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.comprBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.comprFactorCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.collatingBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alphabetTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.commentTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.commentSelTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recDefAdvSec.addExpansionListener((IExpansionListener)var2_2);
        this.externalBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.globalBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.blockBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.blockMinSizeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.blockMinSizeTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        38 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        this.blockMinSizeTxt.addVerifyListener((VerifyListener)var3_3);
        this.blockMaxSizeTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.blockMaxSizeTxt.addVerifyListener((VerifyListener)var3_3);
        this.blockRecordsBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.blockCharactersBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.codeSetBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.codeSetNameTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.labelBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordStdBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordOmBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linageBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linLinesTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linFootingBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linTopBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linBottomBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.containBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordMinBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordMinTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordMinTxt.addVerifyListener((VerifyListener)var3_3);
        this.recordMaxTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordMaxTxt.addVerifyListener((VerifyListener)var3_3);
        this.varyingBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordFromBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordFromTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordFromTxt.addVerifyListener((VerifyListener)var3_3);
        this.recordToBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordToTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordToTxt.addVerifyListener((VerifyListener)var3_3);
        this.recordDependBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.recordDependTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.valueFileIdBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.valueFileIdTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.valueLabelBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.valueLabelTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keyTableBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keyTableTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.varContentPane.addDirtyStateChangeListener((DirtyStateChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setValueFileIdEnabledState(boolean bl) {
        this.valueFileIdLbl.setEnabled(bl);
        this.valueFileIdTxt.setEnabled(bl);
    }

    private void setKeyTableEnabledState(boolean bl) {
        this.keyTableLbl.setEnabled(bl);
        this.keyTableTxt.setEnabled(bl);
    }

    private void setValueLabelEnabledState(boolean bl) {
        this.valueLabelLbl.setEnabled(bl);
        this.valueLabelTxt.setEnabled(bl);
    }

    private void setVaryingSizeSecEnabledState(boolean bl) {
        this.recordFromBtn.setEnabled(bl);
        this.recordToBtn.setEnabled(bl);
        this.recordDependBtn.setEnabled(bl);
        this.setRecordFromEnabledState(bl && this.recordFromBtn.getSelection());
        this.setRecordToEnabledState(bl && this.recordToBtn.getSelection());
        this.setRecordDependEnabledState(bl && this.recordDependBtn.getSelection());
    }

    private void setRecordSecEnabledState(boolean bl) {
        this.containBtn.setEnabled(bl);
        this.setContainSecEnabledState(bl && this.containBtn.getSelection());
        this.varyingBtn.setEnabled(bl);
        this.setVaryingSizeSecEnabledState(bl && this.varyingBtn.getSelection());
    }

    private void setContainSecEnabledState(boolean bl) {
        this.recordMinBtn.setEnabled(bl);
        this.setRecordMinEnabledState(bl && this.recordMinBtn.getSelection());
        this.setRecordMaxEnabledState(bl);
    }

    private void setRecordMinEnabledState(boolean bl) {
        this.recordMinLbl.setEnabled(bl);
        this.recordMinTxt.setEnabled(bl);
    }

    private void setRecordFromEnabledState(boolean bl) {
        this.recordFromLbl.setEnabled(bl);
        this.recordFromTxt.setEnabled(bl);
    }

    private void setRecordToEnabledState(boolean bl) {
        this.recordToLbl.setEnabled(bl);
        this.recordToTxt.setEnabled(bl);
    }

    private void setRecordDependEnabledState(boolean bl) {
        this.recordDependLbl.setEnabled(bl);
        this.recordDependTxt.setEnabled(bl);
    }

    private void setRecordMaxEnabledState(boolean bl) {
        this.recordMaxLbl.setEnabled(bl);
        this.recordMaxTxt.setEnabled(bl);
    }

    private void setLinageSecEnabledState(boolean bl) {
        this.linLinesLbl.setEnabled(bl);
        this.linLinesTxt.setEnabled(bl);
        this.linFootingBtn.setEnabled(bl);
        this.setLinageFootingEnabledState(bl && this.linFootingBtn.getSelection());
        this.linTopBtn.setEnabled(bl);
        this.setLinageTopEnabledState(bl && this.linTopBtn.getSelection());
        this.linBottomBtn.setEnabled(bl);
        this.setLinageBottomEnabledState(bl && this.linBottomBtn.getSelection());
    }

    private void setLabelSecEnabledState(boolean bl) {
        this.recordStdBtn.setEnabled(bl);
        this.recordOmBtn.setEnabled(bl);
    }

    private void setCodeSetSecEnabledState(boolean bl) {
        this.codeSetNameLbl.setEnabled(bl);
        this.codeSetNameTxt.setEnabled(bl);
    }

    private void setBlockSecEnabledState(boolean bl) {
        this.blockMinSizeBtn.setEnabled(bl);
        this.setBlockMinSizeEnabledState(bl && this.blockMinSizeBtn.getSelection());
        this.blockMaxSizeLbl.setEnabled(bl);
        this.blockMaxSizeTxt.setEnabled(bl);
        this.blockRecordsBtn.setEnabled(bl);
        this.blockCharactersBtn.setEnabled(bl);
    }

    private void setBlockMinSizeEnabledState(boolean bl) {
        this.blockMinSizeLbl.setEnabled(bl);
        this.blockMinSizeTxt.setEnabled(bl);
    }

    private void externalBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setExternal(this.externalBtn.getSelection());
        this.makeDirty();
    }

    private void globalBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setGlobal(this.globalBtn.getSelection());
        this.makeDirty();
    }

    private void blockRecordsBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setBlockRecords(this.blockRecordsBtn.getSelection());
        this.makeDirty();
    }

    private void blockCharactersBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setBlockRecords(!this.blockCharactersBtn.getSelection());
        this.makeDirty();
    }

    private void blockBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setUseBlockAttributes(this.blockBtn.getSelection());
        this.setBlockSecEnabledState(this.blockBtn.getSelection());
        this.makeDirty();
    }

    private void blockMinSizeBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setBlockMinSizeEnabledState(this.blockMinSizeBtn.getSelection());
        if (!this.blockMinSizeBtn.getSelection()) {
            fileDescriptor.setBlockMinSize(1);
        }
        this.makeDirty();
    }

    private void codeSetBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setCodeSetSecEnabledState(this.codeSetBtn.getSelection());
        if (!this.codeSetBtn.getSelection()) {
            fileDescriptor.setCodeSetName(null);
        }
        this.makeDirty();
    }

    private void valueFileIdBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setValueFileIdEnabledState(this.valueFileIdBtn.getSelection());
        if (!this.valueFileIdBtn.getSelection()) {
            fileDescriptor.setValueFileId(null);
        }
        this.makeDirty();
    }

    private void valueLabelBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setValueLabelEnabledState(this.valueLabelBtn.getSelection());
        if (!this.valueLabelBtn.getSelection()) {
            fileDescriptor.setValueLabel(null);
        }
        this.makeDirty();
    }

    private void keyTableBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setKeyTableEnabledState(this.keyTableBtn.getSelection());
        if (!this.keyTableBtn.getSelection()) {
            fileDescriptor.setKeyTableDataName(null);
        }
        this.makeDirty();
    }

    private void labelBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setLabelSecEnabledState(this.labelBtn.getSelection());
        fileDescriptor.setUseLabelAttributes(this.labelBtn.getSelection());
        this.makeDirty();
    }

    private void linFootingBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setLinageFootingEnabledState(this.linFootingBtn.getSelection());
        if (!this.linFootingBtn.getSelection()) {
            fileDescriptor.setLinageFooting(null);
        }
        this.makeDirty();
    }

    private void setLinageFootingEnabledState(boolean bl) {
        this.linFootingLbl.setEnabled(bl);
        this.linFootingTxt.setEnabled(bl);
    }

    private void setLinageTopEnabledState(boolean bl) {
        this.linTopLbl.setEnabled(bl);
        this.linTopTxt.setEnabled(bl);
    }

    private void setLinageBottomEnabledState(boolean bl) {
        this.linBottomLbl.setEnabled(bl);
        this.linBottomTxt.setEnabled(bl);
    }

    private void linTopBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setLinageTopEnabledState(this.linTopBtn.getSelection());
        if (!this.linTopBtn.getSelection()) {
            fileDescriptor.setLinageTop(null);
        }
        this.makeDirty();
    }

    private void linBottomBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setLinageBottomEnabledState(this.linBottomBtn.getSelection());
        if (!this.linBottomBtn.getSelection()) {
            fileDescriptor.setLinageBottom(null);
        }
        this.makeDirty();
    }

    private void linageBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setLinageSecEnabledState(this.linageBtn.getSelection());
        if (!this.linageBtn.getSelection()) {
            fileDescriptor.setLinageLines(null);
            fileDescriptor.setLinageBottom(null);
            fileDescriptor.setLinageFooting(null);
            fileDescriptor.setLinageTop(null);
        }
        this.makeDirty();
    }

    private void recordBtnStatechange() {
        this.setRecordSecEnabledState(this.recordBtn.getSelection());
        this.makeDirty();
    }

    private void recordMinBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setRecordMinEnabledState(this.recordMinBtn.getSelection());
        if (!this.recordMinBtn.getSelection()) {
            fileDescriptor.setRecordMinSize(1);
        }
        this.makeDirty();
    }

    private void recordFromBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setRecordFromEnabledState(this.recordFromBtn.getSelection());
        if (!this.recordFromBtn.getSelection()) {
            fileDescriptor.setRecordFrom(1);
        }
        this.makeDirty();
    }

    private void recordToBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setRecordToEnabledState(this.recordToBtn.getSelection());
        if (!this.recordToBtn.getSelection()) {
            fileDescriptor.setRecordTo(1);
        }
        this.makeDirty();
    }

    private void recordDependBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        this.setRecordDependEnabledState(this.recordDependBtn.getSelection());
        if (!this.recordDependBtn.getSelection()) {
            fileDescriptor.setRecordDepend(null);
        }
        this.makeDirty();
    }

    private void containBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setRecordVarying(!this.containBtn.getSelection());
        this.setContainSecEnabledState(this.containBtn.getSelection());
        if (!this.containBtn.getSelection()) {
            fileDescriptor.setRecordMinSize(1);
            fileDescriptor.setRecordMaxSize(1);
        }
        this.makeDirty();
    }

    private void varyingBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setRecordVarying(this.varyingBtn.getSelection());
        this.setVaryingSizeSecEnabledState(this.varyingBtn.getSelection());
        if (!this.varyingBtn.getSelection()) {
            fileDescriptor.setRecordFrom(1);
            fileDescriptor.setRecordTo(1);
            fileDescriptor.setRecordDepend(null);
        }
        this.makeDirty();
    }

    private void recordStdBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setLabelRecordStd(this.recordStdBtn.getSelection());
        this.makeDirty();
    }

    private void recordOmBtnStatechange() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setLabelRecordStd(!this.recordOmBtn.getSelection());
        this.makeDirty();
    }

    private void blockMinSizeTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        try {
            fileDescriptor.setBlockMinSize(Integer.parseInt(this.blockMinSizeTxt.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.makeDirty();
    }

    private void blockMaxSizeTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        try {
            fileDescriptor.setBlockMaxSize(Integer.parseInt(this.blockMaxSizeTxt.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.makeDirty();
    }

    private void codeSetNameTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setCodeSetName(this.codeSetNameTxt.getText());
        this.makeDirty();
    }

    private void valueFileIdTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setValueFileId(this.valueFileIdTxt.getText());
        this.makeDirty();
    }

    private void valueLabelTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setValueLabel(this.valueLabelTxt.getText());
        this.makeDirty();
    }

    private void keyTableTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setKeyTableDataName(this.keyTableTxt.getText());
        this.makeDirty();
    }

    private void linLinesTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setLinageLines(this.linLinesTxt.getText());
        this.makeDirty();
    }

    private void recordMinTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        try {
            fileDescriptor.setRecordMinSize(Integer.parseInt(this.recordMinTxt.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.makeDirty();
    }

    private void recordFromTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        try {
            fileDescriptor.setRecordFrom(Integer.parseInt(this.recordFromTxt.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.makeDirty();
    }

    private void recordToTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        try {
            fileDescriptor.setRecordTo(Integer.parseInt(this.recordToTxt.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.makeDirty();
    }

    private void recordDependTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        fileDescriptor.setRecordDepend(this.recordDependTxt.getText());
        this.makeDirty();
    }

    private void recordMaxTxtModifyText() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        try {
            fileDescriptor.setRecordMaxSize(Integer.parseInt(this.recordMaxTxt.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.makeDirty();
    }

    void cleanDirtyState() {
        this.varContentPane.setDirty(false);
    }

    public VariableSettingsContentPane getVarContentPane() {
        return this.varContentPane;
    }

    public boolean selectProperty(FindInObjectMatchReference[] findInObjectMatchReferenceArray) {
        boolean bl = true;
        if (findInObjectMatchReferenceArray.length == 0) {
            return false;
        }
        String string = findInObjectMatchReferenceArray[0].getName();
        if (string.equals("Access Mode")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            this.accessModeCmb.setFocus();
        } else if (string.equals("Assign Device")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            this.assignDeviceCmb.setFocus();
        } else if (string.equals("Assign Name")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            this.assignNameTxt.setFocus();
        } else if (string.equals("Block Max Size")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.blockMaxSizeTxt.isEnabled()) {
                this.blockMaxSizeTxt.setFocus();
            }
        } else if (string.equals("Block Min Size")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.blockMinSizeTxt.isEnabled()) {
                this.blockMinSizeTxt.setFocus();
            }
        } else if (string.equals("Block Records")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.blockRecordsBtn.isEnabled()) {
                this.blockRecordsBtn.setFocus();
            }
        } else if (string.equals("Code Set Name")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.codeSetNameTxt.isEnabled()) {
                this.codeSetNameTxt.setFocus();
            }
        } else if (string.equals("Collating")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.collatingBtn.isEnabled()) {
                this.collatingBtn.setFocus();
            }
        } else if (string.equals("Compression Factor")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.comprFactorCmb.isEnabled()) {
                this.comprFactorCmb.setFocus();
            }
        } else if (string.equals("External")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.externalBtn.isEnabled()) {
                this.externalBtn.setFocus();
            }
        } else if (string.equals("File Comment")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.commentTxt.isEnabled()) {
                this.commentTxt.setFocus();
            }
        } else if (string.equals("File Comment Select")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.commentSelTxt.isEnabled()) {
                this.commentSelTxt.setFocus();
            }
        } else if (string.equals("File Format")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.fileFormatCmb.isEnabled()) {
                this.fileFormatCmb.setFocus();
            }
        } else if (string.equals("File Status Name")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.fileStatusTxt.isEnabled()) {
                this.fileStatusTxt.setFocus();
            }
        } else if (string.equals("Global")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.globalBtn.isEnabled()) {
                this.globalBtn.setFocus();
            }
        } else if (string.equals("Key Name")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.keyNameTxt.isEnabled()) {
                this.keyNameTxt.setFocus();
            }
        } else if (string.equals("Key Table Data Name")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.keyTableTxt.isEnabled()) {
                this.keyTableTxt.setFocus();
            }
        } else if (string.equals("Label Record Std")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordStdBtn.isEnabled()) {
                this.recordStdBtn.setFocus();
            }
        } else if (string.equals("Linage Bottom")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.linBottomTxt.isEnabled()) {
                this.linBottomTxt.setFocus();
            }
        } else if (string.equals("Linage Footing")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.linFootingTxt.isEnabled()) {
                this.linFootingTxt.setFocus();
            }
        } else if (string.equals("Linage Lines")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.linLinesTxt.isEnabled()) {
                this.linLinesTxt.setFocus();
            }
        } else if (string.equals("Linage Top")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.linTopBtn.isEnabled()) {
                this.linTopBtn.setFocus();
            }
        } else if (string.equals("Lock Mode")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.lockModeCmb.isEnabled()) {
                this.lockModeCmb.setFocus();
            }
        } else if (string.equals("Optional")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.optionalBtn.isEnabled()) {
                this.optionalBtn.setFocus();
            }
        } else if (string.equals("Padding Character")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.paddingCharTxt.isEnabled()) {
                this.paddingCharTxt.setFocus();
            }
        } else if (string.equals("Padding")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.paddingBtn.isEnabled()) {
                this.paddingBtn.setFocus();
            }
        } else if (string.equals("Record delimiter std-1")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.recDelimBtn.isEnabled()) {
                this.recDelimBtn.setFocus();
            }
        } else if (string.equals("Record Depend")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordDependTxt.isEnabled()) {
                this.recordDependTxt.setFocus();
            }
        } else if (string.equals("Record From")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordFromTxt.isEnabled()) {
                this.recordFromTxt.setFocus();
            }
        } else if (string.equals("Record Max Size")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordMaxTxt.isEnabled()) {
                this.recordMaxTxt.setFocus();
            }
        } else if (string.equals("Record Min Size")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordMinTxt.isEnabled()) {
                this.recordMinTxt.setFocus();
            }
        } else if (string.equals("Record To")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordToTxt.isEnabled()) {
                this.recordToTxt.setFocus();
            }
        } else if (string.equals("Reserve Alternate")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.alternateBtn.isEnabled()) {
                this.alternateBtn.setFocus();
            }
        } else if (string.equals("Reserve No Area")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.noAreaBtn.isEnabled()) {
                this.noAreaBtn.setFocus();
            }
        } else if (string.equals("Reserve Number")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.areaNumberTxt.isEnabled()) {
                this.areaNumberTxt.setFocus();
            }
        } else if (string.equals("Reserve")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.reserveBtn.isEnabled()) {
                this.reserveBtn.setFocus();
            }
        } else if (string.equals("Use Block Attrs")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.blockBtn.isEnabled()) {
                this.blockBtn.setFocus();
            }
        } else if (string.equals("Use Label Attrs")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.labelBtn.isEnabled()) {
                this.labelBtn.setFocus();
            }
        } else if (string.equals("Use Record Attrs")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.recordBtn.isEnabled()) {
                this.recordBtn.setFocus();
            }
        } else if (string.equals("Value File ID")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.valueFileIdTxt.isEnabled()) {
                this.valueFileIdTxt.setFocus();
            }
        } else if (string.equals("Value Label")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(1);
            if (this.valueLabelTxt.isEnabled()) {
                this.valueLabelTxt.setFocus();
            }
        } else if (string.equals("With Compression")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.comprBtn.isEnabled()) {
                this.comprBtn.setFocus();
            }
        } else if (string.equals("With Encryption")) {
            this.getDLEditor().activateFileControlPage();
            this.fdTabFolder.setSelection(0);
            if (this.encBtn.isEnabled()) {
                this.encBtn.setFocus();
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void activateRecordDefinitionSection() {
        this.fdTabFolder.setSelection(1);
        this.varContentPane.setFocus();
    }

    public SettingsContentPane getSettingsContentPane() {
        return this.getVarContentPane();
    }

    static /* synthetic */ CommandStack access$000(FileControlPage fileControlPage) {
        return fileControlPage.myGetCommandStack();
    }

    static /* synthetic */ void access$100(FileControlPage fileControlPage) {
        fileControlPage.assignDeviceCmbSelchange();
    }

    static /* synthetic */ void access$200(FileControlPage fileControlPage) {
        fileControlPage.assignAssignNameTxtModify();
    }

    static /* synthetic */ void access$300(FileControlPage fileControlPage) {
        fileControlPage.fileFormatCmbSelchange();
    }

    static /* synthetic */ void access$400(FileControlPage fileControlPage) {
        fileControlPage.keyNameTxtModify();
    }

    static /* synthetic */ void access$500(FileControlPage fileControlPage) {
        fileControlPage.accessModeCmbSelchange();
    }

    static /* synthetic */ void access$600(FileControlPage fileControlPage) {
        fileControlPage.fileStatusTxtModify();
    }

    static /* synthetic */ void access$700(FileControlPage fileControlPage) {
        fileControlPage.lockModeCmbSelchange();
    }

    static /* synthetic */ void access$800(FileControlPage fileControlPage) {
        fileControlPage.classNameTxtModify();
    }

    static /* synthetic */ void access$900(FileControlPage fileControlPage) {
        fileControlPage.classVarTxtModify();
    }

    static /* synthetic */ void access$1000(FileControlPage fileControlPage) {
        fileControlPage.optionalBtnStatechange();
    }

    static /* synthetic */ void access$1100(FileControlPage fileControlPage) {
        fileControlPage.reserveBtnStatechange();
    }

    static /* synthetic */ void access$1200(FileControlPage fileControlPage) {
        fileControlPage.areaNumberBtnStatechange();
    }

    static /* synthetic */ void access$1300(FileControlPage fileControlPage) {
        fileControlPage.noAreaBtnStatechange();
    }

    static /* synthetic */ void access$1400(FileControlPage fileControlPage) {
        fileControlPage.areaNumberTxtModify();
    }

    static /* synthetic */ void access$1500(FileControlPage fileControlPage) {
        fileControlPage.alternateBtnStatechange();
    }

    static /* synthetic */ void access$1600(FileControlPage fileControlPage) {
        fileControlPage.paddingBtnStatechange();
    }

    static /* synthetic */ void access$1700(FileControlPage fileControlPage) {
        fileControlPage.paddingCharTxtModify();
    }

    static /* synthetic */ void access$1800(FileControlPage fileControlPage) {
        fileControlPage.recDelimBtnStatechange();
    }

    static /* synthetic */ void access$1900(FileControlPage fileControlPage) {
        fileControlPage.comprEncBtnStatechange();
    }

    static /* synthetic */ void access$2000(FileControlPage fileControlPage) {
        fileControlPage.encBtnStatechange();
    }

    static /* synthetic */ void access$2100(FileControlPage fileControlPage) {
        fileControlPage.comprBtnStatechange();
    }

    static /* synthetic */ void access$2200(FileControlPage fileControlPage) {
        fileControlPage.comprFactorCmbSelchange();
    }

    static /* synthetic */ void access$2300(FileControlPage fileControlPage) {
        fileControlPage.collatingBtnStatechange();
    }

    static /* synthetic */ void access$2400(FileControlPage fileControlPage) {
        fileControlPage.alphabetTxtModify();
    }

    static /* synthetic */ void access$2500(FileControlPage fileControlPage) {
        fileControlPage.commentTxtModify();
    }

    static /* synthetic */ void access$2600(FileControlPage fileControlPage) {
        fileControlPage.commentSelTxtModify();
    }

    static /* synthetic */ void access$2700(FileControlPage fileControlPage) {
        fileControlPage.externalBtnStatechange();
    }

    static /* synthetic */ void access$2800(FileControlPage fileControlPage) {
        fileControlPage.globalBtnStatechange();
    }

    static /* synthetic */ void access$2900(FileControlPage fileControlPage) {
        fileControlPage.blockBtnStatechange();
    }

    static /* synthetic */ void access$3000(FileControlPage fileControlPage) {
        fileControlPage.blockMinSizeBtnStatechange();
    }

    static /* synthetic */ void access$3100(FileControlPage fileControlPage) {
        fileControlPage.blockMinSizeTxtModifyText();
    }

    static /* synthetic */ void access$3200(FileControlPage fileControlPage) {
        fileControlPage.blockMaxSizeTxtModifyText();
    }

    static /* synthetic */ void access$3300(FileControlPage fileControlPage) {
        fileControlPage.blockRecordsBtnStatechange();
    }

    static /* synthetic */ void access$3400(FileControlPage fileControlPage) {
        fileControlPage.blockCharactersBtnStatechange();
    }

    static /* synthetic */ void access$3500(FileControlPage fileControlPage) {
        fileControlPage.codeSetBtnStatechange();
    }

    static /* synthetic */ void access$3600(FileControlPage fileControlPage) {
        fileControlPage.codeSetNameTxtModifyText();
    }

    static /* synthetic */ void access$3700(FileControlPage fileControlPage) {
        fileControlPage.labelBtnStatechange();
    }

    static /* synthetic */ void access$3800(FileControlPage fileControlPage) {
        fileControlPage.recordStdBtnStatechange();
    }

    static /* synthetic */ void access$3900(FileControlPage fileControlPage) {
        fileControlPage.recordOmBtnStatechange();
    }

    static /* synthetic */ void access$4000(FileControlPage fileControlPage) {
        fileControlPage.linageBtnStatechange();
    }

    static /* synthetic */ void access$4100(FileControlPage fileControlPage) {
        fileControlPage.linLinesTxtModifyText();
    }

    static /* synthetic */ void access$4200(FileControlPage fileControlPage) {
        fileControlPage.linFootingBtnStatechange();
    }

    static /* synthetic */ void access$4300(FileControlPage fileControlPage) {
        fileControlPage.linTopBtnStatechange();
    }

    static /* synthetic */ void access$4400(FileControlPage fileControlPage) {
        fileControlPage.linBottomBtnStatechange();
    }

    static /* synthetic */ void access$4500(FileControlPage fileControlPage) {
        fileControlPage.recordBtnStatechange();
    }

    static /* synthetic */ void access$4600(FileControlPage fileControlPage) {
        fileControlPage.containBtnStatechange();
    }

    static /* synthetic */ void access$4700(FileControlPage fileControlPage) {
        fileControlPage.recordMinBtnStatechange();
    }

    static /* synthetic */ void access$4800(FileControlPage fileControlPage) {
        fileControlPage.recordMinTxtModifyText();
    }

    static /* synthetic */ void access$4900(FileControlPage fileControlPage) {
        fileControlPage.recordMaxTxtModifyText();
    }

    static /* synthetic */ void access$5000(FileControlPage fileControlPage) {
        fileControlPage.varyingBtnStatechange();
    }

    static /* synthetic */ void access$5100(FileControlPage fileControlPage) {
        fileControlPage.recordFromBtnStatechange();
    }

    static /* synthetic */ void access$5200(FileControlPage fileControlPage) {
        fileControlPage.recordFromTxtModifyText();
    }

    static /* synthetic */ void access$5300(FileControlPage fileControlPage) {
        fileControlPage.recordToBtnStatechange();
    }

    static /* synthetic */ void access$5400(FileControlPage fileControlPage) {
        fileControlPage.recordToTxtModifyText();
    }

    static /* synthetic */ void access$5500(FileControlPage fileControlPage) {
        fileControlPage.recordDependBtnStatechange();
    }

    static /* synthetic */ void access$5600(FileControlPage fileControlPage) {
        fileControlPage.recordDependTxtModifyText();
    }

    static /* synthetic */ void access$5700(FileControlPage fileControlPage) {
        fileControlPage.valueFileIdBtnStatechange();
    }

    static /* synthetic */ void access$5800(FileControlPage fileControlPage) {
        fileControlPage.valueFileIdTxtModifyText();
    }

    static /* synthetic */ void access$5900(FileControlPage fileControlPage) {
        fileControlPage.valueLabelBtnStatechange();
    }

    static /* synthetic */ void access$6000(FileControlPage fileControlPage) {
        fileControlPage.valueLabelTxtModifyText();
    }

    static /* synthetic */ void access$6100(FileControlPage fileControlPage) {
        fileControlPage.keyTableBtnStatechange();
    }

    static /* synthetic */ void access$6200(FileControlPage fileControlPage) {
        fileControlPage.keyTableTxtModifyText();
    }
}

