/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.DataLayoutEditor;
import com.iscobol.filedesigner.DataLayoutPage;
import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.filedesigner.IOHandlingPage;
import com.iscobol.filedesigner.propertysheet.IOParagraphEditor;
import com.iscobol.filedesigner.types.IOParagraph;
import com.iscobol.filedesigner.types.IOParagraphList;
import com.iscobol.filedesigner.types.IOParagraphsCodeGeneration;
import com.iscobol.plugins.editor.findinobject.FindInObjectMatchReference;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.propertysheet.TextEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class IOHandlingPage
extends DataLayoutPage {
    private Button useDfltBtn;
    private Button useUserGenBtn;
    private Button doNotGenBtn;
    private Button addBtn;
    private Button removeBtn;
    private Table ioParTable;
    private TableEditor ioParTableEditor;
    private Label errorLbl;
    private static final int FIXED_LINES = 12;

    IOHandlingPage(DataLayoutEditor dataLayoutEditor) {
        super(dataLayoutEditor, "iscobolscreenpainter.DataLayoutEditor.Page4", "IO Handling");
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText("IO Handling");
        scrolledForm.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/fdiohdlsec.png"));
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = scrolledForm.getBody();
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        Section section = formToolkit.createSection(composite, 256);
        section.setText("IO Paragraphs");
        GridData gridData = new GridData(768);
        section.setLayoutData((Object)gridData);
        Composite composite2 = formToolkit.createComposite((Composite)section);
        section.setClient((Control)composite2);
        gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.useDfltBtn = formToolkit.createButton(composite2, "Use Default Code Generation", 16);
        this.useUserGenBtn = formToolkit.createButton(composite2, "Use User-defined IO Paragraphs", 16);
        this.doNotGenBtn = formToolkit.createButton(composite2, "Do not generate any IO Paragraphs", 16);
        Section section2 = formToolkit.createSection(composite, 256);
        section2.setText("User Defined IO Paragraphs");
        gridData = new GridData(1808);
        section2.setLayoutData((Object)gridData);
        Composite composite3 = formToolkit.createComposite((Composite)section2);
        section2.setClient((Control)composite3);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        this.addBtn = formToolkit.createButton(composite3, "", 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        this.addBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/add_item.gif"));
        this.addBtn.setLayoutData((Object)gridData);
        this.removeBtn = formToolkit.createButton(composite3, "", 8);
        this.removeBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/remove_item.gif"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        this.removeBtn.setLayoutData((Object)gridData);
        this.errorLbl = formToolkit.createLabel(composite3, "", 131072);
        this.errorLbl.setForeground(ColorConstants.red);
        gridData = new GridData(768);
        this.errorLbl.setLayoutData((Object)gridData);
        this.ioParTable = formToolkit.createTable(composite3, 67586);
        this.ioParTable.setLinesVisible(true);
        this.ioParTable.setHeaderVisible(true);
        this.ioParTableEditor = new TableEditor(this.ioParTable);
        this.ioParTableEditor.grabHorizontal = true;
        TableColumn tableColumn = new TableColumn(this.ioParTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText("Item");
        tableColumn = new TableColumn(this.ioParTable, 0);
        tableColumn.setWidth(350);
        tableColumn.setText("Value");
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.ioParTable.setLayoutData((Object)gridData);
        this.initData();
        this.addListeners(scrolledForm);
        this.setContentPane(composite);
    }

    void addListeners(ScrolledForm scrolledForm) {
        1 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        this.useDfltBtn.addSelectionListener((SelectionListener)var2_2);
        this.useUserGenBtn.addSelectionListener((SelectionListener)var2_2);
        this.doNotGenBtn.addSelectionListener((SelectionListener)var2_2);
        this.ioParTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addIOPar() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        IOParagraphList iOParagraphList = fileDescriptor.getIOParagraphs();
        IOParagraph iOParagraph = (IOParagraph)iOParagraphList.createNew();
        TableItem tableItem = new TableItem(this.ioParTable, 0);
        String string = iOParagraphList.getNewName(this.getDataLayout().getFdName() + "-Start").replace(' ', '-');
        tableItem.setText(0, string);
        iOParagraph.setName(string);
        iOParagraphList.addSetting((SettingItem)iOParagraph);
        tableItem.setData((Object)iOParagraph);
        this.makeDirty();
    }

    private void removeIOPar() {
        TableItem[] tableItemArray = this.ioParTable.getSelection();
        IOParagraphList iOParagraphList = this.getFileDescriptor().getIOParagraphs();
        if (tableItemArray != null && tableItemArray.length > 0) {
            for (int i = 0; i < tableItemArray.length; ++i) {
                iOParagraphList.removeSetting((SettingItem)((IOParagraph)tableItemArray[i].getData()));
                tableItemArray[i].dispose();
            }
        }
        this.removeBtn.setEnabled(false);
        this.makeDirty();
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void handleIOParTableSelectionEvent(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.ioParTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        if (nArray[0] >= 12) {
            this.removeBtn.setEnabled(true);
        }
        TableItem tableItem = this.ioParTable.getItem(nArray[0]);
        IOParagraphList iOParagraphList = this.getFileDescriptor().getIOParagraphs();
        IOParagraph iOParagraph = (IOParagraph)iOParagraphList.getSettingAt(nArray[0]);
        String string = iOParagraph.getName();
        switch (nArray[1]) {
            case 0: {
                if (nArray[0] < 12) {
                    return;
                }
                TextEditor textEditor = new TextEditor();
                textEditor.setValidator((ICellEditorValidator)new /* Unavailable Anonymous Inner Class!! */);
                textEditor.createEditor((Composite)this.ioParTable);
                textEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
                this.ioParTableEditor.setEditor(textEditor.getEditor(), tableItem, 0);
                textEditor.setValue((Object)string);
                textEditor.selectAll();
                textEditor.setFocus();
                break;
            }
            case 1: {
                String string2 = this.getDataLayout().getFdName() + "-" + iOParagraph.getName().replace(' ', '-');
                IOParagraphEditor iOParagraphEditor = new IOParagraphEditor(iOParagraphList.getNewParName(string2), this.getFileDescriptor());
                iOParagraphEditor.createEditor((Composite)this.ioParTable);
                iOParagraphEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
                this.ioParTableEditor.setEditor(iOParagraphEditor.getEditor(), tableItem, 1);
                if (iOParagraph.getParagraphName() != null) {
                    iOParagraphEditor.setValue((Object)new ParagraphType(iOParagraph.getParagraphName()));
                }
                iOParagraphEditor.selectAll();
                iOParagraphEditor.setFocus();
            }
        }
    }

    private void ioParBtnStatechanged() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        int n = this.useDfltBtn.getSelection() ? 0 : (this.useUserGenBtn.getSelection() ? 1 : 2);
        fileDescriptor.setIOParagraphsCodeGen(new IOParagraphsCodeGeneration(n));
        this.makeDirty();
    }

    void initData() {
        FileDescriptor fileDescriptor = this.getFileDescriptor();
        IOParagraphsCodeGeneration iOParagraphsCodeGeneration = fileDescriptor.getIOParagraphsCodeGen();
        this.useDfltBtn.setSelection(iOParagraphsCodeGeneration.getValue() == 0);
        this.useUserGenBtn.setSelection(iOParagraphsCodeGeneration.getValue() == 1);
        this.doNotGenBtn.setSelection(iOParagraphsCodeGeneration.getValue() == 2);
        IOParagraphList iOParagraphList = fileDescriptor.getIOParagraphs();
        int n = iOParagraphList.getSettingCount();
        this.ioParTable.removeAll();
        for (int i = 0; i < n; ++i) {
            IOParagraph iOParagraph = (IOParagraph)iOParagraphList.getSettingAt(i);
            TableItem tableItem = new TableItem(this.ioParTable, 0);
            tableItem.setText(0, iOParagraph.getName());
            if (iOParagraph.getParagraphName() != null) {
                tableItem.setText(1, iOParagraph.getParagraphName());
            }
            tableItem.setData((Object)iOParagraph);
        }
        this.removeBtn.setEnabled(false);
    }

    public boolean selectProperty(FindInObjectMatchReference[] findInObjectMatchReferenceArray) {
        boolean bl = true;
        if (findInObjectMatchReferenceArray.length == 0) {
            return false;
        }
        String string = findInObjectMatchReferenceArray[0].getName();
        if (string.equals("IO Paragraph Code Gen.")) {
            this.getDLEditor().activateIOHandlingPage();
            this.useDfltBtn.setFocus();
        } else if (string.equals("IO Paragraphs")) {
            this.getDLEditor().activateIOHandlingPage();
            if (findInObjectMatchReferenceArray.length > 1 && this.ioParTable.getItemCount() > findInObjectMatchReferenceArray[1].getIndex()) {
                this.ioParTable.setFocus();
                this.ioParTable.select(findInObjectMatchReferenceArray[1].getIndex());
            }
        } else {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ void access$000(IOHandlingPage iOHandlingPage) {
        iOHandlingPage.ioParBtnStatechanged();
    }

    static /* synthetic */ void access$100(IOHandlingPage iOHandlingPage, MouseEvent mouseEvent) {
        iOHandlingPage.handleIOParTableSelectionEvent(mouseEvent);
    }

    static /* synthetic */ void access$200(IOHandlingPage iOHandlingPage) {
        iOHandlingPage.addIOPar();
    }

    static /* synthetic */ void access$300(IOHandlingPage iOHandlingPage) {
        iOHandlingPage.removeIOPar();
    }

    static /* synthetic */ Label access$400(IOHandlingPage iOHandlingPage) {
        return iOHandlingPage.errorLbl;
    }
}

