/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.DataLayoutEditor;
import com.iscobol.filedesigner.DataLayoutPage;
import com.iscobol.filedesigner.KeyDefinitionPage;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.types.Key;
import com.iscobol.filedesigner.types.KeyList;
import com.iscobol.filedesigner.types.KeyType;
import com.iscobol.plugins.editor.findinobject.FindInObjectMatchReference;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.propertysheet.ComboEditor;
import com.iscobol.screenpainter.propertysheet.TextEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * Exception performing whole class analysis ignored.
 */
public class KeyDefinitionPage
extends DataLayoutPage {
    private static final String SEGMENT_INDEX = "segmentIndex";
    private Button addBtn;
    private Button removeBtn;
    private Button modifyBtn;
    private Button upBtn;
    private Button downBtn;
    private Button selectAllBtn;
    private Button deselectAllBtn;
    private Table keyTable;
    private TableEditor keyTableEditor;
    private Tree fieldsTree;
    private TreeEditor fieldsTreeEditor;

    KeyDefinitionPage(DataLayoutEditor dataLayoutEditor) {
        super(dataLayoutEditor, "iscobolscreenpainter.DataLayoutEditor.Page3", "Key");
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText("Key");
        scrolledForm.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/fdkeysec.png"));
        FormToolkit formToolkit = iManagedForm.getToolkit();
        Composite composite = scrolledForm.getBody();
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        Section section = formToolkit.createSection(composite, 256);
        section.setText("Key List");
        GridData gridData = new GridData(1808);
        section.setLayoutData((Object)gridData);
        Composite composite2 = formToolkit.createComposite((Composite)section);
        section.setClient((Control)composite2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.keyTable = formToolkit.createTable(composite2, 67586);
        this.keyTable.setLinesVisible(true);
        this.keyTable.setHeaderVisible(true);
        this.keyTableEditor = new TableEditor(this.keyTable);
        this.keyTableEditor.grabHorizontal = true;
        TableColumn tableColumn = new TableColumn(this.keyTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText("Name");
        tableColumn = new TableColumn(this.keyTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText("Type");
        tableColumn = new TableColumn(this.keyTable, 0);
        tableColumn.setWidth(350);
        tableColumn.setText("Fields");
        gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.verticalSpan = 4;
        this.keyTable.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.verticalAlignment = 1;
        this.modifyBtn = formToolkit.createButton(composite2, "Modify Key", 8);
        this.modifyBtn.setLayoutData((Object)gridData);
        this.removeBtn = formToolkit.createButton(composite2, "Remove Key", 8);
        this.removeBtn.setLayoutData((Object)gridData);
        this.upBtn = formToolkit.createButton(composite2, "Up", 8);
        this.upBtn.setLayoutData((Object)gridData);
        this.downBtn = formToolkit.createButton(composite2, "Down", 8);
        this.downBtn.setLayoutData((Object)gridData);
        Section section2 = formToolkit.createSection(composite, 256);
        section2.setText("Fields Description");
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        section2.setLayoutData((Object)gridData);
        Composite composite3 = formToolkit.createComposite((Composite)section2);
        section2.setClient((Control)composite3);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fieldsTree = formToolkit.createTree(composite3, 2080);
        this.fieldsTree.setHeaderVisible(true);
        this.fieldsTree.setLinesVisible(true);
        this.fieldsTreeEditor = new TreeEditor(this.fieldsTree);
        this.fieldsTreeEditor.grabHorizontal = true;
        TreeColumn treeColumn = new TreeColumn(this.fieldsTree, 0);
        treeColumn.setWidth(250);
        treeColumn.setText("Field");
        treeColumn = new TreeColumn(this.fieldsTree, 0);
        treeColumn.setWidth(350);
        treeColumn.setText("Name");
        gridData = new GridData(1808);
        gridData.heightHint = 500;
        gridData.verticalSpan = 3;
        this.fieldsTree.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 120;
        gridData.verticalAlignment = 1;
        this.addBtn = formToolkit.createButton(composite3, "Add Key", 8);
        this.addBtn.setLayoutData((Object)gridData);
        this.selectAllBtn = new Button(composite3, 8);
        this.selectAllBtn.setText("Select all");
        this.selectAllBtn.setLayoutData((Object)gridData);
        this.deselectAllBtn = new Button(composite3, 8);
        this.deselectAllBtn.setText("Deselect all");
        this.deselectAllBtn.setLayoutData((Object)gridData);
        this.initData();
        this.addListeners(scrolledForm);
        this.setContentPane(composite);
    }

    void addListeners(ScrolledForm scrolledForm) {
        this.keyTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keyTable.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsTree.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.modifyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deselectAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleFieldsTreeSelectionEvent(MouseEvent mouseEvent) {
        int[] nArray = new int[1];
        TreeItem treeItem = this.getItemForLocation(this.fieldsTree, mouseEvent.x, mouseEvent.y, nArray);
        if (treeItem == null) {
            return;
        }
        if (nArray[0] == 1 && treeItem.getChecked()) {
            Object object;
            ComboEditor comboEditor = new ComboEditor(false);
            ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
            for (object = treeItem.getParentItem(); object != null; object = object.getParentItem()) {
                arrayList.add(0, (TreeItem)object);
            }
            object = treeItem.getText(1);
            Integer n = new Integer(0);
            String[] stringArray = new String[arrayList.size() + 1];
            stringArray[0] = "(none)";
            for (int i = 0; i < arrayList.size(); ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = i; j < arrayList.size(); ++j) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.insert(0, ' ');
                    }
                    stringBuilder.insert(0, "of " + ((TreeItem)arrayList.get(j)).getText(0).substring(3));
                }
                stringArray[i + 1] = stringBuilder.toString();
                if (object == null || !((String)object).equals(stringBuilder.toString())) continue;
                n = new Integer(i + 1);
            }
            comboEditor.setItems(stringArray);
            comboEditor.createEditor((Composite)this.fieldsTree);
            comboEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
            this.fieldsTreeEditor.setEditor(comboEditor.getEditor(), treeItem, 1);
            comboEditor.setValue((Object)n);
            comboEditor.selectAll();
            comboEditor.setFocus();
        }
    }

    private void showErrorMessage(String string) {
        this.getSite().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleKeyTableSelectionEvent(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.keyTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        KeyList keyList = this.getFileDescriptor().getKeys();
        Key key = (Key)keyList.getSettingAt(nArray[0]);
        TableItem tableItem = this.keyTable.getItem(nArray[0]);
        switch (nArray[1]) {
            case 0: {
                TextEditor textEditor = new TextEditor();
                textEditor.createEditor((Composite)this.keyTable);
                textEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
                this.keyTableEditor.setEditor(textEditor.getEditor(), tableItem, 0);
                if (key.getName() != null) {
                    textEditor.setValue((Object)key.getName());
                }
                textEditor.selectAll();
                textEditor.setFocus();
                break;
            }
            case 1: {
                ComboEditor comboEditor = new ComboEditor();
                comboEditor.setItems(new KeyType().getNames());
                comboEditor.createEditor((Composite)this.keyTable);
                comboEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
                this.keyTableEditor.setEditor(comboEditor.getEditor(), tableItem, 1);
                comboEditor.setValue((Object)new Integer(key.getKeyType().getValue()));
                comboEditor.selectAll();
                comboEditor.setFocus();
            }
        }
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private TreeItem getItemForLocation(Tree tree, int n, int n2, int[] nArray) {
        return this.getItemForLocation(tree.getItems(), tree.getColumnCount(), n, n2, nArray);
    }

    private TreeItem getItemForLocation(TreeItem[] treeItemArray, int n, int n2, int n3, int[] nArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (treeItemArray[i].getBounds(j).contains(n2, n3)) {
                    nArray[0] = j;
                    return treeItemArray[i];
                }
                TreeItem treeItem = this.getItemForLocation(treeItemArray[i].getItems(), n, n2, n3, nArray);
                if (treeItem == null) continue;
                return treeItem;
            }
        }
        return null;
    }

    void initData() {
        ScreenFD_SL screenFD_SL = this.getDataLayout();
        VariableTypeList variableTypeList = screenFD_SL.getFdItems();
        this.fillTree(variableTypeList);
        KeyList keyList = screenFD_SL.getFileDescriptor().getKeys();
        this.fillKeyTable(keyList);
        this.addBtn.setEnabled(false);
        this.modifyBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.upBtn.setEnabled(false);
        this.downBtn.setEnabled(false);
        KeyDefinitionPage.expandAll((Tree)this.fieldsTree);
    }

    private void setChecked(TreeItem[] treeItemArray, boolean bl) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItemArray[i].setChecked(bl);
            if (!bl) {
                treeItemArray[i].setText(1, "");
                treeItemArray[i].setData("segmentIndex", null);
            }
            this.setChecked(treeItemArray[i].getItems(), bl);
        }
        this.addBtn.setEnabled(false);
    }

    private boolean checkItems(String string) {
        boolean bl = false;
        String[] stringArray = string.split("\\,");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            int n = string3.indexOf(" of ");
            if (n >= 0) {
                string2 = string3.substring(0, n);
                string3 = string3.substring(n + 1);
            } else {
                string2 = string3;
                string3 = "";
            }
            bl |= this.checkItems(string2, string3, i, this.fieldsTree.getItems());
        }
        return bl;
    }

    private boolean checkItems(String string, String string2, int n, TreeItem[] treeItemArray) {
        for (TreeItem treeItem : treeItemArray) {
            if (treeItem.getText(0).substring(3).equals(string)) {
                treeItem.setChecked(true);
                treeItem.setText(1, string2);
                treeItem.setData("segmentIndex", (Object)new Integer(n));
                return true;
            }
            if (!this.checkItems(string, string2, n, treeItem.getItems())) continue;
            return true;
        }
        return false;
    }

    private void addModifyKey(Key key, TableItem tableItem) {
        KeyList keyList;
        boolean bl = key == null;
        String[] stringArray = this.getSelectedVariables(!bl);
        if (stringArray.length > 1) {
            keyList = new KeyFieldOrderDialog(this.getSite().getShell(), stringArray);
            keyList.open();
            if (KeyFieldOrderDialog.access$1900((KeyFieldOrderDialog)keyList) != null) {
                stringArray = KeyFieldOrderDialog.access$1900((KeyFieldOrderDialog)keyList);
            } else {
                return;
            }
        }
        keyList = this.getFileDescriptor().getKeys();
        if (bl) {
            key = (Key)keyList.createNew();
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(stringArray[i]);
        }
        key.setFieldNameList(stringBuilder.toString());
        if (bl) {
            keyList.addSetting((SettingItem)key);
            tableItem = new TableItem(this.keyTable, 0);
            tableItem.setText(0, key.getName());
            tableItem.setText(1, key.getKeyType().toString());
            tableItem.setData((Object)key);
        }
        tableItem.setText(2, key.getFieldNameList());
        if (bl) {
            this.keyTable.setSelection(tableItem);
        }
        this.makeDirty();
    }

    private void addNewKey() {
        this.addModifyKey(null, null);
    }

    private void modifyKey() {
        TableItem tableItem = this.keyTable.getSelection()[0];
        Key key = (Key)this.getFileDescriptor().getKeys().getSettingAt(this.keyTable.getSelectionIndex());
        this.addModifyKey(key, tableItem);
    }

    private void removeKey() {
        TableItem[] tableItemArray = this.keyTable.getSelection();
        KeyList keyList = this.getFileDescriptor().getKeys();
        if (tableItemArray != null && tableItemArray.length > 0) {
            for (int i = 0; i < tableItemArray.length; ++i) {
                keyList.removeSetting((SettingItem)((Key)tableItemArray[i].getData()));
                tableItemArray[i].dispose();
            }
        }
        this.modifyBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.setChecked(this.fieldsTree.getItems(), false);
        this.makeDirty();
    }

    private void keyUp() {
        int n;
        TableItem[] tableItemArray = this.keyTable.getSelection();
        if (tableItemArray.length == 1 && (n = this.keyTable.indexOf(tableItemArray[0])) > 0) {
            TableItem tableItem = this.keyTable.getItem(n - 1);
            Key key = (Key)tableItem.getData();
            String[] stringArray = new String[this.keyTable.getColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = tableItem.getText(i);
            }
            TableItem tableItem2 = tableItemArray[0];
            Key key2 = (Key)tableItem2.getData();
            for (int i = 0; i < this.keyTable.getColumnCount(); ++i) {
                tableItem.setText(i, tableItem2.getText(i));
            }
            tableItem.setData((Object)key2);
            tableItem2.setText(stringArray);
            tableItem2.setData((Object)key);
            KeyList keyList = this.getFileDescriptor().getKeys();
            keyList.removeSetting(n);
            keyList.addSetting(n - 1, (SettingItem)key2);
            this.keyTable.setSelection(n - 1);
            this.keyTable.showSelection();
            this.makeDirty();
        }
    }

    private void keyDown() {
        int n;
        TableItem[] tableItemArray = this.keyTable.getSelection();
        if (tableItemArray.length == 1 && (n = this.keyTable.indexOf(tableItemArray[0])) < this.keyTable.getItemCount() - 1) {
            TableItem tableItem = this.keyTable.getItem(n + 1);
            Key key = (Key)tableItem.getData();
            String[] stringArray = new String[this.keyTable.getColumnCount()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = tableItem.getText(i);
            }
            TableItem tableItem2 = tableItemArray[0];
            Key key2 = (Key)tableItem2.getData();
            for (int i = 0; i < this.keyTable.getColumnCount(); ++i) {
                tableItem.setText(i, tableItem2.getText(i));
            }
            tableItem.setData((Object)key2);
            tableItem2.setText(stringArray);
            tableItem2.setData((Object)key);
            KeyList keyList = this.getFileDescriptor().getKeys();
            keyList.removeSetting(n);
            if (n < this.keyTable.getItemCount() - 1) {
                keyList.addSetting(n + 1, (SettingItem)key2);
                this.keyTable.setSelection(n + 1);
            } else {
                keyList.addSetting((SettingItem)key2);
                this.keyTable.setSelection(this.keyTable.getItemCount() - 1);
            }
            this.keyTable.showSelection();
            this.makeDirty();
        }
    }

    private String[] getSelectedVariables(boolean bl) {
        TreeItem[] treeItemArray = this.getCheckedItems();
        String[] stringArray = new String[treeItemArray.length];
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < treeItemArray.length; ++i) {
            Integer n;
            stringArray[i] = treeItemArray[i].getText(0).substring(3);
            if (treeItemArray[i].getText(1).length() > 0) {
                int n2 = i;
                stringArray[n2] = stringArray[n2] + " " + treeItemArray[i].getText(1);
            }
            if ((n = (Integer)treeItemArray[i].getData("segmentIndex")) == null) {
                n = new Integer(Integer.MAX_VALUE);
            }
            hashMap.put(stringArray[i], n);
        }
        if (bl) {
            Arrays.sort(stringArray, new /* Unavailable Anonymous Inner Class!! */);
        }
        return stringArray;
    }

    private TreeItem[] getCheckedItems() {
        Vector vector = new Vector();
        this.getCheckedItems(vector, this.fieldsTree.getItems());
        TreeItem[] treeItemArray = new TreeItem[vector.size()];
        vector.toArray(treeItemArray);
        return treeItemArray;
    }

    private void getCheckedItems(Vector vector, TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (treeItemArray[i].getChecked()) {
                vector.addElement(treeItemArray[i]);
            }
            this.getCheckedItems(vector, treeItemArray[i].getItems());
        }
    }

    private void fillKeyTable(KeyList keyList) {
        this.keyTable.removeAll();
        int n = keyList.getSettingCount();
        for (int i = 0; i < n; ++i) {
            Key key = (Key)keyList.getSettingAt(i);
            TableItem tableItem = new TableItem(this.keyTable, 0);
            if (key.getName() != null) {
                tableItem.setText(0, key.getName());
            }
            tableItem.setText(1, key.getKeyType().toString());
            if (key.getFieldNameList() != null) {
                tableItem.setText(2, key.getFieldNameList());
            }
            tableItem.setData((Object)key);
        }
    }

    private void fillTree(VariableTypeList variableTypeList) {
        this.fieldsTree.removeAll();
        int n = variableTypeList.getSettingCount();
        for (int i = 0; i < n; ++i) {
            this.addVariable((VariableType)variableTypeList.getSettingAt(i), null);
        }
    }

    private void addVariable(VariableType variableType, TreeItem treeItem) {
        TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.fieldsTree, 0);
        treeItem2.setText(0, variableType.getLevel() + " " + variableType.getName());
        treeItem2.setData((Object)variableType);
        int n = variableType.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.addVariable((VariableType)variableType.getChildAt(i), treeItem2);
        }
    }

    public boolean selectProperty(FindInObjectMatchReference[] findInObjectMatchReferenceArray) {
        boolean bl = true;
        if (findInObjectMatchReferenceArray.length == 0) {
            return false;
        }
        String string = findInObjectMatchReferenceArray[0].getName();
        if (string.equals("Keys")) {
            this.getDLEditor().activateKeyDefinitionPage();
            if (findInObjectMatchReferenceArray.length > 1 && this.keyTable.getItemCount() > findInObjectMatchReferenceArray[1].getIndex()) {
                this.keyTable.setFocus();
                this.keyTable.select(findInObjectMatchReferenceArray[1].getIndex());
            }
        } else {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ void access$100(KeyDefinitionPage keyDefinitionPage, MouseEvent mouseEvent) {
        keyDefinitionPage.handleKeyTableSelectionEvent(mouseEvent);
    }

    static /* synthetic */ Table access$200(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.keyTable;
    }

    static /* synthetic */ Button access$300(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.removeBtn;
    }

    static /* synthetic */ Button access$400(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.upBtn;
    }

    static /* synthetic */ Button access$500(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.downBtn;
    }

    static /* synthetic */ Tree access$600(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.fieldsTree;
    }

    static /* synthetic */ void access$700(KeyDefinitionPage keyDefinitionPage, TreeItem[] treeItemArray, boolean bl) {
        keyDefinitionPage.setChecked(treeItemArray, bl);
    }

    static /* synthetic */ boolean access$800(KeyDefinitionPage keyDefinitionPage, String string) {
        return keyDefinitionPage.checkItems(string);
    }

    static /* synthetic */ Button access$900(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.addBtn;
    }

    static /* synthetic */ Button access$1000(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.modifyBtn;
    }

    static /* synthetic */ void access$1100(KeyDefinitionPage keyDefinitionPage, MouseEvent mouseEvent) {
        keyDefinitionPage.handleFieldsTreeSelectionEvent(mouseEvent);
    }

    static /* synthetic */ TreeItem[] access$1200(KeyDefinitionPage keyDefinitionPage) {
        return keyDefinitionPage.getCheckedItems();
    }

    static /* synthetic */ void access$1300(KeyDefinitionPage keyDefinitionPage) {
        keyDefinitionPage.addNewKey();
    }

    static /* synthetic */ void access$1400(KeyDefinitionPage keyDefinitionPage) {
        keyDefinitionPage.modifyKey();
    }

    static /* synthetic */ void access$1500(KeyDefinitionPage keyDefinitionPage) {
        keyDefinitionPage.removeKey();
    }

    static /* synthetic */ void access$1600(KeyDefinitionPage keyDefinitionPage) {
        keyDefinitionPage.keyUp();
    }

    static /* synthetic */ void access$1700(KeyDefinitionPage keyDefinitionPage) {
        keyDefinitionPage.keyDown();
    }

    static /* synthetic */ void access$1800(KeyDefinitionPage keyDefinitionPage, String string) {
        keyDefinitionPage.showErrorMessage(string);
    }
}

