/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner;

import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenRoot;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.propertysheet.EventParagraphs;
import com.iscobol.screenpainter.util.BeanReader;
import com.iscobol.screenpainter.util.BeanWriter;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ScreenFD_SL
extends ScreenRoot {
    private VariableTypeList fdItems;
    private FileDescriptor fileDescriptor;
    private boolean fdNameChanged;

    public ScreenFD_SL(IFile iFile) {
        super(iFile);
    }

    public ScreenFD_SL(File file) {
        super(file);
    }

    public boolean getAnsiFormat() {
        return IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.progfile.ansi");
    }

    public String getFdName() {
        String string = null;
        if (this.file != null) {
            string = this.getString("iscobol.fd.name", null);
        }
        if (string == null || string.length() == 0) {
            string = this.getFileName();
        }
        return string;
    }

    public String getUniquePrefix() {
        if (this.file == null) {
            return "";
        }
        String string = this.getString("iscobol.fd.uniquepfx", null);
        return string;
    }

    public void setFdName(String string) {
        String string2 = this.getFdName();
        if (!string.equals(string2)) {
            this.setString("iscobol.fd.name", string);
            this.fdNameChanged = true;
        }
        IscobolScreenPainterPlugin.getDefault().firePropertyChangeEvent(new PropertyChangeEvent((Object)this, "iscobol.fd.name", (Object)string2, (Object)string));
    }

    public void setUniquePrefix(String string) {
        if (this.file != null) {
            this.setString("iscobol.fd.uniquepfx", string);
            this.fdNameChanged = true;
        }
    }

    public void load() {
        this.load(this.getContents());
    }

    public void load(InputStream inputStream) {
        if (this.file != null) {
            try {
                this.file.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        BeanReader beanReader = new BeanReader(inputStream);
        try {
            this.fileDescriptor = (FileDescriptor)beanReader.readObject();
        }
        catch (Exception exception) {
            this.fileDescriptor = new FileDescriptor();
        }
        this.fdItems = new VariableTypeList();
        try {
            VariableType[] variableTypeArray = (VariableType[])beanReader.readObject();
            this.fdItems.setVariables((SettingItem[])variableTypeArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.eventParagraphs = (EventParagraphs)beanReader.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.properties = (Hashtable)beanReader.readObject();
            if (this.properties == (Hashtable)null) {
                this.properties = new Hashtable();
            }
        }
        catch (Exception exception) {
            this.properties = new Hashtable();
        }
        if (this.properties.isEmpty()) {
            this.loadOldProps();
        }
        beanReader.close();
        this.setLoaded();
    }

    protected void loadOldProps() {
        super.loadOldProps();
        Hashtable hashtable = this.properties;
        this.loadOldProp(hashtable, "iscobol.fd.name");
        this.loadOldProp(hashtable, "iscobol.fd.uniquepfx");
    }

    private void loadOldProp(Hashtable hashtable, String string) {
        String string2 = PluginUtilities.getPersistentProperty((IResource)this.file, (String)"Default", (String)string);
        if (string2 != null) {
            hashtable.put(string, string2);
        }
    }

    public void save() {
        try {
            this.setIscobolRelease();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BeanWriter beanWriter = new BeanWriter((OutputStream)byteArrayOutputStream);
            beanWriter.writeObject((Object)this.getFileDescriptor());
            beanWriter.writeObject((Object)this.getFdItems().get01or77Variables());
            beanWriter.writeObject((Object)this.getEventParagraphs());
            beanWriter.writeObject((Object)this.properties);
            beanWriter.close();
            byteArrayOutputStream.close();
            if (this.file != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                PluginUtilities.modifyFile((IFile)this.file, (InputStream)byteArrayInputStream, (boolean)false, (boolean)true);
                if (this.fdNameChanged) {
                    PluginUtilities.saveProjectOptions((IProject)this.file.getProject());
                }
                byteArrayInputStream.close();
            } else {
                FileOutputStream fileOutputStream = new FileOutputStream(this.iofile);
                fileOutputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                fileOutputStream.close();
            }
            this.fdNameChanged = false;
            this.setImported(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public VariableType findVariable(String string) {
        return this.getFdItems().findVariable(string, this.getFdName());
    }

    public VariableTypeList getFdItems() {
        this.checkLoaded();
        if (this.fdItems == null) {
            this.fdItems = new VariableTypeList();
        }
        return this.fdItems;
    }

    public FileDescriptor getFileDescriptor() {
        this.checkLoaded();
        if (this.fileDescriptor == null) {
            this.fileDescriptor = new FileDescriptor();
        }
        return this.fileDescriptor;
    }
}

