/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.fileimport;

import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.fileimport.SLFDUtil;
import com.iscobol.filedesigner.types.AccessMode;
import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IErrors;
import com.iscobol.interfaces.compiler.IFileDescriptorExtension;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.ITokenManager;
import com.iscobol.interfaces.compiler.IVariableDeclaration;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.plugins.editor.util.ProjectFileFinder;
import com.iscobol.plugins.editor.util.intf.CompilerTokens;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.beans.types.DataTypeDirective;
import com.iscobol.screenpainter.beans.types.OccursClause;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.beans.types.VariableUsage;
import com.iscobol.screenpainter.beans.types.XFDAttributes;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class Fd {
    private ITokenManager tm;
    private IPcc pc;
    private IVariableDeclaration virtualParent;
    private IErrors error;
    private FileDescriptor fd;
    private ScreenFD_SL sp;
    private VariableTypeList vtList;
    private int lastLineNumber;
    private String name;
    private CompilerTokens tNums;
    private ICompiler compiler;
    private File fileName;
    private ProjectFileFinder pff;
    private SLFDUtil util;

    public Fd(IFileDescriptorExtension iFileDescriptorExtension, ScreenFD_SL screenFD_SL, IProject iProject, int n) throws InternalErrorException {
        IVariableName iVariableName;
        IVariableName iVariableName2;
        IVariableName iVariableName3;
        IVariableName iVariableName4;
        this.sp = screenFD_SL;
        if (this.sp != null) {
            this.fd = this.sp.getFileDescriptor();
            this.vtList = this.sp.getFdItems();
            if (iProject == null) {
                iProject = this.sp.getProject();
            }
        } else {
            this.fd = new FileDescriptor();
            this.vtList = new VariableTypeList();
        }
        this.fileName = new File(iFileDescriptorExtension.getNameToken().getFileName());
        this.util = new SLFDUtil(n, true);
        if (iProject != null) {
            this.pff = new ProjectFileFinder(iProject);
        }
        this.fd.setComment(this.util.getComment(iFileDescriptorExtension.getNameToken()));
        this.fd.setExternal(iFileDescriptorExtension.isExternal());
        this.fd.setGlobal(iFileDescriptorExtension.isGlobal());
        this.fd.setBlockMaxSize(iFileDescriptorExtension.getBlockMax());
        this.fd.setBlockMinSize(iFileDescriptorExtension.getBlockMin());
        this.fd.setBlockRecords(iFileDescriptorExtension.isBlockRecords());
        IToken iToken = iFileDescriptorExtension.getLinage();
        if (iToken != null) {
            this.fd.setLinageLines(iToken.getWord());
        } else {
            iVariableName4 = iFileDescriptorExtension.getLinageVar();
            if (iVariableName4 != null) {
                this.fd.setLinageLines(iVariableName4.getName());
            }
        }
        iVariableName4 = iFileDescriptorExtension.getLinageFooting();
        if (iVariableName4 != null) {
            this.fd.setLinageFooting(iVariableName4.getWord());
        } else {
            iVariableName3 = iFileDescriptorExtension.getLinageFootingVar();
            if (iVariableName3 != null) {
                this.fd.setLinageFooting(iVariableName3.getName());
            }
        }
        iVariableName3 = iFileDescriptorExtension.getLinageTop();
        if (iVariableName3 != null) {
            this.fd.setLinageTop(iVariableName3.getWord());
        } else {
            iVariableName2 = iFileDescriptorExtension.getLinageTopVar();
            if (iVariableName2 != null) {
                this.fd.setLinageTop(iVariableName2.getName());
            }
        }
        iVariableName2 = iFileDescriptorExtension.getLinageBottom();
        if (iVariableName2 != null) {
            this.fd.setLinageBottom(iVariableName2.getWord());
        } else {
            iVariableName = iFileDescriptorExtension.getLinageBottomVar();
            if (iVariableName != null) {
                this.fd.setLinageBottom(iVariableName.getName());
            }
        }
        iVariableName = iFileDescriptorExtension.getRecordDescription();
        IVariableDeclaration iVariableDeclaration = iVariableName.getFirst();
        while (iVariableDeclaration != null) {
            this.loadVariable(this.vtList, iVariableDeclaration, null, true);
            iVariableDeclaration = iVariableName.getNext();
        }
        this.util.dispose();
    }

    public Fd(String string, ITokenManager iTokenManager, String string2, ScreenFD_SL screenFD_SL, IPcc iPcc, IErrors iErrors) throws InternalErrorException {
        this(string, iTokenManager, string2, screenFD_SL, null, iPcc, iErrors);
    }

    public Fd(String string, ITokenManager iTokenManager, String string2, IProject iProject, IPcc iPcc, IErrors iErrors) throws InternalErrorException {
        this(string, iTokenManager, string2, null, iProject, iPcc, iErrors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Fd(String string, ITokenManager iTokenManager, String string2, ScreenFD_SL screenFD_SL, IProject iProject, IPcc iPcc, IErrors iErrors) throws InternalErrorException {
        boolean bl = false;
        boolean bl2 = false;
        this.pc = iPcc;
        this.tm = iTokenManager;
        this.error = iErrors;
        this.sp = screenFD_SL;
        if (this.sp != null) {
            string2 = this.sp.getFileName() + ".fd";
            this.fd = this.sp.getFileDescriptor();
            this.vtList = this.sp.getFdItems();
            iProject = this.sp.getProject();
        } else {
            this.fd = new FileDescriptor();
            this.vtList = new VariableTypeList();
        }
        this.compiler = Factory.getCompiler((IProject)iProject);
        this.tNums = Factory.getCompilerTokens((IProject)iProject);
        IToken iToken = null;
        try {
            iToken = this.tm.getToken();
            if (iToken.getToknum() != this.tNums.FD && iToken.getToknum() != this.tNums.SD) {
                throw new InternalErrorException(string2 + ": Error FD or SD expected on line " + this.tm.getLineNumber());
            }
            if (iToken.getToknum() == this.tNums.SD) {
                bl = true;
            }
            if ((iToken = this.tm.getToken()).getToknum() != 10009) {
                throw new InternalErrorException(string2 + ": Error USERNAME expected on line " + this.tm.getLineNumber());
            }
            if (this.sp != null && !this.sp.getFdName().equalsIgnoreCase(iToken.getWord())) {
                throw new InternalErrorException(string2 + ": Error FD/SD name does not correspond with SELECT name " + this.tm.getLineNumber());
            }
            this.name = iToken.getWord();
            IToken iToken2 = this.compiler.newToken(iToken);
            iToken2.setWord(string);
            this.virtualParent = this.compiler.newVariableDeclaration(this.pc, iToken2, this.tm);
            if (bl && this.fd.getAccessMode() != new AccessMode(1)) {
                throw new InternalErrorException("Invalid ORGANIZATION for sort file on line " + this.tm.getLineNumber());
            }
            while ((iToken = this.tm.getToken()).getToknum() != 10006) {
                int n = iToken.getToknum();
                if (n == this.tNums.IS) continue;
                if (n == this.tNums.EXTERNAL) {
                    this.fd.setExternal(true);
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.AS) {
                        iToken = this.tm.getToken();
                        if (iToken.getToknum() == 10009) continue;
                        throw new InternalErrorException(string2 + ": Error USERNAME expected on line " + this.tm.getLineNumber());
                    }
                    this.tm.ungetToken();
                    continue;
                }
                if (n == this.tNums.GLOBAL) {
                    this.fd.setGlobal(true);
                    continue;
                }
                if (n == this.tNums.RECORDING) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.MODE) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.IS) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == 10009 && ("V".equals(iToken.getWord()) || "F".equals(iToken.getWord()) || "U".equals(iToken.getWord()) || "S".equals(iToken.getWord()) || "FIXED".equals(iToken.getWord()) || "VARIABLE".equals(iToken.getWord()))) continue;
                    throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                }
                if (n == this.tNums.LABEL) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() != this.tNums.RECORD && iToken.getToknum() != this.tNums.RECORDS) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of RECORD on line " + this.tm.getLineNumber());
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.IS || iToken.getToknum() == this.tNums.ARE) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.OMITTED || iToken.getToknum() == this.tNums.STANDARD) continue;
                    throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of OMITTED or STANDARD on line " + this.tm.getLineNumber());
                }
                if (n == this.tNums.BLOCK) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.CONTAINS) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() != 10002) {
                        throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of INT_LITERAL on line " + this.tm.getLineNumber());
                    }
                    this.fd.setBlockMinSize(Integer.parseInt(iToken.getWord()));
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.TO) {
                        iToken = this.tm.getToken();
                        if (iToken.getToknum() != 10002) {
                            throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of INT_LITERAL on line " + this.tm.getLineNumber());
                        }
                        this.fd.setBlockMaxSize(Integer.parseInt(iToken.getWord()));
                        if (this.fd.getBlockMaxSize() < this.fd.getBlockMinSize()) {
                            throw new InternalErrorException(string2 + ": Error invalid BLOCK value " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                        }
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.RECORDS) {
                        this.fd.setBlockRecords(true);
                        continue;
                    }
                    if (iToken.getToknum() == this.tNums.CHARACTERS) continue;
                    this.tm.ungetToken();
                    continue;
                }
                if (n == this.tNums.RECORD) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.CONTAINS || iToken.getToknum() == this.tNums.IS) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.VARYING) {
                        iToken = this.tm.getToken();
                        if (iToken.getToknum() == this.tNums.IN) {
                            iToken = this.tm.getToken();
                        }
                        if (iToken.getToknum() == this.tNums.SIZE) {
                            iToken = this.tm.getToken();
                        }
                        if (iToken.getToknum() == this.tNums.FROM) {
                            iToken = this.tm.getToken();
                        }
                        if (iToken.getToknum() == 10002) {
                            this.fd.setBlockMinSize(Integer.parseInt(iToken.getWord()));
                            iToken = this.tm.getToken();
                        } else {
                            this.fd.setBlockMinSize(1);
                        }
                        if (iToken.getToknum() == this.tNums.TO) {
                            iToken = this.tm.getToken();
                            if (iToken.getToknum() != 10002) {
                                throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of INT_LITERAL on line " + this.tm.getLineNumber());
                            }
                            this.fd.setBlockMaxSize(Integer.parseInt(iToken.getWord()));
                            if (this.fd.getBlockMaxSize() < this.fd.getBlockMinSize()) {
                                throw new InternalErrorException(string2 + ": Error invalid value " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                            }
                        } else {
                            this.tm.ungetToken();
                        }
                        if ((iToken = this.tm.getToken()).getToknum() == this.tNums.CHARACTERS) {
                            iToken = this.tm.getToken();
                        }
                        if (iToken.getToknum() == this.tNums.DEPENDING) {
                            iToken = this.tm.getToken();
                            if (iToken.getToknum() != this.tNums.ON) {
                                this.tm.ungetToken();
                            }
                            this.tm.ungetToken();
                            continue;
                        }
                        this.tm.ungetToken();
                        continue;
                    }
                    if (iToken.getToknum() != 10002) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                    this.fd.setBlockMinSize(Integer.parseInt(iToken.getWord()));
                    this.fd.setBlockMaxSize(Integer.parseInt(iToken.getWord()));
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.TO) {
                        iToken = this.tm.getToken();
                        if (iToken.getToknum() != 10002) {
                            throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of INT_LITERAL on line " + this.tm.getLineNumber());
                        }
                        this.fd.setBlockMaxSize(Integer.parseInt(iToken.getWord()));
                        if (this.fd.getBlockMaxSize() < this.fd.getBlockMinSize()) {
                            throw new InternalErrorException(string2 + ": Error invalid value " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                        }
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.CHARACTERS) continue;
                    this.tm.ungetToken();
                    continue;
                }
                if (n == this.tNums.VALUE) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() != this.tNums.OF) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of OF on line " + this.tm.getLineNumber());
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() != this.tNums.LABEL && iToken.getToknum() != this.tNums.ID && iToken.getToknum() != this.tNums.FILE_ID) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of LABEL, FILE-ID, ID on line " + this.tm.getLineNumber());
                    IToken iToken3 = iToken;
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.IS || iToken.getToknum() == this.tNums.ARE) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() != 10009 && iToken.getToknum() != 10001) {
                        throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of USERNAME, STR_LITERAL on line " + this.tm.getLineNumber());
                    }
                    if ((iToken3.getToknum() == this.tNums.ID || iToken3.getToknum() == this.tNums.FILE_ID) && iToken.getToknum() != 10001 && iToken.getToknum() != 10009) continue;
                }
                if (n == this.tNums.LINAGE) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.IS) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == 10009) {
                        this.fd.setLinageLines(iToken.getWord());
                    } else {
                        if (iToken.getToknum() != 10002) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of USERNAME, STR_LITERAL on line " + this.tm.getLineNumber());
                        this.fd.setLinageLines(iToken.getWord());
                    }
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() != this.tNums.LINES) {
                        this.tm.ungetToken();
                    }
                    if ((iToken = this.tm.getToken()).getToknum() == this.tNums.WITH || iToken.getToknum() == this.tNums.FOOTING) {
                        if (iToken.getToknum() == this.tNums.WITH) {
                            iToken = this.tm.getToken();
                        }
                        if (iToken.getToknum() != this.tNums.FOOTING) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of FOOTING on line " + this.tm.getLineNumber());
                        iToken = this.tm.getToken();
                        if (iToken.getToknum() == this.tNums.AT) {
                            iToken = this.tm.getToken();
                        }
                        if (iToken.getToknum() == 10009) {
                            this.fd.setLinageFooting(iToken.getWord());
                        } else {
                            if (iToken.getToknum() != 10002) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of USERNAME, STR_LITERAL on line " + this.tm.getLineNumber());
                            this.fd.setLinageFooting(iToken.getWord());
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.LINES) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.AT) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.TOP) {
                        if (iToken.getToknum() == 10009) {
                            this.fd.setLinageTop(iToken.getWord());
                        } else {
                            if (iToken.getToknum() != 10002) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of USERNAME, STR_LITERAL on line " + this.tm.getLineNumber());
                            this.fd.setLinageTop(iToken.getWord());
                        }
                    } else {
                        this.tm.ungetToken();
                    }
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.LINES) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.AT) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() == this.tNums.BOTTOM) {
                        if (iToken.getToknum() == 10009) {
                            this.fd.setLinageBottom(iToken.getWord());
                            continue;
                        }
                        if (iToken.getToknum() != 10002) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of USERNAME, STR_LITERAL on line " + this.tm.getLineNumber());
                        this.fd.setLinageBottom(iToken.getWord());
                        continue;
                    }
                    this.tm.ungetToken();
                    continue;
                }
                if (n == this.tNums.DATA) {
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() != this.tNums.RECORD && iToken.getToknum() != this.tNums.RECORDS) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                    iToken = this.tm.getToken();
                    if (iToken.getToknum() == this.tNums.IS || iToken.getToknum() == this.tNums.ARE) {
                        iToken = this.tm.getToken();
                    }
                    if (iToken.getToknum() != 10009) {
                        throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " instead of USERNAME on line " + this.tm.getLineNumber());
                    }
                    while (iToken.getToknum() == 10009) {
                        iToken = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    continue;
                }
                if (n != this.tNums.REPORT && n != this.tNums.REPORTS) throw new InternalErrorException(string2 + ": Error unexpected token " + iToken.getWord() + " on line " + this.tm.getLineNumber());
                iToken = this.tm.getToken();
                if (iToken.getToknum() == this.tNums.IS || iToken.getToknum() == this.tNums.ARE) {
                    iToken = this.tm.getToken();
                }
                while (iToken.getToknum() == 10009) {
                    iToken = this.tm.getToken();
                }
                this.tm.ungetToken();
            }
            if (bl2) return;
            this.genericFile(string2);
            return;
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException(string2 + ": Error " + exception + " on line" + this.tm.getLineNumber());
        }
    }

    private void genericFile(String string) throws Exception {
        IVariableDeclaration iVariableDeclaration = null;
        Vector<IVariableDeclaration> vector = new Vector<IVariableDeclaration>();
        try {
            while (this.tm.getToken().getToknum() == 10002) {
                this.tm.ungetToken();
                iVariableDeclaration = this.compiler.newVariableDeclaration(this.pc, this.tm, this.error, this.virtualParent);
                this.virtualParent.addChildVar(iVariableDeclaration);
                vector.add(iVariableDeclaration);
            }
            this.tm.ungetToken();
        }
        catch (Exception exception) {
            this.tm.ungetToken();
        }
        if (iVariableDeclaration != null) {
            this.loadVariables(vector);
        }
        if (vector.isEmpty()) {
            throw new InternalErrorException(string + ": Error missing record on line " + this.tm.getLineNumber());
        }
        this.lastLineNumber = this.tm.getLineNumber();
    }

    public int getLastLineNumber() {
        return this.lastLineNumber;
    }

    public String getName() {
        return this.name;
    }

    private void loadVariables(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            IVariableDeclaration iVariableDeclaration = (IVariableDeclaration)enumeration.nextElement();
            this.loadVariable(this.vtList, iVariableDeclaration, null, false);
        }
    }

    private void loadVariable(VariableTypeList variableTypeList, IVariableDeclaration iVariableDeclaration, VariableType variableType, boolean bl) {
        Object object;
        Object object2;
        int n = iVariableDeclaration.getLevel();
        VariableType variableType2 = VariableType.newInstance((int)n);
        if (bl) {
            variableType2.setComment(this.util.getComment(iVariableDeclaration.getNameToken()));
        }
        variableType2.setName(iVariableDeclaration.getName());
        variableType2.setInLinkage(false);
        if (iVariableDeclaration.getPicture() != null && !iVariableDeclaration.getPicture().equals("PIC78")) {
            variableType2.setPicture(iVariableDeclaration.getPicture());
        }
        variableType2.setValue(iVariableDeclaration.getLevel() == 88 ? iVariableDeclaration.getValues() : iVariableDeclaration.getValue());
        if (iVariableDeclaration.getRedefines() != null) {
            variableType2.setRedefines(iVariableDeclaration.getRedefines().getName());
        }
        if (iVariableDeclaration.getRename1() != null) {
            variableType2.setRenames(iVariableDeclaration.getRename1().getName());
            if (iVariableDeclaration.getRename2() != null) {
                variableType2.setRenamesThru(iVariableDeclaration.getRename2().getName());
            }
        }
        variableType2.setUsage(new VariableUsage(iVariableDeclaration.getUsage()));
        if (iVariableDeclaration.isOccursClause()) {
            if (iVariableDeclaration.getDepending() == null) {
                variableType2.setOccurs(OccursClause.getOccursFixed((int)iVariableDeclaration.getOccurs()));
            } else {
                variableType2.setOccurs(OccursClause.getOccursDepOn((int)iVariableDeclaration.getOccursMin(), (int)iVariableDeclaration.getOccursMax(), (String)iVariableDeclaration.getDepending().getName()));
            }
            if (iVariableDeclaration.getIndexes() != null) {
                variableType2.getOccurs().setIndexed(true);
                object2 = iVariableDeclaration.getIndexes().getFirst().getName();
                while (iVariableDeclaration.getIndexes().getNext() != null) {
                    object2 = (String)object2 + "," + iVariableDeclaration.getIndexes().getNext().getVarDecl().getName();
                }
                variableType2.getOccurs().setIndexes((String)object2);
            }
            if (iVariableDeclaration.getAscOccursKey() != null) {
                variableType2.getOccurs().setKeys(true);
                object2 = iVariableDeclaration.getAscOccursKey().getFirst().getName();
                while ((object = iVariableDeclaration.getAscOccursKey().getNext().getVarDecl()) != null) {
                    object2 = (String)object2 + " " + object.getName();
                }
                variableType2.getOccurs().setKeyList((String)object2);
            }
        }
        if (bl && !((File)(object2 = new File(iVariableDeclaration.getNameToken().getFileName()))).equals(this.fileName)) {
            if (this.pff != null && (object = this.pff.findFile(((File)object2).getName())) != null) {
                variableType2.setCopyEntry(((File)object2).getName());
                variableType2.setCopyFile(((File)object2).getName());
                File file = ((File)object).getParentFile();
                if (file != null) {
                    variableType2.setCopyFilePathName(file.getName() + "/" + ((File)object2).getName());
                } else {
                    variableType2.setCopyFilePathName(((File)object2).getName());
                }
            } else {
                variableType2.setCopyEntry(((File)object2).getPath());
                variableType2.setCopyFile(((File)object2).getPath());
                variableType2.setCopyFilePathName(((File)object2).getPath());
            }
        }
        if (iVariableDeclaration.getEfdExtraInfo() != null) {
            object2 = iVariableDeclaration.getEfdExtraInfo();
            object = new XFDAttributes();
            if (object2.isHidden()) {
                object.setHidden(true);
            }
            if (object2.hasWhen()) {
                object.setUseWhenDirective(true);
                object.setWhenDirective(object2.getWhenCondValue());
                object.setTableName(object2.getWhenTableName());
            }
            if (object2.getCobtrigger() != null) {
                object.setCobtrigger(object2.getCobtrigger());
            }
            if (object2.isUseGroup()) {
                object.setUseGroupDirective(true);
            }
            if (object2.getName() != null) {
                object.setNameDirective(object2.getName());
            }
            if (object2.getDate() != null) {
                object.setUseDataTypeDirective(true);
                object.setDataTypeDirective(new DataTypeDirective(2));
                object.setDateFormat(object2.getDate());
            } else if (object2.isNumeric()) {
                object.setUseDataTypeDirective(true);
                object.setDataTypeDirective(new DataTypeDirective(3));
            } else if (object2.isBinary()) {
                object.setUseDataTypeDirective(true);
                object.setDataTypeDirective(new DataTypeDirective(1));
            } else if (object2.isAlpha()) {
                object.setUseDataTypeDirective(true);
                object.setDataTypeDirective(new DataTypeDirective(0));
            }
            if (object2.getComment() != null) {
                object.setUseCommentDirective(true);
                object.setCommentDirective(object2.getComment());
            }
            if (object2.getFile() != null) {
                this.sp.getFileDescriptor().setFileDirective(object2.getFile());
            }
            variableType2.setXFDAttributes((XFDAttributes)object);
        }
        variableType2.setExtVar(true);
        if (iVariableDeclaration.getLevel() == 78 || variableType == null) {
            variableTypeList.addVariable(variableType2);
        } else {
            variableType.addChild((SettingTreeItem)variableType2);
        }
        object2 = iVariableDeclaration.getChildren();
        if (!object2.isEmpty()) {
            object = object2.getFirst();
            while (object != null) {
                this.loadVariable(variableTypeList, (IVariableDeclaration)object, variableType2, bl);
                object = object2.getNext();
            }
        }
    }

    public FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    public VariableTypeList getVariableTypeList() {
        return this.vtList;
    }
}

