/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.fileimport;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.fileimport.Fd;
import com.iscobol.filedesigner.fileimport.Select;
import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IErrors;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IPreProcessor;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.ITokenManager;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;

public class ImpSLFD {
    protected static IOptionList ol;
    protected static IPcc pccFD;
    protected static IPcc pcc;
    private static ITokenManager tmFD;
    public static final String ID = "com.iscobol.projectimport.ImpSLFD";
    protected ITokenManager tm;
    protected IOptionList options;
    protected IErrors error;
    protected ImpSLFD parent = null;
    protected String outDir;
    protected String sourceDir;
    protected String outName;
    protected String nameTempFile;

    public ImpSLFD(IProject iProject) {
        ICompiler iCompiler = Factory.getCompiler((IProject)iProject);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-jj");
        arrayList.add("xxx");
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.error = iCompiler.newErrors();
        ol = iCompiler.newOptionList(stringArray);
    }

    public ImpSLFD(String string, String string2, String string3, ITokenManager iTokenManager, IOptionList iOptionList, IErrors iErrors, ScreenFD_SL screenFD_SL) throws InternalErrorException {
        this.outName = string.substring(0, string.length() - 3);
        this.sourceDir = string2;
        this.outDir = string3;
        this.tm = iTokenManager;
        this.options = iOptionList;
        this.error = iErrors;
        new Select(string, this.outDir, iTokenManager, iErrors, screenFD_SL);
        new Fd(string, tmFD, null, screenFD_SL, pccFD, iErrors);
    }

    boolean start(boolean bl) {
        try {
            IToken iToken = this.tm.getToken();
            while (iToken != null) {
                iToken = this.tm.getToken();
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean importProject(ScreenFD_SL screenFD_SL, File file, String string) {
        if (PluginUtilities.isNewFdSelectInterfaceSupported((IProject)screenFD_SL.getProject())) {
            try {
                PluginUtilities.analyzeFD_Select(null, (String)file.getAbsolutePath(), (IProject)screenFD_SL.getProject(), Select.class, (ScreenFD_SL)screenFD_SL, (boolean)true);
                PluginUtilities.analyzeFD_Select(null, (String)string, (IProject)screenFD_SL.getProject(), Fd.class, (ScreenFD_SL)screenFD_SL, (boolean)true);
                return true;
            }
            catch (Exception exception) {
                IsConsolePlugin.log((IStatus)new Status(4, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + file, exception.getClass().hashCode(), exception.getMessage(), (Throwable)exception));
                return false;
            }
        }
        File file2 = null;
        String string2 = file.getPath();
        String string3 = file.getPath();
        string3 = string3.substring(0, string3.length() - string2.length());
        ICompiler iCompiler = Factory.getCompiler((IProject)screenFD_SL.getProject());
        try {
            ArrayList<String> arrayList = new ArrayList<String>(PluginUtilities.getAllOptions((IProject)screenFD_SL.getProject()));
            arrayList.add("-jj");
            arrayList.add("-efd");
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            ol = iCompiler.newOptionList(stringArray);
            IPreProcessor iPreProcessor = iCompiler.newPreProcessor(string2, string3, ol, this.error);
            this.createFileTemp(string, string3, screenFD_SL);
            IPreProcessor iPreProcessor2 = iCompiler.newPreProcessor(this.nameTempFile, string3, ol, this.error);
            iPreProcessor.start(null, file2);
            iPreProcessor2.start(null, file2);
            tmFD = iCompiler.newTokenManager(iPreProcessor2, ol, this.error);
            pccFD = iCompiler.newPcc(string, string3, string3, iCompiler.newTokenManager(iPreProcessor2, ol, this.error), ol, this.error);
            iPreProcessor2.start(null, file2);
            IsConsolePlugin.log((IStatus)new Status(2, string, 0, "Compiler option used" + pccFD.getOptions().getAll() + " on program " + string, null));
            if (pccFD.getErrors().getErrorCount(4) > 0) {
                Vector vector = pccFD.getErrors().getAllMessages();
                for (int i = 0; i < vector.size(); ++i) {
                    IsConsolePlugin.log((IStatus)new Status(2, string, 0, vector.get(i).toString(), null));
                }
                IsConsolePlugin.log((IStatus)new Status(2, string, 0, "FD " + string + " cannot be imported because compilation errors! ", null));
                return false;
            }
            new ImpSLFD(string2, string3, string3, iCompiler.newTokenManager(iPreProcessor, ol, this.error), ol, this.error, screenFD_SL);
            iPreProcessor.closeSource();
            iPreProcessor.closeListing();
            iPreProcessor2.closeSource();
            iPreProcessor2.closeListing();
            return true;
        }
        catch (Exception exception) {
            IsConsolePlugin.log((IStatus)new Status(4, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + string2, exception.getClass().hashCode(), exception.getMessage(), (Throwable)exception));
            return false;
        }
    }

    void createFileTemp(String string, String string2, ScreenFD_SL screenFD_SL) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string2 + string);
            File file = File.createTempFile(screenFD_SL.getFdName(), ".tmp");
            file.deleteOnExit();
            this.nameTempFile = file.getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(this.nameTempFile);
            int n = fileInputStream.read();
            while (n > 0) {
                fileOutputStream.write(n);
                n = fileInputStream.read();
            }
            fileInputStream.close();
            fileOutputStream.write(10);
            fileOutputStream.write(32);
            fileOutputStream.write(32);
            fileOutputStream.write(32);
            fileOutputStream.write(32);
            fileOutputStream.write(32);
            fileOutputStream.write(32);
            fileOutputStream.write(32);
            fileOutputStream.write(46);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            ConsolePlugin.log((IStatus)new Status(4, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + string, exception.getClass().hashCode(), exception.getMessage(), (Throwable)exception));
        }
    }
}

