/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.fileimport;

import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SLFDUtil {
    private Map<String, String[]> cobolLines = new HashMap();
    private final int sourceFormat;
    private final int shift;
    private final String eol = PluginUtilities.getLineDelimiter();

    SLFDUtil(int n, boolean bl) {
        this.sourceFormat = n;
        this.shift = bl ? 3 : 4;
    }

    void dispose() {
        this.cobolLines.clear();
        this.cobolLines = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getCobolLines(String string) {
        String[] stringArray = (String[])this.cobolLines.get(string);
        if (stringArray == null) {
            BufferedReader bufferedReader = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    arrayList.add(string2);
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            this.cobolLines.put(string, stringArray);
        }
        return stringArray;
    }

    public String getComment(IToken iToken) {
        String string = iToken.getFileName();
        int n = iToken.getFLN() - this.shift - 1;
        String[] stringArray = this.getCobolLines(string);
        if (n > 0 && n < stringArray.length) {
            StringBuilder stringBuilder = new StringBuilder();
            --n;
            while (n >= 0 && this.isComment(stringArray[n])) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(this.eol);
                }
                stringBuilder.append(stringArray[n]);
                --n;
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
        }
        return null;
    }

    private boolean isComment(String string) {
        return this.sourceFormat == 1 && string.length() > 6 && string.charAt(6) == '*' || this.sourceFormat == 2 && string.length() > 0 && string.charAt(0) == '*' || string.trim().startsWith("*>");
    }
}

