/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.propertysheet;

import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.filedesigner.types.IOParagraph;
import com.iscobol.filedesigner.types.IOParagraphList;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.dialogs.AddParagraphDialog;
import com.iscobol.screenpainter.propertysheet.ComboDialogEditor;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import java.util.Vector;
import org.eclipse.swt.widgets.Shell;

public class IOParagraphEditor
extends ComboDialogEditor {
    private String defName;
    private boolean shouldOpenEventEditor;
    private FileDescriptor fd;

    public IOParagraphEditor(String string, FileDescriptor fileDescriptor) {
        this.defName = string;
        this.fd = fileDescriptor;
        Object[] objectArray = this.getElements();
        for (int i = 0; i < objectArray.length; ++i) {
            this.getList().add((Comparable)objectArray[i]);
        }
    }

    protected Object openDialog(Shell shell) {
        String string = null;
        if (this.combo.getSelectionIndex() <= 0) {
            AddParagraphDialog addParagraphDialog = new AddParagraphDialog(shell, this.defName, (ElementsProvider)this);
            ParagraphType paragraphType = addParagraphDialog.openDialog();
            if (paragraphType != null) {
                string = paragraphType.toString();
            }
        } else {
            string = this.getElements()[this.combo.getSelectionIndex() - 1].toString();
        }
        this.shouldOpenEventEditor = true;
        return string;
    }

    public boolean shouldOpenEventEditor() {
        return this.shouldOpenEventEditor;
    }

    public Object[] getElements() {
        if (this.fd == null) {
            return new ParagraphType[0];
        }
        IOParagraphList iOParagraphList = this.fd.getIOParagraphs();
        int n = iOParagraphList.getSettingCount();
        Vector<ParagraphType> vector = new Vector<ParagraphType>();
        for (int i = 0; i < n; ++i) {
            IOParagraph iOParagraph = (IOParagraph)iOParagraphList.getSettingAt(i);
            if (iOParagraph.getParagraphName() == null || iOParagraph.getParagraphName().length() <= 0) continue;
            vector.addElement(new ParagraphType(iOParagraph.getParagraphName()));
        }
        Object[] objectArray = new ParagraphType[vector.size()];
        vector.toArray(objectArray);
        return objectArray;
    }
}

