/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.wizards;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.wizards.AbstractISPImportPage;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public abstract class AbstractFileLayoutImportPage
extends AbstractISPImportPage<ScreenFD_SL> {
    public AbstractFileLayoutImportPage(String string, String string2) {
        super(string, string2);
    }

    protected IContainer getFDFolder() {
        try {
            IProject iProject = this.getParentResource().getProject();
            IContainer iContainer = PluginUtilities.getFDFolder((IProject)iProject);
            if (iContainer == null) {
                Path path = new Path("fd");
                iContainer = iProject.getFolder((IPath)path);
                if (!iProject.exists((IPath)path)) {
                    PluginUtilities.createFolder((IFolder)((IFolder)iContainer));
                }
            }
            return iContainer;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected abstract boolean getCreateLinks();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFiles(IProgressMonitor iProgressMonitor) {
        try {
            IContainer iContainer = this.getFDFolder();
            iContainer.refreshLocal(2, null);
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("Import file layouts", this.progNames.length);
            }
            boolean bl = false;
            for (int i = 0; i < this.progNames.length; ++i) {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String string = this.progNames[i] + ".idl";
                Path path = new Path(string);
                IFile iFile = iContainer.getFile((IPath)path);
                ScreenFD_SL screenFD_SL = new ScreenFD_SL(iFile);
                screenFD_SL.setImported(true);
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Import file layout '" + screenFD_SL.getFileName() + "'...");
                }
                if (this.importProgramInfo((Object)screenFD_SL, this.progFiles[i])) {
                    boolean bl2;
                    if (this.exists((IResource)iFile)) {
                        IscobolScreenPainterPlugin.getDefault().removeCachedScreenFD_SL(iFile);
                        iFile.delete(true, null);
                    }
                    if (bl2 = this.getCreateLinks() ? PluginUtilities.createLinkFile((IFile)iFile, (URI)this.progFiles[i].toURI()) : PluginUtilities.createFile((IFile)iFile)) {
                        screenFD_SL.save();
                        bl = true;
                    }
                } else {
                    PluginUtilities.removePersistentProperties((IFile)iFile);
                }
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            if (bl) {
                PluginUtilities.saveProjectOptions((IProject)this.getParentResource().getProject());
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (iProgressMonitor != null) {
                iProgressMonitor.done();
            }
        }
    }

    protected boolean validateSelection() {
        if (this.progNames == null) {
            this.setPageInvalid(ISPBundle.getString((String)"no_fd_selected_msg"));
            return false;
        }
        return true;
    }

    protected String getLastImportDirectory() {
        return IscobolEditorPlugin.getDefault().getPreferenceStore().getString("iscobol.fdImportDirectory");
    }

    protected void setLastImportDirectory(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.fdImportDirectory", string);
    }
}

