/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.wizards;

import com.iscobol.filedesigner.wizards.NewDataLayoutCreationPage;
import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class DataLayoutWizard
extends Wizard
implements INewWizard {
    private NewDataLayoutCreationPage page1;
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public DataLayoutWizard() {
        this.setHelpAvailable(false);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    private boolean isIscobolProject(IProject iProject) {
        if (iProject == null) {
            return false;
        }
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected final IProject getSelectedProject() {
        if (this.selection != null && !this.selection.isEmpty()) {
            Object object = this.selection.getFirstElement();
            IProject iProject = null;
            if (object instanceof IResource) {
                iProject = ((IResource)object).getProject();
            } else if (object instanceof IscobolProjectAdapter) {
                iProject = ((IscobolProjectAdapter)object).getProject();
            }
            if (this.isIscobolProject(iProject)) {
                return iProject;
            }
        }
        return null;
    }

    public void addPages() {
        this.page1 = new NewDataLayoutCreationPage(this.getSelection());
        this.page1.setTitle(ISPBundle.getString((String)"new_fd_sl_lbl"));
        this.page1.setDescription(ISPBundle.getString((String)"create_new_fd_sl_lbl"));
        this.page1.setWizard((IWizard)this);
        IProject iProject = this.getSelectedProject();
        try {
            IContainer iContainer = iProject != null ? PluginUtilities.getFDFolder((IProject)iProject) : null;
            this.page1.setFileName(PluginUtilities.getSuggestedFileName((IContainer)iContainer, (String)"fd", (String)".idl"));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.addPage((IWizardPage)this.page1);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        IFile iFile = this.page1.createNewFile();
        if (iFile == null) {
            return false;
        }
        if (iFile.exists()) {
            IIscobolNavigator iIscobolNavigator = PluginUtilities.findDataNavigator();
            if (iIscobolNavigator != null) {
                iIscobolNavigator.refresh((Object)iFile.getProject());
                if (!iIscobolNavigator.isVisible()) {
                    iIscobolNavigator.getViewSite().getPage().bringToTop((IWorkbenchPart)iIscobolNavigator);
                }
                this.getContainer().getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            IWorkbenchWindow iWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
            try {
                IWorkbenchPage iWorkbenchPage;
                if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return true;
    }
}

