/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.filedesigner.wizards;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.plugins.editor.views.IscobolProjectAdapter;
import com.iscobol.plugins.editor.wizards.IscobolNewFilePage;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ide.IDE;

public class NewDataLayoutCreationPage
extends IscobolNewFilePage {
    public NewDataLayoutCreationPage(IStructuredSelection iStructuredSelection) {
        super("newFD_SLPage1", "newFD_SLPage1", iStructuredSelection);
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            if (this.isIscobolProject(iProject)) {
                IContainer iContainer = null;
                try {
                    iContainer = PluginUtilities.getFDFolder((IProject)iProject);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (iContainer != null) {
                    this.setContainerFullPath(iContainer.getFullPath());
                }
            }
        } else if (object instanceof IscobolProjectAdapter) {
            IContainer iContainer = null;
            try {
                iContainer = PluginUtilities.getFDFolder((IProject)((IscobolProjectAdapter)object).getProject());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (iContainer != null) {
                this.setContainerFullPath(iContainer.getFullPath());
            }
        }
    }

    private boolean isIscobolProject(IProject iProject) {
        if (iProject == null) {
            return false;
        }
        try {
            return iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IFile createNewFile() {
        IFile iFile = super.createNewFile();
        if (iFile.exists()) {
            IEditorDescriptor iEditorDescriptor;
            ScreenFD_SL screenFD_SL = new ScreenFD_SL(iFile);
            screenFD_SL.setImported(true);
            String string = iFile.getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (!iFile.isLinked()) {
                screenFD_SL.setFdName(string);
                screenFD_SL.save();
            }
            if ((iEditorDescriptor = IDE.getDefaultEditor((IFile)iFile)) == null || !iEditorDescriptor.getId().equals("iscobolscreenpainter.DataLayoutEditor")) {
                IDE.setDefaultEditor((IFile)iFile, (String)"iscobolscreenpainter.DataLayoutEditor");
            }
        }
        return iFile;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IPath iPath = this.getContainerFullPath();
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (!(iResource instanceof IContainer && this.isIscobolProject(iResource.getProject()) && PluginUtilities.isFDFolder((IContainer)((IContainer)iResource)))) {
            this.setErrorMessage(ISPBundle.getString((String)"file_not_in_fd_fld_msg"));
            return false;
        }
        String string = this.getFileName();
        if (!string.endsWith(".idl")) {
            this.setErrorMessage("File extension must be 'idl'");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

