/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.reportdesigner.UnitConverter;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportConstants;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportDetail;
import com.iscobol.reportdesigner.beans.ReportFooter;
import com.iscobol.reportdesigner.beans.ReportGroup;
import com.iscobol.reportdesigner.beans.ReportGroupFooter;
import com.iscobol.reportdesigner.beans.ReportGroupHeader;
import com.iscobol.reportdesigner.beans.ReportHeader;
import com.iscobol.reportdesigner.beans.ReportPageFooter;
import com.iscobol.reportdesigner.beans.ReportPageHeader;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.beans.ReportTable;
import com.iscobol.reportdesigner.beans.types.PaperFormat;
import com.iscobol.reportdesigner.beans.types.PaperSize;
import com.iscobol.reportdesigner.beans.types.PrintSetup;
import com.iscobol.reportdesigner.beans.types.TableColumnSetting;
import com.iscobol.reportdesigner.beans.types.TableColumnSettingList;
import com.iscobol.reportdesigner.beans.types.TableRowSetting;
import com.iscobol.reportdesigner.beans.types.TableRowSettingList;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class CodeGenerator {
    public static final String ISCOBOL_PREFIX = "is-";
    public static final String IS_HTML_RENDERER = "iscobol-html-renderer";
    public static final String JAVA_HTML_RENDERER = "com.iscobol.htmlexporter.ExtendedHTMLRenderer";
    public static final String FIX = "    ";
    public static final List<String> DEF_EXIT_BLOCK = Arrays.asList("exit paragraph");
    private boolean ansiFormat;
    private boolean decPointComma;
    private CobolFormatter formatter;
    private ColorPalette palette;
    private ScreenProgram screenProgram;
    private Report[] reports;
    private String htmlRendererClassName;
    private Map<String, String> labels;

    public CodeGenerator(ScreenProgram screenProgram, int n) {
        this.screenProgram = screenProgram;
        this.reports = screenProgram.getReports();
        this.palette = screenProgram.getReportPalette();
        this.ansiFormat = this.screenProgram.getAnsiFormat();
        this.decPointComma = this.screenProgram.getDecimalPointComma();
        this.formatter = new CobolFormatter(this.ansiFormat, n);
        this.htmlRendererClassName = this.getCobolClassName("com.iscobol.htmlexporter.ExtendedHTMLRenderer", "iscobol-html-renderer");
    }

    public String getCobolClassName(String string, String string2) {
        String string3 = this.screenProgram.getResourceRegistry().getRepository().getCobolClassName(string, true, this.screenProgram.getProject());
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static String getPrintAssignVarName() {
        return "ptr-dev-name";
    }

    public static String getPrintClassVarName() {
        return "ptr-dev-class";
    }

    public static String getPrintRemoteVarName() {
        return "ptr-dev-remote";
    }

    public static String getHtmlRendererVarName() {
        return "is-htmlrnd";
    }

    public static String getOutputFormatVarName() {
        return "is-output-format";
    }

    public static void getPerformCode(String string, String string2, CobolFormatter cobolFormatter, boolean bl, StringBuilder stringBuilder) {
        if (string != null && string.length() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string2 + "perform " + string + (bl ? "." : "")));
        }
    }

    public String getReportMasterPrintLoopParName(String string) {
        return this.getLabel("is-" + string + "-master-print-loop");
    }

    public String getReportDoPrintRtnParName(String string) {
        return this.getLabel("is-" + string + "-do-print-rtn");
    }

    public String getReportHtmlHeaderParName(String string) {
        return this.getLabel("is-" + string + "-html-header");
    }

    public String getReportHtmlFooterParName(String string) {
        return this.getLabel("is-" + string + "-html-footer");
    }

    public String getReportHtmlPageHeaderParName(String string) {
        return this.getLabel("is-" + string + "-html-page-header");
    }

    public String getReportHtmlPageFooterParName(String string) {
        return this.getLabel("is-" + string + "-html-page-footer");
    }

    public String getReportPrintLoopParName(String string) {
        return this.getLabel("is-" + string + "-print-loop");
    }

    public String getReportHtmlCSSParName(String string) {
        return this.getLabel("is-" + string + "-html-css");
    }

    public String getReportSetupHtmlRendererParName(String string) {
        return this.getLabel("is-" + string + "-setup-html-renderer");
    }

    public String getReportSetupPrintParName(String string) {
        return this.getLabel("is-" + string + "-setup-print");
    }

    public String getReportPreviewParName(String string) {
        return this.getLabel("is-" + string + "-preview");
    }

    public String getReportPrintParName(String string) {
        return this.getLabel("is-" + string + "-print");
    }

    public String getReportPrintXLSParName(String string) {
        return this.getLabel("is-" + string + "-print-xls");
    }

    public String getReportPrintXLSXParName(String string) {
        return this.getLabel("is-" + string + "-print-xlsx");
    }

    public String getReportPrintPDFParName(String string) {
        return this.getLabel("is-" + string + "-print-pdf");
    }

    public String getReportPrintParaParName(String string) {
        return this.getLabel("is-" + string + "-print-para");
    }

    public String getReportDoPrintParName(String string) {
        return this.getLabel("is-" + string + "-do-print");
    }

    public String getReportAllResetParName(String string) {
        return this.getLabel("is-" + string + "-all-reset");
    }

    public String getReportHeaderParName(String string) {
        return this.getLabel("is-" + string + "-header");
    }

    public String getReportFooterParName(String string) {
        return this.getLabel("is-" + string + "-footer");
    }

    public String getReportPageHeaderParName(String string) {
        return this.getLabel("is-" + string + "-page-header");
    }

    public String getReportPageFooterParName(String string) {
        return this.getLabel("is-" + string + "-page-footer");
    }

    public String getReportDetailParName(String string) {
        return this.getLabel("is-" + string + "-detail");
    }

    public String getReportDetailPrintParName(String string) {
        return this.getLabel("is-" + string + "-detail-print");
    }

    public String getReportSectionHeadParName(String string) {
        return this.getLabel("is-" + string + "-sec-head");
    }

    public String getReportSectionFootParName(String string) {
        return this.getLabel("is-" + string + "-sec-foot");
    }

    public String getReportPageBreakRtnParName(String string) {
        return this.getLabel("is-" + string + "-page-break-rtn");
    }

    public String getReportPageFooterOverpageParName(String string) {
        return this.getLabel("is-" + string + "-page-footer-overpage");
    }

    public String getReportSectionPrintRtnParName(String string) {
        return this.getLabel("is-" + string + "-print-rtn");
    }

    public String getReportGroupPrintParName(String string) {
        return this.getLabel("is-" + string + "-group-print");
    }

    public String getReportGroupResetParName(String string) {
        return this.getLabel("is-" + string + "-reset");
    }

    public String getReportGroupHeaderParName(String string) {
        return this.getLabel("is-" + string + "-group-header");
    }

    public String getReportGroupFooterParName(String string) {
        return this.getLabel("is-" + string + "-group-footer");
    }

    public String getReportGroupMustDspParName(String string) {
        return this.getLabel("is-" + string + "-group-mustdsp");
    }

    public String getReportGroupNoMustDspParName(String string) {
        return this.getLabel("is-" + string + "-group-nomustdsp");
    }

    public String getReportPrintToFileParName(String string) {
        return this.getLabel("is-" + string + "-print-tofile");
    }

    public String getReportFillDetailZebraParName(String string) {
        return this.getLabel("is-" + string + "-fill-detail-for-zebra");
    }

    public String getReportZebraColorChangeParName(String string) {
        return this.getLabel("is-" + string + "-zebra-color-change");
    }

    public String getPrintOpenRoutineParName() {
        return this.getLabel("is-printf-open-routine");
    }

    public String getPrintCloseRoutineParName() {
        return this.getLabel("is-printf-close-routine");
    }

    public String getFormatPrintBufRoutineParName() {
        return this.getLabel("is-format-print-buf");
    }

    public static String getReportDoPrintLoopVarName(String string) {
        return string + "-doprintrtn-loop";
    }

    public static String getReportGroupByBufVarName(String string) {
        return "is-" + string + "-groupby-buf";
    }

    public static String getReportCleftOffsetVarName(String string) {
        return "is-" + string + "-cleftoffset";
    }

    public static String getReportHeightVarName(String string) {
        return "is-" + string + "-height";
    }

    public static String getReportPageHeightVarName(String string) {
        return "is-" + string + "-page-height";
    }

    public static String getReportPageWidthVarName(String string) {
        return "is-" + string + "-page-width";
    }

    public static String getReportSectionHeightVarName(String string) {
        return "is-" + string + "-height";
    }

    public static String getReportSectionDefHeightVarName(String string) {
        return "is-" + string + "-def-height";
    }

    public static String getReportDetailBGColorVarName(String string) {
        return "is-" + string + "-bgcolor";
    }

    public static String getReportGroupFooterMustDisplayVarName(String string) {
        return "is-" + string + "-must-display";
    }

    public static String getPrintSelectName() {
        return "printf";
    }

    public static String getPrintRecordName() {
        return "printf-r";
    }

    public static String getPrintRecordSubitemName() {
        return "printf-01";
    }

    public static String getHtmlForegroundVarName() {
        return "is-html-foreground";
    }

    public static String getHtmlBackgroundVarName() {
        return "is-html-background";
    }

    public static String getHtmlFontVarName() {
        return "is-font-fullname";
    }

    public static String getHtmlFontFlagsVarName() {
        return "is-font-flags";
    }

    public static String getHtmlFontBoldVarName() {
        return "is-font-bold";
    }

    public static String getHtmlFontItalicVarName() {
        return "is-font-italic";
    }

    public static String getEscapedTextVarName() {
        return "is-escaped-text";
    }

    public static String getHtmlTableRowColorBufVarName(String string, int n) {
        return string + "-row" + n + "-color-buf";
    }

    public static String getHtmlTableRowForegroundVarName(String string, int n) {
        return "html-fg of " + CodeGenerator.getHtmlTableRowColorBufVarName((String)string, (int)n);
    }

    public static String getHtmlTableRowBackgroundVarName(String string, int n) {
        return "html-fg of " + CodeGenerator.getHtmlTableRowColorBufVarName((String)string, (int)n);
    }

    public static String getHtmlTableColumnColorBufVarName(String string, int n) {
        return string + "-column" + n + "-color-buf";
    }

    public static String getHtmlTableColumnForegroundVarName(String string, int n) {
        return "html-fg of " + CodeGenerator.getHtmlTableColumnColorBufVarName((String)string, (int)n);
    }

    public static String getHtmlTableColumnBackgroundVarName(String string, int n) {
        return "html-fg of " + CodeGenerator.getHtmlTableColumnColorBufVarName((String)string, (int)n);
    }

    public static String getPrintFileStatusVarName() {
        return "stat-printf";
    }

    public void generateFileSectionCode(StringBuilder stringBuilder) {
        stringBuilder.append(this.formatter.formatLine("fd " + CodeGenerator.getPrintSelectName() + " label record omitted."));
        stringBuilder.append(this.formatter.formatLine("01 " + CodeGenerator.getPrintRecordName() + "."));
        stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getPrintRecordSubitemName() + " pic x occurs 1024."));
    }

    public void generateFileControlCode(StringBuilder stringBuilder) {
        stringBuilder.append(this.formatter.formatLine("select " + CodeGenerator.getPrintSelectName()));
        stringBuilder.append(this.formatter.formatLine("   assign to print " + CodeGenerator.getPrintAssignVarName()));
        stringBuilder.append(this.formatter.formatLine("   class is " + CodeGenerator.getPrintClassVarName()));
        stringBuilder.append(this.formatter.formatLine("   file status is " + CodeGenerator.getPrintFileStatusVarName() + "."));
    }

    public void generateWorkingStorageCode(StringBuilder stringBuilder) {
        stringBuilder.append(this.formatter.formatLine("77 " + CodeGenerator.getHtmlRendererVarName() + " object reference " + this.htmlRendererClassName + "."));
        for (Report report : this.reports) {
            this.generateWorkingStorageCode(stringBuilder, report);
        }
    }

    private static int getGroupLen(VariableType variableType) {
        int n = 0;
        if (variableType != null) {
            n = variableType.getPhisicLen();
            int n2 = variableType.getChildCount();
            for (int i = 0; i < n2; ++i) {
                n += CodeGenerator.getGroupLen((VariableType)((VariableType)variableType.getChildAt(i)));
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private void generateWorkingStorageCode(StringBuilder stringBuilder, Report report) {
        void var7_15;
        void var7_13;
        ReportSection[] reportSectionArray = report.getAllSections();
        for (ReportDetail reportDetail : report.getDetails()) {
            String string = IscobolBeanConstants.getRgbString((int)reportDetail.getAwtBackgroundColor().getRGB());
            stringBuilder.append(this.formatter.formatLine("77 " + CodeGenerator.getReportDetailBGColorVarName((String)reportDetail.getName()) + " pic x(7) value \"" + string + "\"."));
        }
        for (ReportDetail string : report.getGroupFooters()) {
            stringBuilder.append(this.formatter.formatLine("77 " + CodeGenerator.getReportGroupFooterMustDisplayVarName((String)string.getName()) + " pic 9 value 0."));
        }
        stringBuilder.append(this.formatter.formatLine("01 " + CodeGenerator.getReportGroupByBufVarName((String)report.getName()) + "."));
        ArrayList arrayList = new ArrayList();
        Object object = report.getGroupHeaders();
        int n = ((ReportGroupHeader[])object).length;
        boolean n2 = false;
        while (var7_13 < n) {
            ReportGroupHeader reportGroupHeader = object[var7_13];
            arrayList.add(reportGroupHeader);
            ++var7_13;
        }
        object = report.getGroupFooters();
        n = ((ReportGroupHeader[])object).length;
        boolean bl = false;
        while (var7_15 < n) {
            ReportGroupHeader reportGroupHeader = object[var7_15];
            arrayList.add(reportGroupHeader);
            ++var7_15;
        }
        if (arrayList.size() > 0) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ReportGroup reportGroup = (ReportGroup)object.next();
                if (reportGroup.getGroupType().getValue() == 0) {
                    void var7_18;
                    int n3;
                    String string = reportGroup.getGroupedBy();
                    if (string == null) {
                        String string2 = "";
                    }
                    if ((n3 = CodeGenerator.getGroupLen((VariableType)this.screenProgram.getProgramVariable((String)var7_18))) == 0) {
                        n3 = 10;
                    }
                    stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getReportGroupByBufVarName((String)reportGroup.getName()) + " pic x(" + n3 + ")."));
                    continue;
                }
                stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getReportGroupByBufVarName((String)reportGroup.getName()) + " pic 9(3) value " + (reportGroup instanceof ReportGroupHeader ? "999." : "1.")));
            }
        } else {
            stringBuilder.append(this.formatter.formatLine("   03 filler pic x."));
        }
        stringBuilder.append(this.formatter.formatLine("77 " + CodeGenerator.getReportDoPrintLoopVarName((String)report.getName()) + " pic 9 value 0."));
        stringBuilder.append(this.formatter.formatLine("01 " + CodeGenerator.getReportHeightVarName((String)report.getName()) + "."));
        object = report.getPaperSize();
        n = UnitConverter.toPixel((float)(object.getHeight() - object.getMarginBottom() - object.getMarginTop()));
        int n4 = UnitConverter.toPixel((float)(object.getWidth() - object.getMarginLeft() - object.getMarginRight()));
        stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " pic 9(4) value " + n + "."));
        stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getReportPageWidthVarName((String)report.getName()) + " pic 9(4) value " + n4 + "."));
        for (ReportSection reportSection : reportSectionArray) {
            int n5 = UnitConverter.toPixel((float)reportSection.getLines());
            stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getReportSectionDefHeightVarName((String)reportSection.getName()) + " pic 9(4) value " + n5 + "."));
            stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getReportSectionHeightVarName((String)reportSection.getName()) + " pic 9(4) value " + n5 + "."));
        }
        stringBuilder.append(this.formatter.formatLine("77 " + CodeGenerator.getReportCleftOffsetVarName((String)report.getName()) + " pic 9(6) value 0."));
        boolean bl2 = true;
        for (ReportSection reportSection : reportSectionArray) {
            for (ReportControl reportControl : reportSection.getComponents()) {
                boolean bl3;
                if (!(reportControl instanceof ReportTable)) continue;
                ReportTable reportTable = (ReportTable)reportControl;
                TableRowSettingList tableRowSettingList = reportTable.getRowSettings();
                for (int i = 0; i < tableRowSettingList.getSettingCount(); ++i) {
                    TableRowSetting tableRowSetting = (TableRowSetting)tableRowSettingList.getSettingAt(i);
                    if (tableRowSetting.getColorVariable() == null || tableRowSetting.getColorVariable().length() <= 0) continue;
                    if (bl3) {
                        stringBuilder.append(this.formatter.formatLine("01 " + reportControl.getName() + "-html-color-buf."));
                        bl3 = false;
                    }
                    stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getHtmlTableRowColorBufVarName((String)reportTable.getName(), (int)(i + 1)) + "."));
                    stringBuilder.append(this.formatter.formatLine("      05 html-fg pic x(7)."));
                    stringBuilder.append(this.formatter.formatLine("      05 html-bg pic x(7)."));
                }
                TableColumnSettingList tableColumnSettingList = reportTable.getColumnSettings();
                for (int i = 0; i < tableColumnSettingList.getSettingCount(); ++i) {
                    TableColumnSetting tableColumnSetting = (TableColumnSetting)tableColumnSettingList.getSettingAt(i);
                    if (tableColumnSetting.getColorVariable() == null || tableColumnSetting.getColorVariable().length() <= 0) continue;
                    if (bl3) {
                        stringBuilder.append(this.formatter.formatLine("01 " + reportControl.getName() + "-html-color-buf."));
                        bl3 = false;
                    }
                    stringBuilder.append(this.formatter.formatLine("   03 " + CodeGenerator.getHtmlTableColumnColorBufVarName((String)reportTable.getName(), (int)(i + 1)) + "."));
                    stringBuilder.append(this.formatter.formatLine("      05 html-fg pic x(7)."));
                    stringBuilder.append(this.formatter.formatLine("      05 html-bg pic x(7)."));
                }
            }
        }
    }

    private void generateOpenPrintRoutine(StringBuilder stringBuilder) {
        stringBuilder.append(this.formatter.formatLine(this.getPrintOpenRoutineParName() + "."));
        stringBuilder.append(this.formatter.formatLine("    open output " + CodeGenerator.getPrintSelectName() + " with no rewind."));
        stringBuilder.append(this.formatter.formatLine("    if not valid-printf"));
        stringBuilder.append(this.formatter.formatLine("       move \"printf\" to is-err-file"));
        stringBuilder.append(this.formatter.formatLine("    end-if."));
    }

    private void generateClosePrintRoutine(StringBuilder stringBuilder) {
        stringBuilder.append(this.formatter.formatLine(this.getPrintCloseRoutineParName() + "."));
        stringBuilder.append(this.formatter.formatLine("    close " + CodeGenerator.getPrintSelectName() + "."));
    }

    private void generateFormatPrintBufRoutine(StringBuilder stringBuilder) {
        stringBuilder.append(this.formatter.formatLine(this.getFormatPrintBufRoutineParName() + "."));
        stringBuilder.append(this.formatter.formatLine("    initialize new-print-data-size print-buf-size print-buf-length print-buf-trail-spaces print-buf-total-spaces print-buf-count"));
        stringBuilder.append(this.formatter.formatLine("    set print-buf-length to length of print-buf"));
        stringBuilder.append(this.formatter.formatLine("    inspect print-buf tallying print-buf-trail-spaces for trailing spaces"));
        stringBuilder.append(this.formatter.formatLine("    inspect print-buf tallying print-buf-total-spaces for all spaces"));
        stringBuilder.append(this.formatter.formatLine("    compute print-buf-size = print-buf-length - print-buf-trail-spaces"));
        stringBuilder.append(this.formatter.formatLine("    if print-buf-size = 0 or print-buf-total-spaces = print-buf-trail-spaces"));
        stringBuilder.append(this.formatter.formatLine("       move print-buf to new-print-data"));
        stringBuilder.append(this.formatter.formatLine("       inspect new-print-data replacing trailing spaces by low-values"));
        stringBuilder.append(this.formatter.formatLine("       exit paragraph"));
        stringBuilder.append(this.formatter.formatLine("    end-if"));
        stringBuilder.append(this.formatter.formatLine("    initialize new-print-data"));
        stringBuilder.append(this.formatter.formatLine("    perform varying print-buf-count from 1 by 1 until print-buf-count > print-buf-size or new-print-data-size > print-buf-length"));
        stringBuilder.append(this.formatter.formatLine("       move print-buf(print-buf-count : 1) to print-buf-char"));
        stringBuilder.append(this.formatter.formatLine("       if print-buf-char = \" \""));
        stringBuilder.append(this.formatter.formatLine("          string new-print-data delimited by spaces \"&nbsp;\" delimited by size into new-print-data"));
        stringBuilder.append(this.formatter.formatLine("          end-string"));
        stringBuilder.append(this.formatter.formatLine("          add 6 to new-print-data-size"));
        stringBuilder.append(this.formatter.formatLine("       else"));
        stringBuilder.append(this.formatter.formatLine("          string new-print-data delimited by spaces print-buf-char  delimited by size into new-print-data"));
        stringBuilder.append(this.formatter.formatLine("          end-string"));
        stringBuilder.append(this.formatter.formatLine("          add 1 to new-print-data-size"));
        stringBuilder.append(this.formatter.formatLine("       end-if"));
        stringBuilder.append(this.formatter.formatLine("    end-perform"));
        stringBuilder.append(this.formatter.formatLine("    inspect new-print-data replacing trailing spaces by low-values."));
    }

    public void generateProcedureCode(StringBuilder stringBuilder) {
        for (Report report : this.reports) {
            this.generateProcedureCode(stringBuilder, report);
        }
        this.generateOpenPrintRoutine(stringBuilder);
        this.generateClosePrintRoutine(stringBuilder);
        this.generateFormatPrintBufRoutine(stringBuilder);
    }

    private void generateHtmlHeaderRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportHtmlHeaderParName(report.getName()) + "."));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)false, (String[])new String[]{"'<html>'"});
        String string = report.getTitle();
        if (string == null) {
            string = "";
        }
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)false, (String[])new String[]{"'<head><title> " + string + " </title></head>'"});
        CodeGenerator.getPerformCode((String)this.getReportHtmlCSSParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        String string2 = "";
        if (report.getDetailCount() > 0) {
            string2 = IscobolBeanConstants.getRgbString((int)report.getDetailAt(0).getAwtBackgroundColor().getRGB());
        }
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'<body style=\"background-color:" + string2 + ";\">'"});
    }

    private void generateHtmlFooterRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportHtmlFooterParName(report.getName()) + "."));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)false, (String[])new String[]{"'</body>'"});
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'</html>'"});
    }

    private void generateHtmlCSSRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportHtmlCSSParName(report.getName()) + "."));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'<style type=\"text/css\">'"});
        for (ReportSection reportSection : report.getAllSections()) {
            for (ReportControl reportControl : reportSection.getComponents()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                FontType fontType = reportControl.getFont();
                reportControl.getCSSFontAttributes(stringBuilder2, fontType);
                if (stringBuilder2.length() > 0 && fontType != null && fontType.isStandardFont()) {
                    stringBuilder.append(this.formatter.formatLine("    " + this.htmlRendererClassName + ":>getFontValue(\"" + fontType.getDisplayName() + "\" as string " + CodeGenerator.getHtmlFontVarName() + ")"));
                    CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'   ." + CodeGenerator.getCSSClassName((ReportControl)reportControl) + " {" + reportControl.getCSSAttributes() + " '", CodeGenerator.getHtmlFontVarName(), "'}'"});
                } else {
                    CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'   ." + CodeGenerator.getCSSClassName((ReportControl)reportControl) + " {" + reportControl.getCSSAttributes() + stringBuilder2 + "}'"});
                }
                reportControl.writeNestedCSSAttributes(this.formatter, stringBuilder, "    ");
            }
        }
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'</style>'"});
    }

    private void generatePrintToFileRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportPrintToFileParName(report.getName()) + "."));
        String string = report.getOutputFileNameVariable();
        if (string != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    if function lower-case(" + string + "(1:11)) = \"@[display]:\""));
            stringBuilder.append(this.formatter.formatLine("       set " + CodeGenerator.getPrintRemoteVarName() + " to true"));
            stringBuilder.append(this.formatter.formatLine("       move " + string + "(12:) to " + CodeGenerator.getPrintAssignVarName()));
            stringBuilder.append(this.formatter.formatLine("    else"));
            stringBuilder.append(this.formatter.formatLine("       set " + CodeGenerator.getPrintRemoteVarName() + " to false"));
            stringBuilder.append(this.formatter.formatLine("       move " + string + " to " + CodeGenerator.getPrintAssignVarName()));
            stringBuilder.append(this.formatter.formatLine("    end-if."));
        } else {
            boolean bl;
            String string2 = report.getOutputFileName();
            if (string2 == null || string2.length() == 0) {
                string2 = report.getName() + ".html";
            }
            if (bl = string2.toLowerCase().startsWith("@[display]:")) {
                string2 = string2.substring(11);
            }
            stringBuilder.append(this.formatter.formatLine("    set " + CodeGenerator.getPrintRemoteVarName() + " to " + bl + "."));
            stringBuilder.append(this.formatter.formatLine("    move \"" + string2 + "\" to " + CodeGenerator.getPrintAssignVarName() + "."));
        }
        stringBuilder.append(this.formatter.formatLine("    move 1 to current-col"));
        stringBuilder.append(this.formatter.formatLine("    move 0 to " + CodeGenerator.getReportCleftOffsetVarName((String)report.getName())));
        stringBuilder.append(this.formatter.formatLine("    move 0 to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("    move 1 to ntopcolumnnum"));
        CodeGenerator.getPerformCode((String)this.getPrintOpenRoutineParName(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)report.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportHtmlHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportHtmlPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportPrintLoopParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportHtmlFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)report.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getPrintCloseRoutineParName(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generatePrintLoopRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportPrintLoopParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move 1 to tmp-printornot"));
        stringBuilder.append(this.formatter.formatLine("    move 0 to cnt-inpagepixels"));
        stringBuilder.append(this.formatter.formatLine("    move 1 to is-pagenum"));
        stringBuilder.append(this.formatter.formatLine("    move 1 to is-pagenum-sys"));
        stringBuilder.append(this.formatter.formatLine("    move 0 to sys-endprimaryfd"));
        stringBuilder.append(this.formatter.formatLine("    move " + (report.getFooter() != null && report.getFooter().getPrintAfterPageFooter() ? "1" : "0") + " to report-footer-print-after-page"));
        if (report.getGroupHeaderCount() > 0 || report.getGroupFooterCount() > 0) {
            CodeGenerator.getPerformCode((String)this.getReportAllResetParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        if (report.getHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportMasterPrintLoopParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        if (report.getPageHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        if (report.getGroupFooterCount() > 0) {
            CodeGenerator.getPerformCode((String)this.getReportGroupMustDspParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            CodeGenerator.getPerformCode((String)this.getReportGroupFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        if (report.getFooter() != null) {
            stringBuilder.append(this.formatter.formatLine("    if report-footer-print-after-page = 0"));
            CodeGenerator.getPerformCode((String)this.getReportFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    end-if"));
        }
        if (CodeGenerator.isZebraEnabled((Report)report)) {
            CodeGenerator.getPerformCode((String)this.getReportFillDetailZebraParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        stringBuilder.append(this.formatter.formatLine("    if report-footer-print-after-page = 0"));
        stringBuilder.append(this.formatter.formatLine("       move 1 to sys-endprimaryfd"));
        if (report.getPageFooter() != null) {
            stringBuilder.append(this.formatter.formatLine("       compute cnt-pixels = (is-pagenum-sys * " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + ") - " + CodeGenerator.getReportSectionDefHeightVarName((String)report.getPageFooter().getName())));
        }
        stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to cnt-inpagepixels"));
        CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    end-if."));
        if (report.getFooter() != null) {
            stringBuilder.append(this.formatter.formatLine("    if report-footer-print-after-page = 1"));
            CodeGenerator.getPerformCode((String)this.getReportFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    end-if."));
        }
    }

    private void generateHtmlPageHeaderRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportHtmlPageHeaderParName(report.getName()) + "."));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'   <!-- html page header -->'"});
        String string = "";
        if (report.getWatermarkStyle().getValue() != 0 && report.getWatermark() != null) {
            string = " background:url(" + report.getWatermark().getFileName() + ") ";
            if (report.getWatermarkStyle().getValue() == 1) {
                string = string + "no-";
            }
            string = string + "repeat scroll center;";
        }
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'   <div style=\"position:absolute; top:'", "cnt-pixels", "'; left:'", CodeGenerator.getReportCleftOffsetVarName((String)report.getName()), "'; height:'", CodeGenerator.getReportPageHeightVarName((String)report.getName()), "'; width:'", CodeGenerator.getReportPageWidthVarName((String)report.getName()), "' ;" + string + "\">'"});
    }

    private void generateHtmlPageFooterRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportHtmlPageFooterParName(report.getName()) + "."));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'   </div>'"});
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'   <!-- end html page header -->'"});
    }

    private void generateReportHeaderRoutine(StringBuilder stringBuilder, Report report) {
        ReportHeader reportHeader = report.getHeader();
        stringBuilder.append(this.formatter.formatLine(this.getReportHeaderParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)reportHeader.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)reportHeader.getVisible(), (String)reportHeader.getVisibleVariable());
        CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (String)reportHeader.getPrintCondition());
        if (!reportHeader.getPrintBeforePageHeader() && report.getPageHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportHeader.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    add " + CodeGenerator.getReportSectionHeightVarName((String)reportHeader.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("    add " + CodeGenerator.getReportSectionHeightVarName((String)reportHeader.getName()) + " to cnt-inpagepixels."));
        if (reportHeader.getPrintBeforePageHeader() && report.getPageHeader() != null) {
            stringBuilder.append(this.formatter.formatLine("    move 1 to report-header-print-before-page."));
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    move 0 to report-header-print-before-page."));
        }
        if (reportHeader.getSkipPageAfterPrint()) {
            stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to cnt-inpagepixels."));
            CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)reportHeader.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportFooterRoutine(StringBuilder stringBuilder, Report report) {
        ReportFooter reportFooter = report.getFooter();
        stringBuilder.append(this.formatter.formatLine(this.getReportFooterParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)reportFooter.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)reportFooter.getVisible(), (String)reportFooter.getVisibleVariable());
        CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (String)reportFooter.getPrintCondition());
        if (report.getPageHeader() != null && reportFooter.getSkipPageBeforePrint().getValue() != 0) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to current-height"));
        } else {
            stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportFooter.getName()) + " to current-height"));
        }
        CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        if (report.getPageHeader() != null && (!reportFooter.getPrintAfterPageFooter() && reportFooter.getSkipPageBeforePrint().getValue() != 2 || reportFooter.getPrintAfterPageFooter() && reportFooter.getSkipPageBeforePrint().getValue() == 1)) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportFooter.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    add " + CodeGenerator.getReportSectionHeightVarName((String)reportFooter.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("    add " + CodeGenerator.getReportSectionHeightVarName((String)reportFooter.getName()) + " to cnt-inpagepixels."));
        CodeGenerator.getPerformCode((String)reportFooter.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportPageHeaderRoutine(StringBuilder stringBuilder, Report report) {
        ReportPageHeader reportPageHeader = report.getPageHeader();
        stringBuilder.append(this.formatter.formatLine(this.getReportPageHeaderParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)reportPageHeader.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)reportPageHeader.getVisible(), (String)reportPageHeader.getVisibleVariable());
        CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (String)reportPageHeader.getPrintCondition());
        stringBuilder.append(this.formatter.formatLine("    if (cnt-inpagepixels < " + CodeGenerator.getReportSectionHeightVarName((String)reportPageHeader.getName()) + ") or (report-header-print-before-page = 1)"));
        CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportPageHeader.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportPageHeader.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("       if report-header-print-before-page = 1"));
        stringBuilder.append(this.formatter.formatLine("          add " + CodeGenerator.getReportSectionHeightVarName((String)reportPageHeader.getName()) + " to cnt-inpagepixels"));
        stringBuilder.append(this.formatter.formatLine("       else"));
        stringBuilder.append(this.formatter.formatLine("          move " + CodeGenerator.getReportSectionHeightVarName((String)reportPageHeader.getName()) + " to cnt-inpagepixels"));
        stringBuilder.append(this.formatter.formatLine("       end-if"));
        stringBuilder.append(this.formatter.formatLine("    end-if."));
        CodeGenerator.getPerformCode((String)reportPageHeader.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportPageFooterRoutine(StringBuilder stringBuilder, Report report) {
        Object object;
        ReportPageFooter reportPageFooter = report.getPageFooter();
        stringBuilder.append(this.formatter.formatLine(this.getReportPageFooterParName(report.getName()) + "."));
        if (reportPageFooter != null) {
            CodeGenerator.getPerformCode((String)reportPageFooter.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            object = new ArrayList();
            object.add("compute tmp-pixels = cnt-inpagepixels + current-height");
            object.add("if tmp-pixels > " + CodeGenerator.getReportPageHeightVarName((String)report.getName()));
            object.add("   perform " + this.getReportPageBreakRtnParName(report.getName()));
            object.add("end-if");
            object.add("exit paragraph");
            CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)reportPageFooter.getVisible(), (String)reportPageFooter.getVisibleVariable(), (List)object);
            CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (String)reportPageFooter.getPrintCondition(), (List)object);
        }
        object = "    compute tmp-pixels = cnt-inpagepixels + current-height";
        if (reportPageFooter != null) {
            object = (String)object + " + " + CodeGenerator.getReportSectionHeightVarName((String)reportPageFooter.getName());
        }
        stringBuilder.append(this.formatter.formatLine((String)object));
        stringBuilder.append(this.formatter.formatLine("    if tmp-pixels > " + CodeGenerator.getReportPageHeightVarName((String)report.getName())));
        object = "       compute cnt-pixels = (is-pagenum-sys * " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + ")";
        if (reportPageFooter != null) {
            object = (String)object + " - " + CodeGenerator.getReportSectionHeightVarName((String)reportPageFooter.getName());
        }
        stringBuilder.append(this.formatter.formatLine((String)object));
        object = "       compute cnt-inpagepixels = " + CodeGenerator.getReportPageHeightVarName((String)report.getName());
        if (reportPageFooter != null) {
            object = (String)object + " - " + CodeGenerator.getReportSectionDefHeightVarName((String)reportPageFooter.getName());
        }
        stringBuilder.append(this.formatter.formatLine((String)object));
        if (reportPageFooter != null) {
            CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportPageFooter.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportPageBreakRtnParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        if (reportPageFooter != null) {
            stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportPageFooter.getName()) + " to " + CodeGenerator.getReportSectionHeightVarName((String)reportPageFooter.getName())));
        }
        stringBuilder.append(this.formatter.formatLine("    end-if."));
        if (reportPageFooter != null) {
            CodeGenerator.getPerformCode((String)reportPageFooter.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportPageFooterOverpageRoutine(StringBuilder stringBuilder, Report report) {
        ReportPageFooter reportPageFooter = report.getPageFooter();
        stringBuilder.append(this.formatter.formatLine(this.getReportPageFooterOverpageParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move 0 to rpt-return-value"));
        String string = "    compute tmp-pixels = cnt-inpagepixels + current-height";
        if (reportPageFooter != null) {
            string = string + " + " + CodeGenerator.getReportSectionHeightVarName((String)reportPageFooter.getName());
        }
        stringBuilder.append(this.formatter.formatLine(string));
        stringBuilder.append(this.formatter.formatLine("    if tmp-pixels + 1 >= " + CodeGenerator.getReportPageHeightVarName((String)report.getName())));
        stringBuilder.append(this.formatter.formatLine("       move 1 to rpt-return-value"));
        stringBuilder.append(this.formatter.formatLine("    end-if."));
    }

    private void generateReportDetailRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportDetailParName(report.getName()) + "."));
        for (ReportDetail reportDetail : report.getDetails()) {
            CodeGenerator.getPerformCode((String)this.getReportDetailPrintParName(reportDetail.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportGroupHeaderRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupHeaderParName(report.getName()) + "."));
        for (ReportGroupHeader reportGroupHeader : report.getGroupHeaders()) {
            CodeGenerator.getPerformCode((String)this.getReportGroupPrintParName(reportGroupHeader.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportGroupFooterRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupFooterParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)this.getReportGroupPrintParName(report.getGroupFooterAt(report.getGroupFooterCount() - 1).getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportGroupMustDspRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupMustDspParName(report.getName()) + "."));
        for (ReportGroupFooter reportGroupFooter : report.getGroupFooters()) {
            stringBuilder.append(this.formatter.formatLine("    move 1 to " + CodeGenerator.getReportGroupFooterMustDisplayVarName((String)reportGroupFooter.getName()) + "."));
        }
    }

    private void generateReportGroupNoMustDspRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupNoMustDspParName(report.getName()) + "."));
        for (ReportGroupFooter reportGroupFooter : report.getGroupFooters()) {
            stringBuilder.append(this.formatter.formatLine("    move 0 to " + CodeGenerator.getReportGroupFooterMustDisplayVarName((String)reportGroupFooter.getName()) + "."));
        }
    }

    private void generateReportAllResetRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportAllResetParName(report.getName()) + "."));
        for (ReportGroupHeader reportGroupHeader : report.getGroupHeaders()) {
            CodeGenerator.getPerformCode((String)this.getReportGroupResetParName(reportGroupHeader.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        for (ReportGroupHeader reportGroupHeader : report.getGroupFooters()) {
            CodeGenerator.getPerformCode((String)this.getReportGroupResetParName(reportGroupHeader.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportDoPrintRtnRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportDoPrintRtnParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move 1 to tmp-printornot."));
        if (report.getGroupFooterCount() > 0) {
            CodeGenerator.getPerformCode((String)this.getReportGroupFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        if (report.getDetailCount() > 0) {
            stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportSectionHeightVarName((String)report.getDetailAt(0).getName()) + " to current-height"));
        }
        CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        if (report.getPageHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        if (report.getGroupHeaderCount() > 0) {
            CodeGenerator.getPerformCode((String)this.getReportGroupHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        if (report.getDetailCount() > 0) {
            CodeGenerator.getPerformCode((String)this.getReportDetailParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportPageBreakRtnRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportPageBreakRtnParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    if current-col < ntopcolumnnum"));
        stringBuilder.append(this.formatter.formatLine("       compute cnt-pixels = (is-pagenum-sys - 1) * " + CodeGenerator.getReportPageHeightVarName((String)report.getName())));
        stringBuilder.append(this.formatter.formatLine("       compute " + CodeGenerator.getReportCleftOffsetVarName((String)report.getName()) + " = " + CodeGenerator.getReportCleftOffsetVarName((String)report.getName()) + " + detail-width"));
        stringBuilder.append(this.formatter.formatLine("       move 0 to cnt-inpagepixels"));
        stringBuilder.append(this.formatter.formatLine("       add 1 to current-col"));
        stringBuilder.append(this.formatter.formatLine("    else"));
        stringBuilder.append(this.formatter.formatLine("       compute cnt-pixels = is-pagenum-sys * " + CodeGenerator.getReportPageHeightVarName((String)report.getName())));
        stringBuilder.append(this.formatter.formatLine("       move 0 to " + CodeGenerator.getReportCleftOffsetVarName((String)report.getName())));
        stringBuilder.append(this.formatter.formatLine("       move 0 to cnt-inpagepixels"));
        stringBuilder.append(this.formatter.formatLine("       add 1 to is-pagenum-sys"));
        stringBuilder.append(this.formatter.formatLine("       move 1 to current-col"));
        stringBuilder.append(this.formatter.formatLine("    end-if"));
        CodeGenerator.getPerformCode((String)this.getReportHtmlPageFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    if sys-endprimaryfd = 0"));
        CodeGenerator.getPerformCode((String)this.getReportHtmlPageHeaderParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    end-if."));
    }

    private void generateReportFillDetailZebraRoutine(StringBuilder stringBuilder, Report report) {
        ReportDetail reportDetail = report.getDetailAt(0);
        stringBuilder.append(this.formatter.formatLine(this.getReportFillDetailZebraParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move 0 to rpt-return-value"));
        stringBuilder.append(this.formatter.formatLine("    perform until rpt-return-value > 0"));
        stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportDetail.getName()) + " to current-height"));
        if (report.getPageFooter() != null || CodeGenerator.isZebraEnabled((Report)report)) {
            CodeGenerator.getPerformCode((String)this.getReportPageFooterOverpageParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        stringBuilder.append(this.formatter.formatLine("       if rpt-return-value > 0"));
        stringBuilder.append(this.formatter.formatLine("          exit perform"));
        stringBuilder.append(this.formatter.formatLine("       end-if"));
        CodeGenerator.getPerformCode((String)this.getReportSectionHeadParName(reportDetail.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportSectionFootParName(reportDetail.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + " to cnt-inpagepixels"));
        CodeGenerator.getPerformCode((String)this.getReportZebraColorChangeParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    end-perform."));
    }

    private void generateReportZebraColorChangeRoutine(StringBuilder stringBuilder, Report report) {
        ReportDetail reportDetail = report.getDetailAt(0);
        String string = IscobolBeanConstants.getRgbString((int)reportDetail.getAwtBackgroundColor().getRGB());
        String string2 = IscobolBeanConstants.getRgbString((int)reportDetail.getZebra().getBackgroundColor(this.palette).getRGB());
        String string3 = CodeGenerator.getReportDetailBGColorVarName((String)reportDetail.getName());
        stringBuilder.append(this.formatter.formatLine(this.getReportZebraColorChangeParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    evaluate " + string3));
        stringBuilder.append(this.formatter.formatLine("    when \"" + string + "\""));
        stringBuilder.append(this.formatter.formatLine("       move \"" + string2 + "\" to " + string3));
        stringBuilder.append(this.formatter.formatLine("    when \"" + string2 + "\""));
        stringBuilder.append(this.formatter.formatLine("       move \"" + string + "\" to " + string3));
        stringBuilder.append(this.formatter.formatLine("    end-evaluate."));
    }

    private void generateReportDetailPrintRoutine(StringBuilder stringBuilder, Report report, int n) {
        ReportDetail reportDetail = report.getDetailAt(n);
        boolean bl = n == 0 && !reportDetail.getZebra().isDisabled();
        stringBuilder.append(this.formatter.formatLine(this.getReportDetailPrintParName(reportDetail.getName()) + "."));
        int n2 = UnitConverter.toPixel((float)reportDetail.getSize());
        stringBuilder.append(this.formatter.formatLine("    move " + n2 + " to detail-width"));
        CodeGenerator.getPerformCode((String)reportDetail.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)reportDetail.getVisible(), (String)reportDetail.getVisibleVariable());
        CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (String)reportDetail.getPrintCondition());
        stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + " to current-height"));
        CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        if (report.getPageHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportDetail.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    add " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("    add " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + " to cnt-inpagepixels"));
        stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportDetail.getName()) + " to " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + "."));
        if (reportDetail.getSkipPageAfterPrint()) {
            if (bl) {
                CodeGenerator.getPerformCode((String)this.getReportFillDetailZebraParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
            }
            stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to current-height."));
            CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportSectionHeightVarName((String)reportDetail.getName()) + " to current-height."));
        }
        if (bl) {
            CodeGenerator.getPerformCode((String)this.getReportZebraColorChangeParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)reportDetail.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportGroupHeaderPrintRoutine(StringBuilder stringBuilder, Report report, int n) {
        ReportGroupHeader reportGroupHeader = report.getGroupHeaderAt(n);
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupPrintParName(reportGroupHeader.getName()) + "."));
        CodeGenerator.getPerformCode((String)reportGroupHeader.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        boolean bl = reportGroupHeader.getGroupType().getValue() == 0;
        stringBuilder.append(this.formatter.formatLine("    if " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupHeader.getName()) + (bl ? " not = " : " > ") + reportGroupHeader.getGroupedBy()));
        if (!bl) {
            stringBuilder.append(this.formatter.formatLine("       move 1 to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupHeader.getName())));
        }
        stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportGroupHeader.getName()) + " to current-height"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("move " + reportGroupHeader.getGroupedBy() + " to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupHeader.getName()));
        arrayList.add("exit paragraph");
        CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"       ", (boolean)reportGroupHeader.getVisible(), (String)reportGroupHeader.getVisibleVariable(), arrayList);
        CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"       ", (String)reportGroupHeader.getPrintCondition());
        if (reportGroupHeader.getSkipPageBeforePrint()) {
            stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to current-height"));
        }
        CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        if (report.getPageHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportGroupHeader.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportGroupHeader.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportGroupHeader.getName()) + " to cnt-inpagepixels"));
        if (reportGroupHeader.getSkipPageAfterPrint()) {
            stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to current-height"));
            CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        if (n < report.getGroupHeaderCount() - 1) {
            CodeGenerator.getPerformCode((String)this.getReportGroupResetParName(report.getGroupHeaderAt(n + 1).getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        if (bl) {
            stringBuilder.append(this.formatter.formatLine("       move " + reportGroupHeader.getGroupedBy() + " to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupHeader.getName())));
        }
        stringBuilder.append(this.formatter.formatLine("    end-if."));
        if (!bl) {
            stringBuilder.append(this.formatter.formatLine("    add 1 to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupHeader.getName()) + "."));
        }
        CodeGenerator.getPerformCode((String)reportGroupHeader.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportGroupHeaderResetRoutine(StringBuilder stringBuilder, Report report, int n) {
        ReportGroupHeader reportGroupHeader = report.getGroupHeaderAt(n);
        boolean bl = reportGroupHeader.getGroupType().getValue() == 0;
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupResetParName(reportGroupHeader.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move " + (bl ? "high-values to " : "999 to ") + CodeGenerator.getReportGroupByBufVarName((String)reportGroupHeader.getName()) + "."));
        if (n < report.getGroupHeaderCount() - 1) {
            CodeGenerator.getPerformCode((String)this.getReportGroupResetParName(report.getGroupHeaderAt(n + 1).getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportGroupFooterPrintRoutine(StringBuilder stringBuilder, Report report, int n) {
        ReportGroupFooter reportGroupFooter = report.getGroupFooterAt(n);
        boolean bl = reportGroupFooter.getGroupType().getValue() == 0;
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupPrintParName(reportGroupFooter.getName()) + "."));
        CodeGenerator.getPerformCode((String)reportGroupFooter.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("move " + reportGroupFooter.getGroupedBy() + " to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName()));
        arrayList.add("exit paragraph");
        CodeGenerator.getVisibleCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)reportGroupFooter.getVisible(), (String)reportGroupFooter.getVisibleVariable(), arrayList);
        CodeGenerator.getPrintConditionCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (String)reportGroupFooter.getPrintCondition());
        if (bl) {
            stringBuilder.append(this.formatter.formatLine("    if ((" + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName()) + " not = " + reportGroupFooter.getGroupedBy() + ") and (" + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName()) + " not = high-values)) or (" + CodeGenerator.getReportGroupFooterMustDisplayVarName((String)reportGroupFooter.getName()) + " not = 0)"));
        } else {
            stringBuilder.append(this.formatter.formatLine("    if (" + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName()) + " > " + reportGroupFooter.getGroupedBy() + ") or (" + CodeGenerator.getReportGroupFooterMustDisplayVarName((String)reportGroupFooter.getName()) + " not = 0)"));
        }
        if (n > 0) {
            CodeGenerator.getPerformCode((String)this.getReportGroupMustDspParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            CodeGenerator.getPerformCode((String)this.getReportGroupPrintParName(report.getGroupFooterAt(n - 1).getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            CodeGenerator.getPerformCode((String)this.getReportGroupNoMustDspParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportGroupFooter.getName()) + " to current-height"));
        if (reportGroupFooter.getSkipPageBeforePrint()) {
            stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to current-height"));
        }
        CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        if (report.getPageHeader() != null) {
            CodeGenerator.getPerformCode((String)this.getReportPageHeaderParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportSectionPrintRtnParName(reportGroupFooter.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportGroupFooter.getName()) + " to cnt-pixels"));
        stringBuilder.append(this.formatter.formatLine("       add " + CodeGenerator.getReportSectionHeightVarName((String)reportGroupFooter.getName()) + " to cnt-inpagepixels"));
        if (reportGroupFooter.getSkipPageAfterPrint()) {
            stringBuilder.append(this.formatter.formatLine("       move " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to cnt-inpagepixels"));
            CodeGenerator.getPerformCode((String)this.getReportPageFooterParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        stringBuilder.append(this.formatter.formatLine("       move " + (bl ? reportGroupFooter.getGroupedBy() : "1") + " to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName())));
        if (n > 0) {
            stringBuilder.append(this.formatter.formatLine("    else"));
            CodeGenerator.getPerformCode((String)this.getReportGroupPrintParName(report.getGroupFooterAt(n - 1).getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        }
        stringBuilder.append(this.formatter.formatLine("    end-if"));
        stringBuilder.append(this.formatter.formatLine("    " + (bl ? "move " + reportGroupFooter.getGroupedBy() : "add 1") + " to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName()) + "."));
        CodeGenerator.getPerformCode((String)reportGroupFooter.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateReportGroupFooterResetRoutine(StringBuilder stringBuilder, Report report, int n) {
        ReportGroupFooter reportGroupFooter = report.getGroupFooterAt(n);
        boolean bl = reportGroupFooter.getGroupType().getValue() == 0;
        stringBuilder.append(this.formatter.formatLine(this.getReportGroupResetParName(reportGroupFooter.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move " + (bl ? "high-values" : "1") + " to " + CodeGenerator.getReportGroupByBufVarName((String)reportGroupFooter.getName())));
        stringBuilder.append(this.formatter.formatLine("    move 0 to " + CodeGenerator.getReportGroupFooterMustDisplayVarName((String)reportGroupFooter.getName()) + "."));
        if (n > 0) {
            CodeGenerator.getPerformCode((String)this.getReportGroupResetParName(report.getGroupFooterAt(n - 1).getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
    }

    private void generateReportSectionHeadRoutine(StringBuilder stringBuilder, ReportSection reportSection) {
        int n = UnitConverter.toPixel((float)reportSection.getSize());
        FontType fontType = reportSection.getFont(true);
        String string = IscobolBeanConstants.getRgbString((int)reportSection.getAwtForegroundColor().getRGB());
        String string2 = reportSection instanceof ReportDetail ? "' " + CodeGenerator.getReportDetailBGColorVarName((String)reportSection.getName()) + " '" : IscobolBeanConstants.getRgbString((int)reportSection.getAwtBackgroundColor().getRGB());
        stringBuilder.append(this.formatter.formatLine(this.getReportSectionHeadParName(reportSection.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    compute tmp-pixels = cnt-inpagepixels - high-offset-in"));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'      <!-- " + reportSection.getName() + " head -->'"});
        if (fontType != null && fontType.isStandardFont()) {
            stringBuilder.append(this.formatter.formatLine("    " + this.htmlRendererClassName + ":>getFontValue(\"" + fontType.getDisplayName() + "\" as string " + CodeGenerator.getHtmlFontVarName() + ")"));
            CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'      <div style=\"position:absolute; top:'", "tmp-pixels", "'; left:0; width:" + n + "; '", CodeGenerator.getHtmlFontVarName(), "' color:" + string + "; background-color:" + string2 + "; \">'"});
        } else {
            CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'      <div style=\"position:absolute; top:'", "tmp-pixels", "'; left:0; width:" + n + "; font-size:" + Math.round(fontType.getSize()) + "pt; font-family:" + CodeGenerator.getFontFamily((FontType)fontType) + "; color:" + string + "; background-color:" + string2 + "; \">'"});
        }
    }

    private void generateReportSectionFootRoutine(StringBuilder stringBuilder, ReportSection reportSection) {
        stringBuilder.append(this.formatter.formatLine(this.getReportSectionFootParName(reportSection.getName()) + "."));
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'         <div style=\"position:relative; height:'", CodeGenerator.getReportSectionHeightVarName((String)reportSection.getName()), "';\"> </div>'"});
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'      </div>'"});
        CodeGenerator.getWriteCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)"    ", (boolean)true, (String[])new String[]{"'      <!-- " + reportSection.getName() + " foot -->'"});
    }

    private static ReportControl[] sortReportComponents(ReportControl[] reportControlArray) {
        Arrays.sort(reportControlArray, new /* Unavailable Anonymous Inner Class!! */);
        return reportControlArray;
    }

    private void generateReportSectionPrintRtnRoutine(StringBuilder stringBuilder, ReportSection reportSection) {
        stringBuilder.append(this.formatter.formatLine(this.getReportSectionPrintRtnParName(reportSection.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    move 0 to section-high-stack"));
        stringBuilder.append(this.formatter.formatLine("    move " + CodeGenerator.getReportSectionDefHeightVarName((String)reportSection.getName()) + " to " + CodeGenerator.getReportSectionHeightVarName((String)reportSection.getName())));
        CodeGenerator.getPerformCode((String)this.getReportSectionHeadParName(reportSection.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        for (ReportControl reportControl : CodeGenerator.sortReportComponents((ReportControl[])reportSection.getComponents())) {
            if (!reportControl.getVisible()) continue;
            CodeGenerator.getPerformCode((String)reportControl.getBeforePrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            StringBuilder stringBuilder2 = new StringBuilder();
            if (reportControl.getVisibleVariable() != null && reportControl.getVisibleVariable().length() > 0) {
                stringBuilder2.append(reportControl.getVisibleVariable() + " not = 0");
            }
            if (reportControl.getPrintCondition() != null && reportControl.getPrintCondition().length() > 0) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(" and ");
                }
                stringBuilder2.append("( " + reportControl.getPrintCondition() + " )");
            }
            String string = "    ";
            if (stringBuilder2.length() > 0) {
                CodeGenerator.writeHandWrittenCode((CobolFormatter)this.formatter, (StringBuilder)stringBuilder, (String)string, (String)("if " + stringBuilder2.toString()));
                string = string + "   ";
            }
            stringBuilder.append(reportControl.getHTMLCode(this.formatter, string, this.htmlRendererClassName));
            if (stringBuilder2.length() > 0) {
                stringBuilder.append(this.formatter.formatLine("    end-if."));
            }
            CodeGenerator.getPerformCode((String)reportControl.getAfterPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        }
        CodeGenerator.getPerformCode((String)this.getReportSectionFootParName(reportSection.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void putLabel(String string, String string2) {
        this.labels.put(string2, string);
    }

    private String getLabel(String string) {
        String string2 = string;
        if (this.labels != null && (string2 = (String)this.labels.get(string)) == null) {
            string2 = string;
        }
        return string2;
    }

    private void createAcubenchReportLabels(Report report) {
        String string;
        String string2;
        String string3 = report.getName();
        String string4 = "Acu-" + string3 + "-";
        String string5 = "Acu-RPT-" + string3 + "-";
        this.putLabel(string5 + "MASTER-PRINT-LOOP", this.getReportMasterPrintLoopParName(string3));
        this.putLabel(string4 + "PRINT-PARA", this.getReportSetupHtmlRendererParName(string3));
        this.putLabel(string4 + "SETUP-PRINT", this.getReportSetupPrintParName(string3));
        this.putLabel(string4 + "PREVIEW", this.getReportPreviewParName(string3));
        this.putLabel(string4 + "PRINT", this.getReportPrintParName(string3));
        this.putLabel(string4 + "DO-PRINT", this.getReportDoPrintParName(string3));
        this.putLabel(string4 + "HTML-HEADER", this.getReportHtmlHeaderParName(string3));
        this.putLabel(string4 + "HTML-FOOTER", this.getReportHtmlFooterParName(string3));
        this.putLabel(string4 + "HTML-CSS", this.getReportHtmlCSSParName(string3));
        this.putLabel(string4 + "PRINT-TOFILE", this.getReportPrintToFileParName(string3));
        this.putLabel(string5 + "PRINT-LOOP", this.getReportPrintLoopParName(string3));
        this.putLabel(string4 + "HTML-PAGE-HEADER", this.getReportHtmlPageHeaderParName(string3));
        this.putLabel(string4 + "HTML-PAGE-FOOTER", this.getReportHtmlPageFooterParName(string3));
        this.putLabel(string5 + "REPORT-HEADER", report.getHeader() != null ? this.getReportHeaderParName(string3) : null);
        this.putLabel(string5 + "REPORT-FOOTER", report.getFooter() != null ? this.getReportFooterParName(string3) : null);
        this.putLabel(string5 + "PAGE-HEADER", report.getPageHeader() != null ? this.getReportPageHeaderParName(string3) : null);
        this.putLabel(string5 + "PAGE-FOOTER", this.getReportPageFooterParName(string3));
        this.putLabel(string5 + "PAGE-FOOTER-OVERPAGE", report.getPageFooter() != null || CodeGenerator.isZebraEnabled((Report)report) ? this.getReportPageFooterOverpageParName(string3) : null);
        this.putLabel(string4 + "PAGE-BREAK-RTN", this.getReportPageBreakRtnParName(string3));
        this.putLabel(string5 + "DETAIL", report.getDetailCount() > 0 ? this.getReportDetailParName(string3) : null);
        this.putLabel(string5 + "GROUP-HEADER", report.getGroupHeaderCount() > 0 ? this.getReportGroupHeaderParName(string3) : null);
        this.putLabel(string5 + "GROUP-FOOTER", report.getGroupFooterCount() > 0 ? this.getReportGroupFooterParName(string3) : null);
        this.putLabel(string5 + "GROUP-MUSTDSP", report.getGroupFooterCount() > 0 ? this.getReportGroupMustDspParName(string3) : null);
        this.putLabel(string5 + "GROUP-NOMUSTDSP", report.getGroupFooterCount() > 0 ? this.getReportGroupNoMustDspParName(string3) : null);
        this.putLabel(string5 + "ALL-RESET", report.getGroupFooterCount() > 0 || report.getGroupHeaderCount() > 0 ? this.getReportAllResetParName(string3) : null);
        this.putLabel(string5 + "DO-PRINT-RTN", this.getReportDoPrintRtnParName(string3));
        boolean bl = CodeGenerator.isZebraEnabled((Report)report);
        this.putLabel(string4 + "FILL-DETAIL-FOR-ZEBRA", bl ? this.getReportFillDetailZebraParName(string3) : null);
        this.putLabel(string4 + "ZEBRA-COLOR-CHANGE", bl ? this.getReportZebraColorChangeParName(string3) : null);
        for (ReportDetail reportDetail : report.getDetails()) {
            string2 = reportDetail.getName();
            string = "Acu-" + string2 + "-";
            this.putLabel(string + "DETAIL-PRINT", this.getReportDetailPrintParName(string2));
        }
        for (ReportDetail reportDetail : report.getGroupHeaders()) {
            string2 = reportDetail.getName();
            string = "Acu-" + string2 + "-";
            this.putLabel(string + "GROUP-PRINT", this.getReportGroupPrintParName(string2));
            this.putLabel(string + "GROUP-RESET", this.getReportGroupResetParName(string2));
        }
        for (ReportDetail reportDetail : report.getGroupFooters()) {
            string2 = reportDetail.getName();
            string = "Acu-" + string2 + "-";
            this.putLabel(string + "GROUP-PRINT", this.getReportGroupPrintParName(string2));
            this.putLabel(string + "GROUP-RESET", this.getReportGroupResetParName(string2));
        }
        for (ReportDetail reportDetail : report.getAllSections()) {
            string2 = reportDetail.getName();
            string = "Acu-" + string2 + "-";
            this.putLabel(string + "SEC-HEAD", this.getReportSectionHeadParName(string2));
            this.putLabel(string + "SEC-FOOT", this.getReportSectionFootParName(string2));
            this.putLabel(string + "PRINT-RTN", this.getReportSectionPrintRtnParName(string2));
        }
    }

    public void createAcubenchLabels(Map<String, String> map) {
        this.labels = map;
        this.createAcubenchLabels();
    }

    private void createAcubenchLabels() {
        this.putLabel("Acu-PRINTF-OPEN-ROUTINE", this.getPrintOpenRoutineParName());
        this.putLabel("Acu-PRINTF-CLOSE-ROUTINE", this.getPrintCloseRoutineParName());
        this.putLabel("Acu-Format-Print-Buf", this.getFormatPrintBufRoutineParName());
        for (Report report : this.reports) {
            this.createAcubenchReportLabels(report);
        }
    }

    private void generatePreviewRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportPreviewParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)this.getReportPrintToFileParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportSetupHtmlRendererParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPreview ( true as boolean )."));
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>open."));
    }

    private void generateDoPrintRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportDoPrintParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPreview ( false as boolean )."));
        stringBuilder.append(this.formatter.formatLine("    evaluate " + CodeGenerator.getOutputFormatVarName()));
        stringBuilder.append(this.formatter.formatLine("    when \"XLS\""));
        stringBuilder.append(this.formatter.formatLine("       " + CodeGenerator.getHtmlRendererVarName() + ":>exportXLS"));
        stringBuilder.append(this.formatter.formatLine("    when \"XLSX\""));
        stringBuilder.append(this.formatter.formatLine("       " + CodeGenerator.getHtmlRendererVarName() + ":>exportXLSX"));
        stringBuilder.append(this.formatter.formatLine("    when \"PDF\""));
        stringBuilder.append(this.formatter.formatLine("       " + CodeGenerator.getHtmlRendererVarName() + ":>exportPDF"));
        stringBuilder.append(this.formatter.formatLine("    when other"));
        stringBuilder.append(this.formatter.formatLine("       " + CodeGenerator.getHtmlRendererVarName() + ":>open"));
        stringBuilder.append(this.formatter.formatLine("    end-evaluate."));
    }

    private void generatePrintRoutine(StringBuilder stringBuilder, Report report, String string, String string2) {
        stringBuilder.append(this.formatter.formatLine(string + "."));
        stringBuilder.append(this.formatter.formatLine("    move " + string2 + " to " + CodeGenerator.getOutputFormatVarName() + "."));
        CodeGenerator.getPerformCode((String)this.getReportPrintParaParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generatePrintParaRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportPrintParaParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)this.getReportPrintToFileParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportSetupHtmlRendererParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportDoPrintParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
    }

    private void generateSetupPrintRoutine(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportSetupPrintParName(report.getName()) + "."));
        CodeGenerator.getPerformCode((String)this.getReportSetupHtmlRendererParName(report.getName()), (String)"    ", (CobolFormatter)this.formatter, (boolean)true, (StringBuilder)stringBuilder);
        stringBuilder.append(this.formatter.formatLine("    if " + CodeGenerator.getHtmlRendererVarName() + ":>setup (is-paper-sizeint is-paper-margin)"));
        stringBuilder.append(this.formatter.formatLine("       compute is-paper-tmp = is-paper-width - is-margin-right - is-margin-left"));
        stringBuilder.append(this.formatter.formatLine("       set " + CodeGenerator.getReportPageWidthVarName((String)report.getName()) + " to " + CodeGenerator.getHtmlRendererVarName() + ":>inchToPixel ( is-paper-tmp as float )"));
        stringBuilder.append(this.formatter.formatLine("       compute is-paper-tmp = is-paper-height - is-margin-bottom - is-margin-top"));
        stringBuilder.append(this.formatter.formatLine("       set " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to " + CodeGenerator.getHtmlRendererVarName() + ":>inchToPixel ( is-paper-tmp as float )"));
        CodeGenerator.getPerformCode((String)this.getReportPrintToFileParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        CodeGenerator.getPerformCode((String)this.getReportDoPrintParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
        PaperSize paperSize = report.getPaperSize();
        int n = UnitConverter.toPixel((float)(paperSize.getHeight() - paperSize.getMarginBottom() - paperSize.getMarginTop()));
        int n2 = UnitConverter.toPixel((float)(paperSize.getWidth() - paperSize.getMarginLeft() - paperSize.getMarginRight()));
        stringBuilder.append(this.formatter.formatLine("       set " + CodeGenerator.getReportPageWidthVarName((String)report.getName()) + " to " + n2));
        stringBuilder.append(this.formatter.formatLine("       set " + CodeGenerator.getReportPageHeightVarName((String)report.getName()) + " to " + n));
        stringBuilder.append(this.formatter.formatLine("    end-if."));
    }

    private void generateSetupHtmlRendererRoutine(StringBuilder stringBuilder, Report report) {
        int n;
        PrintSetup printSetup;
        String string;
        String string2;
        String string3;
        stringBuilder.append(this.formatter.formatLine(this.getReportSetupHtmlRendererParName(report.getName()) + "."));
        stringBuilder.append(this.formatter.formatLine("    set " + CodeGenerator.getHtmlRendererVarName() + " to " + this.htmlRendererClassName + ":>new."));
        String string4 = report.getOutputFileNameVariable();
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    if function lower-case(" + string4 + "(1:11)) = \"@[display]:\""));
            stringBuilder.append(this.formatter.formatLine("       move " + string4 + " to " + CodeGenerator.getPrintAssignVarName()));
            stringBuilder.append(this.formatter.formatLine("    else"));
            stringBuilder.append(this.formatter.formatLine("       call \"c$fullname\" using " + string4 + " " + CodeGenerator.getPrintAssignVarName()));
            stringBuilder.append(this.formatter.formatLine("    end-if."));
        } else {
            string3 = report.getOutputFileName();
            if (string3 == null || string3.length() == 0) {
                string3 = report.getName() + ".html";
            }
            if (string3.toLowerCase().startsWith("@[display]:")) {
                stringBuilder.append(this.formatter.formatLine("    move \"" + string3 + "\" to " + CodeGenerator.getPrintAssignVarName() + "."));
            } else {
                stringBuilder.append(this.formatter.formatLine("    call \"c$fullname\" using \"" + string3 + "\" " + CodeGenerator.getPrintAssignVarName() + "."));
            }
        }
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPaperUrl ( " + CodeGenerator.getPrintAssignVarName() + " as string )."));
        string3 = report.getPaperSize();
        PaperFormat paperFormat = string3.getFormat();
        boolean bl = string3.isLandscape();
        if (paperFormat.getValue() == 0) {
            if (bl) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setCustomPaperSize ( " + IscobolBeanConstants.floatToString((float)string3.getHeight(), (boolean)this.decPointComma, (boolean)true) + " as float " + IscobolBeanConstants.floatToString((float)string3.getWidth(), (boolean)this.decPointComma, (boolean)true) + " as float )."));
            } else {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setCustomPaperSize ( " + IscobolBeanConstants.floatToString((float)string3.getWidth(), (boolean)this.decPointComma, (boolean)true) + " as float " + IscobolBeanConstants.floatToString((float)string3.getHeight(), (boolean)this.decPointComma, (boolean)true) + " as float )."));
            }
        } else {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPaperSize ( \"" + paperFormat.getName() + "\" as string )."));
        }
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setLandscape ( " + bl + " as boolean )."));
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setMargins ( " + IscobolBeanConstants.floatToString((float)string3.getMarginLeft(), (boolean)this.decPointComma, (boolean)true) + " as double " + IscobolBeanConstants.floatToString((float)string3.getMarginRight(), (boolean)this.decPointComma, (boolean)true) + " as double " + IscobolBeanConstants.floatToString((float)string3.getMarginTop(), (boolean)this.decPointComma, (boolean)true) + " as double " + IscobolBeanConstants.floatToString((float)string3.getMarginBottom(), (boolean)this.decPointComma, (boolean)true) + " as double )."));
        String string5 = string3.getHeader();
        if (string5 == null) {
            string5 = "";
        }
        if ((string2 = string3.getFooter()) == null) {
            string2 = "";
        }
        stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setHeaderFooter ( \"" + string5 + "\" as string \"" + string2 + "\" as string )."));
        if (report.getTitle() != null && report.getTitle().length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPaperTitle ( \"" + report.getTitle() + "\" as string )."));
        }
        if ((string = (printSetup = report.getPrintSetup()).getPrinterNameVariable()) != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPrinter ( " + string + " as string )."));
        } else {
            string = printSetup.getPrinterName();
            if (string != null && !string.equals("$$default_printer$$")) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setPrinter ( \"" + string + "\" as string )."));
            }
        }
        string = printSetup.getCopiesVariable();
        if (string != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setCopies ( " + string + " as int)."));
        } else {
            n = printSetup.getCopies();
            if (n > 1) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setCopies ( " + n + " )."));
            }
        }
        string = printSetup.getCollateVariable();
        if (string != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setCollate ( " + string + " as int)."));
        } else {
            n = printSetup.getCollate().getValue();
            if (n != 0) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setCollate ( " + (n == 1 ? "1" : "0") + " )."));
            }
        }
        string = printSetup.getChromacityVariable();
        if (string != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setChromacity ( " + string + " as int)."));
        } else {
            n = printSetup.getChromacity().getValue();
            if (n != 0) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setChromacity ( " + (n == 1 ? "0" : "1") + " )."));
            }
        }
        string = printSetup.getQualityVariable();
        if (string != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setQuality ( " + string + " as int)."));
        } else {
            n = 0;
            switch (printSetup.getQuality().getValue()) {
                case 3: {
                    n = -1;
                    break;
                }
                case 1: {
                    n = -4;
                    break;
                }
                case 2: {
                    n = -2;
                }
            }
            if (n != 0) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setQuality ( " + n + " )."));
            }
        }
        string = printSetup.getSidesVariable();
        if (string != null && string.length() > 0) {
            stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setDuplexPrinting ( " + string + " as int)."));
        } else {
            n = 0;
            switch (printSetup.getSides().getValue()) {
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    n = 1;
                }
            }
            if (n != 0) {
                stringBuilder.append(this.formatter.formatLine("    " + CodeGenerator.getHtmlRendererVarName() + ":>setDuplexPrinting ( " + n + " )."));
            }
        }
    }

    private static boolean isZebraEnabled(Report report) {
        return report.getDetailCount() > 0 && !report.getDetailAt(0).getZebra().isDisabled();
    }

    private void generateProcedureCode(StringBuilder stringBuilder, Report report) {
        int n;
        ReportSection[] reportSectionArray = report.getAllSections();
        this.generateHtmlHeaderRoutine(stringBuilder, report);
        this.generateHtmlFooterRoutine(stringBuilder, report);
        this.generateHtmlCSSRoutine(stringBuilder, report);
        this.generateSetupHtmlRendererRoutine(stringBuilder, report);
        this.generateSetupPrintRoutine(stringBuilder, report);
        this.generatePreviewRoutine(stringBuilder, report);
        this.generateDoPrintRoutine(stringBuilder, report);
        this.generatePrintRoutine(stringBuilder, report, this.getReportPrintParName(report.getName()), "spaces");
        this.generatePrintRoutine(stringBuilder, report, this.getReportPrintXLSParName(report.getName()), "\"XLS\"");
        this.generatePrintRoutine(stringBuilder, report, this.getReportPrintXLSXParName(report.getName()), "\"XLSX\"");
        this.generatePrintRoutine(stringBuilder, report, this.getReportPrintPDFParName(report.getName()), "\"PDF\"");
        this.generatePrintParaRoutine(stringBuilder, report);
        this.generatePrintToFileRoutine(stringBuilder, report);
        this.generatePrintLoopRoutine(stringBuilder, report);
        this.generateHtmlPageHeaderRoutine(stringBuilder, report);
        this.generateHtmlPageFooterRoutine(stringBuilder, report);
        if (report.getHeader() != null) {
            this.generateReportHeaderRoutine(stringBuilder, report);
        }
        if (report.getFooter() != null) {
            this.generateReportFooterRoutine(stringBuilder, report);
        }
        if (report.getPageHeader() != null) {
            this.generateReportPageHeaderRoutine(stringBuilder, report);
        }
        this.generateReportPageFooterRoutine(stringBuilder, report);
        if (report.getPageFooter() != null || CodeGenerator.isZebraEnabled((Report)report)) {
            this.generateReportPageFooterOverpageRoutine(stringBuilder, report);
        }
        if (report.getDetailCount() > 0) {
            this.generateReportDetailRoutine(stringBuilder, report);
        }
        if (report.getGroupHeaderCount() > 0 || report.getGroupFooterCount() > 0) {
            if (report.getGroupHeaderCount() > 0) {
                this.generateReportGroupHeaderRoutine(stringBuilder, report);
            }
            if (report.getGroupFooterCount() > 0) {
                this.generateReportGroupFooterRoutine(stringBuilder, report);
                this.generateReportGroupMustDspRoutine(stringBuilder, report);
                this.generateReportGroupNoMustDspRoutine(stringBuilder, report);
            }
            this.generateReportAllResetRoutine(stringBuilder, report);
        }
        this.generateReportDoPrintRtnRoutine(stringBuilder, report);
        this.generateReportPageBreakRtnRoutine(stringBuilder, report);
        if (CodeGenerator.isZebraEnabled((Report)report)) {
            this.generateReportFillDetailZebraRoutine(stringBuilder, report);
            this.generateReportZebraColorChangeRoutine(stringBuilder, report);
        }
        for (n = 0; n < report.getDetailCount(); ++n) {
            this.generateReportDetailPrintRoutine(stringBuilder, report, n);
        }
        for (n = 0; n < report.getGroupHeaderCount(); ++n) {
            this.generateReportGroupHeaderPrintRoutine(stringBuilder, report, n);
            this.generateReportGroupHeaderResetRoutine(stringBuilder, report, n);
        }
        for (n = 0; n < report.getGroupFooterCount(); ++n) {
            this.generateReportGroupFooterPrintRoutine(stringBuilder, report, n);
            this.generateReportGroupFooterResetRoutine(stringBuilder, report, n);
        }
        for (ReportSection reportSection : reportSectionArray) {
            this.generateReportSectionHeadRoutine(stringBuilder, reportSection);
            this.generateReportSectionFootRoutine(stringBuilder, reportSection);
            this.generateReportSectionPrintRtnRoutine(stringBuilder, reportSection);
        }
    }

    public void getProgramParNames(Vector<String> vector, Map<String, String> map) {
        this.labels = map;
        if (this.screenProgram.getProgramNamingConvention() == 1) {
            this.createAcubenchLabels();
        }
        vector.add(this.getPrintOpenRoutineParName());
        vector.add(this.getPrintCloseRoutineParName());
        vector.add(this.getFormatPrintBufRoutineParName());
        for (Report report : this.reports) {
            this.getReportParNames(report, vector);
        }
    }

    public String[] getReportParNames(Report report, Map<String, String> map) {
        this.labels = map;
        if (this.screenProgram.getProgramNamingConvention() == 1) {
            this.createAcubenchReportLabels(report);
        }
        Vector vector = new Vector();
        this.getReportParNames(report, vector);
        return vector.toArray(new String[vector.size()]);
    }

    private void getReportParNames(Report report, Vector<String> vector) {
        String string;
        String string2 = report.getName();
        vector.add(this.getReportSetupHtmlRendererParName(string2));
        vector.add(this.getReportSetupPrintParName(string2));
        vector.add(this.getReportPreviewParName(string2));
        vector.add(this.getReportPrintParName(string2));
        vector.add(this.getReportPrintParaParName(string2));
        vector.add(this.getReportPrintXLSParName(string2));
        vector.add(this.getReportPrintXLSXParName(string2));
        vector.add(this.getReportPrintPDFParName(string2));
        vector.add(this.getReportDoPrintParName(string2));
        vector.add(this.getReportHtmlHeaderParName(string2));
        vector.add(this.getReportHtmlFooterParName(string2));
        vector.add(this.getReportHtmlCSSParName(string2));
        vector.add(this.getReportPrintToFileParName(string2));
        vector.add(this.getReportPrintLoopParName(string2));
        vector.add(this.getReportHtmlPageHeaderParName(string2));
        vector.add(this.getReportHtmlPageFooterParName(string2));
        if (report.getHeader() != null) {
            vector.add(this.getReportHeaderParName(string2));
        }
        if (report.getFooter() != null) {
            vector.add(this.getReportFooterParName(string2));
        }
        if (report.getPageHeader() != null) {
            vector.add(this.getReportPageHeaderParName(string2));
        }
        vector.add(this.getReportPageFooterParName(string2));
        vector.add(this.getReportPageBreakRtnParName(string2));
        if (report.getDetailCount() > 0) {
            vector.add(this.getReportDetailParName(string2));
        }
        if (report.getGroupHeaderCount() > 0) {
            vector.add(this.getReportGroupHeaderParName(string2));
        }
        if (report.getGroupFooterCount() > 0) {
            vector.add(this.getReportGroupFooterParName(string2));
            vector.add(this.getReportGroupMustDspParName(string2));
            vector.add(this.getReportGroupNoMustDspParName(string2));
        }
        if (report.getGroupFooterCount() > 0 || report.getGroupHeaderCount() > 0) {
            vector.add(this.getReportAllResetParName(string2));
        }
        vector.add(this.getReportDoPrintRtnParName(string2));
        boolean bl = CodeGenerator.isZebraEnabled((Report)report);
        if (bl) {
            vector.add(this.getReportFillDetailZebraParName(string2));
            vector.add(this.getReportZebraColorChangeParName(string2));
        }
        for (ReportDetail reportDetail : report.getDetails()) {
            string = reportDetail.getName();
            vector.add(this.getReportDetailPrintParName(string));
        }
        for (ReportDetail reportDetail : report.getGroupHeaders()) {
            string = reportDetail.getName();
            vector.add(this.getReportGroupPrintParName(string));
            vector.add(this.getReportGroupResetParName(string));
        }
        for (ReportDetail reportDetail : report.getGroupFooters()) {
            string = reportDetail.getName();
            vector.add(this.getReportGroupPrintParName(string));
            vector.add(this.getReportGroupResetParName(string));
        }
        for (ReportDetail reportDetail : report.getAllSections()) {
            string = reportDetail.getName();
            vector.add(this.getReportSectionHeadParName(string));
            vector.add(this.getReportSectionFootParName(string));
            vector.add(this.getReportSectionPrintRtnParName(string));
        }
    }

    public void generateProcedureMasterParagraphCode(StringBuilder stringBuilder, Report report) {
        stringBuilder.append(this.formatter.formatLine(this.getReportMasterPrintLoopParName(report.getName()) + "."));
        if (report.getBeforeDoPrint() != null && report.getBeforeDoPrint().length() > 0 || report.getAfterDoPrint() != null && report.getAfterDoPrint().length() > 0) {
            CodeGenerator.getPerformCode((String)report.getBeforeDoPrint(), (String)"    ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    perform until " + CodeGenerator.getReportDoPrintLoopVarName((String)report.getName()) + " = 0"));
            CodeGenerator.getPerformCode((String)this.getReportDoPrintRtnParName(report.getName()), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            CodeGenerator.getPerformCode((String)report.getAfterDoPrint(), (String)"       ", (CobolFormatter)this.formatter, (boolean)false, (StringBuilder)stringBuilder);
            stringBuilder.append(this.formatter.formatLine("    end-perform."));
        }
    }

    public static void getWriteCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, boolean bl, String ... stringArray) {
        if (stringArray.length == 1) {
            stringBuilder.append(cobolFormatter.formatLine(string + "move " + stringArray[0] + " to print-buf"));
        } else {
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.append("string");
            for (String string2 : stringArray) {
                stringBuilder2.append(' ').append(string2);
            }
            stringBuilder2.append(" delimited by size into print-buf");
            stringBuilder.append(cobolFormatter.formatLine(stringBuilder2.toString()));
        }
        stringBuilder.append(cobolFormatter.formatLine(string + "write " + CodeGenerator.getPrintRecordName() + " from print-buf after advancing 1 line"));
        stringBuilder.append(cobolFormatter.formatLine(string + "initialize print-buf to default" + (bl ? "." : "")));
    }

    private static void getPrintConditionCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
        CodeGenerator.getPrintConditionCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (String)string2, (List)DEF_EXIT_BLOCK);
    }

    private static void getPrintConditionCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2, List<String> list) {
        if (string2 != null && string2.length() > 0) {
            CodeGenerator.writeHandWrittenCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (String)("if not (" + string2 + ")"));
            for (String string3 : list) {
                stringBuilder.append(cobolFormatter.formatLine(string + "   " + string3));
            }
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
        }
    }

    private static void writeHandWrittenCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
        StringReader stringReader = new StringReader(string2);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuilder.append(cobolFormatter.formatLine(string + string3));
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void getVisibleCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, boolean bl, String string2) {
        CodeGenerator.getVisibleCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)bl, (String)string2, (List)DEF_EXIT_BLOCK);
    }

    public static void getVisibleCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, boolean bl, String string2, List<String> list) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + "if " + string2 + " = 0"));
            for (String string3 : list) {
                stringBuilder.append(cobolFormatter.formatLine(string + "   " + string3));
            }
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
        } else if (!bl) {
            stringBuilder.append(cobolFormatter.formatComment("visible is false"));
            for (String string4 : list) {
                stringBuilder.append(cobolFormatter.formatLine(string + string4));
            }
        }
    }

    public static String getFontFamily(FontType fontType) {
        Font font = fontType.getFont();
        return font != null ? font.getName() : fontType.getName();
    }

    public static String getCSSClassName(ReportControl reportControl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ReportConstants.getSectionId((ReportSection)((ReportSection)reportControl.getParent()));
        stringBuilder.append(string);
        stringBuilder.append("-");
        stringBuilder.append(ReportConstants.getShortTypeName((int)reportControl.getType()));
        stringBuilder.append("-");
        stringBuilder.append(reportControl.getName());
        return stringBuilder.toString();
    }

    public static String escapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        block8: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '\u20ac': {
                    stringBuilder.append("&euro;");
                    continue block8;
                }
                case '\u00a0': {
                    stringBuilder.append("&nbsp;");
                    continue block8;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }
}

