/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner;

import com.iscobol.reportdesigner.ReportDesignerDataPool;
import com.iscobol.reportdesigner.ReportEditorInput;
import com.iscobol.reportdesigner.ReportEditorPaletteFactory;
import com.iscobol.reportdesigner.ReportOutlinePage;
import com.iscobol.reportdesigner.ReportPaletteModel;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import com.iscobol.reportdesigner.parts.ReportComponentEditPart;
import com.iscobol.reportdesigner.parts.ReportComponentsEditPartFactory;
import com.iscobol.reportdesigner.parts.ReportEditPart;
import com.iscobol.reportdesigner.parts.ReportSectionEditPart;
import com.iscobol.reportdesigner.policies.ReportComponentXYLayoutEditPolicy;
import com.iscobol.screenpainter.BaseGraphicalEditor;
import com.iscobol.screenpainter.BaseGraphicalEditorOutlinePage;
import com.iscobol.screenpainter.DataPool;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgramEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.ui.IEditorInput;

public class ReportEditor
extends BaseGraphicalEditor {
    private ReportPaletteModel paletteModel;
    private ReportOutlinePage outlinePage;
    private ReportModel root;
    private DataPool dataPool = new ReportDesignerDataPool();

    public ReportEditor(ScreenProgramEditor screenProgramEditor) {
        super(screenProgramEditor);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteModel == null) {
            this.paletteModel = ReportEditorPaletteFactory.createPalette();
        }
        return this.paletteModel;
    }

    public BaseGraphicalEditorOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new ReportOutlinePage((BaseGraphicalEditor)this);
        }
        return this.outlinePage;
    }

    public Object getModel() {
        return this.root;
    }

    public ReportModel getReportModel() {
        return this.root;
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        ReportEditorInput reportEditorInput = (ReportEditorInput)iEditorInput;
        Report report = reportEditorInput.getReport();
        this.screenProgram = reportEditorInput.getProgram();
        this.root = new ReportModel((ReportElement)report, this.screenProgram);
        this.paletteModel.setDrawersVisible(this.screenProgram.getProject());
        this.setPartName(report.getName());
    }

    protected EditPartFactory createEditPartFactory() {
        return new ReportComponentsEditPartFactory();
    }

    protected void moveComponent(List list, int n, boolean bl) {
        ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"move");
        Command command = null;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (!(editPart instanceof ReportComponentEditPart)) continue;
            ReportComponentEditPart reportComponentEditPart = (ReportComponentEditPart)editPart;
            ReportComponentXYLayoutEditPolicy reportComponentXYLayoutEditPolicy = (ReportComponentXYLayoutEditPolicy)reportComponentEditPart.getParent().getEditPolicy((Object)"LayoutEditPolicy");
            ReportComponentModel reportComponentModel = (ReportComponentModel)reportComponentEditPart.getModel();
            Rectangle rectangle = new Rectangle(reportComponentModel.getX(), reportComponentModel.getY(), reportComponentModel.getWidth(), reportComponentModel.getHeight());
            ReportSectionModel reportSectionModel = (ReportSectionModel)reportComponentModel.getParent();
            Dimension dimension = new Dimension(reportSectionModel.getWidth(), reportSectionModel.getHeight());
            int n2 = IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getInt("iscobolrd.grid.width");
            int n3 = IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getInt("iscobolrd.grid.height");
            switch (n) {
                case 0x1000002: {
                    if (rectangle.y + rectangle.height >= dimension.height) {
                        return;
                    }
                    rectangle.y += n3;
                    int n4 = rectangle.y + rectangle.height - dimension.height;
                    if (n4 <= 0) break;
                    rectangle.y -= n4;
                    break;
                }
                case 0x1000001: {
                    if (rectangle.y <= 0) {
                        return;
                    }
                    rectangle.y -= n3;
                    if (rectangle.y >= 0) break;
                    rectangle.y = 0;
                    break;
                }
                case 0x1000003: {
                    if (rectangle.x <= 0) {
                        return;
                    }
                    rectangle.x -= n2;
                    if (rectangle.x >= 0) break;
                    rectangle.x = 0;
                    break;
                }
                case 0x1000004: {
                    if (rectangle.x + rectangle.width >= dimension.width) {
                        return;
                    }
                    rectangle.x += n2;
                    int n4 = rectangle.x + rectangle.width - dimension.width;
                    if (n4 <= 0) break;
                    rectangle.x -= n4;
                    break;
                }
                default: {
                    return;
                }
            }
            Command command2 = reportComponentXYLayoutEditPolicy.createChangeConstraintCommand(changeBoundsRequest, (EditPart)reportComponentEditPart, (Object)rectangle, false);
            if (command == null) {
                command = command2;
                continue;
            }
            command = command.chain(command2);
        }
        if (command != null) {
            this.getGraphicalViewer().getEditDomain().getCommandStack().execute(command);
        }
    }

    protected void resizeComponent(List list, int n, boolean bl) {
        ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"resize");
        Command command = null;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (!(editPart instanceof ReportComponentEditPart)) continue;
            ReportComponentEditPart reportComponentEditPart = (ReportComponentEditPart)editPart;
            ReportComponentXYLayoutEditPolicy reportComponentXYLayoutEditPolicy = (ReportComponentXYLayoutEditPolicy)reportComponentEditPart.getParent().getEditPolicy((Object)"LayoutEditPolicy");
            ReportComponentModel reportComponentModel = (ReportComponentModel)reportComponentEditPart.getModel();
            Rectangle rectangle = new Rectangle(reportComponentModel.getX(), reportComponentModel.getY(), reportComponentModel.getWidth(), reportComponentModel.getHeight());
            int n2 = IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getInt("iscobolrd.grid.width");
            int n3 = IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getInt("iscobolrd.grid.height");
            switch (n) {
                case 0x1000002: {
                    rectangle.height += n3;
                    break;
                }
                case 0x1000001: {
                    if (rectangle.height <= 1) {
                        return;
                    }
                    rectangle.height -= n3;
                    if (rectangle.height >= 1) break;
                    rectangle.height = 1;
                    break;
                }
                case 0x1000003: {
                    if (rectangle.width <= 1) {
                        return;
                    }
                    rectangle.width -= n2;
                    if (rectangle.width >= 1) break;
                    rectangle.width = 1;
                    break;
                }
                case 0x1000004: {
                    rectangle.width += n2;
                    break;
                }
                default: {
                    return;
                }
            }
            Command command2 = reportComponentXYLayoutEditPolicy.createChangeConstraintCommand(changeBoundsRequest, (EditPart)reportComponentEditPart, (Object)rectangle, false);
            if (command == null) {
                command = command2;
                continue;
            }
            command = command.chain(command2);
        }
        if (command != null) {
            this.getGraphicalViewer().getEditDomain().getCommandStack().execute(command);
        }
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.setContents(this.getModel());
    }

    public List getSelectableEditParts(GraphicalViewer graphicalViewer) {
        ArrayList arrayList = new ArrayList();
        RootEditPart rootEditPart = graphicalViewer.getRootEditPart();
        List list = rootEditPart.getChildren();
        if (list.size() == 0 || !(list.get(0) instanceof ReportEditPart)) {
            return arrayList;
        }
        list = ((ReportEditPart)rootEditPart.getChildren().get(0)).getChildren();
        for (EditPart editPart : list) {
            if (!(editPart instanceof ReportSectionEditPart)) continue;
            arrayList.addAll(editPart.getChildren());
        }
        return arrayList;
    }

    protected boolean getSelectComponentWithArrowKeys() {
        return !IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getBoolean("iscobolrd.keyhdl.movewitharrow");
    }

    protected EditPart getEditPartToBeSelected(EditPart editPart, boolean bl) {
        EditPart editPart2;
        Object object = editPart.getModel();
        if (editPart instanceof ReportSectionEditPart) {
            EditPart editPart3;
            EditPart editPart4;
            List list;
            int n;
            List list2;
            int n2;
            List list3;
            ReportSectionModel reportSectionModel = (ReportSectionModel)object;
            editPart2 = bl ? (!(list3 = reportSectionModel.getComponents()).isEmpty() ? this.findEditPart(list3.get(0), (AbstractEditPart)editPart) : ((n2 = (list2 = ((ReportModel)reportSectionModel.getParent()).getChildren()).indexOf(reportSectionModel)) < list2.size() - 1 ? this.findEditPart(list2.get(n2 + 1), (AbstractEditPart)editPart.getParent()) : this.findEditPart(list2.get(0), (AbstractEditPart)editPart.getParent()))) : ((n = (list = ((ReportModel)reportSectionModel.getParent()).getChildren()).indexOf(reportSectionModel)) > 0 ? ((editPart4 = this.getLastComponent(reportSectionModel = (ReportSectionModel)list.get(n - 1), editPart3 = this.findEditPart((Object)reportSectionModel, (AbstractEditPart)editPart.getParent()), -1)) != null ? editPart4 : editPart3) : this.findEditPart(list.get(list.size() - 1), (AbstractEditPart)editPart.getParent()));
        } else {
            editPart2 = editPart instanceof ReportComponentEditPart ? this.getEditPartToBeSelected((ReportComponentModel)object, editPart, bl) : null;
        }
        return editPart2;
    }

    private EditPart getEditPartToBeSelected(ReportComponentModel reportComponentModel, EditPart editPart, boolean bl) {
        List list;
        ReportSectionModel reportSectionModel = (ReportSectionModel)reportComponentModel.getParent();
        List list2 = reportSectionModel.getComponents();
        int n = list2.indexOf(reportComponentModel);
        EditPart editPart2 = bl ? (n < list2.size() - 1 ? this.findEditPart(list2.get(n + 1), (AbstractEditPart)editPart.getParent()) : ((n = (list = reportSectionModel.getReportModel().getChildren()).indexOf(reportSectionModel)) < list.size() - 1 ? this.findEditPart(list.get(n + 1), (AbstractEditPart)editPart.getParent().getParent()) : editPart.getParent().getParent().getParent())) : (n > 0 ? this.getLastComponent(reportSectionModel, editPart.getParent(), n) : this.findEditPart((Object)reportSectionModel, (AbstractEditPart)editPart.getParent().getParent()));
        return editPart2;
    }

    private EditPart getLastComponent(ReportSectionModel reportSectionModel, EditPart editPart, int n) {
        EditPart editPart2;
        List list = reportSectionModel.getComponents();
        if (n < 0) {
            n = list.size();
        }
        if (!list.isEmpty()) {
            ReportComponentModel reportComponentModel = (ReportComponentModel)list.get(n - 1);
            editPart2 = this.findEditPart((Object)reportComponentModel, (AbstractEditPart)editPart);
        } else {
            editPart2 = null;
        }
        return editPart2;
    }

    private EditPart findEditPart(Object object, AbstractEditPart abstractEditPart) {
        ListIterator listIterator = abstractEditPart.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart.getModel() != object) continue;
            return editPart;
        }
        return null;
    }

    public DataPool getDataPool() {
        return this.dataPool;
    }

    protected boolean isContainerEditPart(EditPart editPart) {
        return editPart != null && editPart.getModel() instanceof ReportSectionModel;
    }
}

