/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.beans;

import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportBox;
import com.iscobol.reportdesigner.beans.ReportCheckBox;
import com.iscobol.reportdesigner.beans.ReportDateTime;
import com.iscobol.reportdesigner.beans.ReportDetail;
import com.iscobol.reportdesigner.beans.ReportEntryField;
import com.iscobol.reportdesigner.beans.ReportGroupFooter;
import com.iscobol.reportdesigner.beans.ReportGroupHeader;
import com.iscobol.reportdesigner.beans.ReportImage;
import com.iscobol.reportdesigner.beans.ReportLabel;
import com.iscobol.reportdesigner.beans.ReportLine;
import com.iscobol.reportdesigner.beans.ReportRadioButton;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.beans.ReportTable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class ReportConstants {
    public static final int REPORT = 501;
    public static final int REPORT_BOX = 502;
    public static final int REPORT_CHECK_BOX = 503;
    public static final int REPORT_DATE_TIME = 504;
    public static final int REPORT_ENTRY_FIELD = 505;
    public static final int REPORT_IMAGE = 506;
    public static final int REPORT_LABEL = 507;
    public static final int REPORT_LINE = 508;
    public static final int REPORT_RADIO_BUTTON = 509;
    public static final int REPORT_TABLE = 510;
    public static final int REPORT_DETAIL = 551;
    public static final int REPORT_FOOTER = 552;
    public static final int REPORT_HEADER = 553;
    public static final int REPORT_PAGE_FOOTER = 554;
    public static final int REPORT_PAGE_HEADER = 555;
    public static final int REPORT_GROUP_FOOTER = 556;
    public static final int REPORT_GROUP_HEADER = 557;
    public static final String NAME_PROPERTY_ID = "name";
    public static final String COLOR_PROPERTY_ID = "color";
    public static final String COLOR_VAR_PROPERTY_ID = "color variable";
    public static final String VALUE_PROPERTY_ID = "value";
    public static final String VALUE_VAR_PROPERTY_ID = "value variable";
    public static final String VALUE_PICTURE_PROPERTY_ID = "value picture";
    public static final String FONT_PROPERTY_ID = "font";
    public static final String LINES_PROPERTY_ID = "lines";
    public static final String REPORT_SIZE_PROPERTY_ID = "rptsize";
    public static final String SIZE_PROPERTY_ID = "size";
    public static final String PRINT_CONDITION_PROPERTY_ID = "print condition";
    public static final String PRINT_IF_REPEAT_PROPERTY_ID = "print if repeat";
    public static final String VISIBLE_PROPERTY_ID = "visible";
    public static final String VISIBLE_VAR_PROPERTY_ID = "visible variable";
    public static final String COLUMN_PROPERTY_ID = "column";
    public static final String LINE_PROPERTY_ID = "line";
    public static final String HYPERLINK_PROPERTY_ID = "hyperlink";
    public static final String HYPERLINK_VAR_PROPERTY_ID = "hyperlink variable";
    public static final String LOCK_PROPERTY_ID = "lock";
    public static final String REPORT_PREFIX_PROPERTY_ID = "report-prefix";
    public static final String OUTPUT_FILE_NAME_PROPERTY_ID = "output file name";
    public static final String OUTPUT_FILE_NAME_VAR_PROPERTY_ID = "output file name variable";
    public static final String TITLE_PROPERTY_ID = "title";
    public static final String TITLE_VAR_PROPERTY_ID = "title variable";
    public static final String WATERMARK_PROPERTY_ID = "watermark";
    public static final String WATERMARK_STYLE_PROPERTY_ID = "watermark style";
    public static final String PAPER_SIZE_PROPERTY_ID = "paper size";
    public static final String PRINT_SETUP_PROPERTY_ID = "print setup";
    public static final String REPORT_COMPONENTS_PROPERTY_ID = "rptcomponents";
    public static final String REPORT_HEADER_PROPERTY_ID = "rptheader";
    public static final String REPORT_FOOTER_PROPERTY_ID = "rptfooter";
    public static final String REPORT_PAGE_HEADER_PROPERTY_ID = "rptpgheader";
    public static final String REPORT_PAGE_FOOTER_PROPERTY_ID = "rptpgfooter";
    public static final String REPORT_GROUP_HEADERS_PROPERTY_ID = "rptgrpheaders";
    public static final String REPORT_GROUP_FOOTERS_PROPERTY_ID = "rptgrpfooters";
    public static final String REPORT_DETAILS_PROPERTY_ID = "rptdetails";
    public static final String COUNT_HEIGHT_PROPERTY_ID = "rpt_count_height";
    public static final String GROUP_TYPE_PROPERTY_ID = "rpt_group_type";
    public static final String GROUPED_BY_PROPERTY_ID = "rpt_grouped_by_var";
    public static final String BEFORE_PRINT_PROPERTY_ID = "BeforePrint";
    public static final String AFTER_PRINT_PROPERTY_ID = "AfterPrint";
    public static final String BEFORE_DO_PRINT_PROPERTY_ID = "BeforeDoPrint";
    public static final String AFTER_DO_PRINT_PROPERTY_ID = "AfterDoPrint";
    public static final String PRINT_BEFORE_PAGE_HEADER_PROPERTY_ID = "printBefPH";
    public static final String PRINT_AFTER_PAGE_FOOTER_PROPERTY_ID = "printAftPF";
    public static final String SKIP_PAGE_AFTER_PRINT_PROPERTY_ID = "skipPageAftPrint";
    public static final String SKIP_PAGE_BEFORE_PRINT_PROPERTY_ID = "skipPageBefPrint";
    public static final String ZEBRA_PROPERTY_ID = "zebra";
    public static final String BITMAP_PROPERTY_ID = "bitmap";
    public static final String BITMAP_PATH_PROPERTY_ID = "bitmap path";
    public static final String BITMAP_POSITION_PROPERTY_ID = "bitmap position";
    public static final String BITMAP_STYLE_PROPERTY_ID = "bitmap style";
    public static final String BORDER_COLOR_PROPERTY_ID = "border color";
    public static final String BORDER_STYLE_PROPERTY_ID = "border style";
    public static final String BORDER_WIDTH_PROPERTY_ID = "border width";
    public static final String JUSTIFICATION_PROPERTY_ID = "justification";
    public static final String DISPLAY_TYPE_PROPERTY_ID = "display type";
    public static final String HORIZONTAL_SPACING_PROPERTY_ID = "h-spacing";
    public static final String GROUP_PROPERTY_ID = "group";
    public static final String DATE_FORMAT_PROPERTY_ID = "date format";
    public static final String DATE_PICTURE_FORMAT_PROPERTY_ID = "date picture format";
    public static final String TIME_FORMAT_PROPERTY_ID = "time format";
    public static final String TIME_PICTURE_FORMAT_PROPERTY_ID = "time picture format";
    public static final String KIND_PROPERTY_ID = "kind";
    public static final String WIDTH_PROPERTY_ID = "width";
    public static final String CELL_PADDING_PROPERTY_ID = "cell padding";
    public static final String CELL_SPACING_PROPERTY_ID = "cell spacing";
    public static final String SHOW_GRID_LINE_PROPERTY_ID = "show grid line";
    public static final String COLUMN_SETTINGS_PROPERTY_ID = "rpt_col_settings";
    public static final String ROW_SETTINGS_PROPERTY_ID = "rpt_row_settings";
    public static final String CELL_SETTINGS_PROPERTY_ID = "rpt_cell_settings";
    public static final String CELL_DATA_PROPERTY_ID = "1tbl-cell-data";
    public static final String CELL_DATA_TYPE_PROPERTY_ID = "0tbl-cell-data-type";
    public static final String PICTURE_PROPERTY_ID = "picture";
    public static final String ALIGNMENT_PROPERTY_ID = "alignment";
    public static final String HEIGHT_PROPERTY_ID = "height";
    public static final String AUTO_RESIZE_PROPERTY_ID = "auto resize";
    public static final String COLUMN_HEADINGS_PROPERTY_ID = "column headings";
    public static final String HEADING_COLOR_PROPERTY_ID = "heading color";
    public static final String ROW_COLOR_PATTERN_PROPERTY_ID = "row color pattern";
    public static final String LOAD_GRID_INIT_PROPERTY_ID = "LoadGridInit";
    public static final String LOAD_GRID_NEXT_PROPERTY_ID = "LoadGridNext";
    private static final LinkedHashMap<String, Class> reportDesignerTypes = new LinkedHashMap();
    public static final String[] reportControlNames;

    private ReportConstants() {
    }

    public static Object[] getReportTargets() {
        Object[] objectArray = new Object[reportDesignerTypes.size()];
        int n = 0;
        for (Class clazz : reportDesignerTypes.values()) {
            try {
                objectArray[n++] = clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return objectArray;
    }

    public static String getDefaultParagraphName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("-");
        if (AFTER_PRINT_PROPERTY_ID.equals(string2)) {
            stringBuilder.append("aft-print");
        } else if (BEFORE_PRINT_PROPERTY_ID.equals(string2)) {
            stringBuilder.append("bef-print");
        } else if (AFTER_DO_PRINT_PROPERTY_ID.equals(string2)) {
            stringBuilder.append("aft-do-print");
        } else if (BEFORE_DO_PRINT_PROPERTY_ID.equals(string2)) {
            stringBuilder.append("bef-do-print");
        }
        return stringBuilder.toString();
    }

    public static String getDefaultEventProperty(int n) {
        switch (n) {
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: {
                return BEFORE_PRINT_PROPERTY_ID;
            }
        }
        return null;
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 501: {
                return "Report";
            }
            case 551: {
                return "Detail";
            }
            case 553: {
                return "Header";
            }
            case 552: {
                return "Footer";
            }
            case 555: {
                return "Page-Header";
            }
            case 554: {
                return "Page-Footer";
            }
            case 557: {
                return "Group-Header";
            }
            case 556: {
                return "Group-Footer";
            }
            case 502: {
                return "Box";
            }
            case 503: {
                return "Check-Box";
            }
            case 504: {
                return "Date-Time";
            }
            case 505: {
                return "Entry-Field";
            }
            case 506: {
                return "Image";
            }
            case 507: {
                return "Label";
            }
            case 508: {
                return "Line";
            }
            case 509: {
                return "Radio-Button";
            }
            case 510: {
                return "Table";
            }
        }
        return "Unknown-type";
    }

    public static String getDefaultProperty(int n) {
        switch (n) {
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 510: 
            case 551: 
            case 552: 
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 557: {
                return NAME_PROPERTY_ID;
            }
        }
        return null;
    }

    public static String getShortTypeName(int n) {
        switch (n) {
            case 553: {
                return "rh";
            }
            case 552: {
                return "rf";
            }
            case 555: {
                return "ph";
            }
            case 554: {
                return "pf";
            }
            case 551: {
                return "dl";
            }
            case 556: {
                return "gf";
            }
            case 557: {
                return "gh";
            }
            case 502: {
                return "bx";
            }
            case 503: {
                return "cb";
            }
            case 504: {
                return "dt";
            }
            case 505: {
                return "ef";
            }
            case 506: {
                return "im";
            }
            case 507: {
                return "lb";
            }
            case 508: {
                return "ln";
            }
            case 509: {
                return "rb";
            }
            case 510: {
                return "tb";
            }
        }
        return "un";
    }

    public static Set<String> getPositiveNumericProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(BORDER_WIDTH_PROPERTY_ID);
        hashSet.add(GROUP_PROPERTY_ID);
        hashSet.add(CELL_PADDING_PROPERTY_ID);
        hashSet.add(CELL_SPACING_PROPERTY_ID);
        return hashSet;
    }

    public static Set<String> getHiddenProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(REPORT_COMPONENTS_PROPERTY_ID);
        hashSet.add(REPORT_DETAILS_PROPERTY_ID);
        hashSet.add(REPORT_FOOTER_PROPERTY_ID);
        hashSet.add(REPORT_GROUP_FOOTERS_PROPERTY_ID);
        hashSet.add(REPORT_GROUP_HEADERS_PROPERTY_ID);
        hashSet.add(REPORT_HEADER_PROPERTY_ID);
        hashSet.add(REPORT_PAGE_FOOTER_PROPERTY_ID);
        hashSet.add(REPORT_PAGE_HEADER_PROPERTY_ID);
        hashSet.add(REPORT_SIZE_PROPERTY_ID);
        hashSet.add(COUNT_HEIGHT_PROPERTY_ID);
        hashSet.add(GROUP_TYPE_PROPERTY_ID);
        hashSet.add(GROUPED_BY_PROPERTY_ID);
        hashSet.add(REPORT_PREFIX_PROPERTY_ID);
        return hashSet;
    }

    public static Set<String> getParagraphProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(AFTER_DO_PRINT_PROPERTY_ID);
        hashSet.add(AFTER_PRINT_PROPERTY_ID);
        hashSet.add(BEFORE_DO_PRINT_PROPERTY_ID);
        hashSet.add(BEFORE_PRINT_PROPERTY_ID);
        return hashSet;
    }

    public static Set<String> getProcedureProperties() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(AFTER_DO_PRINT_PROPERTY_ID);
        hashSet.add(AFTER_PRINT_PROPERTY_ID);
        hashSet.add(BEFORE_DO_PRINT_PROPERTY_ID);
        hashSet.add(BEFORE_PRINT_PROPERTY_ID);
        return hashSet;
    }

    public static String getSectionId(ReportSection reportSection) {
        if (reportSection == null || reportSection.getParent() == null) {
            return "un0";
        }
        Report report = (Report)reportSection.getParent();
        switch (reportSection.getType()) {
            case 553: {
                return "rh1";
            }
            case 555: {
                return "ph1";
            }
            case 552: {
                return "rf1";
            }
            case 554: {
                return "pf1";
            }
            case 557: {
                return "gh" + Integer.toString(report.indexOfGroupHeader((ReportGroupHeader)reportSection) + 1);
            }
            case 556: {
                return "gf" + Integer.toString(report.indexOfGroupFooter((ReportGroupFooter)reportSection) + 1);
            }
            case 551: {
                return "dl" + Integer.toString(report.indexOfDetail((ReportDetail)reportSection) + 1);
            }
        }
        return "un0";
    }

    static {
        reportDesignerTypes.put("Box", ReportBox.class);
        reportDesignerTypes.put("Check-Box", ReportCheckBox.class);
        reportDesignerTypes.put("Date-Time", ReportDateTime.class);
        reportDesignerTypes.put("Entry-Field", ReportEntryField.class);
        reportDesignerTypes.put("Image", ReportImage.class);
        reportDesignerTypes.put("Label", ReportLabel.class);
        reportDesignerTypes.put("Line", ReportLine.class);
        reportDesignerTypes.put("Radio-Button", ReportRadioButton.class);
        reportDesignerTypes.put("Table", ReportTable.class);
        reportControlNames = reportDesignerTypes.keySet().toArray(new String[reportDesignerTypes.size()]);
    }
}

