/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.beans;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.reportdesigner.CodeGenerator;
import com.iscobol.reportdesigner.UnitConverter;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.beans.types.BorderStyle;
import com.iscobol.reportdesigner.beans.types.Justification;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import java.awt.Font;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ReportControl
implements ReportElement {
    public static final Font defaultFont = FontType.getStandardFont((String)"default-font").getFont();
    private String name;
    private String afterPrint;
    private String beforePrint;
    private float lines;
    private float line;
    private float size;
    private float column;
    private ColorType color = ColorType.DISABLED_COLOR;
    private String colorVar;
    private FontType font;
    private boolean lock;
    private boolean visible = true;
    private String visibleVar;
    private String printCondition;
    private ReportElement parent;
    protected ColorPalette palette;

    public ReportElement getParent() {
        return this.parent;
    }

    public void setParent(ReportElement reportElement) {
        this.parent = reportElement;
        if (this.parent != null) {
            this.line = this.checkLine(this.line);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAfterPrint() {
        return this.afterPrint;
    }

    public void setAfterPrint(String string) {
        this.afterPrint = string;
    }

    public String getBeforePrint() {
        return this.beforePrint;
    }

    public void setBeforePrint(String string) {
        this.beforePrint = string;
    }

    public float getLines() {
        return this.lines;
    }

    public void setLines(float f) {
        this.lines = f;
        this.line = this.checkLine(this.line);
    }

    public float getLine() {
        return this.line;
    }

    public void setLine(float f) {
        this.line = this.checkLine(f);
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public float getColumn() {
        return this.column;
    }

    public void setColumn(float f) {
        this.column = f;
    }

    public ColorType getColor() {
        return this.color;
    }

    public void setColor(ColorType colorType) {
        this.color = colorType;
    }

    public String getColorVariable() {
        return this.colorVar;
    }

    public void setColorVariable(String string) {
        this.colorVar = string;
    }

    public FontType getFont(boolean bl) {
        if ((this.font == null || this.font.isNullFont()) && bl) {
            if (this.parent != null) {
                return ((ReportSection)this.parent).getFont(true);
            }
            return ReportSection.defaultFont;
        }
        return this.font;
    }

    public FontType getFont() {
        return this.getFont(false);
    }

    public void setFont(FontType fontType) {
        this.font = fontType;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean bl) {
        this.lock = bl;
    }

    public String getVisibleVariable() {
        return this.visibleVar;
    }

    public void setVisibleVariable(String string) {
        this.visibleVar = string;
    }

    public String getPrintCondition() {
        return this.printCondition;
    }

    public void setPrintCondition(String string) {
        this.printCondition = string;
    }

    public Color getAwtBackgroundColor() {
        Color color;
        if (this.color != null && (color = this.color.getBackgroundColor(this.palette)) != null) {
            return color;
        }
        if (this.parent != null) {
            return ((ReportSection)this.parent).getAwtBackgroundColor();
        }
        return Color.white;
    }

    public Color getAwtForegroundColor() {
        Color color;
        if (this.color != null && (color = this.color.getForegroundColor(this.palette)) != null) {
            return color;
        }
        if (this.parent != null) {
            return ((ReportSection)this.parent).getAwtForegroundColor();
        }
        return Color.black;
    }

    public String getCSSAttributes() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("position:absolute;");
        this.getCSSBoundsAttributes(stringBuilder);
        this.getCSSColorAttributes(stringBuilder);
        return stringBuilder.toString();
    }

    public void writeNestedCSSAttributes(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string) {
    }

    public int getXPx() {
        return UnitConverter.toPixel((float)this.getColumn());
    }

    public int getYPx() {
        return UnitConverter.toPixel((float)this.getLine());
    }

    public int getWidthPx() {
        return UnitConverter.toPixel((float)this.getSize());
    }

    private float checkLine(float f) {
        ReportSection reportSection;
        float f2;
        if (this.getParent() != null && (f2 = (reportSection = (ReportSection)this.getParent()).getLines() - this.getLines() - f) < 0.0f) {
            f = Math.max(0.0f, f + f2);
        }
        return f;
    }

    public int getHeightPx() {
        ReportSection reportSection;
        float f;
        float f2 = this.getLines();
        if (this.getParent() != null && (f = (reportSection = (ReportSection)this.getParent()).getLines() - this.getLine() - f2) < 0.0f) {
            f2 = Math.max(0.1f, f2 + f);
        }
        return UnitConverter.toPixel((float)f2);
    }

    protected void getCSSColorAttributes(StringBuilder stringBuilder) {
        stringBuilder.append(" background-color:transparent;");
    }

    protected void getCSSJustificationAttributes(StringBuilder stringBuilder, Justification justification) {
        if (justification.getValue() != 3) {
            stringBuilder.append(" text-align:");
            switch (justification.getValue()) {
                case 0: {
                    stringBuilder.append("center");
                    break;
                }
                case 1: {
                    stringBuilder.append("left");
                    break;
                }
                case 2: {
                    stringBuilder.append("right");
                }
            }
            stringBuilder.append(";");
        }
    }

    protected void getCSSBorderAttributes(StringBuilder stringBuilder, BorderStyle borderStyle, int n, ForegroundColorType foregroundColorType) {
        if (borderStyle.getValue() == 0) {
            stringBuilder.append(" border-style:solid; border-width:");
            stringBuilder.append(n);
            stringBuilder.append("px; border-color:");
            int n2 = foregroundColorType != null && !foregroundColorType.isDisabled() ? foregroundColorType.getForegroundColor(this.palette).getRGB() : (this.palette != null ? this.palette.getColor(0).getRGB() : ColorType.getDefaultColor((int)0, (boolean)true).getRGB());
            stringBuilder.append(IscobolBeanConstants.getRgbString((int)n2));
            stringBuilder.append(";");
        }
    }

    public void getCSSFontAttributes(StringBuilder stringBuilder, FontType fontType) {
        if (fontType != null && !fontType.isNullFont()) {
            stringBuilder.append(" font-size:");
            stringBuilder.append(Math.round(fontType.getSize()));
            stringBuilder.append("pt; font-family:");
            stringBuilder.append(CodeGenerator.getFontFamily((FontType)fontType));
            stringBuilder.append(";");
        }
    }

    protected void getCSSBoundsAttributes(StringBuilder stringBuilder) {
        stringBuilder.append(" top:");
        stringBuilder.append(this.getYPx());
        stringBuilder.append("; left:");
        stringBuilder.append(this.getXPx());
        stringBuilder.append("; width:");
        stringBuilder.append(this.getWidthPx());
        stringBuilder.append("; height:");
        stringBuilder.append(this.getHeightPx());
        stringBuilder.append(";");
    }

    public final String getHTMLCode(CobolFormatter cobolFormatter, String string, String string2) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.colorVar != null && this.colorVar.length() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + string2 + ":>getRGBValues ( " + this.colorVar + " " + CodeGenerator.getHtmlForegroundVarName() + " " + CodeGenerator.getHtmlBackgroundVarName() + " )"));
        }
        CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'         <!-- " + this.getName() + " -->'"});
        String string3 = "'         <div class=\"" + CodeGenerator.getCSSClassName((ReportControl)this) + "\"";
        String[] stringArray2 = this.getHTMLStyleTokens();
        if (stringArray2 != null) {
            string3 = string3 + " style=\"'";
            stringArray = new String[stringArray2.length + 2];
            stringArray[0] = string3;
            System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
            stringArray[stringArray.length - 1] = "'\">'";
        } else {
            string3 = string3 + ">'";
            stringArray = new String[]{string3};
        }
        CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])stringArray);
        String string4 = this.getHyperlinkVariable();
        if (string4 != null && string4.length() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + "if " + string4 + " = zeros or spaces"));
            this.getHTMLCode(cobolFormatter, stringBuilder, string + "   ", null, null, string2);
            stringBuilder.append(cobolFormatter.formatLine(string + "else"));
            this.getHTMLCode(cobolFormatter, stringBuilder, string + "   ", null, string4, string2);
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
        } else {
            String string5 = this.getHyperlink();
            if (string5 != null && string5.length() == 0) {
                string5 = null;
            }
            this.getHTMLCode(cobolFormatter, stringBuilder, string, string5, null, string2);
        }
        CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'         </div>'"});
        CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'         <!-- end " + this.getName() + " -->'"});
        return stringBuilder.toString();
    }

    private void getHTMLCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2, String string3, String string4) {
        this.getFontOpenTagCode(cobolFormatter, stringBuilder, string, string4);
        if (string2 != null) {
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            <a href=\"" + string2 + "\">'"});
        } else if (string3 != null) {
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            <a href=\"'", string3, "'\">'"});
        }
        this.getNestedHTMLCode(cobolFormatter, stringBuilder, string, string4);
        if (string2 != null || string3 != null) {
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            </a>'"});
        }
        this.getFontCloseTagCode(cobolFormatter, stringBuilder, string);
    }

    protected void getFontOpenTagCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
        FontType fontType = this.getFont(true);
        if (fontType != null && fontType.isStandardFont()) {
            stringBuilder.append(cobolFormatter.formatLine(string + string2 + ":>getFontFlags(\"" + fontType.getDisplayName() + "\" as string " + CodeGenerator.getHtmlFontFlagsVarName() + ")"));
            stringBuilder.append(cobolFormatter.formatLine(string + "if " + CodeGenerator.getHtmlFontBoldVarName()));
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)(string + "   "), (boolean)false, (String[])new String[]{"'            <strong>'"});
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
            stringBuilder.append(cobolFormatter.formatLine(string + "if " + CodeGenerator.getHtmlFontItalicVarName()));
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)(string + "   "), (boolean)false, (String[])new String[]{"'            <em>'"});
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
        } else {
            String string3 = "";
            if (fontType != null && fontType.isBold()) {
                string3 = string3 + "<strong>";
            }
            if (fontType != null && fontType.isItalic()) {
                string3 = string3 + "<em>";
            }
            if (string3.length() > 0) {
                CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            " + string3 + "'"});
            }
        }
    }

    protected void getFontCloseTagCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string) {
        FontType fontType = this.getFont(true);
        if (fontType != null && fontType.isStandardFont()) {
            stringBuilder.append(cobolFormatter.formatLine(string + "if " + CodeGenerator.getHtmlFontItalicVarName()));
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)(string + "   "), (boolean)false, (String[])new String[]{"'            </em>'"});
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
            stringBuilder.append(cobolFormatter.formatLine(string + "if " + CodeGenerator.getHtmlFontBoldVarName()));
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)(string + "   "), (boolean)false, (String[])new String[]{"'            </strong>'"});
            stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
        } else {
            String string2 = "";
            if (fontType != null && fontType.isItalic()) {
                string2 = string2 + "</em>";
            }
            if (fontType != null && fontType.isBold()) {
                string2 = string2 + "</strong>";
            }
            if (string2.length() > 0) {
                CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            " + string2 + "'"});
            }
        }
    }

    protected void getNestedHTMLCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
    }

    protected String[] getHTMLStyleTokens() {
        return ReportControl.getHTMLStyleTokens((String)this.getColorVariable(), (ColorType)this.getColor(), (ColorPalette)this.palette);
    }

    protected static String[] getHTMLStyleTokens(String string, ColorType colorType, ColorPalette colorPalette) {
        if (string != null && string.length() > 0) {
            return new String[]{"'background-color:'", "is-html-background", "'; color:'", "is-html-foreground", "';'"};
        }
        if (colorType != null) {
            Color color = colorType.getBackgroundColor(colorPalette);
            Color color2 = colorType.getForegroundColor(colorPalette);
            if (color != null) {
                if (color2 != null) {
                    return new String[]{"'background-color:" + IscobolBeanConstants.getRgbString((int)color.getRGB()) + "; color:" + IscobolBeanConstants.getRgbString((int)color2.getRGB()) + ";'"};
                }
                return new String[]{"'background-color:" + IscobolBeanConstants.getRgbString((int)color.getRGB()) + ";'"};
            }
            if (color2 != null) {
                return new String[]{"'color:" + IscobolBeanConstants.getRgbString((int)color2.getRGB()) + ";'"};
            }
        }
        return null;
    }

    public String getHyperlinkVariable() {
        return null;
    }

    public String getHyperlink() {
        return null;
    }

    public ColorPalette getPalette() {
        return this.palette;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }
}

