/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.beans;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.reportdesigner.CodeGenerator;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.types.BorderStyle;
import com.iscobol.reportdesigner.beans.types.DisplayType;
import com.iscobol.reportdesigner.beans.types.Justification;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;

public class ReportEntryField
extends ReportControl {
    private ForegroundColorType borderColor = ForegroundColorType.DISABLED_COLOR;
    private BorderStyle borderStyle = new BorderStyle(0);
    private int borderWidth = 1;
    private String hyperlink;
    private String hyperlinkVar;
    private Justification justification = new Justification();
    private String value;
    private String valueVar;
    private String valuePicture;
    private boolean printIfRepeat = true;
    private DisplayType displayType = new DisplayType();
    private float horizontalSpacing;

    public ReportEntryField() {
        this.setSize(1.0f);
        this.setLines(0.2f);
    }

    public ForegroundColorType getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        this.borderColor = foregroundColorType;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(BorderStyle borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String string) {
        this.hyperlink = string;
    }

    public String getHyperlinkVariable() {
        return this.hyperlinkVar;
    }

    public void setHyperlinkVariable(String string) {
        this.hyperlinkVar = string;
    }

    public Justification getJustification() {
        return this.justification;
    }

    public void setJustification(Justification justification) {
        this.justification = justification;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public String getValuePicture() {
        return this.valuePicture;
    }

    public void setValuePicture(String string) {
        this.valuePicture = string;
    }

    public boolean getPrintIfRepeat() {
        return this.printIfRepeat;
    }

    public void setPrintIfRepeat(boolean bl) {
        this.printIfRepeat = bl;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
    }

    public float getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(float f) {
        this.horizontalSpacing = f;
    }

    public int getType() {
        return 505;
    }

    protected void getNestedHTMLCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
        if (this.valueVar != null && this.valueVar.length() > 0) {
            stringBuilder.append(cobolFormatter.formatLine(string + string2 + ":>escapeText(" + this.valueVar + " " + CodeGenerator.getEscapedTextVarName() + ")"));
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'         '", CodeGenerator.getEscapedTextVarName()});
        } else if (this.value != null && this.value.length() > 0) {
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'         " + CodeGenerator.escapeText((String)this.value) + "'"});
        }
    }

    public String getCSSAttributes() {
        StringBuilder stringBuilder = new StringBuilder(super.getCSSAttributes());
        this.getCSSBorderAttributes(stringBuilder, this.borderStyle, this.borderWidth, this.borderColor);
        this.getCSSJustificationAttributes(stringBuilder, this.justification);
        stringBuilder.append(" letter-spacing:");
        stringBuilder.append(String.valueOf(this.horizontalSpacing).replace('.', ','));
        stringBuilder.append("; overflow:hidden;");
        return stringBuilder.toString();
    }
}

