/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.beans;

import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.reportdesigner.CodeGenerator;
import com.iscobol.reportdesigner.beans.ReportConstants;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.beans.types.BitmapPath;
import com.iscobol.reportdesigner.beans.types.BitmapPosition;
import com.iscobol.reportdesigner.beans.types.BitmapStyle;
import com.iscobol.reportdesigner.beans.types.BorderStyle;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.ImageType;
import java.awt.Image;

public class ReportImage
extends ReportControl {
    private ForegroundColorType borderColor = ForegroundColorType.DISABLED_COLOR;
    private BorderStyle borderStyle = new BorderStyle();
    private int borderWidth = 1;
    private ImageType bitmap;
    private BitmapPath bitmapPath = new BitmapPath();
    private BitmapPosition bitmapPosition = new BitmapPosition();
    private BitmapStyle bitmapStyle = new BitmapStyle();
    private String hyperlink;
    private String hyperlinkVar;
    private String value;
    private String valueVar;
    private boolean printIfRepeat = true;

    public ReportImage() {
        this.setSize(0.3f);
        this.setLines(0.3f);
    }

    public ForegroundColorType getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(ForegroundColorType foregroundColorType) {
        this.borderColor = foregroundColorType;
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(BorderStyle borderStyle) {
        this.borderStyle = borderStyle;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public ImageType getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(ImageType imageType) {
        this.bitmap = imageType;
    }

    public BitmapPath getBitmapPath() {
        return this.bitmapPath;
    }

    public void setBitmapPath(BitmapPath bitmapPath) {
        this.bitmapPath = bitmapPath;
    }

    public BitmapPosition getBitmapPosition() {
        return this.bitmapPosition;
    }

    public void setBitmapPosition(BitmapPosition bitmapPosition) {
        this.bitmapPosition = bitmapPosition;
    }

    public BitmapStyle getBitmapStyle() {
        return this.bitmapStyle;
    }

    public void setBitmapStyle(BitmapStyle bitmapStyle) {
        this.bitmapStyle = bitmapStyle;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    public void setHyperlink(String string) {
        this.hyperlink = string;
    }

    public String getHyperlinkVariable() {
        return this.hyperlinkVar;
    }

    public void setHyperlinkVariable(String string) {
        this.hyperlinkVar = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValueVariable() {
        return this.valueVar;
    }

    public void setValueVariable(String string) {
        this.valueVar = string;
    }

    public boolean getPrintIfRepeat() {
        return this.printIfRepeat;
    }

    public void setPrintIfRepeat(boolean bl) {
        this.printIfRepeat = bl;
    }

    public int getType() {
        return 506;
    }

    protected void getNestedHTMLCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
        ImageType imageType = this.getBitmap();
        if (imageType != null) {
            String string3 = "class=\"" + this.getNestedCSSClassName() + "\"";
            switch (this.getBitmapPath().getValue()) {
                case 1: {
                    if (this.valueVar != null && this.valueVar.length() > 0) {
                        stringBuilder.append(cobolFormatter.formatLine(string + "if " + this.valueVar + " = spaces"));
                        stringBuilder.append(cobolFormatter.formatLine(string + "   call \"c$fullname\" using \"" + imageType.getFileName() + "\" is-image-fullname"));
                        CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)(string + "   "), (boolean)false, (String[])new String[]{"'            <img src=\"file:'", "is-image-fullname", "'\" " + string3 + "></img>'"});
                        stringBuilder.append(cobolFormatter.formatLine(string + "else"));
                        stringBuilder.append(cobolFormatter.formatLine(string + "   call \"c$fullname\" using " + this.valueVar + " is-image-fullname"));
                        CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)(string + "   "), (boolean)false, (String[])new String[]{"'            <img src=\"file:'", this.valueVar, "'\" " + string3 + "></img>'"});
                        stringBuilder.append(cobolFormatter.formatLine(string + "end-if"));
                        break;
                    }
                    stringBuilder.append(cobolFormatter.formatLine(string + "call \"c$fullname\" using \"" + imageType.getFileName() + "\" is-image-fullname"));
                    CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            <img src=\"file:'", "is-image-fullname", "'\" " + string3 + "></img>'"});
                    break;
                }
                case 0: {
                    CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            <img src=\"file:" + imageType.getAbsoluteFilePath() + "\" " + string3 + "></img>'"});
                    break;
                }
                case 2: {
                    CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)false, (String[])new String[]{"'            <img src=\"" + imageType.getFileName() + "\" " + string3 + "></img>'"});
                }
            }
        }
    }

    private String getNestedCSSAttributes() {
        ImageType imageType = this.getBitmap();
        if (imageType != null) {
            Object object;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = n5 = this.borderStyle.getValue() == 0 ? this.borderWidth : 0;
            if (this.getBitmapStyle().getValue() == 0) {
                n4 = n5;
                n3 = n5;
                n2 = this.getWidthPx() - n5 * 2;
                n = this.getHeightPx() - n5 * 2;
            } else {
                object = imageType.getImage();
                if (object != null) {
                    int n7 = ((Image)object).getWidth(null);
                    int n8 = ((Image)object).getHeight(null);
                    n2 = n7;
                    n = n8;
                    switch (this.getBitmapPosition().getValue()) {
                        default: {
                            n4 = n5 + Math.max(0, (this.getHeightPx() - n8 - n5 * 2) / 2);
                            n3 = n5 + Math.max(0, (this.getWidthPx() - n7 - n5 * 2) / 2);
                            break;
                        }
                        case 2: {
                            n4 = n5 + Math.max(0, this.getHeightPx() - n8 - n5 * 2);
                            n3 = n5;
                            break;
                        }
                        case 1: {
                            n4 = n5;
                            n3 = n5;
                            break;
                        }
                        case 4: {
                            n4 = n5 + Math.max(0, this.getHeightPx() - n8 - n5 * 2);
                            n3 = n5 + Math.max(0, this.getWidthPx() - n7 - n5 * 2);
                            break;
                        }
                        case 3: {
                            n4 = n5;
                            n3 = n5 + Math.max(0, this.getWidthPx() - n7 - n5 * 2);
                            break;
                        }
                    }
                } else {
                    n4 = n5;
                    n3 = n5;
                    n2 = this.getWidthPx() - n5 * 2;
                    n = this.getHeightPx() - n5 * 2;
                }
            }
            object = "position:absolute; top:" + n4 + "; left:" + n3 + "; width:" + n2 + "; height:" + n;
            return object;
        }
        return null;
    }

    public void getCSSFontAttributes(StringBuilder stringBuilder, FontType fontType) {
    }

    protected void getCSSColorAttributes(StringBuilder stringBuilder) {
    }

    protected void getFontOpenTagCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string, String string2) {
    }

    protected void getFontCloseTagCode(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string) {
    }

    public String getCSSAttributes() {
        StringBuilder stringBuilder = new StringBuilder(super.getCSSAttributes());
        this.getCSSBorderAttributes(stringBuilder, this.borderStyle, this.borderWidth, this.borderColor);
        return stringBuilder.toString();
    }

    public void writeNestedCSSAttributes(CobolFormatter cobolFormatter, StringBuilder stringBuilder, String string) {
        ImageType imageType = this.getBitmap();
        if (imageType != null) {
            String string2 = this.getNestedCSSClassName();
            CodeGenerator.getWriteCode((CobolFormatter)cobolFormatter, (StringBuilder)stringBuilder, (String)string, (boolean)true, (String[])new String[]{"'   ." + string2 + " {" + this.getNestedCSSAttributes() + "}'"});
        }
    }

    private String getNestedCSSClassName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ReportConstants.getSectionId((ReportSection)((ReportSection)this.getParent())));
        stringBuilder.append("-imc-");
        stringBuilder.append(this.getName());
        stringBuilder.append("-1");
        return stringBuilder.toString();
    }
}

