/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.beans;

import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import java.util.Vector;

public abstract class ReportSection
implements ReportElement {
    public static final FontType defaultFont = FontType.getStandardFont((String)"default-font");
    private String name;
    private String afterPrint;
    private String beforePrint;
    private float lines;
    private ColorType color;
    private String colorVar;
    private FontType font;
    private String printCondition;
    private boolean lock;
    private boolean visible = true;
    private String visibleVar;
    private ReportElement parent;
    protected Vector<ReportControl> components = new Vector();
    private boolean countHeight;
    private ColorPalette palette;

    public ReportSection() {
        this.color = new ColorType(131329);
        this.font = FontType.getStandardFont((String)"default-font");
    }

    public ReportElement getParent() {
        return this.parent;
    }

    public void setParent(ReportElement reportElement) {
        this.parent = reportElement;
    }

    public int indexOfComponent(ReportControl reportControl) {
        return this.components.indexOf(reportControl);
    }

    public void setComponentAt(int n, ReportControl reportControl) {
        if (n < this.getComponentCount()) {
            ReportControl reportControl2 = (ReportControl)this.components.elementAt(n);
            reportControl2.setParent(null);
            this.components.setElementAt(reportControl, n);
            reportControl.setParent((ReportElement)this);
        }
    }

    public ReportControl getComponentAt(int n) {
        if (n < this.getComponentCount()) {
            return (ReportControl)this.components.elementAt(n);
        }
        return null;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public void addComponent(ReportControl reportControl) {
        this.addComponent(-1, reportControl);
    }

    public void addComponent(int n, ReportControl reportControl) {
        ReportSection reportSection = (ReportSection)reportControl.getParent();
        if (reportSection != null) {
            reportSection.removeComponent(reportControl);
        }
        if (n < 0 || n >= this.components.size()) {
            this.components.addElement(reportControl);
        } else {
            this.components.add(n, reportControl);
        }
        reportControl.setParent((ReportElement)this);
    }

    public void removeComponent(ReportControl reportControl) {
        this.components.removeElement(reportControl);
        reportControl.setParent(null);
    }

    public void removeAllComponents() {
        while (this.components.size() > 0) {
            this.removeComponent((ReportControl)this.components.elementAt(0));
        }
    }

    public ReportControl[] getComponents() {
        ReportControl[] reportControlArray = new ReportControl[this.getComponentCount()];
        this.components.toArray(reportControlArray);
        return reportControlArray;
    }

    public void setComponents(ReportControl[] reportControlArray) {
        this.removeAllComponents();
        for (int i = 0; i < reportControlArray.length; ++i) {
            this.addComponent(reportControlArray[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAfterPrint() {
        return this.afterPrint;
    }

    public void setAfterPrint(String string) {
        this.afterPrint = string;
    }

    public String getBeforePrint() {
        return this.beforePrint;
    }

    public void setBeforePrint(String string) {
        this.beforePrint = string;
    }

    public float getLines() {
        return this.lines;
    }

    public void setLines(float f) {
        this.lines = f;
    }

    public float getSize() {
        return this.getParent() != null ? ((Report)this.getParent()).getSize() : 0.0f;
    }

    public void setSize(float f) {
        if (this.getParent() != null) {
            ((Report)this.getParent()).setSize(f);
        }
    }

    public ColorType getColor() {
        return this.color;
    }

    public void setColor(ColorType colorType) {
        this.color = colorType;
    }

    public String getColorVariable() {
        return this.colorVar;
    }

    public void setColorVariable(String string) {
        this.colorVar = string;
    }

    public FontType getFont(boolean bl) {
        if ((this.font == null || this.font.isNullFont()) && bl) {
            return defaultFont;
        }
        return this.font;
    }

    public FontType getFont() {
        return this.getFont(false);
    }

    public void setFont(FontType fontType) {
        this.font = fontType;
    }

    public String getPrintCondition() {
        return this.printCondition;
    }

    public void setPrintCondition(String string) {
        this.printCondition = string;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public String getVisibleVariable() {
        return this.visibleVar;
    }

    public void setVisibleVariable(String string) {
        this.visibleVar = string;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean bl) {
        this.lock = bl;
    }

    public boolean isCountHeight() {
        return this.countHeight;
    }

    public void setCountHeight(boolean bl) {
        this.countHeight = bl;
    }

    public Color getAwtBackgroundColor() {
        Color color;
        if (this.color != null && (color = this.color.getBackgroundColor(this.palette)) != null) {
            return color;
        }
        return Color.white;
    }

    public Color getAwtForegroundColor() {
        Color color;
        if (this.color != null && (color = this.color.getForegroundColor(this.palette)) != null) {
            return color;
        }
        return Color.black;
    }

    public ColorPalette getPalette() {
        return this.palette;
    }

    public void setPalette(ColorPalette colorPalette) {
        this.palette = colorPalette;
    }
}

