/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.beans.types;

import com.iscobol.screenpainter.beans.types.Choice;
import java.util.HashMap;
import java.util.Map;

public class PaperFormat
extends Choice {
    public static final int CUSTOM = 0;
    public static final int LETTER = 1;
    public static final int LETTER_SMALL = 2;
    public static final int TABLOID = 3;
    public static final int LEDGER = 4;
    public static final int LEGAL = 5;
    public static final int STATEMENT = 6;
    public static final int EXECUTIVE = 7;
    public static final int A3 = 8;
    public static final int A4 = 9;
    public static final int A4_SMALL = 10;
    public static final int A5 = 11;
    public static final int B4_JIS = 12;
    public static final int B5_JIS = 13;
    public static final int FOLIO = 14;
    public static final int QUARTO = 15;
    public static final int _10x14 = 16;
    public static final int _11x17 = 17;
    public static final int NOTE = 18;
    public static final int ENVELOPE_9 = 19;
    public static final int ENVELOPE_10 = 20;
    public static final int ENVELOPE_11 = 21;
    public static final int ENVELOPE_12 = 22;
    public static final int ENVELOPE_14 = 23;
    public static final int C = 24;
    public static final int D = 25;
    public static final int E = 26;
    public static final int ENVELOPE_DL = 27;
    public static final int ENVELOPE_C5 = 28;
    public static final int ENVELOPE_C3 = 29;
    public static final int ENVELOPE_C4 = 30;
    public static final int ENVELOPE_C6 = 31;
    public static final int ENVELOPE_C65 = 32;
    public static final int ENVELOPE_B4 = 33;
    public static final int ENVELOPE_B5 = 34;
    public static final int ENVELOPE_B6 = 35;
    public static final int ENVELOPE_ITALY = 36;
    public static final int ENVELOPE_MONARCH = 37;
    public static final int ENVELOPE_PERSONAL = 38;
    public static final int US_STD_FANFOLD = 39;
    public static final int GERMAN_STD_FANFOLD = 40;
    public static final int GERMAN_LEGAL_FANFOLD = 41;
    public static final int B4 = 42;
    public static final int JAPANESE_POSTCARD = 43;
    public static final int _9x11_ENVELOPE = 44;
    public static final int _10x11_ENVELOPE = 45;
    public static final int _15x11_ENVELOPE = 46;
    public static final int ENVELOPE_INVITE = 47;
    private static final Map<String, Integer> acu2is = new HashMap();
    private static final String[] names;
    private static final float[][] formatSizes;

    public PaperFormat() {
        this(9);
    }

    public PaperFormat(int n) {
        super(n);
    }

    public String[] getNames() {
        return names;
    }

    public static float getDefaultWidth(int n, boolean bl) {
        return n > 0 && n < formatSizes.length ? formatSizes[n][bl ? 0 : 1] : 0.0f;
    }

    public static float getDefaultHeight(int n, boolean bl) {
        return n > 0 && n < formatSizes.length ? formatSizes[n][bl ? 1 : 0] : 0.0f;
    }

    public static int acuFormat2IsFormat(String string) {
        Integer n = (Integer)acu2is.get(string.toLowerCase());
        return n != null ? n : 0;
    }

    static {
        acu2is.put("letter", 1);
        acu2is.put("letter small", 2);
        acu2is.put("tabloid", 3);
        acu2is.put("legal", 5);
        acu2is.put("statement", 6);
        acu2is.put("execute", 7);
        acu2is.put("a3", 8);
        acu2is.put("a4", 9);
        acu2is.put("a4 small", 10);
        acu2is.put("a5", 11);
        acu2is.put("b5(jis)", 13);
        acu2is.put("folio", 14);
        acu2is.put("quarto", 15);
        acu2is.put("note", 18);
        acu2is.put("envelope #9", 19);
        acu2is.put("envelope #10", 20);
        acu2is.put("envelope #11", 21);
        acu2is.put("envelope #12", 22);
        acu2is.put("envelope #14", 23);
        acu2is.put("envelope dl", 27);
        acu2is.put("envelope c5", 28);
        acu2is.put("envelope c3", 29);
        acu2is.put("envelope c4", 30);
        acu2is.put("envelope c6", 31);
        acu2is.put("envelope c65", 32);
        acu2is.put("envelope b4", 33);
        acu2is.put("envelope b5", 34);
        acu2is.put("envelope monarch", 37);
        acu2is.put("6 3/4 envelope", 38);
        acu2is.put("letter transverse", 1);
        acu2is.put("a4 transverse", 9);
        acu2is.put("a5 transverse", 11);
        names = new String[]{"Custom", "Letter", "Letter small", "Tabloid", "Ledger", "Legal", "Statement", "Executive", "A3", "A4", "A4 small", "A5", "B4", "B5", "Folio", "Quarto", "10x14", "11x17", "Note", "Envelope #9", "Envelope #10", "Envelope #11", "Envelope #12", "Envelope #14", "C", "D", "E", "Envelope Dl", "Envelope C5", "Envelope C3", "Envelope C4", "Envelope C6", "Envelope C65", "Envelope B4", "Envelope B5", "Envelope B6", "Envelope Italy", "Envelope Monarch", "Envelope Personal", "US Std Fanfold", "German Std Fanfold", "German Legal Fanfold", "B4", "Japanese Postcard", "9x11 Envelope", "10x11 Envelope", "15x11 Envelope", "Envelope Invite"};
        formatSizes = new float[][]{{0.0f, 0.0f}, {8.5f, 11.0f}, {8.5f, 11.0f}, {11.0f, 17.0f}, {11.0f, 17.0f}, {8.5f, 14.0f}, {5.5f, 8.5f}, {7.25f, 10.5f}, {11.69f, 16.54f}, {8.27f, 11.69f}, {8.27f, 11.69f}, {5.83f, 8.27f}, {9.84f, 13.9f}, {6.93f, 9.84f}, {8.5f, 13.0f}, {8.5f, 10.83f}, {10.0f, 14.0f}, {11.0f, 17.0f}, {8.5f, 11.0f}, {3.87f, 8.87f}, {4.13f, 9.5f}, {4.5f, 10.37f}, {4.75f, 11.0f}, {5.0f, 11.5f}, {17.0f, 22.0f}, {22.0f, 34.0f}, {34.0f, 44.0f}, {4.33f, 8.66f}, {6.38f, 9.02f}, {12.76f, 18.03f}, {9.02f, 12.76f}, {4.49f, 6.38f}, {4.49f, 9.02f}, {9.84f, 13.9f}, {6.93f, 9.84f}, {4.92f, 6.93f}, {4.33f, 9.06f}, {3.87f, 7.5f}, {3.63f, 6.5f}, {7.8f, 11.0f}, {8.5f, 12.0f}, {8.5f, 13.0f}, {9.84f, 13.9f}, {3.94f, 5.83f}, {9.0f, 11.0f}, {10.0f, 11.0f}, {11.0f, 15.0f}, {8.66f, 8.66f}};
    }
}

