/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.dialogs;

import com.iscobol.reportdesigner.UnitConverter;
import com.iscobol.reportdesigner.beans.types.PaperFormat;
import com.iscobol.reportdesigner.beans.types.PaperOrientation;
import com.iscobol.reportdesigner.beans.types.PaperSize;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PaperSizeDialog
extends Dialog {
    private boolean unitInch = UnitConverter.isUnitInch();
    private Combo paperFormatCmb;
    private Text paperWidthTxt;
    private Text paperHeightTxt;
    private Button portraitBtn;
    private Button landscapeBtn;
    private Text headerTxt;
    private Text footerTxt;
    private Text leftMarginTxt;
    private Text rightMarginTxt;
    private Text topMarginTxt;
    private Text bottomMarginTxt;
    private PaperSize value;
    private PaperSize Return;
    private ModifyListener whListener;

    public PaperSizeDialog(Shell shell, PaperSize paperSize) {
        super(shell);
        this.value = paperSize;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Paper Size");
    }

    protected Control createDialogArea(Composite composite) {
        String string2;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setText("Paper");
        this.paperFormatCmb = new Combo((Composite)group, 8);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.paperFormatCmb.setLayoutData((Object)gridData);
        for (String string2 : new PaperFormat().getNames()) {
            this.paperFormatCmb.add(string2);
        }
        Label label = new Label((Composite)group, 0);
        label.setText("Width:");
        this.paperWidthTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.paperWidthTxt.setLayoutData((Object)gridData);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.unitInch ? " inch" : " cm");
        Label label3 = new Label((Composite)group, 0);
        label3.setText("Height:");
        this.paperHeightTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.paperHeightTxt.setLayoutData((Object)gridData);
        label2 = new Label((Composite)group, 0);
        label2.setText(this.unitInch ? " inch" : " cm");
        string2 = new Group(composite2, 0);
        string2.setText("Orientation");
        gridLayout = new GridLayout();
        string2.setLayout((Layout)gridLayout);
        gridData = new GridData(1040);
        string2.setLayoutData((Object)gridData);
        this.portraitBtn = new Button((Composite)string2, 16);
        this.portraitBtn.setText("Portrait");
        this.landscapeBtn = new Button((Composite)string2, 16);
        this.landscapeBtn.setText("Landscape");
        Group group2 = new Group(composite2, 0);
        group2.setText("Headers and Footers");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group2.setLayoutData((Object)gridData);
        Label label4 = new Label((Composite)group2, 0);
        label4.setText("Header:");
        this.headerTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        this.headerTxt.setLayoutData((Object)gridData);
        Label label5 = new Label((Composite)group2, 0);
        label5.setText("Footer:");
        this.footerTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        this.footerTxt.setLayoutData((Object)gridData);
        Group group3 = new Group(composite2, 0);
        group3.setText("Margins " + (this.unitInch ? "(inch)" : "(cm)"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group3.setLayoutData((Object)gridData);
        Label label6 = new Label((Composite)group3, 0);
        label6.setText("Left:");
        this.leftMarginTxt = new Text((Composite)group3, 2048);
        gridData = new GridData(768);
        this.leftMarginTxt.setLayoutData((Object)gridData);
        Label label7 = new Label((Composite)group3, 0);
        label7.setText("Right:");
        this.rightMarginTxt = new Text((Composite)group3, 2048);
        gridData = new GridData(768);
        this.rightMarginTxt.setLayoutData((Object)gridData);
        Label label8 = new Label((Composite)group3, 0);
        label8.setText("Top:");
        this.topMarginTxt = new Text((Composite)group3, 2048);
        gridData = new GridData(768);
        this.topMarginTxt.setLayoutData((Object)gridData);
        Label label9 = new Label((Composite)group3, 0);
        label9.setText("Bottom:");
        this.bottomMarginTxt = new Text((Composite)group3, 2048);
        gridData = new GridData(768);
        this.bottomMarginTxt.setLayoutData((Object)gridData);
        this.initData();
        this.addListeners();
        return composite2;
    }

    private void initData() {
        if (this.value == null) {
            return;
        }
        this.paperFormatCmb.select(this.value.getFormat().getValue());
        this.paperWidthTxt.setText(String.valueOf(this.getDisplayedValue(this.value.getWidth())));
        this.paperHeightTxt.setText(String.valueOf(this.getDisplayedValue(this.value.getHeight())));
        if (this.value.isLandscape()) {
            this.landscapeBtn.setSelection(true);
        } else {
            this.portraitBtn.setSelection(true);
        }
        this.headerTxt.setText(this.value.getHeader());
        this.footerTxt.setText(this.value.getFooter());
        this.leftMarginTxt.setText(String.valueOf(this.getDisplayedValue(this.value.getMarginLeft())));
        this.rightMarginTxt.setText(String.valueOf(this.getDisplayedValue(this.value.getMarginRight())));
        this.topMarginTxt.setText(String.valueOf(this.getDisplayedValue(this.value.getMarginTop())));
        this.bottomMarginTxt.setText(String.valueOf(this.getDisplayedValue(this.value.getMarginBottom())));
    }

    private void addListeners() {
        this.paperFormatCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portraitBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.whListener = new /* Unavailable Anonymous Inner Class!! */;
        this.paperWidthTxt.addModifyListener(this.whListener);
        this.paperHeightTxt.addModifyListener(this.whListener);
    }

    private float getDisplayedValue(float f) {
        if (this.unitInch) {
            return f;
        }
        return UnitConverter.inchToCentimeter((float)f);
    }

    private float getRealValue(float f) {
        if (this.unitInch) {
            return UnitConverter.round2Digits((float)f);
        }
        return UnitConverter.centimeterToInch((float)f);
    }

    private void showErrorMessage(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText("Error");
        messageBox.setMessage(string);
        messageBox.open();
    }

    public void okPressed() {
        try {
            float f = this.validateNumericField(this.paperWidthTxt, "Width", true);
            float f2 = this.validateNumericField(this.paperHeightTxt, "Height", true);
            float f3 = this.validateNumericField(this.leftMarginTxt, "Left margin", false);
            float f4 = this.validateNumericField(this.rightMarginTxt, "Right margin", false);
            float f5 = this.validateNumericField(this.topMarginTxt, "Top margin", false);
            float f6 = this.validateNumericField(this.bottomMarginTxt, "Bottom margin", false);
            int n = this.paperFormatCmb.getSelectionIndex();
            boolean bl = this.portraitBtn.getSelection();
            if (n == 0) {
                for (int i = 0; i < this.paperFormatCmb.getItemCount() - 1; ++i) {
                    if (PaperFormat.getDefaultWidth((int)i, (boolean)bl) != f || PaperFormat.getDefaultHeight((int)i, (boolean)bl) != f2) continue;
                    n = i;
                    break;
                }
            }
            String string = this.headerTxt.getText();
            String string2 = this.footerTxt.getText();
            this.Return = new PaperSize();
            this.Return.setFormat(new PaperFormat(n));
            this.Return.setWidth(f);
            this.Return.setHeight(f2);
            if (bl) {
                this.Return.setOrientation(new PaperOrientation(0));
            } else {
                this.Return.setOrientation(new PaperOrientation(1));
            }
            this.Return.setMarginTop(f5);
            this.Return.setMarginBottom(f6);
            this.Return.setMarginLeft(f3);
            this.Return.setMarginRight(f4);
            this.Return.setHeader(string);
            this.Return.setFooter(string2);
            super.okPressed();
        }
        catch (Exception exception) {
            this.showErrorMessage(exception.getMessage());
        }
    }

    private float validateNumericField(Text text, String string, boolean bl) throws Exception {
        float f;
        try {
            f = Float.parseFloat(text.getText());
        }
        catch (NumberFormatException numberFormatException) {
            f = 0.0f;
        }
        if (f <= 0.0f && (bl || f < 0.0f)) {
            throw new Exception("'" + string + "' field has an invalid value");
        }
        return this.getRealValue(f);
    }

    public PaperSize openDialog() {
        this.open();
        return this.Return;
    }

    static /* synthetic */ Combo access$000(PaperSizeDialog paperSizeDialog) {
        return paperSizeDialog.paperFormatCmb;
    }

    static /* synthetic */ ModifyListener access$100(PaperSizeDialog paperSizeDialog) {
        return paperSizeDialog.whListener;
    }

    static /* synthetic */ Text access$200(PaperSizeDialog paperSizeDialog) {
        return paperSizeDialog.paperWidthTxt;
    }

    static /* synthetic */ Text access$300(PaperSizeDialog paperSizeDialog) {
        return paperSizeDialog.paperHeightTxt;
    }

    static /* synthetic */ Button access$400(PaperSizeDialog paperSizeDialog) {
        return paperSizeDialog.portraitBtn;
    }

    static /* synthetic */ float access$500(PaperSizeDialog paperSizeDialog, float f) {
        return paperSizeDialog.getDisplayedValue(f);
    }
}

