/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.dialogs;

import com.iscobol.reportdesigner.beans.types.PrintChromacity;
import com.iscobol.reportdesigner.beans.types.PrintCollate;
import com.iscobol.reportdesigner.beans.types.PrintQuality;
import com.iscobol.reportdesigner.beans.types.PrintSetup;
import com.iscobol.reportdesigner.beans.types.PrintSides;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.Choice;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.VariableFieldEditor;
import com.iscobol.screenpainter.util.PluginUtilities;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class PrintSetupDialog
extends Dialog {
    private PrintSetup value;
    private PrintSetup Return;
    private Combo printerNameCmb;
    private Spinner copiesSpn;
    private Combo collateCmb;
    private Button defChromacityBtn;
    private Button monochromeBtn;
    private Button colorBtn;
    private Button defQualityBtn;
    private Button qualityDraftBtn;
    private Button qualityNormalBtn;
    private Button qualityHighBtn;
    private Button defSideBtn;
    private Button oneSideBtn;
    private Button tumbleBtn;
    private Button duplexBtn;
    private VariableFieldEditor printerNameVarEd;
    private VariableFieldEditor copiesVarEd;
    private VariableFieldEditor collateVarEd;
    private VariableFieldEditor appearanceVarEd;
    private VariableFieldEditor qualityVarEd;
    private VariableFieldEditor sidesVarEd;

    public PrintSetupDialog(Shell shell, PrintSetup printSetup) {
        super(shell);
        this.value = printSetup;
        if (this.value == null) {
            this.value = new PrintSetup();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Print Setup");
    }

    protected Control createDialogArea(Composite composite) {
        PrintService printService2;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Printer Name:");
        this.printerNameCmb = new Combo(composite2, 2056);
        GridData gridData = new GridData(768);
        this.printerNameCmb.setLayoutData((Object)gridData);
        this.printerNameCmb.add("Default Printer");
        for (PrintService printService2 : PrintServiceLookup.lookupPrintServices(null, null)) {
            this.printerNameCmb.add(printService2.getName());
        }
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        VariableType[] variableTypeArray = screenProgram.getProgramVariables();
        this.printerNameVarEd = this.createEditor(composite2, gridData, "Printer Name variable:", "prn", 1011, variableTypeArray, this.value.getPrinterNameVariable());
        Group group = new Group(composite2, 0);
        group.setText("Copies");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText("Number of copies:");
        this.copiesSpn = new Spinner((Composite)group, 133120);
        this.copiesSpn.setMinimum(1);
        gridData = new GridData();
        gridData.widthHint = 40;
        this.copiesSpn.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.copiesVarEd = this.createEditor((Composite)group, gridData, "Number of copies variable:", "ncp", 1010, variableTypeArray, this.value.getCopiesVariable());
        label = new Label((Composite)group, 0);
        label.setText("Collate:");
        this.collateCmb = new Combo((Composite)group, 2056);
        this.collateCmb.setItems(new PrintCollate().getNames());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.collateVarEd = this.createEditor((Composite)group, gridData, "Collate variable:", "col", 1010, variableTypeArray, this.value.getCollateVariable());
        printService2 = new Group(composite2, 0);
        printService2.setText("Color Appearance");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        printService2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        printService2.setLayoutData(gridData);
        this.defChromacityBtn = new Button((Composite)printService2, 16);
        this.defChromacityBtn.setText("Default");
        this.monochromeBtn = new Button((Composite)printService2, 16);
        this.monochromeBtn.setText("Monochrome");
        this.colorBtn = new Button((Composite)printService2, 16);
        this.colorBtn.setText("Color");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.appearanceVarEd = this.createEditor((Composite)printService2, gridData, "Color appearance variable:", "app", 1010, variableTypeArray, this.value.getChromacityVariable());
        Group group2 = new Group(composite2, 0);
        group2.setText("Quality");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group2.setLayoutData((Object)gridData);
        this.defQualityBtn = new Button((Composite)group2, 16);
        this.defQualityBtn.setText("Default");
        this.qualityDraftBtn = new Button((Composite)group2, 16);
        this.qualityDraftBtn.setText("Draft");
        this.qualityNormalBtn = new Button((Composite)group2, 16);
        this.qualityNormalBtn.setText("Normal");
        this.qualityHighBtn = new Button((Composite)group2, 16);
        this.qualityHighBtn.setText("High");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.qualityVarEd = this.createEditor((Composite)group2, gridData, "Quality variable:", "qlt", 1009, variableTypeArray, this.value.getQualityVariable());
        Group group3 = new Group(composite2, 0);
        group3.setText("Sides");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        group3.setLayoutData((Object)gridData);
        this.defSideBtn = new Button((Composite)group3, 16);
        this.defSideBtn.setText("Default");
        this.oneSideBtn = new Button((Composite)group3, 16);
        this.oneSideBtn.setText("One Side");
        this.tumbleBtn = new Button((Composite)group3, 16);
        this.tumbleBtn.setText("Tumble");
        this.duplexBtn = new Button((Composite)group3, 16);
        this.duplexBtn.setText("Duplex");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.sidesVarEd = this.createEditor((Composite)group3, gridData, "Sides variable:", "sid", 1010, variableTypeArray, this.value.getSidesVariable());
        this.printerNameCmb.setText(this.value.toString());
        this.copiesSpn.setSelection(this.value.getCopies());
        this.collateCmb.select(this.value.getCollate().getValue());
        switch (this.value.getChromacity().getValue()) {
            case 2: {
                this.colorBtn.setSelection(true);
                break;
            }
            case 1: {
                this.monochromeBtn.setSelection(true);
                break;
            }
            default: {
                this.defChromacityBtn.setSelection(true);
            }
        }
        switch (this.value.getQuality().getValue()) {
            case 1: {
                this.qualityDraftBtn.setSelection(true);
                break;
            }
            case 3: {
                this.qualityHighBtn.setSelection(true);
                break;
            }
            case 2: {
                this.qualityNormalBtn.setSelection(true);
                break;
            }
            default: {
                this.defQualityBtn.setSelection(true);
            }
        }
        switch (this.value.getSides().getValue()) {
            case 3: {
                this.duplexBtn.setSelection(true);
                break;
            }
            case 2: {
                this.tumbleBtn.setSelection(true);
                break;
            }
            case 1: {
                this.oneSideBtn.setSelection(true);
                break;
            }
            default: {
                this.defSideBtn.setSelection(true);
            }
        }
        return composite2;
    }

    private VariableFieldEditor createEditor(Composite composite, GridData gridData, String string, String string2, int n, VariableType[] variableTypeArray, String string3) {
        VariableFieldEditor variableFieldEditor = new VariableFieldEditor(composite, string, string2, n, true, variableTypeArray, string3);
        variableFieldEditor.getControl().setLayoutData((Object)gridData);
        return variableFieldEditor;
    }

    private void createVariable(VariableName variableName, int n, String string, Class clazz, ScreenProgram screenProgram) {
        VariableType variableType;
        String string2;
        String string3 = string.substring(0, 1).toUpperCase() + string.substring(1);
        if (variableName != null) {
            if (variableName.getVariable() == null) {
                string2 = variableName.getFullString();
                variableType = screenProgram.createVariable(string2, n);
            } else {
                variableType = variableName.getVariable();
            }
        } else {
            variableType = null;
        }
        try {
            string2 = (String)PrintSetup.class.getMethod("get" + string3, new Class[0]).invoke((Object)this.Return, new Object[0]);
            VariableType variableType2 = null;
            if (string2 != null && string2.length() > 0) {
                variableType2 = screenProgram.getProgramVariable(string2);
            }
            if (variableType2 != null) {
                screenProgram.getResourceRegistry().unregisterVariable(variableType2, (Object)this.Return, string);
            }
            if (variableType != null) {
                PrintSetup.class.getMethod("set" + string3, String.class).invoke((Object)this.Return, variableName.getFullString());
                Object object = PrintSetup.class.getMethod("get" + string3.substring(0, string3.length() - 8), new Class[0]).invoke((Object)this.Return, new Object[0]);
                if (object != null) {
                    if (string.equals("printerNameVariable")) {
                        if ("$$default_printer$$".equals(object.toString())) {
                            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
                            variableType.setValue(printService != null ? "\"" + printService.getName() + "\"" : null);
                        } else {
                            variableType.setValue("\"" + object.toString() + "\"");
                        }
                    } else if (string.equals("copiesVariable")) {
                        variableType.setValue(object.toString());
                    } else if (string.equals("collateVariable")) {
                        switch (((Choice)object).getValue()) {
                            default: {
                                variableType.setValue("1");
                                break;
                            }
                            case 2: {
                                variableType.setValue("0");
                                break;
                            }
                        }
                    } else if (string.equals("chromacityVariable")) {
                        switch (((Choice)object).getValue()) {
                            default: {
                                variableType.setValue("1");
                                break;
                            }
                            case 1: {
                                variableType.setValue("0");
                                break;
                            }
                        }
                    } else if (string.equals("qualityVariable")) {
                        switch (((Choice)object).getValue()) {
                            case 1: {
                                variableType.setValue("-4");
                                break;
                            }
                            case 3: {
                                variableType.setValue("-1");
                                break;
                            }
                            default: {
                                variableType.setValue("-2");
                                break;
                            }
                        }
                    } else if (string.equals("sidesVariable")) {
                        switch (((Choice)object).getValue()) {
                            default: {
                                variableType.setValue("1");
                                break;
                            }
                            case 3: {
                                variableType.setValue("2");
                                break;
                            }
                            case 2: {
                                variableType.setValue("3");
                                break;
                            }
                        }
                    }
                } else {
                    variableType.setValue(null);
                }
                screenProgram.getResourceRegistry().registerVariable(variableType, (Object)this.Return, string);
            } else {
                PrintSetup.class.getMethod("set" + string3, String.class).invoke((Object)this.Return, new Object[]{null});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void okPressed() {
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        VariableName variableName = null;
        VariableName variableName2 = null;
        VariableName variableName3 = null;
        VariableName variableName4 = null;
        VariableName variableName5 = null;
        VariableName variableName6 = null;
        try {
            variableName = this.printerNameVarEd.getValue();
            VariableFieldEditor.validateVariable((VariableName)variableName, (String)"Printer Name variable", (ScreenProgram)screenProgram);
            variableName2 = this.copiesVarEd.getValue();
            VariableFieldEditor.validateVariable((VariableName)variableName2, (String)"Copies variable", (ScreenProgram)screenProgram);
            variableName3 = this.collateVarEd.getValue();
            VariableFieldEditor.validateVariable((VariableName)variableName3, (String)"Collate variable", (ScreenProgram)screenProgram);
            variableName4 = this.appearanceVarEd.getValue();
            VariableFieldEditor.validateVariable((VariableName)variableName4, (String)"Color appearance variable", (ScreenProgram)screenProgram);
            variableName5 = this.qualityVarEd.getValue();
            VariableFieldEditor.validateVariable((VariableName)variableName5, (String)"Quality variable", (ScreenProgram)screenProgram);
            variableName6 = this.sidesVarEd.getValue();
            VariableFieldEditor.validateVariable((VariableName)variableName6, (String)"Sides variable", (ScreenProgram)screenProgram);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PluginUtilities.logError((String)illegalArgumentException.getMessage());
            return;
        }
        this.Return = new PrintSetup();
        this.Return.setPrinterName(this.printerNameCmb.getSelectionIndex() == 0 ? "$$default_printer$$" : this.printerNameCmb.getText());
        this.Return.setCopies(this.copiesSpn.getSelection());
        this.Return.setCollate(new PrintCollate(this.collateCmb.getSelectionIndex()));
        PrintChromacity printChromacity = this.monochromeBtn.getSelection() ? new PrintChromacity(1) : (this.colorBtn.getSelection() ? new PrintChromacity(2) : new PrintChromacity(0));
        this.Return.setChromacity(printChromacity);
        PrintQuality printQuality = this.qualityDraftBtn.getSelection() ? new PrintQuality(1) : (this.qualityHighBtn.getSelection() ? new PrintQuality(3) : (this.qualityNormalBtn.getSelection() ? new PrintQuality(2) : new PrintQuality(0)));
        this.Return.setQuality(printQuality);
        PrintSides printSides = this.tumbleBtn.getSelection() ? new PrintSides(2) : (this.duplexBtn.getSelection() ? new PrintSides(3) : (this.oneSideBtn.getSelection() ? new PrintSides(1) : new PrintSides(0)));
        this.Return.setSides(printSides);
        this.createVariable(variableName, 1011, "printerNameVariable", String.class, screenProgram);
        this.createVariable(variableName2, 1010, "copiesVariable", Integer.TYPE, screenProgram);
        this.createVariable(variableName3, 1010, "collateVariable", PrintCollate.class, screenProgram);
        this.createVariable(variableName4, 1010, "chromacityVariable", PrintChromacity.class, screenProgram);
        this.createVariable(variableName5, 1009, "qualityVariable", PrintQuality.class, screenProgram);
        this.createVariable(variableName6, 1010, "sidesVariable", PrintSides.class, screenProgram);
        super.okPressed();
    }

    public PrintSetup openDialog() {
        this.open();
        return this.Return;
    }
}

