/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.dialogs;

import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportDetail;
import com.iscobol.reportdesigner.beans.ReportFooter;
import com.iscobol.reportdesigner.beans.ReportGroup;
import com.iscobol.reportdesigner.beans.ReportGroupFooter;
import com.iscobol.reportdesigner.beans.ReportGroupHeader;
import com.iscobol.reportdesigner.beans.ReportHeader;
import com.iscobol.reportdesigner.beans.ReportPageFooter;
import com.iscobol.reportdesigner.beans.ReportPageHeader;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.beans.types.GroupType;
import com.iscobol.reportdesigner.dialogs.SectionControllerDialog;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.ComboEditor;
import com.iscobol.screenpainter.propertysheet.ExpressionEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import com.iscobol.screenpainter.propertysheet.VariableEditor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SectionControllerDialog
extends Dialog {
    private static final String GROUP_FIELD = new GroupType().toString();
    private Table hfTable;
    private Table dtlTable;
    private Table grpTable;
    private TableEditor hfEditor;
    private TableEditor dtlEditor;
    private TableEditor grpEditor;
    private Button addDtlBtn;
    private Button removeDtlBtn;
    private Button upDtlBtn;
    private Button downDtlBtn;
    private Button addGrpBtn;
    private Button removeGrpBtn;
    private Button upGrpBtn;
    private Button downGrpBtn;
    private ReportModel reportModel;
    private Set<String> reportElementNames;
    private ReportFooter footer;
    private ReportHeader header;
    private ReportPageFooter pageFooter;
    private ReportPageHeader pageHeader;
    private ReportGroupFooter[] groupFooters;
    private ReportGroupHeader[] groupHeaders;
    private ReportDetail[] details;

    public SectionControllerDialog(Shell shell, ReportModel reportModel) {
        super(shell);
        this.reportModel = reportModel;
        this.reportElementNames = new HashSet();
        Report report = (Report)this.reportModel.getTarget();
        this.reportElementNames.add(report.getName());
        if (report.getHeader() != null) {
            this.addSectionNames((ReportSection)report.getHeader());
        }
        if (report.getPageHeader() != null) {
            this.addSectionNames((ReportSection)report.getPageHeader());
        }
        for (ReportGroupHeader reportGroupHeader : report.getGroupHeaders()) {
            this.addSectionNames((ReportSection)reportGroupHeader);
        }
        for (ReportGroupHeader reportGroupHeader : report.getDetails()) {
            this.addSectionNames((ReportSection)reportGroupHeader);
        }
        for (ReportGroupHeader reportGroupHeader : report.getGroupFooters()) {
            this.addSectionNames((ReportSection)reportGroupHeader);
        }
        if (report.getPageFooter() != null) {
            this.addSectionNames((ReportSection)report.getPageFooter());
        }
        if (report.getFooter() != null) {
            this.addSectionNames((ReportSection)report.getFooter());
        }
    }

    private void addSectionNames(ReportSection reportSection) {
        this.reportElementNames.add(reportSection.getName());
        for (ReportControl reportControl : reportSection.getComponents()) {
            this.reportElementNames.add(reportControl.getName());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Section Controller");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        group.setLayoutData((Object)gridData);
        group.setText("Header/Footer");
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        this.hfTable = new Table((Composite)group, 67618);
        this.hfTable.setLinesVisible(true);
        this.hfTable.setHeaderVisible(true);
        gridData = new GridData(1808);
        this.hfTable.setLayoutData((Object)gridData);
        this.hfEditor = new TableEditor(this.hfTable);
        this.hfEditor.grabHorizontal = true;
        TableColumn tableColumn = new TableColumn(this.hfTable, 0);
        tableColumn.setWidth(40);
        tableColumn = new TableColumn(this.hfTable, 0);
        tableColumn.setWidth(200);
        tableColumn.setText("Name");
        tableColumn = new TableColumn(this.hfTable, 0);
        tableColumn.setWidth(130);
        tableColumn.setText("Count height");
        Group group2 = new Group(composite2, 0);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        group2.setLayoutData((Object)gridData);
        group2.setText("Detail Section");
        gridLayout = new GridLayout();
        group2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite((Composite)group2, 0);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 131072;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite3.setLayout((Layout)gridLayout);
        this.upDtlBtn = new Button(composite3, 8);
        this.upDtlBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_up.png"));
        this.downDtlBtn = new Button(composite3, 8);
        this.downDtlBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_down.png"));
        this.addDtlBtn = new Button(composite3, 8);
        this.addDtlBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/add_item.gif"));
        this.removeDtlBtn = new Button(composite3, 8);
        this.removeDtlBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/remove_item.gif"));
        this.dtlTable = new Table((Composite)group2, 67586);
        this.dtlTable.setLinesVisible(true);
        this.dtlTable.setHeaderVisible(true);
        gridData = new GridData(1808);
        this.dtlTable.setLayoutData((Object)gridData);
        this.dtlEditor = new TableEditor(this.dtlTable);
        this.dtlEditor.grabHorizontal = true;
        tableColumn = new TableColumn(this.dtlTable, 0);
        tableColumn.setWidth(200);
        tableColumn.setText("Name");
        tableColumn = new TableColumn(this.dtlTable, 0);
        tableColumn.setWidth(180);
        tableColumn.setText("Count height");
        Group group3 = new Group(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 200;
        group3.setLayoutData((Object)gridData);
        group3.setText("Group Section");
        gridLayout = new GridLayout();
        group3.setLayout((Layout)gridLayout);
        composite3 = new Composite((Composite)group3, 0);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 131072;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite3.setLayout((Layout)gridLayout);
        this.upGrpBtn = new Button(composite3, 8);
        this.upGrpBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_up.png"));
        this.downGrpBtn = new Button(composite3, 8);
        this.downGrpBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_down.png"));
        this.addGrpBtn = new Button(composite3, 8);
        this.addGrpBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/add_item.gif"));
        this.removeGrpBtn = new Button(composite3, 8);
        this.removeGrpBtn.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/remove_item.gif"));
        this.grpTable = new Table((Composite)group3, 67586);
        this.grpTable.setLinesVisible(true);
        this.grpTable.setHeaderVisible(true);
        gridData = new GridData(768);
        gridData.heightHint = 300;
        this.grpTable.setLayoutData((Object)gridData);
        this.grpEditor = new TableEditor(this.grpTable);
        this.grpEditor.grabHorizontal = true;
        tableColumn = new TableColumn(this.grpTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText("Type");
        tableColumn = new TableColumn(this.grpTable, 0);
        tableColumn.setWidth(250);
        tableColumn.setText("Grouped By");
        tableColumn = new TableColumn(this.grpTable, 0);
        tableColumn.setWidth(150);
        tableColumn.setText("Show what");
        tableColumn = new TableColumn(this.grpTable, 0);
        tableColumn.setWidth(100);
        tableColumn.setText("Count height");
        this.initData();
        this.addListeners();
        return composite2;
    }

    private void initData() {
        ReportGroup[] reportGroupArray;
        Report report = (Report)this.reportModel.getTarget();
        this.createHeaderFooterItem((ReportSection)report.getHeader(), "Report Header");
        this.createHeaderFooterItem((ReportSection)report.getFooter(), "Report Footer");
        this.createHeaderFooterItem((ReportSection)report.getPageHeader(), "Page Header");
        this.createHeaderFooterItem((ReportSection)report.getPageFooter(), "Page Footer");
        for (ReportDetail reportDetail : report.getDetails()) {
            this.createDetailItem(reportDetail);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (ReportGroupHeader reportGroupHeader : report.getGroupHeaders()) {
            reportGroupArray = (ReportGroup[])linkedHashMap.get(reportGroupHeader.getGroupedBy());
            if (reportGroupArray == null) {
                reportGroupArray = new ReportGroup[2];
                linkedHashMap.put(reportGroupHeader.getGroupedBy(), reportGroupArray);
            }
            reportGroupArray[0] = reportGroupHeader;
        }
        for (ReportGroupHeader reportGroupHeader : report.getGroupFooters()) {
            reportGroupArray = (ReportGroup[])linkedHashMap.get(reportGroupHeader.getGroupedBy());
            if (reportGroupArray == null) {
                reportGroupArray = new ReportGroup[2];
                linkedHashMap.put(reportGroupHeader.getGroupedBy(), reportGroupArray);
            }
            reportGroupArray[1] = reportGroupHeader;
        }
        for (ReportGroup[] reportGroupArray2 : linkedHashMap.values()) {
            this.createGroupItem(reportGroupArray2);
        }
    }

    private void createHeaderFooterItem(ReportSection reportSection, String string) {
        TableItem tableItem = new TableItem(this.hfTable, 0);
        tableItem.setChecked(reportSection != null);
        tableItem.setText(1, string);
        boolean bl = reportSection != null && reportSection.isCountHeight();
        tableItem.setText(2, String.valueOf(bl));
        tableItem.setData((Object)reportSection);
    }

    private void createDetailItem(ReportDetail reportDetail) {
        TableItem tableItem = new TableItem(this.dtlTable, 0);
        tableItem.setText(0, reportDetail.getName());
        tableItem.setText(1, String.valueOf(reportDetail.isCountHeight()));
        tableItem.setData((Object)reportDetail);
    }

    private void createGroupItem(ReportGroup[] reportGroupArray) {
        TableItem tableItem = new TableItem(this.grpTable, 0);
        GroupType groupType = reportGroupArray[0] != null ? reportGroupArray[0].getGroupType() : reportGroupArray[1].getGroupType();
        String string = reportGroupArray[0] != null ? reportGroupArray[0].getGroupedBy() : reportGroupArray[1].getGroupedBy();
        tableItem.setText(0, groupType.toString());
        if (string != null) {
            tableItem.setText(1, string);
            this.grpTable.setData(string, (Object)reportGroupArray);
        }
        tableItem.setData((Object)reportGroupArray);
        String string2 = reportGroupArray[0] != null ? (reportGroupArray[1] != null ? "Both" : "Header") : "Footer";
        tableItem.setText(2, string2);
        String string3 = reportGroupArray[0] != null && reportGroupArray[0].isCountHeight() ? (reportGroupArray[1] != null && reportGroupArray[1].isCountHeight() ? "Both" : "Header") : (reportGroupArray[1] != null && reportGroupArray[1].isCountHeight() ? "Footer" : "None");
        tableItem.setText(3, string3);
    }

    private void addListeners() {
        this.hfTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.hfTable.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dtlTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.grpTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addDtlBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeDtlBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upDtlBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downDtlBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addGrpBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeGrpBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upGrpBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downGrpBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleHFTableCheck(SelectionEvent selectionEvent) {
        TableItem tableItem = (TableItem)selectionEvent.item;
        int n = this.hfTable.indexOf(tableItem);
        if (selectionEvent.detail == 32 && tableItem.getData() == null) {
            ReportSection reportSection = this.createNewHeaderFooter(n);
            tableItem.setData((Object)reportSection);
        }
    }

    private void handleHFTableSelection(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.hfTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        TableItem tableItem = this.hfTable.getItem(nArray[0]);
        switch (nArray[1]) {
            case 2: {
                this.createComboEditor(this.hfTable, this.hfEditor, tableItem, 2, new String[]{"false", "true"});
            }
        }
    }

    private void createComboEditor(Table table, TableEditor tableEditor, TableItem tableItem, int n, String[] stringArray) {
        ComboEditor comboEditor = new ComboEditor(false);
        13 var7_7 = new /* Unavailable Anonymous Inner Class!! */;
        this.createComboEditor(table, tableEditor, tableItem, n, stringArray, comboEditor, (ValueListener)var7_7);
    }

    private void createComboEditor(Table table, TableEditor tableEditor, TableItem tableItem, int n, String[] stringArray, ComboEditor comboEditor, ValueListener valueListener) {
        comboEditor.setItems(stringArray);
        comboEditor.createEditor((Composite)table);
        comboEditor.setListener(valueListener);
        tableEditor.setEditor(comboEditor.getEditor(), tableItem, n);
        String string = tableItem.getText(n);
        Integer n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n2 = i;
            break;
        }
        comboEditor.setValue((Object)n2);
        comboEditor.selectAll();
        comboEditor.setFocus();
    }

    private void createExpressionEditor(Table table, TableEditor tableEditor, TableItem tableItem, int n) {
        ExpressionEditor expressionEditor = new ExpressionEditor("Grouped By");
        expressionEditor.createEditor((Composite)table);
        expressionEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
        tableEditor.setEditor(expressionEditor.getEditor(), tableItem, n);
        String string = tableItem.getText(n);
        expressionEditor.setValue((Object)string);
        expressionEditor.selectAll();
        expressionEditor.setFocus();
    }

    private void createVariableEditor(Table table, TableEditor tableEditor, TableItem tableItem, int n) {
        VariableEditor variableEditor = new VariableEditor(1001, 0, "rpt_grouped_by_var", null);
        variableEditor.createEditor((Composite)table);
        variableEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
        tableEditor.setEditor(variableEditor.getEditor(), tableItem, n);
        String string = tableItem.getText(n);
        ScreenProgram screenProgram = this.reportModel.getScreenProgram();
        VariableType variableType = screenProgram.getProgramVariable(string);
        if (variableType != null) {
            variableEditor.setValue((Object)variableType);
        } else {
            variableEditor.setValue((Object)new VariableName(null, string));
        }
        variableEditor.selectAll();
        variableEditor.setFocus();
    }

    private void handleDTLTableSelection(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.dtlTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        TableItem tableItem = this.dtlTable.getItem(nArray[0]);
        switch (nArray[1]) {
            case 1: {
                this.createComboEditor(this.dtlTable, this.dtlEditor, tableItem, 1, new String[]{"false", "true"});
            }
        }
    }

    private void handleGRPTableSelection(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.grpTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        TableItem tableItem = this.grpTable.getItem(nArray[0]);
        switch (nArray[1]) {
            case 0: {
                this.createComboEditor(this.grpTable, this.grpEditor, tableItem, 0, new GroupType().getNames());
                break;
            }
            case 1: {
                if (tableItem.getText(0).equals(GROUP_FIELD)) {
                    this.createVariableEditor(this.grpTable, this.grpEditor, tableItem, 1);
                    break;
                }
                this.createExpressionEditor(this.grpTable, this.grpEditor, tableItem, 1);
                break;
            }
            case 2: {
                ComboEditor comboEditor = new ComboEditor(false);
                16 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
                this.createComboEditor(this.grpTable, this.grpEditor, tableItem, 2, new String[]{"Both", "Header", "Footer"}, comboEditor, (ValueListener)var5_5);
                break;
            }
            case 3: {
                String string = tableItem.getText(2);
                String[] stringArray = this.getGRPCountHeightItems(string);
                this.createComboEditor(this.grpTable, this.grpEditor, tableItem, 3, stringArray);
            }
        }
    }

    private String[] getGRPCountHeightItems(String string) {
        String[] stringArray = string.equals("Both") ? new String[]{"None", "Both", "Header", "Footer"} : (string.equals("Header") ? new String[]{"None", "Header"} : new String[]{"None", "Footer"});
        return stringArray;
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private String getDefaultName(String string) {
        String string2 = string + "1";
        int n = 2;
        while (this.reportElementNames.contains(string2)) {
            string2 = string + Integer.toString(n);
            ++n;
        }
        return string2;
    }

    private void swap(TableItem tableItem, TableItem tableItem2, int n) {
        int n2;
        Object object = tableItem.getData();
        String[] stringArray = new String[n];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray[n2] = tableItem.getText(n2);
        }
        tableItem.setData(tableItem2.getData());
        for (n2 = 0; n2 < n; ++n2) {
            tableItem.setText(n2, tableItem2.getText(n2));
        }
        tableItem2.setData(object);
        for (n2 = 0; n2 < n; ++n2) {
            tableItem2.setText(n2, stringArray[n2]);
        }
    }

    private void up(Table table) {
        if (table.getSelectionIndex() > 0) {
            TableItem tableItem = table.getSelection()[0];
            TableItem tableItem2 = table.getItem(table.getSelectionIndex() - 1);
            this.swap(tableItem, tableItem2, table.getColumnCount());
        }
    }

    private void down(Table table) {
        if (table.getSelectionIndex() >= 0 && table.getSelectionIndex() < table.getItemCount() - 1) {
            TableItem tableItem = table.getSelection()[0];
            TableItem tableItem2 = table.getItem(table.getSelectionIndex() + 1);
            this.swap(tableItem, tableItem2, table.getColumnCount());
        }
    }

    private void addDetail() {
        ReportDetail reportDetail = new ReportDetail();
        Report report = (Report)this.reportModel.getTarget();
        String string = this.getDefaultName(report.getName() + "-dtl-");
        reportDetail.setName(string);
        this.reportElementNames.add(string);
        this.createDetailItem(reportDetail);
    }

    private void removeDetail() {
        if (this.dtlTable.getSelectionCount() > 0) {
            TableItem[] tableItemArray;
            for (TableItem tableItem : tableItemArray = this.dtlTable.getSelection()) {
                ReportDetail reportDetail = (ReportDetail)tableItem.getData();
                this.reportElementNames.remove(reportDetail.getName());
                tableItem.dispose();
            }
        }
    }

    private void upDetail() {
        this.up(this.dtlTable);
    }

    private void downDetail() {
        this.down(this.dtlTable);
    }

    private void addGroup() {
        ReportGroup reportGroup = this.createNewGroup(true);
        this.createGroupItem(new ReportGroup[]{reportGroup, null});
    }

    private ReportGroup createNewGroup(boolean bl) {
        ReportGroupHeader reportGroupHeader = bl ? new ReportGroupHeader() : new ReportGroupFooter();
        reportGroupHeader.setCountHeight(true);
        Report report = (Report)this.reportModel.getTarget();
        String string = this.getDefaultName(report.getName() + (bl ? "-gh-" : "-gf-"));
        reportGroupHeader.setName(string);
        this.reportElementNames.add(string);
        return reportGroupHeader;
    }

    private ReportSection createNewHeaderFooter(int n) {
        ReportHeader reportHeader = null;
        switch (n) {
            case 0: {
                reportHeader = new ReportHeader();
                break;
            }
            case 1: {
                reportHeader = new ReportFooter();
                break;
            }
            case 2: {
                reportHeader = new ReportPageHeader();
                break;
            }
            case 3: {
                reportHeader = new ReportPageFooter();
            }
        }
        reportHeader.setCountHeight(false);
        Report report = (Report)this.reportModel.getTarget();
        String string = this.getDefaultName(report.getName() + "-" + IscobolBeanConstants.getShortTypeName((int)reportHeader.getType()) + "-");
        reportHeader.setName(string);
        this.reportElementNames.add(string);
        return reportHeader;
    }

    private void removeGroup() {
        if (this.grpTable.getSelectionCount() > 0) {
            TableItem[] tableItemArray;
            for (TableItem tableItem : tableItemArray = this.grpTable.getSelection()) {
                ReportGroup[] reportGroupArray = (ReportGroup[])tableItem.getData();
                String string = null;
                if (reportGroupArray[0] != null) {
                    string = reportGroupArray[0].getGroupedBy();
                    this.reportElementNames.remove(reportGroupArray[0].getName());
                }
                if (reportGroupArray[1] != null) {
                    string = reportGroupArray[1].getGroupedBy();
                    this.reportElementNames.remove(reportGroupArray[1].getName());
                }
                tableItem.dispose();
                if (string == null) continue;
                this.grpTable.setData(string, (Object)reportGroupArray);
            }
        }
    }

    private void upGroup() {
        this.up(this.grpTable);
    }

    private void downGroup() {
        this.down(this.grpTable);
    }

    /*
     * WARNING - void declaration
     */
    public void okPressed() {
        void var10_32;
        int n;
        boolean bl;
        int n2;
        int n3;
        ScreenProgram screenProgram = this.reportModel.getScreenProgram();
        boolean bl2 = false;
        for (TableItem object2 : this.hfTable.getItems()) {
            if (!object2.getChecked()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            boolean bl3 = bl2 = this.dtlTable.getItemCount() > 0 || this.grpTable.getItemCount() > 0;
        }
        if (!bl2) {
            this.showErrorMessage("A report must have at least one section");
            return;
        }
        TableItem[] tableItemArray = this.grpTable.getItems();
        TableItem[] tableItemArray2 = this.dtlTable.getItems();
        for (n3 = 0; n3 < tableItemArray.length; ++n3) {
            String string = tableItemArray[n3].getText(1).trim();
            if (string.length() == 0) {
                this.showErrorMessage("Value required for 'Grouped By' property");
                return;
            }
            for (int reportGroupFooterArray = n3 + 1; reportGroupFooterArray < tableItemArray.length; ++reportGroupFooterArray) {
                String string2 = tableItemArray[reportGroupFooterArray].getText(1).trim();
                if (!string.equalsIgnoreCase(string2)) continue;
                this.showErrorMessage("'Grouped By' is duplicated: '" + string + "'");
                return;
            }
        }
        n3 = 0;
        Report report = (Report)this.reportModel.getTarget();
        n3 |= !this.hfTable.getItem(0).getChecked() && report.getHeader() != null ? 1 : 0;
        n3 |= !this.hfTable.getItem(1).getChecked() && report.getFooter() != null ? 1 : 0;
        n3 |= !this.hfTable.getItem(2).getChecked() && report.getPageHeader() != null ? 1 : 0;
        if ((n3 |= !this.hfTable.getItem(3).getChecked() && report.getPageFooter() != null ? 1 : 0) == 0 && report.getGroupHeaderCount() > 0) {
            ReportGroupHeader[] reportGroupHeaderArray = report.getGroupHeaders();
            int arrayList2 = reportGroupHeaderArray.length;
            for (n2 = 0; n2 < arrayList2; ++n2) {
                ReportGroupHeader reportGroupHeader = reportGroupHeaderArray[n2];
                bl = false;
                for (TableItem tableItem : tableItemArray) {
                    if (((ReportGroup[])tableItem.getData())[0] != reportGroupHeader || tableItem.getText(2).equals("Footer")) continue;
                    bl = true;
                    break;
                }
                if ((n3 |= !bl ? 1 : 0) != 0) break;
            }
        }
        if (n3 == 0 && report.getGroupFooterCount() > 0) {
            ReportGroupFooter[] i = report.getGroupFooters();
            int n4 = i.length;
            for (n2 = 0; n2 < n4; ++n2) {
                ReportGroupFooter reportGroupFooter = i[n2];
                bl = false;
                for (TableItem tableItem : tableItemArray) {
                    if (((ReportGroup[])tableItem.getData())[1] != reportGroupFooter || tableItem.getText(2).equals("Header")) continue;
                    bl = true;
                    break;
                }
                if ((n3 |= !bl ? 1 : 0) != 0) break;
            }
        }
        if (n3 == 0 && report.getDetailCount() > 0) {
            for (ReportDetail reportDetail : report.getDetails()) {
                bl = false;
                for (TableItem tableItem : tableItemArray2) {
                    if (tableItem.getData() != reportDetail) continue;
                    bl = true;
                    break;
                }
                if ((n3 |= !bl ? 1 : 0) != 0) break;
            }
        }
        if (n3 != 0 && (n = this.showWarningMessage("Warning: some sections were deleted, the information in those sections will be lost!")) != 32) {
            return;
        }
        if (this.hfTable.getItem(0).getChecked()) {
            this.header = (ReportHeader)this.hfTable.getItem(0).getData();
            this.header.setCountHeight(Boolean.parseBoolean(this.hfTable.getItem(0).getText(1)));
        }
        if (this.hfTable.getItem(1).getChecked()) {
            this.footer = (ReportFooter)this.hfTable.getItem(1).getData();
            this.footer.setCountHeight(Boolean.parseBoolean(this.hfTable.getItem(1).getText(1)));
        }
        if (this.hfTable.getItem(2).getChecked()) {
            this.pageHeader = (ReportPageHeader)this.hfTable.getItem(2).getData();
            this.pageHeader.setCountHeight(Boolean.parseBoolean(this.hfTable.getItem(2).getText(1)));
        }
        if (this.hfTable.getItem(3).getChecked()) {
            this.pageFooter = (ReportPageFooter)this.hfTable.getItem(3).getData();
            this.pageFooter.setCountHeight(Boolean.parseBoolean(this.hfTable.getItem(3).getText(1)));
        }
        this.details = new ReportDetail[tableItemArray2.length];
        for (int i = 0; i < tableItemArray2.length; ++i) {
            this.details[i] = (ReportDetail)tableItemArray2[i].getData();
            this.details[i].setCountHeight(Boolean.parseBoolean(tableItemArray2[i].getText(1)));
        }
        ArrayList<ReportGroupHeader> arrayList = new ArrayList<ReportGroupHeader>();
        ArrayList<ReportGroupFooter> arrayList2 = new ArrayList<ReportGroupFooter>();
        String string = "rpt_grouped_by_var";
        boolean bl4 = false;
        while (var10_32 < tableItemArray.length) {
            ReportGroup[] reportGroupArray = (ReportGroup[])tableItemArray[var10_32].getData();
            if (!tableItemArray[var10_32].getText(2).equals("Footer")) {
                arrayList.add((ReportGroupHeader)reportGroupArray[0]);
                ReportModelElement.setVariablePropertyValue((Object)reportGroupArray[0], (String)string, (VariableName)((VariableName)tableItemArray[var10_32].getData(string)), (ScreenProgram)screenProgram);
                reportGroupArray[0].setGroupedBy(tableItemArray[var10_32].getText(1));
                if (tableItemArray[var10_32].getText(0).equals(GROUP_FIELD)) {
                    reportGroupArray[0].setGroupType(new GroupType(0));
                } else {
                    reportGroupArray[0].setGroupType(new GroupType(1));
                }
            }
            if (!tableItemArray[var10_32].getText(2).equals("Header")) {
                arrayList2.add(0, (ReportGroupFooter)reportGroupArray[1]);
                ReportModelElement.setVariablePropertyValue((Object)reportGroupArray[1], (String)string, (VariableName)((VariableName)tableItemArray[var10_32].getData(string)), (ScreenProgram)screenProgram);
                reportGroupArray[1].setGroupedBy(tableItemArray[var10_32].getText(1));
                if (tableItemArray[var10_32].getText(0).equals(GROUP_FIELD)) {
                    reportGroupArray[1].setGroupType(new GroupType(0));
                } else {
                    reportGroupArray[1].setGroupType(new GroupType(1));
                }
            }
            if (tableItemArray[var10_32].getText(3).equals("None")) {
                if (reportGroupArray[0] != null) {
                    reportGroupArray[0].setCountHeight(false);
                }
                if (reportGroupArray[1] != null) {
                    reportGroupArray[1].setCountHeight(false);
                }
            } else if (tableItemArray[var10_32].getText(3).equals("Header")) {
                if (reportGroupArray[0] != null) {
                    reportGroupArray[0].setCountHeight(true);
                }
                if (reportGroupArray[1] != null) {
                    reportGroupArray[1].setCountHeight(false);
                }
            } else if (tableItemArray[var10_32].getText(3).equals("Footer")) {
                if (reportGroupArray[0] != null) {
                    reportGroupArray[0].setCountHeight(false);
                }
                if (reportGroupArray[1] != null) {
                    reportGroupArray[1].setCountHeight(true);
                }
            } else {
                if (reportGroupArray[0] != null) {
                    reportGroupArray[0].setCountHeight(true);
                }
                if (reportGroupArray[1] != null) {
                    reportGroupArray[1].setCountHeight(true);
                }
            }
            ++var10_32;
        }
        this.groupHeaders = arrayList.toArray(new ReportGroupHeader[arrayList.size()]);
        this.groupFooters = arrayList2.toArray(new ReportGroupFooter[arrayList2.size()]);
        super.okPressed();
    }

    private void showErrorMessage(String string) {
        this.showMessage(string, 33);
    }

    private int showWarningMessage(String string) {
        return this.showMessage(string, 296);
    }

    private int showMessage(String string, int n) {
        MessageBox messageBox = new MessageBox(this.getShell(), n);
        messageBox.setText(this.getShell().getText());
        messageBox.setMessage(string);
        return messageBox.open();
    }

    public boolean openDialog() {
        return this.open() == 0;
    }

    public ReportFooter getFooter() {
        return this.footer;
    }

    public void setFooter(ReportFooter reportFooter) {
        this.footer = reportFooter;
    }

    public ReportHeader getHeader() {
        return this.header;
    }

    public void setHeader(ReportHeader reportHeader) {
        this.header = reportHeader;
    }

    public ReportPageFooter getPageFooter() {
        return this.pageFooter;
    }

    public void setPageFooter(ReportPageFooter reportPageFooter) {
        this.pageFooter = reportPageFooter;
    }

    public ReportPageHeader getPageHeader() {
        return this.pageHeader;
    }

    public void setPageHeader(ReportPageHeader reportPageHeader) {
        this.pageHeader = reportPageHeader;
    }

    public ReportGroupFooter[] getGroupFooters() {
        return this.groupFooters;
    }

    public void setGroupFooters(ReportGroupFooter[] reportGroupFooterArray) {
        this.groupFooters = reportGroupFooterArray;
    }

    public ReportGroupHeader[] getGroupHeaders() {
        return this.groupHeaders;
    }

    public void setGroupHeaders(ReportGroupHeader[] reportGroupHeaderArray) {
        this.groupHeaders = reportGroupHeaderArray;
    }

    public ReportDetail[] getDetails() {
        return this.details;
    }

    public void setDetails(ReportDetail[] reportDetailArray) {
        this.details = reportDetailArray;
    }

    public Set<String> getReportElementNames() {
        return this.reportElementNames;
    }

    static /* synthetic */ void access$000(SectionControllerDialog sectionControllerDialog, MouseEvent mouseEvent) {
        sectionControllerDialog.handleHFTableSelection(mouseEvent);
    }

    static /* synthetic */ void access$100(SectionControllerDialog sectionControllerDialog, SelectionEvent selectionEvent) {
        sectionControllerDialog.handleHFTableCheck(selectionEvent);
    }

    static /* synthetic */ void access$200(SectionControllerDialog sectionControllerDialog, MouseEvent mouseEvent) {
        sectionControllerDialog.handleDTLTableSelection(mouseEvent);
    }

    static /* synthetic */ void access$300(SectionControllerDialog sectionControllerDialog, MouseEvent mouseEvent) {
        sectionControllerDialog.handleGRPTableSelection(mouseEvent);
    }

    static /* synthetic */ void access$400(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.addDetail();
    }

    static /* synthetic */ void access$500(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.removeDetail();
    }

    static /* synthetic */ void access$600(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.upDetail();
    }

    static /* synthetic */ void access$700(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.downDetail();
    }

    static /* synthetic */ void access$800(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.addGroup();
    }

    static /* synthetic */ void access$900(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.removeGroup();
    }

    static /* synthetic */ void access$1000(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.upGroup();
    }

    static /* synthetic */ void access$1100(SectionControllerDialog sectionControllerDialog) {
        sectionControllerDialog.downGroup();
    }

    static /* synthetic */ ReportGroup access$1200(SectionControllerDialog sectionControllerDialog, boolean bl) {
        return sectionControllerDialog.createNewGroup(bl);
    }

    static /* synthetic */ String[] access$1300(SectionControllerDialog sectionControllerDialog, String string) {
        return sectionControllerDialog.getGRPCountHeightItems(string);
    }
}

