/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TableRearrangeDialog
extends Dialog {
    private Combo rowCmb;
    private Combo columnCmb;
    private Button rowBtn;
    private Button columnBtn;
    private int numRows;
    private int numColumns;
    private boolean rowRearrange;
    private boolean ok;

    public TableRearrangeDialog(Shell shell, int n, int n2) {
        super(shell);
        this.numRows = n;
        this.numColumns = n2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Table Rearrange");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Arrangement");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText("Column number:");
        this.columnCmb = new Combo((Composite)group, 2056);
        GridData gridData = new GridData();
        gridData.widthHint = 70;
        this.columnCmb.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText("Row number:");
        this.rowCmb = new Combo((Composite)group, 2056);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.rowCmb.setLayoutData((Object)gridData);
        Group group2 = new Group(composite2, 0);
        group2.setText("Arrange Type");
        gridLayout = new GridLayout();
        group2.setLayout((Layout)gridLayout);
        this.rowBtn = new Button((Composite)group2, 16);
        this.rowBtn.setText("Row Measure");
        this.columnBtn = new Button((Composite)group2, 16);
        this.columnBtn.setText("Column Measure");
        int n = this.numRows * this.numColumns;
        int[] nArray = this.getDivisors(n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            this.rowCmb.add(String.valueOf(nArray[i]));
            this.columnCmb.add(String.valueOf(nArray[i]));
            if (nArray[i] == this.numRows) {
                n2 = i;
            }
            if (nArray[i] != this.numColumns) continue;
            n3 = i;
        }
        this.rowCmb.select(n2);
        this.columnCmb.select(n3);
        this.rowBtn.setSelection(true);
        this.rowCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.columnCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private int[] getDivisors(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        int n2 = n / 2;
        for (int i = 2; i <= n2; ++i) {
            if (n % i != 0) continue;
            arrayList.add(i);
        }
        arrayList.add(n);
        int[] nArray = new int[arrayList.size()];
        int n3 = 0;
        for (Integer n4 : arrayList) {
            nArray[n3++] = n4;
        }
        return nArray;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public boolean isRowRearrange() {
        return this.rowRearrange;
    }

    public void okPressed() {
        this.ok = true;
        this.numRows = Integer.parseInt(this.rowCmb.getText());
        this.numColumns = Integer.parseInt(this.columnCmb.getText());
        this.rowRearrange = this.rowBtn.getSelection();
        super.okPressed();
    }

    public boolean openDialog() {
        this.open();
        return this.ok;
    }

    static /* synthetic */ Combo access$000(TableRearrangeDialog tableRearrangeDialog) {
        return tableRearrangeDialog.rowCmb;
    }

    static /* synthetic */ Combo access$100(TableRearrangeDialog tableRearrangeDialog) {
        return tableRearrangeDialog.columnCmb;
    }
}

