/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.handlers;

import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.dialogs.SectionControllerDialog;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.reportdesigner.parts.ReportDesignerEditPart;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SectionControllerHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchPart iWorkbenchPart = HandlerUtil.getActivePart((ExecutionEvent)executionEvent);
        EditPart editPart = this.getSelectedEditPart(executionEvent);
        if (editPart instanceof ReportDesignerEditPart) {
            ReportModel reportModel = ((ReportModelElement)editPart.getModel()).getReportModel();
            SectionControllerDialog sectionControllerDialog = new SectionControllerDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), reportModel);
            if (sectionControllerDialog.openDialog()) {
                ScreenProgram screenProgram = reportModel.getScreenProgram();
                Set set = sectionControllerDialog.getReportElementNames();
                for (String string : set) {
                    screenProgram.registerReportControlName(string);
                }
                Report report = (Report)reportModel.getTarget();
                report.removeAllSections();
                report.setHeader(sectionControllerDialog.getHeader());
                report.setFooter(sectionControllerDialog.getFooter());
                report.setPageHeader(sectionControllerDialog.getPageHeader());
                report.setPageFooter(sectionControllerDialog.getPageFooter());
                report.setDetails(sectionControllerDialog.getDetails());
                report.setGroupHeaders(sectionControllerDialog.getGroupHeaders());
                report.setGroupFooters(sectionControllerDialog.getGroupFooters());
                reportModel.updateStructure();
                if (iWorkbenchPart instanceof ScreenProgramEditor) {
                    ((ScreenProgramEditor)iWorkbenchPart).setDirty(true);
                }
            }
        }
        return null;
    }

    private EditPart getSelectedEditPart(ExecutionEvent executionEvent) {
        StructuredSelection structuredSelection;
        Object object;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)iSelection).getFirstElement()) instanceof EditPart) {
            return (EditPart)object;
        }
        return null;
    }
}

