/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.model;

import com.iscobol.reportdesigner.UnitConverter;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.beans.ReportLine;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.model.ScreenPainterModelWithTitle;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class ReportComponentModel
extends ReportModelElement
implements ScreenPainterModelWithTitle {
    public ReportComponentModel(ReportElement reportElement) {
        super(reportElement);
    }

    public ReportComponentModel(int n) {
        super(n);
    }

    public void setPropertyValue(Object object, Object object2) {
        if ("size".equals(object) || "lines".equals(object) || "column".equals(object) || "line".equals(object)) {
            Float f;
            ReportControl reportControl = (ReportControl)this.getTarget();
            Float f2 = PropertyDescriptorRegistry.ParseFloat((String)((String)object2));
            if (UnitConverter.isUnitCentimeter()) {
                f2 = Float.valueOf(UnitConverter.centimeterToInch((float)f2.floatValue()));
            }
            if ("size".equals(object)) {
                f = new Float(reportControl.getSize());
                reportControl.setSize(f2.floatValue());
            } else if ("lines".equals(object)) {
                f = new Float(reportControl.getLines());
                reportControl.setLines(f2.floatValue());
            } else if ("column".equals(object)) {
                f = new Float(reportControl.getColumn());
                reportControl.setColumn(f2.floatValue());
            } else {
                f = new Float(reportControl.getLine());
                reportControl.setLine(f2.floatValue());
            }
            this.firePropertyChange(object.toString(), (Object)f, (Object)f2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    public int getWidth() {
        if (this.getType() == 508) {
            ReportLine reportLine = (ReportLine)this.getTarget();
            if (reportLine.isHorizontal()) {
                return UnitConverter.inchToPixel((float)((ReportControl)this.getTarget()).getSize());
            }
            return reportLine.getWidth();
        }
        return UnitConverter.inchToPixel((float)((ReportControl)this.getTarget()).getSize());
    }

    public int getHeight() {
        if (this.getType() == 508) {
            ReportLine reportLine = (ReportLine)this.getTarget();
            if (reportLine.isVertical()) {
                return UnitConverter.inchToPixel((float)((ReportControl)this.getTarget()).getLines());
            }
            return reportLine.getWidth();
        }
        return UnitConverter.inchToPixel((float)((ReportControl)this.getTarget()).getLines());
    }

    public int getX() {
        return UnitConverter.inchToPixel((float)((ReportControl)this.getTarget()).getColumn());
    }

    public int getY() {
        return UnitConverter.inchToPixel((float)((ReportControl)this.getTarget()).getLine());
    }

    public void setSize(int n, int n2) {
        String string = String.valueOf(UnitConverter.toUnit((int)n));
        this.setPropertyValue((Object)"size", (Object)string);
        string = String.valueOf(UnitConverter.toUnit((int)n2));
        this.setPropertyValue((Object)"lines", (Object)string);
    }

    public void setLocation(int n, int n2) {
        String string = String.valueOf(UnitConverter.toUnit((int)n));
        this.setPropertyValue((Object)"column", (Object)string);
        string = String.valueOf(UnitConverter.toUnit((int)n2));
        this.setPropertyValue((Object)"line", (Object)string);
    }

    public void setTitle(String string) {
        switch (this.getType()) {
            case 503: 
            case 507: 
            case 509: {
                this.setPropertyValue((Object)"title", (Object)string);
            }
        }
    }

    public String getTitle() {
        switch (this.getType()) {
            case 503: 
            case 507: 
            case 509: {
                return (String)this.getPropertyValue((Object)"title");
            }
        }
        return null;
    }

    public String toString() {
        return this.getTarget().getName() + " (" + IscobolBeanConstants.getTypeName((int)this.getType()) + ")";
    }

    public Point getLocation() {
        return new Point(this.getX(), this.getY());
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public boolean isLockable() {
        return true;
    }
}

