/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.model;

import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.reportdesigner.CodeGenerator;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.beans.ReportGroupHeader;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.propertysheet.ResourceRegistry;
import com.iscobol.screenpainter.util.ColorPalette;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReportModel
extends ReportModelElement {
    public static final String UPDATE_PROPERTY = "iscobolrd.update";
    private ReportSectionModel headerModel;
    private ReportSectionModel footerModel;
    private ReportSectionModel pageHeaderModel;
    private ReportSectionModel pageFooterModel;
    private List<ReportSectionModel> groupHeaderModels = new ArrayList();
    private List<ReportSectionModel> groupFooterModels = new ArrayList();
    private List<ReportSectionModel> detailModels = new ArrayList();
    private ScreenProgram screenProgram;

    public ReportModel(ReportElement reportElement, ScreenProgram screenProgram) {
        super(reportElement);
        this.screenProgram = screenProgram;
        Report report = (Report)reportElement;
        report.setPalette(this.screenProgram.getReportPalette());
        this.addChildren(report);
    }

    private void addChildren(Report report) {
        ReportSectionModel reportSectionModel;
        ColorPalette colorPalette = report.getPalette();
        if (report.getHeader() != null) {
            report.getHeader().setPalette(colorPalette);
            this.headerModel = new ReportSectionModel((ReportElement)report.getHeader(), this);
        }
        if (report.getPageHeader() != null) {
            report.getPageHeader().setPalette(colorPalette);
            this.pageHeaderModel = new ReportSectionModel((ReportElement)report.getPageHeader(), this);
        }
        if (report.getGroupHeaderCount() > 0) {
            for (ReportGroupHeader reportGroupHeader : report.getGroupHeaders()) {
                reportGroupHeader.setPalette(colorPalette);
                reportSectionModel = new ReportSectionModel((ReportElement)reportGroupHeader, this);
                this.groupHeaderModels.add(reportSectionModel);
            }
        }
        if (report.getDetailCount() > 0) {
            for (ReportGroupHeader reportGroupHeader : report.getDetails()) {
                reportGroupHeader.setPalette(colorPalette);
                reportSectionModel = new ReportSectionModel((ReportElement)reportGroupHeader, this);
                this.detailModels.add(reportSectionModel);
            }
        }
        if (report.getGroupFooterCount() > 0) {
            for (ReportGroupHeader reportGroupHeader : report.getGroupFooters()) {
                reportGroupHeader.setPalette(colorPalette);
                reportSectionModel = new ReportSectionModel((ReportElement)reportGroupHeader, this);
                this.groupFooterModels.add(reportSectionModel);
            }
        }
        if (report.getPageFooter() != null) {
            report.getPageFooter().setPalette(colorPalette);
            this.pageFooterModel = new ReportSectionModel((ReportElement)report.getPageFooter(), this);
        }
        if (report.getFooter() != null) {
            report.getFooter().setPalette(colorPalette);
            this.footerModel = new ReportSectionModel((ReportElement)report.getFooter(), this);
        }
    }

    public List<ReportModelElement> getChildren() {
        ArrayList<ReportModelElement> arrayList = new ArrayList<ReportModelElement>();
        if (this.headerModel != null) {
            arrayList.add((ReportModelElement)this.headerModel);
        }
        if (this.pageHeaderModel != null) {
            arrayList.add((ReportModelElement)this.pageHeaderModel);
        }
        arrayList.addAll(this.groupHeaderModels);
        arrayList.addAll(this.detailModels);
        arrayList.addAll(this.groupFooterModels);
        if (this.pageFooterModel != null) {
            arrayList.add((ReportModelElement)this.pageFooterModel);
        }
        if (this.footerModel != null) {
            arrayList.add((ReportModelElement)this.footerModel);
        }
        return arrayList;
    }

    public ReportSectionModel getHeaderModel() {
        return this.headerModel;
    }

    public void setHeaderModel(ReportSectionModel reportSectionModel) {
        this.setHeaderModel(reportSectionModel, true);
    }

    public void setHeaderModel(ReportSectionModel reportSectionModel, boolean bl) {
        this.headerModel = reportSectionModel;
    }

    public ReportSectionModel getFooterModel() {
        return this.footerModel;
    }

    public void setFooterModel(ReportSectionModel reportSectionModel) {
        this.setFooterModel(reportSectionModel, true);
    }

    public void setFooterModel(ReportSectionModel reportSectionModel, boolean bl) {
        this.footerModel = reportSectionModel;
    }

    public ReportSectionModel getPageHeaderModel() {
        return this.pageHeaderModel;
    }

    public void setPageHeaderModel(ReportSectionModel reportSectionModel) {
        this.setPageHeaderModel(reportSectionModel, true);
    }

    public void setPageHeaderModel(ReportSectionModel reportSectionModel, boolean bl) {
        this.pageHeaderModel = reportSectionModel;
    }

    public ReportSectionModel getPageFooterModel() {
        return this.pageFooterModel;
    }

    public void setPageFooterModel(ReportSectionModel reportSectionModel) {
        this.setPageFooterModel(reportSectionModel, true);
    }

    public void setPageFooterModel(ReportSectionModel reportSectionModel, boolean bl) {
        this.pageFooterModel = reportSectionModel;
    }

    public void addGroupHeader(int n, ReportSectionModel reportSectionModel, boolean bl) {
    }

    public void addGroupHeader(int n, ReportSectionModel reportSectionModel) {
        this.addGroupHeader(n, reportSectionModel, true);
    }

    public void addGroupHeader(ReportSectionModel reportSectionModel) {
        this.addGroupHeader(-1, reportSectionModel, true);
    }

    public int removeGroupHeader(ReportSectionModel reportSectionModel) {
        return this.removeGroupHeader(reportSectionModel, true);
    }

    public int removeGroupHeader(ReportSectionModel reportSectionModel, boolean bl) {
        return -1;
    }

    public List getGroupHeaders() {
        return this.groupHeaderModels;
    }

    public ReportSectionModel[] getGroupHeaders(ReportSectionModel[] reportSectionModelArray) {
        this.groupHeaderModels.toArray(reportSectionModelArray);
        return reportSectionModelArray;
    }

    public int getGroupHeaderCount() {
        return this.groupHeaderModels.size();
    }

    public void addGroupFooter(int n, ReportSectionModel reportSectionModel, boolean bl) {
    }

    public void addGroupFooter(int n, ReportSectionModel reportSectionModel) {
        this.addGroupFooter(n, reportSectionModel, true);
    }

    public void addGroupFooter(ReportSectionModel reportSectionModel) {
        this.addGroupFooter(-1, reportSectionModel, true);
    }

    public int removeGroupFooter(ReportSectionModel reportSectionModel) {
        return this.removeGroupFooter(reportSectionModel, true);
    }

    public int removeGroupFooter(ReportSectionModel reportSectionModel, boolean bl) {
        return -1;
    }

    public List getGroupFooters() {
        return this.groupFooterModels;
    }

    public ReportSectionModel[] getGroupFooters(ReportSectionModel[] reportSectionModelArray) {
        this.groupFooterModels.toArray(reportSectionModelArray);
        return reportSectionModelArray;
    }

    public int getGroupFooterCount() {
        return this.groupFooterModels.size();
    }

    public void addDetail(int n, ReportSectionModel reportSectionModel, boolean bl) {
    }

    public void addDetail(int n, ReportSectionModel reportSectionModel) {
        this.addDetail(n, reportSectionModel, true);
    }

    public void addDetail(ReportSectionModel reportSectionModel) {
        this.addDetail(-1, reportSectionModel, true);
    }

    public int removeDetail(ReportSectionModel reportSectionModel) {
        return this.removeDetail(reportSectionModel, true);
    }

    public int removeDetail(ReportSectionModel reportSectionModel, boolean bl) {
        return -1;
    }

    public List getDetails() {
        return this.detailModels;
    }

    public ReportSectionModel[] getDetails(ReportSectionModel[] reportSectionModelArray) {
        this.detailModels.toArray(reportSectionModelArray);
        return reportSectionModelArray;
    }

    public int getDetailCount() {
        return this.detailModels.size();
    }

    public ScreenProgram getScreenProgram() {
        return this.screenProgram;
    }

    public void setScreenProgram(ScreenProgram screenProgram) {
        this.screenProgram = screenProgram;
    }

    private void clearAll() {
        this.headerModel = null;
        this.footerModel = null;
        this.pageHeaderModel = null;
        this.pageFooterModel = null;
        this.detailModels.clear();
        this.groupHeaderModels.clear();
        this.groupFooterModels.clear();
    }

    public void updateStructure() {
        this.clearAll();
        this.addChildren((Report)this.getTarget());
        this.firePropertyChange("Element.UpdateStructure", null, (Object)this.getTarget());
    }

    public void setPropertyValue(Object object, Object object2) {
        if ("name".equals(object)) {
            int n;
            ScreenProgramEditor screenProgramEditor;
            Report report = (Report)this.getTarget();
            String string = report.getName();
            String string2 = object2.toString();
            CodeGenerator codeGenerator = new CodeGenerator(this.getScreenProgram(), 0);
            String[] stringArray = codeGenerator.getReportParNames(report, new HashMap());
            super.setPropertyValue(object, object2);
            ResourceRegistry resourceRegistry = this.getScreenProgram().getResourceRegistry();
            for (int i = 0; i < stringArray.length; ++i) {
                resourceRegistry.renameParagraph(stringArray[i], stringArray[i].replace(string, string2));
            }
            IIscobolNavigator iIscobolNavigator = PluginUtilities.findStructuralNavigator();
            if (iIscobolNavigator != null) {
                iIscobolNavigator.refresh((Object)new ScreenProgramAdapter(this.getScreenProgram().getFile()));
            }
            if ((screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor()) != null && (n = screenProgramEditor.indexOfReport(string2)) >= 0) {
                screenProgramEditor.setPageText(screenProgramEditor.getScreenSectionEditorCount() + n, report.getName());
            }
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    public void updateControlDecorations(String string) {
        this.firePropertyChange(string, (Object)"old", (Object)"new");
    }
}

