/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.model;

import com.iscobol.reportdesigner.UnitConverter;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;

public class ReportSectionModel
extends ReportModelElement {
    public static final String COMPONENT_ADDED_PROP = "ComponentAdded";
    public static final String COMPONENT_REMOVED_PROP = "ComponentRemoved";
    public static final String REPORT_GRID_SIZE_PROPERTY = "iscobolrd.grid.size";
    private static int widthInsets = 2;
    private static int heightInsets = 25;
    private List components = new ArrayList();

    public ReportSectionModel(ReportElement reportElement, ReportModel reportModel) {
        super(reportElement);
        this.addChildren((ReportSection)reportElement);
        this.setParent((ReportModelElement)reportModel);
    }

    private void addChildren(ReportSection reportSection) {
        ReportControl[] reportControlArray;
        for (ReportControl reportControl : reportControlArray = reportSection.getComponents()) {
            reportControl.setPalette(reportSection.getPalette());
            ReportComponentModel reportComponentModel = new ReportComponentModel((ReportElement)reportControl);
            reportComponentModel.setParent((ReportModelElement)this);
            this.components.add(reportComponentModel);
        }
    }

    public void addComponent(int n, ReportComponentModel reportComponentModel, boolean bl) {
        if (reportComponentModel != null) {
            if (n < 0 || n >= this.components.size()) {
                this.components.add(reportComponentModel);
            } else {
                this.components.add(n, reportComponentModel);
            }
            ((ReportSection)this.getTarget()).addComponent(n, (ReportControl)reportComponentModel.getTarget());
            if (bl) {
                this.firePropertyChange(COMPONENT_ADDED_PROP, null, (Object)reportComponentModel);
            }
        }
    }

    public void addComponent(int n, ReportComponentModel reportComponentModel) {
        this.addComponent(n, reportComponentModel, true);
    }

    public void addComponent(ReportComponentModel reportComponentModel) {
        this.addComponent(-1, reportComponentModel, true);
    }

    public int removeComponent(ReportComponentModel reportComponentModel) {
        return this.removeComponent(reportComponentModel, true);
    }

    public int removeComponent(ReportComponentModel reportComponentModel, boolean bl) {
        int n;
        if (reportComponentModel != null && (n = this.components.indexOf(reportComponentModel)) >= 0) {
            this.components.remove(n);
            ReportControl reportControl = (ReportControl)reportComponentModel.getTarget();
            ((ReportSection)reportControl.getParent()).removeComponent(reportControl);
            if (bl) {
                this.firePropertyChange(COMPONENT_REMOVED_PROP, null, (Object)reportComponentModel);
            }
            return n;
        }
        return -1;
    }

    public List<ReportModelElement> getChildren() {
        return this.components;
    }

    public List getComponents() {
        return this.components;
    }

    public ReportComponentModel[] getComponents(ReportComponentModel[] reportComponentModelArray) {
        this.components.toArray(reportComponentModelArray);
        return reportComponentModelArray;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public int getWidth() {
        return UnitConverter.inchToPixel((float)((ReportSection)this.getTarget()).getSize());
    }

    public int getHeight() {
        return UnitConverter.inchToPixel((float)((ReportSection)this.getTarget()).getLines());
    }

    public void setSize(int n, int n2) {
        String string = String.valueOf(UnitConverter.toUnit((int)n));
        this.setPropertyValue((Object)"size", (Object)string);
        string = String.valueOf(UnitConverter.toUnit((int)n2));
        this.setPropertyValue((Object)"lines", (Object)string);
    }

    public void setPropertyValue(Object object, Object object2) {
        if ("size".equals(object) || "lines".equals(object)) {
            Float f;
            ReportSection reportSection = (ReportSection)this.getTarget();
            Float f2 = PropertyDescriptorRegistry.ParseFloat((String)((String)object2));
            if (UnitConverter.isUnitCentimeter()) {
                f2 = Float.valueOf(UnitConverter.centimeterToInch((float)f2.floatValue()));
            }
            if ("size".equals(object)) {
                f = new Float(reportSection.getSize());
                reportSection.setSize(f2.floatValue());
            } else {
                f = new Float(reportSection.getLines());
                reportSection.setLines(f2.floatValue());
            }
            ReportModel reportModel = this.getReportModel();
            List list = reportModel.getChildren();
            for (Object e : list) {
                ((ReportSectionModel)e).firePropertyChange(object.toString(), (Object)f, (Object)f2);
            }
            reportModel.firePropertyChange(object.toString(), (Object)f, (Object)f2);
        } else {
            super.setPropertyValue(object, object2);
        }
    }

    public Object getPropertyValue(Object object) {
        Object object2 = super.getPropertyValue(object);
        if (("size".equals(object) || "lines".equals(object)) && UnitConverter.isUnitCentimeter()) {
            object2 = Float.valueOf(UnitConverter.inchToCentimeter((float)Float.parseFloat(object2.toString())));
        }
        return object2;
    }

    public static int getWidthInsets() {
        return widthInsets;
    }

    public static int getHeightInsets() {
        return heightInsets;
    }

    public static void setInsets(int n, int n2) {
        widthInsets = n;
        heightInsets = n2;
    }

    public String toString() {
        return this.getTarget().getName() + " (" + IscobolBeanConstants.getTypeName((int)this.getType()) + ")";
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public boolean isLockable() {
        return true;
    }
}

