/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.model.commands;

import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import com.iscobol.screenpainter.ScreenProgram;
import org.eclipse.gef.commands.Command;

public class ReportComponentDeleteCommand
extends Command {
    private final ReportComponentModel child;
    private final ReportSectionModel parent;
    private int removedComponentIdx;

    public ReportComponentDeleteCommand(ReportSectionModel reportSectionModel, ReportComponentModel reportComponentModel) {
        if (reportSectionModel == null || reportComponentModel == null) {
            throw new IllegalArgumentException();
        }
        this.parent = reportSectionModel;
        this.child = reportComponentModel;
        this.setLabel("Delete " + reportComponentModel.getName());
    }

    public boolean canUndo() {
        return this.removedComponentIdx >= 0;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        ReportControl reportControl = (ReportControl)this.child.getTarget();
        ScreenProgram screenProgram = this.parent.getScreenProgram();
        screenProgram.pruneReportResources((ReportElement)reportControl);
        this.removedComponentIdx = this.parent.removeComponent(this.child);
        this.child.setParent(null);
    }

    public void undo() {
        this.parent.addComponent(this.removedComponentIdx, this.child);
        this.child.setParent((ReportModelElement)this.parent);
        ReportControl reportControl = (ReportControl)this.child.getTarget();
        ScreenProgram screenProgram = this.parent.getScreenProgram();
        screenProgram.restoreReportResources((ReportElement)reportControl);
    }
}

