/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.model.commands;

import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ReportComponentSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final ReportComponentModel component;

    public ReportComponentSetConstraintCommand(ReportComponentModel reportComponentModel, ChangeBoundsRequest changeBoundsRequest, Rectangle rectangle) {
        if (reportComponentModel == null || changeBoundsRequest == null || rectangle == null) {
            throw new IllegalArgumentException();
        }
        this.component = reportComponentModel;
        this.request = changeBoundsRequest;
        this.newBounds = rectangle.getCopy();
        this.setLabel("Change bounds " + (reportComponentModel != null ? reportComponentModel.getName() : ""));
    }

    private boolean isLock() {
        return ((ReportControl)this.component.getTarget()).isLock();
    }

    public boolean canExecute() {
        Object object = this.request.getType();
        return !this.isLock() && ("move".equals(object) || "move children".equals(object) || "resize".equals(object) || "resize children".equals(object));
    }

    public void execute() {
        Point point = new Point(this.component.getX(), this.component.getY());
        Dimension dimension = new Dimension(this.component.getWidth(), this.component.getHeight());
        this.oldBounds = new Rectangle(point, dimension);
        this.redo();
    }

    public void redo() {
        Rectangle rectangle = this.newBounds;
        this.component.setSize(rectangle.width, rectangle.height);
        this.component.setLocation(rectangle.x, rectangle.y);
    }

    public void undo() {
        this.component.setSize(this.oldBounds.width, this.oldBounds.height);
        this.component.setLocation(this.oldBounds.x, this.oldBounds.y);
    }
}

