/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.model.commands;

import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ReportSectionSetConstraintCommand
extends Command {
    private final Dimension newSize;
    private Dimension oldSize;
    private final ChangeBoundsRequest request;
    private final ReportSectionModel section;

    public ReportSectionSetConstraintCommand(ReportSectionModel reportSectionModel, ChangeBoundsRequest changeBoundsRequest, Dimension dimension) {
        if (reportSectionModel == null || changeBoundsRequest == null || dimension == null) {
            throw new IllegalArgumentException();
        }
        this.section = reportSectionModel;
        this.request = changeBoundsRequest;
        this.newSize = dimension.getCopy();
        this.newSize.width -= ReportSectionModel.getWidthInsets();
        this.newSize.height -= ReportSectionModel.getHeightInsets();
        this.setLabel("Resize " + (reportSectionModel != null ? reportSectionModel.getName() : ""));
    }

    private boolean isLock() {
        return ((ReportSection)this.section.getTarget()).isLock();
    }

    public boolean canExecute() {
        Object object = this.request.getType();
        return !this.isLock() && ("resize".equals(object) || "resize children".equals(object)) && this.newSize.width >= 0 && this.newSize.height >= 0;
    }

    public void execute() {
        this.oldSize = new Dimension(this.section.getWidth(), this.section.getHeight());
        this.redo();
    }

    public void redo() {
        this.section.setSize(this.newSize.width, this.newSize.height);
    }

    public void undo() {
        this.section.setSize(this.oldSize.width, this.oldSize.height);
    }
}

