/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.parts;

import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.reportdesigner.parts.ReportDesignerEditPart;
import com.iscobol.reportdesigner.parts.gui.ReportBoxFigure;
import com.iscobol.reportdesigner.parts.gui.ReportCheckBoxFigure;
import com.iscobol.reportdesigner.parts.gui.ReportComponentFigure;
import com.iscobol.reportdesigner.parts.gui.ReportDateTimeFigure;
import com.iscobol.reportdesigner.parts.gui.ReportEntryFieldFigure;
import com.iscobol.reportdesigner.parts.gui.ReportImageFigure;
import com.iscobol.reportdesigner.parts.gui.ReportLabelFigure;
import com.iscobol.reportdesigner.parts.gui.ReportLineFigure;
import com.iscobol.reportdesigner.parts.gui.ReportRadioButtonFigure;
import com.iscobol.reportdesigner.parts.gui.ReportTableFigure;
import com.iscobol.reportdesigner.policies.ReportComponentDeletionEditPolicy;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.model.ScreenPainterModelWithTitle;
import com.iscobol.screenpainter.parts.ChangeTitleCellEditorLocator;
import com.iscobol.screenpainter.parts.ChangeTitleDirectEditManager;
import com.iscobol.screenpainter.parts.DirectEditable;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.policies.ChangeTitleDirectEditPolicy;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.TextCellEditor;

public class ReportComponentEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
ReportDesignerEditPart,
DirectEditable {
    private Rectangle oldBounds;
    protected ChangeTitleDirectEditManager manager;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ReportModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new ReportComponentDeletionEditPolicy());
        if (this.isDirectEditSupported()) {
            this.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new ChangeTitleDirectEditPolicy());
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ReportModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
            if (this.figure instanceof ReportComponentFigure) {
                ((ReportComponentFigure)this.figure).dispose();
            }
        }
    }

    protected IFigure createFigure() {
        ReportLabelFigure reportLabelFigure;
        ReportComponentModel reportComponentModel = this.getCastedModel();
        switch (reportComponentModel.getType()) {
            case 507: {
                reportLabelFigure = new ReportLabelFigure(reportComponentModel);
                break;
            }
            case 505: {
                reportLabelFigure = new ReportEntryFieldFigure(reportComponentModel);
                break;
            }
            case 504: {
                reportLabelFigure = new ReportDateTimeFigure(reportComponentModel);
                break;
            }
            case 502: {
                reportLabelFigure = new ReportBoxFigure(reportComponentModel);
                break;
            }
            case 506: {
                reportLabelFigure = new ReportImageFigure(reportComponentModel);
                break;
            }
            case 503: {
                reportLabelFigure = new ReportCheckBoxFigure(reportComponentModel);
                break;
            }
            case 509: {
                reportLabelFigure = new ReportRadioButtonFigure(reportComponentModel);
                break;
            }
            case 508: {
                reportLabelFigure = new ReportLineFigure(reportComponentModel);
                break;
            }
            case 510: {
                reportLabelFigure = new ReportTableFigure(reportComponentModel);
                break;
            }
            default: {
                reportLabelFigure = new ReportComponentFigure(reportComponentModel);
            }
        }
        this.figure = reportLabelFigure;
        return reportLabelFigure;
    }

    private ReportComponentModel getCastedModel() {
        return (ReportComponentModel)this.getModel();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshVisuals();
        this.getFigure().repaint();
    }

    protected void refreshVisuals() {
        this.updateLock();
        ReportComponentModel reportComponentModel = this.getCastedModel();
        Point point = new Point(reportComponentModel.getX(), reportComponentModel.getY());
        Dimension dimension = new Dimension(reportComponentModel.getWidth(), reportComponentModel.getHeight());
        Rectangle rectangle = new Rectangle(point, dimension);
        if (this.oldBounds == null || !this.oldBounds.equals((Object)rectangle)) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
            this.oldBounds = rectangle;
        }
    }

    public ScreenPainterModel getScreenPainterModel() {
        return this.getCastedModel();
    }

    public void performDirectEdit(String string, boolean bl) {
        if (this.manager == null) {
            this.manager = new ChangeTitleDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, (CellEditorLocator)new ChangeTitleCellEditorLocator((GraphicalEditPart)this));
        }
        this.manager.setOrigValue(string, bl);
        this.manager.show();
    }

    public boolean isDirectEditSupported() {
        switch (this.getCastedModel().getType()) {
            case 503: 
            case 507: 
            case 509: {
                return true;
            }
        }
        return false;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            if (this.getCastedModel().getType() == 507) {
                String string = ((ScreenPainterModelWithTitle)this.getModel()).getTitle();
                this.performDirectEdit(string, true);
            } else {
                PropertyDescriptorRegistry.openEventParagraphsEditor((IscobolScreenPainterEditPart)this);
            }
        }
        super.performRequest(request);
    }

    public void update() {
        this.refreshVisuals();
        this.getFigure().repaint();
    }

    void updateControlDecorations(String string) {
        if ("iscobolrd.showlockedicon".equals(string)) {
            this.updateLock();
        }
    }

    private void updateLock() {
        ReportControl reportControl = (ReportControl)this.getCastedModel().getTarget();
        ((ReportComponentFigure)this.getFigure()).setShowLock(reportControl.isLock() && IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolrd.showlockedicon"));
    }
}

