/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.reportdesigner.parts;

import com.iscobol.reportdesigner.beans.ReportGroupFooter;
import com.iscobol.reportdesigner.beans.ReportGroupHeader;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import com.iscobol.reportdesigner.parts.ReportComponentEditPart;
import com.iscobol.reportdesigner.parts.ReportDesignerEditPart;
import com.iscobol.reportdesigner.parts.ReportDesignerMarqueeDragTracker;
import com.iscobol.reportdesigner.parts.gui.ReportSectionFigure;
import com.iscobol.reportdesigner.policies.ReportComponentXYLayoutEditPolicy;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.policies.GuideEditPolicy;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ReportSectionEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
IPropertyChangeListener,
ReportDesignerEditPart {
    private CompoundBorder border;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ReportModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
            IscobolScreenPainterPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new ReportComponentXYLayoutEditPolicy());
        this.installEditPolicy((Object)"Snap Helper Feedback", (EditPolicy)new GuideEditPolicy("iscobolrd.guides.snaptoguides.color"));
    }

    public Object getAdapter(Class clazz) {
        SnapToHelper snapToHelper = PluginUtilities.getReportDesignerSnapToHelper((Class)clazz, (GraphicalEditPart)this);
        if (snapToHelper != null) {
            return snapToHelper;
        }
        return super.getAdapter(clazz);
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ReportModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
            IscobolScreenPainterPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected IFigure createFigure() {
        ReportSectionFigure reportSectionFigure = new ReportSectionFigure(this.getCastedModel());
        reportSectionFigure.setGridCellSize(IscobolScreenPainterPlugin.getIntFromStore((String)"iscobolrd.grid.width"), IscobolScreenPainterPlugin.getIntFromStore((String)"iscobolrd.grid.height"), IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolrd.grid.show"));
        TitleBarBorder titleBarBorder = new TitleBarBorder(this.getTitle());
        titleBarBorder.setBackgroundColor(IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(new RGB(240, 240, 240)));
        titleBarBorder.setTextColor(Display.getDefault().getSystemColor(2));
        this.border = new CompoundBorder((Border)titleBarBorder, (Border)new LineBorder());
        reportSectionFigure.setBorder((Border)this.border);
        this.figure = reportSectionFigure;
        reportSectionFigure.setLayoutManager((LayoutManager)new XYLayout());
        return reportSectionFigure;
    }

    public String getTitle() {
        switch (this.getCastedModel().getType()) {
            case 553: {
                return "Header";
            }
            case 552: {
                return "Footer";
            }
            case 555: {
                return "Page-Header";
            }
            case 554: {
                return "Page-Footer";
            }
            case 551: {
                return "Detail: " + this.getCastedModel().getName();
            }
            case 557: {
                ReportGroupHeader reportGroupHeader = (ReportGroupHeader)this.getCastedModel().getTarget();
                return "Group-Header: " + reportGroupHeader.getGroupedBy() + " (" + reportGroupHeader.getGroupType() + ")";
            }
            case 556: {
                ReportGroupFooter reportGroupFooter = (ReportGroupFooter)this.getCastedModel().getTarget();
                return "Group-Footer: " + reportGroupFooter.getGroupedBy() + " (" + reportGroupFooter.getGroupType() + ")";
            }
        }
        return this.getCastedModel().getName();
    }

    private ReportSectionModel getCastedModel() {
        return (ReportSectionModel)this.getModel();
    }

    protected List getModelChildren() {
        ArrayList arrayList = new ArrayList(this.getCastedModel().getComponents());
        Collections.sort(arrayList, new /* Unavailable Anonymous Inner Class!! */);
        return arrayList;
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ComponentAdded".equals(string) || "ComponentRemoved".equals(string)) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
            ((TitleBarBorder)this.border.getOuterBorder()).setLabel(this.getTitle());
            this.getFigure().repaint();
        }
    }

    void updateControlDecorations(String string) {
        if ("iscobolrd.showlockedicon".equals(string)) {
            this.updateLock();
        }
        for (Object e : this.getChildren()) {
            if (!(e instanceof ReportComponentEditPart)) continue;
            ((ReportComponentEditPart)e).updateControlDecorations(string);
        }
    }

    private void updateLock() {
        ReportSection reportSection = (ReportSection)this.getCastedModel().getTarget();
        ((ReportSectionFigure)this.getFigure()).setShowLock(reportSection.isLock() && IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolrd.showlockedicon"));
    }

    public void update() {
        for (Object e : this.getChildren()) {
            if (!(e instanceof ReportComponentEditPart)) continue;
            ((ReportComponentEditPart)e).update();
        }
        this.refreshVisuals();
        this.getFigure().repaint();
    }

    protected void refreshVisuals() {
        ReportSectionEditPart reportSectionEditPart;
        Object object2;
        List list = this.getParent().getChildren();
        int n = 0;
        int n2 = 2;
        for (Object object2 : list) {
            if (!(object2 instanceof ReportSectionEditPart)) continue;
            reportSectionEditPart = (ReportSectionEditPart)object2;
            if (object2 == this) break;
            Insets insets = reportSectionEditPart.border.getInsets(reportSectionEditPart.getFigure());
            if (n == 0) {
                n = reportSectionEditPart.getCastedModel().getWidth() + insets.right + insets.left;
            }
            n2 += reportSectionEditPart.getCastedModel().getHeight() + insets.top + insets.bottom;
        }
        Insets insets = this.border.getInsets(this.getFigure());
        ReportSectionModel.setInsets((int)(insets.left + insets.right), (int)(insets.top + insets.bottom));
        if (n == 0) {
            n = this.getCastedModel().getWidth() + insets.right + insets.left;
        }
        object2 = new Point(2, n2);
        reportSectionEditPart = new Dimension(n, this.getCastedModel().getHeight() + insets.top + insets.bottom);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(object2, (Dimension)reportSectionEditPart));
        this.updateLock();
    }

    public DragTracker getDragTracker(Request request) {
        if (this.getSelected() != 0) {
            return super.getDragTracker(request);
        }
        return new ReportDesignerMarqueeDragTracker((AbstractGraphicalEditPart)this);
    }

    public ScreenPainterModel getScreenPainterModel() {
        return this.getCastedModel();
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            PropertyDescriptorRegistry.openEventParagraphsEditor((IscobolScreenPainterEditPart)this);
        }
        super.performRequest(request);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("iscobolrd.grid.height")) {
            ((ReportSectionFigure)this.getFigure()).setGridCellHeight(Integer.parseInt(propertyChangeEvent.getNewValue().toString()));
        } else if (propertyChangeEvent.getProperty().equals("iscobolrd.grid.width")) {
            ((ReportSectionFigure)this.getFigure()).setGridCellWidth(Integer.parseInt(propertyChangeEvent.getNewValue().toString()));
        } else if (propertyChangeEvent.getProperty().equals("iscobolrd.grid.show")) {
            ((ReportSectionFigure)this.getFigure()).setShowGrid(Boolean.parseBoolean(propertyChangeEvent.getNewValue().toString()));
        }
    }
}

